<?php
$config = require_once 'config/config.php';
$pdo = $config['pdo'];

echo "=== APPLYING FIXED DATABASE PATCH ===\n\n";

$sql = file_get_contents('apply_fixed_patch.sql');
$statements = explode(';', $sql);

foreach ($statements as $statement) {
    $statement = trim($statement);
    if (empty($statement)) continue;
    
    try {
        $pdo->exec($statement);
        echo "✓ Executed: " . substr($statement, 0, 50) . "...\n";
    } catch (Exception $e) {
        echo "✗ Failed: " . substr($statement, 0, 50) . "... - " . $e->getMessage() . "\n";
    }
}

echo "\n=== TESTING FIXED FUNCTION ===\n";
try {
    $stmt = $pdo->prepare("SELECT insert_wallet_transaction(10, 'credit', 'admin_credit', 25.00, 'Test fixed function', 'TEST_FIXED', 'admin_action', NULL, JSON_OBJECT('test', 'fixed'))");
    $stmt->execute();
    $result = $stmt->fetchColumn();
    echo "✓ Function test successful! Transaction ID: $result\n";
    
    // Clean up
    $pdo->prepare("DELETE FROM wallet_transactions WHERE id = ?")->execute([$result]);
    $pdo->prepare("UPDATE wallets SET balance = balance - 25.00 WHERE user_id = 10")->execute();
    echo "  Test transaction cleaned up\n";
} catch (Exception $e) {
    echo "✗ Function test failed: " . $e->getMessage() . "\n";
}

echo "\nPatch applied successfully!\n";
?>
