<?php
/** @var string $csrf */
/** @var array $package */
/** @var array $variants */
/** @var array $pricesByVariant */
/** @var array $times */
/** @var int $vendorId */
if (!isset($title)) { $title = 'Manage Package'; }
?>
<style>
  .section-card { border: 1px solid #e9ecef; border-radius: .5rem; padding: 1rem; margin-bottom: 1rem; }
  .chip { display:inline-block; padding:.25rem .5rem; border-radius:1rem; background:#f1f3f5; margin:.125rem; font-size:.85rem }
  .table-sm td, .table-sm th { padding:.35rem .5rem; }
  .sticky-head th { position: sticky; top: 0; background: #f8f9fa; z-index: 1; }
  .variant-toolbar { display:flex; gap:.5rem; align-items:center; margin:.25rem 0 .5rem; flex-wrap: wrap; }
  .variant-item { border:1px solid #e9ecef; border-radius:.375rem; margin-bottom:.5rem; }
  .variant-header { padding:.5rem .75rem; background:#f8f9fa; display:flex; align-items:center; justify-content:space-between; cursor: pointer; }
  .variant-body { padding:.5rem .75rem; }
  /* Polished edit button */
  .btn-edit { border:1px solid #dee2e6; background:#fff; color:#495057; }
  .btn-edit:hover { background:#f8f9fa; border-color:#ced4da; color:#212529; }
  .btn-pill { border-radius: 9999px; }
  .btn-icon-only { padding: .25rem .35rem; display:inline-flex; align-items:center; justify-content:center; }
  .btn .icon { width:16px; height:16px; margin-right:.45rem; vertical-align:middle; }
  .btn-edit .icon { width:14px; height:14px; margin-right:.35rem; }
  .btn-icon-only .icon { margin-right:0; }
  /* Modern soft buttons */
  .btn-elevated { box-shadow: 0 1px 2px rgba(16,24,40,.06), 0 1px 1px rgba(16,24,40,.04); transition: box-shadow .15s ease, transform .05s ease, background-color .15s ease, border-color .15s ease; }
  .btn-elevated:hover { box-shadow: 0 2px 6px rgba(16,24,40,.12), 0 1px 3px rgba(16,24,40,.08); transform: translateY(-1px); }
  .btn-outline-primary-strong { color:#0b5ed7; background:#fff; border:1.5px solid #0b5ed7; }
  .btn-outline-primary-strong:hover { background:rgba(13,110,253,.06); }
  .btn-outline-secondary-strong { color:#495057; background:#fff; border:1.5px solid #adb5bd; }
  .btn-outline-secondary-strong:hover { background:rgba(33,37,41,.05); }
  .btn-gradient-primary { color:#fff; background:linear-gradient(135deg,#1d6ef0,#0b5ed7); border:0; }
  .btn-gradient-primary:hover { filter:brightness(1.05); box-shadow:0 4px 12px rgba(13,110,253,.3); }
  .btn-icon-left { display:inline-flex; align-items:center; gap:.4rem; }
  .btn-pill-lg { border-radius:9999px; padding:.4rem 1rem; font-weight:600; }
  .btn-pill { border-radius:9999px; padding:.35rem .9rem; font-weight:600; }
  .btn:focus-visible { outline:none; box-shadow: 0 0 0 .2rem rgba(13,110,253,.25); }
  .form-help { font-size:.82rem; color:#6c757d; margin-top:.25rem; }
</style>
<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <h4 class="mb-0">Manage: <?= htmlspecialchars($package['name']) ?></h4>
    <div>
      <a href="/admin/vendors/package_manage?vendor_id=<?= (int)$vendorId ?>" class="btn btn-outline-secondary-strong btn-sm btn-pill btn-elevated btn-icon-left" data-bs-toggle-tooltip title="Back to list">
        <svg class="icon" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"><path d="M15 8a.75.75 0 0 1-.75.75H3.56l3.22 3.22a.75.75 0 0 1-1.06 1.06l-4.5-4.5a.75.75 0 0 1 0-1.06l4.5-4.5a.75.75 0 1 1 1.06 1.06L3.56 7.25h10.69A.75.75 0 0 1 15 8z"/></svg>
        Back to Packages
      </a>
      <button type="button" class="btn btn-outline-primary-strong btn-sm btn-pill btn-elevated btn-icon-left ms-2" data-bs-toggle="modal" data-bs-target="#editPackageModal" data-bs-toggle-tooltip title="Edit package">
        <svg class="icon" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"><path d="M12.146.646a.5.5 0 0 1 .708 0l2.5 2.5a.5.5 0 0 1 0 .708l-9.5 9.5a.5.5 0 0 1-.233.131l-4 1a.5.5 0 0 1-.606-.606l1-4a.5.5 0 0 1 .131-.233l9.5-9.5zM11.207 2.5 13.5 4.793 14.793 3.5 12.5 1.207 11.207 2.5zM12.5 5.5 10.5 3.5 3 11v2h2l7.5-7.5z"/></svg>
        Edit Package
      </button>
    </div>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-2"><?= htmlspecialchars($_SESSION['flash']) ?></div>
    <?php unset($_SESSION['flash']); endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2">
      <?php foreach ((array)$_SESSION['errors'] as $e): ?>
        <div>- <?= htmlspecialchars($e) ?></div>
      <?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <div class="section-card bg-white">
    <?php if (!isset($allModals)) { $allModals = ''; } ?>
    <!-- Transport Options (Fixed-Price) -->
    <div class="mb-3">
      <div class="d-flex align-items-center justify-content-between">
        <h6 class="mb-2">Transport Options</h6>
        <form method="post" action="/admin/vendor-packages/transport/toggle" class="m-0 p-0">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
          <input type="hidden" name="package_id" value="<?= (int)$package['id'] ?>">
          <div class="form-check form-switch">
            <input class="form-check-input" type="checkbox" role="switch" name="transport_enabled" id="transport_enabled"
                   <?= !empty($transportEnabled) ? 'checked' : '' ?> onchange="this.form.submit()">
            <label class="form-check-label" for="transport_enabled">Enable optional transport in Agent booking</label>
          </div>
        </form>
      </div>

      <?php if (!empty($transportEnabled)): ?>
        <div class="table-responsive mt-2">
          <table class="table table-sm align-middle">
            <thead class="table-light">
              <tr>
                <th style="width:48px">#</th>
                <th>Vehicle Type</th>
                <th style="width:140px">Price (THB)</th>
                <th style="width:160px">Status</th>
                <th class="text-end" style="width:160px">Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php $sn=1; foreach (($transportOptions ?? []) as $opt): ?>
                <tr>
                  <td><?= $sn++ ?></td>
                  <td><?= htmlspecialchars((string)$opt['vehicle_type']) ?></td>
                  <td><?= number_format((float)$opt['price'],2) ?></td>
                  <td>
                    <form method="post" action="/admin/vendor-packages/transport/toggle-active" class="d-inline-flex align-items-center gap-2 m-0 p-0">
                      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                      <input type="hidden" name="package_id" value="<?= (int)$package['id'] ?>">
                      <input type="hidden" name="id" value="<?= (int)$opt['id'] ?>">
                      <input type="hidden" name="is_active" value="<?= (int)$opt['is_active'] ? 1 : 0 ?>">
                      <span class="badge <?= (int)$opt['is_active'] ? 'bg-success' : 'bg-secondary' ?>">
                        <?= (int)$opt['is_active'] ? 'Active' : 'Inactive' ?>
                      </span>
                      <div class="form-check form-switch m-0">
                        <input class="form-check-input js-switch-active" type="checkbox" role="switch" <?= (int)$opt['is_active'] ? 'checked' : '' ?>>
                      </div>
                    </form>
                  </td>
                  <td class="text-end">
                    <button type="button" class="btn btn-edit btn-sm btn-pill" data-bs-toggle="modal" data-bs-target="#editTransport_<?= (int)$opt['id'] ?>">Edit</button>
                    <button type="button" class="btn btn-outline-danger btn-sm btn-pill" data-bs-toggle="modal" data-bs-target="#delTransport_<?= (int)$opt['id'] ?>">Delete</button>
                  </td>
                </tr>
                <?php ob_start(); ?>
                <div class="modal fade" id="editTransport_<?= (int)$opt['id'] ?>" tabindex="-1" aria-hidden="true">
                  <div class="modal-dialog">
                    <div class="modal-content">
                      <div class="modal-header"><h5 class="modal-title">Edit Transport Option</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
                      <form method="post" action="/admin/vendor-packages/transport/store">
                        <div class="modal-body">
                          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                          <input type="hidden" name="package_id" value="<?= (int)$package['id'] ?>">
                          <input type="hidden" name="id" value="<?= (int)$opt['id'] ?>">
                          <div class="row g-3">
                            <div class="col-md-6">
                              <label class="form-label fw-semibold">Vehicle Type <span class="text-danger">*</span></label>
                              <input type="text" name="vehicle_type" class="form-control" value="<?= htmlspecialchars((string)($opt['vehicle_type'] ?? '')) ?>" placeholder="e.g., 4-seater / Sedan / Custom" required>
                            </div>
                            <div class="col-md-2">
                              <label class="form-label fw-semibold">Seats <span class="text-danger">*</span></label>
                              <input type="number" min="1" max="99" name="max_pax" value="<?= (int)($opt['max_pax'] ?? 4) ?>" class="form-control" required>
                            </div>
                            <div class="col-12"></div>
                            <div class="col-md-4">
                              <label class="form-label fw-semibold">Vendor Cost <span class="text-danger">*</span></label>
                              <div class="input-group">
                                <input type="number" step="0.01" min="0" name="vendor_cost" value="<?= htmlspecialchars((string)($opt['vendor_cost'] ?? '0.00')) ?>" class="form-control" required>
                                <span class="input-group-text">THB</span>
                              </div>
                            </div>
                            <div class="col-md-4">
                              <label class="form-label fw-semibold">Agent Price <span class="text-danger">*</span></label>
                              <div class="input-group">
                                <input type="number" step="0.01" min="0" name="agent_price" value="<?= htmlspecialchars((string)($opt['agent_price'] ?? '0.00')) ?>" class="form-control" required>
                                <span class="input-group-text">THB</span>
                              </div>
                            </div>
                            <div class="col-md-4">
                              <label class="form-label">Customer Price</label>
                              <div class="input-group">
                                <input type="number" step="0.01" min="0" name="customer_price" value="<?= htmlspecialchars((string)($opt['customer_price'] ?? '')) ?>" class="form-control">
                                <span class="input-group-text">THB</span>
                              </div>
                            </div>
                            <div class="col-12">
                              <div class="form-check mt-2">
                                <input class="form-check-input" type="checkbox" name="is_active" id="is_active_<?= (int)$opt['id'] ?>" <?= (int)$opt['is_active']? 'checked':'' ?>>
                                <label class="form-check-label" for="is_active_<?= (int)$opt['id'] ?>">Active</label>
                              </div>
                            </div>
                            <div class="col-12">
                              <label class="form-label fw-semibold">Master Password <span class="text-danger">*</span></label>
                              <input type="password" name="master_password" class="form-control" required>
                            </div>
                          </div>
                        </div>
                        <div class="modal-footer"><button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button><button type="submit" class="btn btn-primary">Save</button></div>
                      </form>
                    </div>
                  </div>
                </div>
                <div class="modal fade" id="delTransport_<?= (int)$opt['id'] ?>" tabindex="-1" aria-hidden="true">
                  <div class="modal-dialog">
                    <div class="modal-content">
                      <div class="modal-header"><h5 class="modal-title">Delete Transport Option</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
                      <form method="post" action="/admin/vendor-packages/transport/delete">
                        <div class="modal-body">
                          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                          <input type="hidden" name="package_id" value="<?= (int)$package['id'] ?>">
                          <input type="hidden" name="id" value="<?= (int)$opt['id'] ?>">
                          <div class="alert alert-warning small">This will permanently delete this option.</div>
                          <div class="mb-2">
                            <label class="form-label">Master Password</label>
                            <input type="password" name="master_password" class="form-control" required>
                          </div>
                        </div>
                        <div class="modal-footer"><button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button><button type="submit" class="btn btn-danger">Delete</button></div>
                      </form>
                    </div>
                  </div>
                </div>
                <?php $allModals .= ob_get_clean(); ?>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
        <div class="mt-2">
          <button type="button" class="btn btn-outline-primary-strong btn-sm btn-pill" data-bs-toggle="modal" data-bs-target="#addTransportModal">Add Transport Option</button>
        </div>
        <div class="modal fade" id="addTransportModal" tabindex="-1" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header"><h5 class="modal-title">Add Transport Option</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
              <form method="post" action="/admin/vendor-packages/transport/store">
                <div class="modal-body">
                  <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                  <input type="hidden" name="package_id" value="<?= (int)$package['id'] ?>">
                  <div class="row g-3">
                    <div class="col-md-6">
                      <label class="form-label fw-semibold">Vehicle Type <span class="text-danger">*</span></label>
                      <input type="text" name="vehicle_type" class="form-control" placeholder="e.g., 4-seater / Sedan / Custom" required>
                    </div>
                    <div class="col-md-2">
                      <label class="form-label fw-semibold">Seats <span class="text-danger">*</span></label>
                      <input type="number" min="1" max="99" name="max_pax" value="4" class="form-control" required>
                    </div>
                    <div class="col-12"></div>
                    <div class="col-md-4">
                      <label class="form-label fw-semibold">Vendor Cost <span class="text-danger">*</span></label>
                      <div class="input-group">
                        <input type="number" step="0.01" min="0" name="vendor_cost" class="form-control" value="0.00" required>
                        <span class="input-group-text">THB</span>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <label class="form-label fw-semibold">Agent Price <span class="text-danger">*</span></label>
                      <div class="input-group">
                        <input type="number" step="0.01" min="0" name="agent_price" class="form-control" value="0.00" required>
                        <span class="input-group-text">THB</span>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <label class="form-label">Customer Price</label>
                      <div class="input-group">
                        <input type="number" step="0.01" min="0" name="customer_price" class="form-control">
                        <span class="input-group-text">THB</span>
                      </div>
                    </div>
                    <div class="col-12">
                      <div class="form-check mt-2">
                        <input class="form-check-input" type="checkbox" name="is_active" id="is_active_add" checked>
                        <label class="form-check-label" for="is_active_add">Active</label>
                      </div>
                    </div>
                    <div class="col-12">
                      <label class="form-label fw-semibold">Master Password <span class="text-danger">*</span></label>
                      <input type="password" name="master_password" class="form-control" required>
                    </div>
                  </div>
                </div>
                <div class="modal-footer"><button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button><button type="submit" class="btn btn-primary">Add</button></div>
              </form>
            </div>
          </div>
        </div>
      <?php else: ?>
        <div class="text-muted small">Transport is disabled for this package.</div>
      <?php endif; ?>
    </div>

    <div class="d-flex align-items-center flex-wrap gap-2">
      <div class="me-auto">
        <?php if (!empty($package['thumbnail_path'])): ?>
          <img src="<?= htmlspecialchars($package['thumbnail_path']) ?>" alt="thumb" class="me-2" style="width:48px;height:48px;object-fit:cover;border-radius:4px;border:1px solid #eee;vertical-align:middle">
        <?php endif; ?>
        <strong><?= htmlspecialchars($package['name']) ?></strong>
        <span class="ms-2 badge <?= (int)$package['active']? 'bg-success':'bg-secondary' ?>"><?= (int)$package['active']? 'Active':'Inactive' ?></span>
        <span class="ms-2 text-muted">Policy: <?= htmlspecialchars($package['age_policy']) ?><?= (int)$package['requires_show_time']? ', Needs time':'' ?></span>
      </div>
      <div class="d-flex align-items-center gap-2">
        <button type="button" class="btn btn-outline-primary-strong btn-sm btn-pill btn-elevated btn-icon-left" data-bs-toggle="modal" data-bs-target="#addVariantModal" data-bs-toggle-tooltip title="Create a new variant">
          <svg class="icon" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"><path d="M8 1.5a.75.75 0 0 1 .75.75v5h5a.75.75 0 0 1 0 1.5h-5v5a.75.75 0 0 1-1.5 0v-5h-5a.75.75 0 0 1 0-1.5h5v-5A.75.75 0 0 1 8 1.5z"/></svg>
          Add Variant
        </button>
        <button type="button" class="btn btn-gradient-primary btn-sm btn-pill btn-elevated btn-icon-left" data-bs-toggle="modal" data-bs-target="#addPriceModal" data-bs-toggle-tooltip title="Add a price for a variant">
          <svg class="icon" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"><path d="M3 2.75A.75.75 0 0 1 3.75 2h8.5a.75.75 0 0 1 .75.75v10.5a.75.75 0 0 1-.75.75h-8.5A.75.75 0 0 1 3 13.25V2.75zm1.5.75v9h7v-9h-7z"></path><path d="M5.75 8a.75.75 0 0 1 .75-.75h3a.75.75 0 0 1 0 1.5h-3A.75.75 0 0 1 5.75 8z"></path></svg>
          Add Price
        </button>
        <?php $pkgActive = (int)$package['active'] === 1; ?>
        <form method="post" action="/admin/vendor-packages/toggle-active" class="d-inline-flex align-items-center gap-2 m-0 p-0 js-no-toggle">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
          <input type="hidden" name="vendor_id" value="<?= (int)$vendorId ?>">
          <input type="hidden" name="id" value="<?= (int)$package['id'] ?>">
          <div class="form-check form-switch m-0">
            <input class="form-check-input" type="checkbox" role="switch" name="active" value="1" <?= $pkgActive ? 'checked' : '' ?> onchange="this.form.submit()">
          </div>
        </form>
        <!-- Delete removed on this page by request -->
      </div>
    </div>

    <div class="mb-2">
      <small class="text-muted">Times (override or vendor default):</small>
      <?php if (!empty($times)) { foreach ($times as $t) { echo '<span class="chip">'.htmlspecialchars($t).'</span>'; } } else { echo '<span class="text-muted">Using vendor default</span>'; } ?>
    </div>

    <!-- Quick test inputs: date and show time (for packages needing time) -->
    <div class="row g-2 align-items-end mb-2">
      <div class="col-sm-4 col-md-3">
        <label class="form-label mb-1" for="pkgTestDate">Select date</label>
        <?php $tz = new DateTimeZone('Asia/Bangkok'); $min = (new DateTime('now', $tz))->format('Y-m-d'); ?>
        <input id="pkgTestDate" type="date" class="form-control" value="<?= htmlspecialchars($min) ?>" min="<?= htmlspecialchars($min) ?>">
      </div>
      <?php if (!empty($times) || ((int)($package['requires_show_time'] ?? 0) === 1)): ?>
      <div class="col-sm-4 col-md-3">
        <label class="form-label mb-1" for="pkgTestTime">Select your show time</label>
        <select id="pkgTestTime" class="form-select">
          <?php if (!empty($times)) { foreach ($times as $t) { echo '<option value="'.htmlspecialchars($t).'">'.htmlspecialchars($t).'</option>'; } } else { echo '<option value="" disabled selected>No times configured</option>'; } ?>
        </select>
      </div>
      <?php endif; ?>
    </div>

    <div class="row g-3">
      <div class="col-12">
        <h6 class="mb-1">Variants</h6>
        <div class="variant-toolbar">
          <input type="text" id="variantFilter" class="form-control form-control-sm" placeholder="Filter variants..." style="max-width:220px">
          <button type="button" class="btn btn-outline-secondary-strong btn-sm btn-pill btn-elevated btn-icon-left" id="expandAll" data-bs-toggle-tooltip title="Show all variants">
            <svg class="icon" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"><path d="M8 1.5a.75.75 0 0 1 .75.75v3h3a.75.75 0 0 1 0 1.5h-3v3a.75.75 0 0 1-1.5 0v-3h-3a.75.75 0 0 1 0-1.5h3v-3A.75.75 0 0 1 8 1.5z"/></svg>
            Expand all
          </button>
          <button type="button" class="btn btn-outline-secondary-strong btn-sm btn-pill btn-elevated btn-icon-left" id="collapseAll" data-bs-toggle-tooltip title="Hide all variants">
            <svg class="icon" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"><path d="M3 7.25a.75.75 0 0 0 0 1.5h10a.75.75 0 0 0 0-1.5H3z"/></svg>
            Collapse all
          </button>
        </div>

        <?php $allModals = ''; ?>
        <div id="variantsList">
        <?php $first = true; $i = 0; foreach ($variants as $v): $open = $first; $first = false; $collapseId = 'var_'.$v['id']; $variantModals = ''; ?>
          <div class="variant-item" data-name="<?= strtolower(htmlspecialchars($v['name'])) ?>">
            <div class="variant-header">
              <button type="button" class="btn btn-link p-0 text-decoration-none variant-toggle" data-bs-toggle="collapse" data-bs-target="#<?= $collapseId ?>" aria-expanded="<?= $open ? 'true':'false' ?>" aria-controls="<?= $collapseId ?>">
                <strong class="text-dark"><?= (++$i) . '. ' . htmlspecialchars($v['name']) ?></strong>
                <span class="ms-2 badge <?= (int)$v['active']? 'bg-success':'bg-secondary' ?>"><?= (int)$v['active']? 'Active':'Inactive' ?></span>
              </button>
              <div>
                <?php $vActive = (int)$v['active'] === 1; ?>
                <form method="post" action="/admin/vendor-package-variants/toggle-active" class="d-inline-flex align-items-center gap-2 m-0 p-0 js-no-toggle">
                  <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                  <input type="hidden" name="vendor_id" value="<?= (int)$vendorId ?>">
                  <input type="hidden" name="id" value="<?= (int)$v['id'] ?>">
                  <div class="form-check form-switch m-0">
                    <input class="form-check-input" type="checkbox" role="switch" name="active" value="1" <?= $vActive ? 'checked' : '' ?> onchange="this.form.submit()">
                  </div>
                </form>
                <button type="button" class="btn btn-edit btn-sm btn-pill btn-icon-only js-no-toggle" data-bs-toggle="modal" data-bs-target="#editVariantModal_<?= (int)$v['id'] ?>" data-bs-toggle-tooltip title="Edit variant">
                  <svg class="icon" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"><path d="M12.146.646a.5.5 0 0 1 .708 0l2.5 2.5a.5.5 0 0 1 0 .708l-9.5 9.5a.5.5 0 0 1-.233.131l-4 1a.5.5 0 0 1-.606-.606l1-4a.5.5 0 0 1 .131-.233l9.5-9.5zM11.207 2.5 13.5 4.793 14.793 3.5 12.5 1.207 11.207 2.5zM12.5 5.5 10.5 3.5 3 11v2h2l7.5-7.5z"/></svg>
                </button>
                <button type="button" class="btn btn-outline-danger btn-sm btn-pill btn-icon-only js-no-toggle" data-bs-toggle="modal" data-bs-target="#delVariantModal_<?= (int)$v['id'] ?>" data-bs-toggle-tooltip title="Delete variant">
                  <svg class="icon" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"><path d="M5.5 5a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5zm3 0a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5z"/><path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1 0-2h3.086a1 1 0 0 1 .707.293l.854.854h2.906l.854-.854A1 1 0 0 1 11.414 1H14.5a1 1 0 0 1 1 1z"/></svg>
                </button>
                <?php ob_start(); ?>
                <!-- Delete Variant Modal -->
                <div class="modal fade" id="delVariantModal_<?= (int)$v['id'] ?>" tabindex="-1" aria-labelledby="delVariantModalLabel_<?= (int)$v['id'] ?>" aria-hidden="true">
                  <div class="modal-dialog">
                    <div class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title" id="delVariantModalLabel_<?= (int)$v['id'] ?>">Delete Variant</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                      </div>
                      <form method="post" action="/admin/vendor-package-variants/delete">
                        <div class="modal-body">
                          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                          <input type="hidden" name="vendor_id" value="<?= (int)$vendorId ?>">
                          <input type="hidden" name="id" value="<?= (int)$v['id'] ?>">
                          <div class="alert alert-warning small">
                            This will delete the variant <strong><?= htmlspecialchars($v['name']) ?></strong> and its prices.
                          </div>
                          <div class="mb-2">
                            <label class="form-label">Master Password</label>
                            <input type="password" name="master_password" class="form-control" required>
                          </div>
                        </div>
                        <div class="modal-footer">
                          <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                          <button type="submit" class="btn btn-danger">Delete</button>
                        </div>
                      </form>
                    </div>
                  </div>
                </div>
                <?php $variantModals .= ob_get_clean(); ?>
              </div>
            </div>
            <!-- Variant Edit Modal -->
            <?php ob_start(); ?>
            <div class="modal fade" id="editVariantModal_<?= (int)$v['id'] ?>" tabindex="-1" aria-labelledby="editVariantModalLabel_<?= (int)$v['id'] ?>" aria-hidden="true">
              <div class="modal-dialog">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title" id="editVariantModalLabel_<?= (int)$v['id'] ?>">Edit Variant</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                  </div>
                  <form method="post" action="/admin/vendor-package-variants/store">
                    <div class="modal-body">
                      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                      <input type="hidden" name="vendor_id" value="<?= (int)$vendorId ?>">
                      <input type="hidden" name="package_id" value="<?= (int)$package['id'] ?>">
                      <input type="hidden" name="id" value="<?= (int)$v['id'] ?>">
                      <div class="row g-2">
                        <div class="col-12">
                          <label class="form-label">Name</label>
                          <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($v['name']) ?>" required>
                        </div>
                        <div class="col-12">
                          <label class="form-label">Included Activities (comma-separated)</label>
                          <textarea name="notes" class="form-control" rows="4" placeholder="Parasailing, Seawalk, Banana Boat, Lunch, VIP Beach Chair, Speed Boat"><?= htmlspecialchars((string)($v['notes'] ?? '')) ?></textarea>
                          <div class="form-help">Add activities separated by commas. Leave blank if nothing is included.</div>
                        </div>
                        <div class="col-sm-6 d-flex align-items-center">
                          <div class="form-check mb-0">
                            <input class="form-check-input" type="checkbox" name="active" id="v_active_edit_<?= (int)$v['id'] ?>" <?= $vActive ? 'checked' : '' ?>>
                            <label class="form-check-label" for="v_active_edit_<?= (int)$v['id'] ?>">Active</label>
                          </div>
                        </div>
                        <div class="col-sm-6">
                          <label class="form-label">Master Password</label>
                          <input type="password" name="master_password" class="form-control" required>
                        </div>
                      </div>
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                      <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>
                  </form>
                </div>
              </div>
            </div>
            <?php $variantModals .= ob_get_clean(); ?>
            <div id="<?= $collapseId ?>" class="variant-body collapse <?= $open ? 'show':'' ?>">
              <div class="small text-muted">Prices</div>
              <div class="table-responsive" style="max-height: 280px;">
                <table class="table table-sm table-striped sticky-head">
                  <thead class="table-light"><tr><th>Type</th><th>Pax</th><th>Min Qty</th><th>Vendor Cost</th><th>Agent Price</th><th>Customer Price</th><th>Customer Promo Price</th><th>Currency</th><th>Pickup</th><th>Actions</th></tr></thead>
                  <tbody>
                  <?php foreach (($pricesByVariant[$v['id']] ?? []) as $p): ?>
                    <?php $pid = (int)$p['id']; $modalId = 'editPriceModal_' . $pid; ?>
                    <tr>
                      <td><?= htmlspecialchars($p['price_type']) ?></td>
                      <td><?= htmlspecialchars($p['pax_type']) ?></td>
                      <td><?= htmlspecialchars((string)$p['min_quantity']) ?></td>
                      <td><?= htmlspecialchars(number_format((float)$p['vendor_cost'],2)) ?></td>
                      <td><?= htmlspecialchars(number_format((float)$p['agent_price'],2)) ?></td>
                      <td><?= isset($p['customer_price']) && $p['customer_price'] !== null ? htmlspecialchars(number_format((float)$p['customer_price'],2)) : '-' ?></td>
                      <?php $promoTxt = '-'; if (!empty($p['customer_promo_price'])) { $promoTxt = number_format((float)$p['customer_promo_price'],2); if (!empty($p['promo_start_at']) || !empty($p['promo_end_at'])) { $win = trim(($p['promo_start_at'] ?? '').' - '.($p['promo_end_at'] ?? '')); $promoTxt .= ' (' . htmlspecialchars($win) . ')'; } } ?>
                      <td><?= $promoTxt ?></td>
                      <td><?= htmlspecialchars($p['currency']) ?></td>
                      <?php
                        $pt = (string)($p['pickup_type'] ?? 'none');
                        $pscope = (string)($p['pickup_scope'] ?? 'pickup_and_drop');
                        $pn = trim((string)($p['pickup_notes'] ?? ''));
                        if ($pt === 'none') { $pickupDisp = 'No Pickup'; }
                        else if ($pscope === 'pickup_only') { $pickupDisp = 'Free Pickup'; }
                        else { $pickupDisp = 'Free Pick & Drop'; }
                        if ($pt !== 'none' && $pn !== '') { $pickupDisp .= ' – '.htmlspecialchars($pn); }
                      ?>
                      <td><?= htmlspecialchars($pickupDisp) ?></td>
                      <td>
                        <div class="d-inline-flex gap-1">
                          <button type="button" class="btn btn-edit btn-sm btn-pill btn-icon-only" data-bs-toggle="modal" data-bs-target="#<?= $modalId ?>" data-bs-toggle-tooltip title="Edit price">
                            <svg class="icon" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"><path d="M12.146.646a.5.5 0 0 1 .708 0l2.5 2.5a.5.5 0 0 1 0 .708l-9.5 9.5a.5.5 0 0 1-.233.131l-4 1a.5.5 0 0 1-.606-.606l1-4a.5.5 0 0 1 .131-.233l9.5-9.5zM11.207 2.5 13.5 4.793 14.793 3.5 12.5 1.207 11.207 2.5zM12.5 5.5 10.5 3.5 3 11v2h2l7.5-7.5z"/></svg>
                          </button>
                          <button type="button" class="btn btn-outline-danger btn-sm btn-pill btn-icon-only" data-bs-toggle="modal" data-bs-target="#delPriceModal_<?= $pid ?>" data-bs-toggle-tooltip title="Delete price">
                            <svg class="icon" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"><path d="M5.5 5a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5zm3 0a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5z"/><path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1 0-2h3.086a1 1 0 0 1 .707.293l.854.854h2.906l.854-.854A1 1 0 0 1 11.414 1H14.5a1 1 0 0 1 1 1z"/></svg>
                          </button>
                        </div>
                      </td>
                    </tr>
                    <?php ob_start(); ?>
                    <!-- Price Edit Modal -->
                    <div class="modal fade" id="<?= $modalId ?>" tabindex="-1" aria-labelledby="<?= $modalId ?>Label" aria-hidden="true">
                      <div class="modal-dialog modal-lg modal-dialog-scrollable">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h5 class="modal-title" id="<?= $modalId ?>Label">Edit Price</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                          </div>
                          <form method="post" action="/admin/vendor-package-prices/store">
                            <div class="modal-body">
                              <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                              <input type="hidden" name="vendor_id" value="<?= (int)$vendorId ?>">
                              <input type="hidden" name="package_id" value="<?= (int)$package['id'] ?>">
                              <input type="hidden" name="variant_id" value="<?= (int)$v['id'] ?>">
                              <input type="hidden" name="id" value="<?= $pid ?>">
                              <div class="row g-2">
                                <div class="col-sm-4">
                                  <label class="form-label">Type</label>
                                  <?php $ptype = (string)$p['price_type']; ?>
                                  <select name="price_type" class="form-select" required>
                                    <option value="base" <?= $ptype==='base'? 'selected':'' ?>>base</option>
                                    <option value="group_tier" <?= $ptype==='group_tier'? 'selected':'' ?>>group_tier</option>
                                  </select>
                                </div>
                                <div class="col-sm-4">
                                  <label class="form-label">Pax</label>
                                  <?php $pax = (string)$p['pax_type']; ?>
                                  <select name="pax_type" class="form-select" required>
                                    <option value="adult" <?= $pax==='adult'? 'selected':'' ?>>adult</option>
                                    <option value="child" <?= $pax==='child'? 'selected':'' ?>>child</option>
                                    <option value="flat" <?= $pax==='flat'? 'selected':'' ?>>flat</option>
                                  </select>
                                </div>
                                <div class="col-sm-4">
                                  <label class="form-label">Min Qty</label>
                                  <input type="number" name="min_quantity" class="form-control" min="0" value="<?= (int)$p['min_quantity'] ?>" required>
                                </div>
                                <div class="col-sm-4">
                                  <label class="form-label">Vendor Cost</label>
                                  <input type="number" step="0.01" name="vendor_cost" class="form-control" value="<?= htmlspecialchars((string)$p['vendor_cost']) ?>" required>
                                </div>
                                <div class="col-sm-4">
                                  <label class="form-label">Agent Price</label>
                                  <input type="number" step="0.01" name="agent_price" class="form-control" value="<?= htmlspecialchars((string)$p['agent_price']) ?>" required>
                                </div>
                                <div class="col-sm-4">
                                  <label class="form-label">Customer Price</label>
                                  <input type="number" step="0.01" name="customer_price" class="form-control" value="<?= htmlspecialchars((string)($p['customer_price'] ?? '')) ?>">
                                </div>
                                <div class="col-sm-4">
                                  <label class="form-label">Customer Promo Price</label>
                                  <input type="number" step="0.01" name="customer_promo_price" class="form-control" value="<?= htmlspecialchars((string)($p['customer_promo_price'] ?? '')) ?>">
                                </div>
                                <?php $ps = !empty($p['promo_start_at']) ? date('Y-m-d\\TH:i', strtotime($p['promo_start_at'])) : ''; $pe = !empty($p['promo_end_at']) ? date('Y-m-d\\TH:i', strtotime($p['promo_end_at'])) : ''; ?>
                                <div class="col-sm-4">
                                  <label class="form-label">Promo Start</label>
                                  <input type="datetime-local" name="promo_start_at" class="form-control" value="<?= htmlspecialchars($ps) ?>">
                                </div>
                                <div class="col-sm-4">
                                  <label class="form-label">Promo End</label>
                                  <input type="datetime-local" name="promo_end_at" class="form-control" value="<?= htmlspecialchars($pe) ?>">
                                </div>
                                <div class="col-sm-4">
                                  <label class="form-label">Currency</label>
                                  <input type="text" name="currency" class="form-control" value="<?= htmlspecialchars($p['currency']) ?>" required>
                                </div>
                                <?php $pkType = (string)($p['pickup_type'] ?? 'none'); $pkScope = (string)($p['pickup_scope'] ?? 'pickup_and_drop'); $pickupComboVal = ($pkType==='none' ? 'none' : ($pkScope==='pickup_only' ? 'pickup_only' : 'pickup_and_drop')); ?>
                                <div class="col-sm-6">
                                  <label class="form-label">Pickup Option</label>
                                  <select name="pickup_combo" class="form-select">
                                    <option value="pickup_only" <?= $pickupComboVal==='pickup_only'? 'selected':'' ?>>Only Free Pickup</option>
                                    <option value="pickup_and_drop" <?= $pickupComboVal==='pickup_and_drop'? 'selected':'' ?>>Free Pick & Drop</option>
                                    <option value="none" <?= $pickupComboVal==='none'? 'selected':'' ?>>No Pickup</option>
                                  </select>
                                </div>
                                <div class="col-sm-4">
                                  <label class="form-label">Pickup Notes</label>
                                  <input type="text" name="pickup_notes" class="form-control" value="<?= htmlspecialchars((string)($p['pickup_notes'] ?? '')) ?>">
                                </div>
                                <div class="col-sm-6 d-flex align-items-center">
                                  <div class="form-check mb-0">
                                    <input class="form-check-input" type="checkbox" name="active" id="price_active_<?= $pid ?>" <?= ((int)($p['active'] ?? 1) === 1) ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="price_active_<?= $pid ?>">Active</label>
                                  </div>
                                </div>
                                <div class="col-sm-6">
                                  <label class="form-label">Master Password</label>
                                  <input type="password" name="master_password" class="form-control" required>
                                </div>
                              </div>
                            </div>
                            <div class="modal-footer">
                              <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                              <button type="submit" class="btn btn-primary">Save Changes</button>
                            </div>
                          </form>
                        </div>
                      </div>
                    </div>
                    <!-- Price Delete Modal -->
                    <div class="modal fade" id="delPriceModal_<?= $pid ?>" tabindex="-1" aria-labelledby="delPriceModalLabel_<?= $pid ?>" aria-hidden="true">
                      <div class="modal-dialog">
                        <div class="modal-content">
                          <div class="modal-header">
                            <h5 class="modal-title" id="delPriceModalLabel_<?= $pid ?>">Delete Price</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                          </div>
                          <form method="post" action="/admin/vendor-package-prices/delete">
                            <div class="modal-body">
                              <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                              <input type="hidden" name="vendor_id" value="<?= (int)$vendorId ?>">
                              <input type="hidden" name="id" value="<?= $pid ?>">
                              <div class="alert alert-warning small">This will permanently delete this price row.</div>
                              <div class="mb-2">
                                <label class="form-label">Master Password</label>
                                <input type="password" name="master_password" class="form-control" required>
                              </div>
                            </div>
                            <div class="modal-footer">
                              <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                              <button type="submit" class="btn btn-danger">Delete</button>
                            </div>
                          </form>
                        </div>
                      </div>
                    </div>
                    <?php $variantModals .= ob_get_clean(); ?>
                  <?php endforeach; ?>
                  </tbody>
                </table>
              </div>
              <?php $allModals .= $variantModals; ?>
            </div>
          </div>
        <?php endforeach; ?>
        </div>
      </div>

      <!-- No right column; buttons are in header. Keep modal markup below -->
      <?= $allModals ?>

        <!-- Modal: Add Variant -->
        <div class="modal fade" id="addVariantModal" tabindex="-1" aria-labelledby="addVariantModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="addVariantModalLabel">Add Variant</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <form method="post" action="/admin/vendor-package-variants/store">
                <div class="modal-body">
                  <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                  <input type="hidden" name="vendor_id" value="<?= (int)$vendorId ?>">
                  <input type="hidden" name="package_id" value="<?= (int)$package['id'] ?>">
                  <div class="row g-2">
                    <div class="col-12">
                      <label class="form-label">Name</label>
                      <input type="text" name="name" class="form-control" placeholder="Standard / VIP" required>
                    </div>
                    <div class="col-12">
                      <label class="form-label">Included Activities (comma-separated)</label>
                      <textarea name="notes" class="form-control" rows="4" placeholder="Parasailing, Seawalk, Banana Boat, Lunch, VIP Beach Chair, Speed Boat"></textarea>
                      <div class="form-help">Add activities separated by commas. Leave blank if nothing is included.</div>
                    </div>
                    <div class="col-sm-6 d-flex align-items-center">
                      <div class="form-check mb-0">
                        <input class="form-check-input" type="checkbox" name="active" id="v_active_modal" checked>
                        <label class="form-check-label" for="v_active_modal">Active</label>
                      </div>
                    </div>
                    <div class="col-sm-6">
                      <label class="form-label">Master Password</label>
                      <input type="password" name="master_password" class="form-control" required>
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                  <button type="submit" class="btn btn-primary">Save Variant</button>
                </div>
              </form>
            </div>
          </div>
        </div>

        <!-- End Add Variant modal. Add Price modal below. -->

        <!-- Modal: Add Price -->
        <div class="modal fade" id="addPriceModal" tabindex="-1" aria-labelledby="addPriceModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg modal-dialog-scrollable">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="addPriceModalLabel">Add Price</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
              </div>
              <form method="post" action="/admin/vendor-package-prices/store">
                <div class="modal-body">
                  <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                  <input type="hidden" name="vendor_id" value="<?= (int)$vendorId ?>">
                  <input type="hidden" name="package_id" value="<?= (int)$package['id'] ?>">

                  <div class="row g-2">
                    <div class="col-sm-6 col-md-4">
                      <label class="form-label">Variant</label>
                      <select name="variant_id" class="form-select" required>
                        <option value="">-- Choose --</option>
                        <?php foreach ($variants as $v) { echo '<option value="'.(int)$v['id'].'">'.htmlspecialchars($v['name']).'</option>'; } ?>
                      </select>
                    </div>
                    <div class="col-sm-6 col-md-3">
                      <label class="form-label">Type</label>
                      <select name="price_type" class="form-select">
                        <option value="base">Base</option>
                        <option value="group_tier">Group Tier</option>
                      </select>
                    </div>
                    <div class="col-sm-6 col-md-3">
                      <label class="form-label">Pax</label>
                      <?php $isAdultOnly = ($package['age_policy'] ?? 'adult_only') === 'adult_only'; ?>
                      <select name="pax_type" class="form-select">
                        <option value="adult">Adult</option>
                        <?php if (!$isAdultOnly): ?>
                          <option value="child">Child</option>
                        <?php endif; ?>
                        <option value="flat">Flat</option>
                      </select>
                    </div>
                    <div class="col-sm-6 col-md-2">
                      <label class="form-label">Min Qty</label>
                      <input type="number" min="0" name="min_quantity" class="form-control" placeholder="0 or 10+">
                    </div>
                    <div class="col-sm-6 col-md-3">
                      <label class="form-label">Vendor Cost</label>
                      <input type="number" min="0" step="0.01" name="vendor_cost" class="form-control" required>
                    </div>
                    <div class="col-sm-6 col-md-3">
                      <label class="form-label">Agent Price</label>
                      <input type="number" min="0" step="0.01" name="agent_price" class="form-control" required>
                    </div>
                    <div class="col-sm-6 col-md-3">
                      <label class="form-label">Customer Price</label>
                      <input type="number" min="0" step="0.01" name="customer_price" class="form-control">
                    </div>
                    <div class="col-sm-6 col-md-3">
                      <label class="form-label">Customer Promo Price</label>
                      <input type="number" min="0" step="0.01" name="customer_promo_price" class="form-control">
                    </div>
                    <div class="col-sm-6 col-md-3">
                      <label class="form-label">Promo Start</label>
                      <input type="datetime-local" name="promo_start_at" class="form-control">
                    </div>
                    <div class="col-sm-6 col-md-3">
                      <label class="form-label">Promo End</label>
                      <input type="datetime-local" name="promo_end_at" class="form-control">
                    </div>
                    <div class="col-sm-6 col-md-2">
                      <label class="form-label">Currency</label>
                      <input type="text" name="currency" class="form-control" value="THB">
                    </div>
                    <div class="col-sm-6 col-md-4">
                      <label class="form-label">Pickup Option</label>
                      <select name="pickup_combo" class="form-select">
                        <option value="pickup_only">Only Free Pickup</option>
                        <option value="pickup_and_drop" selected>Free Pick & Drop</option>
                        <option value="none">No Pickup</option>
                      </select>
                    </div>
                    <div class="col-sm-6 col-md-8">
                      <label class="form-label">Pickup Notes</label>
                      <input type="text" name="pickup_notes" class="form-control" placeholder="Optional notes">
                    </div>
                    <div class="col-sm-6 col-md-2 d-flex align-items-center">
                      <div class="form-check mb-0">
                        <input class="form-check-input" type="checkbox" name="active" id="p_active_modal" checked>
                        <label class="form-check-label" for="p_active_modal">Active</label>
                      </div>
                    </div>
                    <div class="col-sm-12 col-md-4">
                      <label class="form-label">Master Password</label>
                      <input type="password" name="master_password" class="form-control" required>
                    </div>
                  </div>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                  <button type="submit" class="btn btn-primary">Save Price</button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>

    <script>
      (function(){
        const list = document.getElementById('variantsList');
        const filterInput = document.getElementById('variantFilter');
        const btnExpand = document.getElementById('expandAll');
        const btnCollapse = document.getElementById('collapseAll');
        if (!list) return;

        // Filter by variant name
        if (filterInput) {
          filterInput.addEventListener('input', function(){
            const q = this.value.trim().toLowerCase();
            list.querySelectorAll('.variant-item').forEach(function(item){
              const name = item.getAttribute('data-name') || '';
              item.style.display = name.indexOf(q) !== -1 ? '' : 'none';
            });
          });
        }

        function setAll(open) {
          list.querySelectorAll('.variant-body').forEach(function(body){
            if (window.bootstrap && bootstrap.Collapse) {
              const inst = bootstrap.Collapse.getOrCreateInstance(body, {toggle:false});
              open ? inst.show() : inst.hide();
            } else {
              // Fallback if Bootstrap JS not loaded
              if (open) body.classList.add('show'); else body.classList.remove('show');
            }
          });
        }

        if (btnExpand) btnExpand.addEventListener('click', function(){ setAll(true); });
        if (btnCollapse) btnCollapse.addEventListener('click', function(){ setAll(false); });
        // Init polished tooltips without conflicting with modal toggles
        try {
          if (window.bootstrap) {
            document.querySelectorAll('[data-bs-toggle-tooltip]').forEach(function(el){
              try { new bootstrap.Tooltip(el, { container: 'body' }); } catch(e) { /* ignore */ }
            });
          }
        } catch (e) { /* ignore */ }

      })();

      (function(){
        // Prevent collapse toggle when clicking action buttons,
        // general action zones should not toggle collapse
        document.querySelectorAll('.js-no-toggle').forEach(function(el){
          ['click','mousedown'].forEach(function(evt){
            el.addEventListener(evt, function(e){
              e.stopPropagation();
            }, true);
          });
        });

        function toggleVariant(toggler) {
          var sel = toggler.getAttribute('data-bs-target');
          if (!sel) return;
          var target = document.querySelector(sel);
          if (!target) return;
          try {
            if (window.bootstrap && bootstrap.Collapse) {
              var instance = bootstrap.Collapse.getOrCreateInstance(target);
              instance.toggle();
            } else {
              // Fallback: toggle 'show' class and height style
              var willShow = !target.classList.contains('show');
              if (willShow) {
                target.classList.add('show');
                target.style.height = 'auto';
              } else {
                target.classList.remove('show');
                target.style.height = '';
              }
            }
          } catch (err) {
            target.classList.toggle('show');
          }
          var isShown = target.classList.contains('show');
          toggler.setAttribute('aria-expanded', isShown ? 'true' : 'false');
        }

        // Delegated click: handles dynamically rendered items as well
        var variantsList = document.getElementById('variantsList');
        if (variantsList) {
          variantsList.addEventListener('click', function(e){
            var toggler = e.target.closest('.variant-toggle');
            if (!toggler) return;
            // Do not trigger from inside action zones
            if (e.target.closest('.js-no-toggle, .js-pass-form, .js-del-form')) return;
            e.preventDefault();
            e.stopPropagation();
            toggleVariant(toggler);
          }, true);

          // Keyboard support
          variantsList.addEventListener('keydown', function(e){
  </div>
</div>

<!-- Modal: Edit Package -->
<script>
  (function(){
    // Initialize vehicle selectors
    function initVehSelectors(ctx) {
      if (!ctx) ctx = document;
      // Initialize vehicle type selectors
      ctx.querySelectorAll('.veh-selector').forEach(function(sel) {
        if (sel._vehInitialized) return;
        sel._vehInitialized = true;
        sel.addEventListener('change', function() {
          const val = this.value;
          const row = this.closest('tr');
          if (!row) return;
          // Update display
          const display = row.querySelector('.veh-display');
          if (display) display.textContent = this.options[this.selectedIndex]?.text || '';
          // Show/hide capacity field based on selection
          const capField = row.querySelector('.veh-capacity-field');
          if (capField) capField.style.display = val && val !== 'private' ? '' : 'none';
        });
        // Trigger change to set initial state
        sel.dispatchEvent(new Event('change'));
      });
    }
    
    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
      initVehSelectors(document);
      
      // Also re-init when modals open (Bootstrap event)
      document.addEventListener('shown.bs.modal', function(e) {
        initVehSelectors(e.target);
      });
      
      // Initialize tooltips
      const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
      tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
      });
      
      // Auto-submit Enable/Disable switch
      document.addEventListener('change', function(e) {
        const el = e.target;
        if (!el.classList || !el.classList.contains('js-switch-active')) return;
        const form = el.closest('form');
        if (!form) return;
        const hidden = form.querySelector('input[name="is_active"]');
        if (hidden) { 
          hidden.value = el.checked ? '1' : '0'; 
        }
        form.submit();
      });
      
      // Thumbnail dropzones: drag & drop + instant preview
      function bindZone(zone) {
        if (!zone) return;
        var inputSel = zone.getAttribute('data-input');
        var prevSel = zone.getAttribute('data-preview');
        var input = inputSel ? document.querySelector(inputSel) : null;
        var preview = prevSel ? document.querySelector(prevSel) : null;

        function showFile(file) {
          if (!file || !file.type || !file.type.startsWith('image/')) return;
          if (file.size > 2*1024*1024) { 
            alert('Image too large (max 2MB).'); 
            return; 
          }
          var reader = new FileReader();
          reader.onload = function(e) {
            if (preview) { 
              preview.src = e.target.result; 
              preview.style.display = ''; 
            }
          };
          reader.readAsDataURL(file);
        }

        zone.addEventListener('click', function() { 
          if (input) input.click(); 
        });

        ['dragenter', 'dragover'].forEach(function(evt) {
          zone.addEventListener(evt, function(e) { 
            e.preventDefault(); 
            e.stopPropagation(); 
            zone.classList.add('border-primary'); 
          });
        });

        ['dragleave', 'drop'].forEach(function(evt) {
          zone.addEventListener(evt, function(e) { 
            e.preventDefault(); 
            e.stopPropagation(); 
            zone.classList.remove('border-primary'); 
          });
        });

        zone.addEventListener('drop', function(e) {
          var f = e.dataTransfer && e.dataTransfer.files && e.dataTransfer.files[0];
          if (f) { 
            if (input) { 
              input.files = e.dataTransfer.files; 
            } 
            showFile(f);
          }
        });

        if (input) {
          input.addEventListener('change', function() { 
            var f = this.files && this.files[0]; 
            if (f) showFile(f); 
          });
        }
      }

      document.querySelectorAll('.thumb-dropzone').forEach(bindZone);
    });
  })();
</script>

<div class="modal fade" id="editPackageModal" tabindex="-1" aria-labelledby="editPackageModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="editPackageModalLabel">Edit Package</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <form method="post" action="/admin/vendor-packages/store" enctype="multipart/form-data">
        <div class="modal-body">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
          <input type="hidden" name="vendor_id" value="<?= (int)$vendorId ?>">
          <input type="hidden" name="id" value="<?= (int)$package['id'] ?>">
          <div class="row g-2">
            <div class="col-sm-6">
              <label class="form-label">Name</label>
              <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($package['name']) ?>" required>
            </div>
            <div class="col-sm-6">
              <label class="form-label">Module</label>
              <?php $mod = (string)($package['module'] ?? 'activity'); ?>
              <select name="module" class="form-select" required>
                <option value="activity" <?= $mod==='activity'?'selected':'' ?>>Activity</option>
                <option value="hotel" <?= $mod==='hotel'?'selected':'' ?>>Hotel</option>
                <option value="taxi" <?= $mod==='taxi'?'selected':'' ?>>Taxi</option>
                <option value="evisa" <?= $mod==='evisa'?'selected':'' ?>>eVisa</option>
              </select>
            </div>
            <div class="col-sm-6 d-flex align-items-center">
              <div class="form-check mt-3">
                <input class="form-check-input" type="checkbox" name="requires_show_time" id="reqTime_modal" <?= (int)($package['requires_show_time'] ?? 0) ? 'checked' : '' ?>>
                <label class="form-check-label" for="reqTime_modal">Requires show time</label>
              </div>
            </div>
            <div class="col-sm-6">
              <label class="form-label">Age Policy</label>
              <?php $policy = (string)($package['age_policy'] ?? 'adult_only'); ?>
              <select name="age_policy" class="form-select">
                <option value="adult_only" <?= $policy==='adult_only'?'selected':'' ?>>adult_only</option>
                <option value="family" <?= $policy==='family'?'selected':'' ?>>family</option>
              </select>
            </div>
            <div class="col-12">
              <label class="form-label">Address Override</label>
              <textarea name="address_override" class="form-control" rows="2"><?= htmlspecialchars((string)($package['address_override'] ?? '')) ?></textarea>
            </div>
            <div class="col-sm-6">
              <label class="form-label">Thumbnail</label>
              <div class="thumb-dropzone" id="thumbZone_manage" data-input="#thumbInput_manage" data-preview="#thumbPrev_manage" style="border:1px dashed #ced4da;border-radius:.375rem;padding:.5rem;display:flex;gap:.5rem;align-items:center;cursor:pointer;background:#fff;">
                <img id="thumbPrev_manage" src="<?= !empty($package['thumbnail_path']) ? htmlspecialchars($package['thumbnail_path']) : '' ?>" alt="preview" style="width:64px;height:64px;object-fit:cover;border-radius:4px;border:1px solid #eee;<?= empty($package['thumbnail_path']) ? 'display:none;' : '' ?>">
                <div class="small text-muted">
                  <div><strong>Drop image</strong> here or click to choose</div>
                  <div>JPG/PNG/WebP up to 2MB</div>
                  <?php if (!empty($package['thumbnail_path'])): ?>
                    <div class="text-truncate" style="max-width:280px;">Current: <?= htmlspecialchars($package['thumbnail_path']) ?></div>
                  <?php endif; ?>
                </div>
              </div>
              <input id="thumbInput_manage" type="file" name="thumbnail" accept="image/*" class="form-control mt-2" style="display:none">
            </div>
            <div class="col-sm-6 d-flex align-items-center">
              <div class="form-check mt-3">
                <input class="form-check-input" type="checkbox" name="active" id="pkgActive_modal" <?= (int)($package['active'] ?? 1) ? 'checked' : '' ?>>
                <label class="form-check-label" for="pkgActive_modal">Active</label>
              </div>
            </div>
            <div class="col-sm-6">
              <label class="form-label">Master Password</label>
              <input type="password" name="master_password" class="form-control" required>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-primary">Save Changes</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
  (function(){
    const list = document.getElementById('variantsList');
    const filterInput = document.getElementById('variantFilter');
    const btnExpand = document.getElementById('expandAll');
    const btnCollapse = document.getElementById('collapseAll');
    if (!list) return;

    // Filter by variant name
    if (filterInput) {
      filterInput.addEventListener('input', function(){
        const q = this.value.trim().toLowerCase();
        list.querySelectorAll('.variant-item').forEach(function(item){
          const name = item.getAttribute('data-name') || '';
          item.style.display = name.indexOf(q) !== -1 ? '' : 'none';
        });
      });
    }

    function setAll(open) {
      list.querySelectorAll('.variant-body').forEach(function(body){
        if (window.bootstrap && bootstrap.Collapse) {
          const inst = bootstrap.Collapse.getOrCreateInstance(body, {toggle:false});
          open ? inst.show() : inst.hide();
        } else { // Fallback if Bootstrap JS not loaded
          if (open) body.classList.add('show');
          else body.classList.remove('show');
        }
      });
    }

    if (btnExpand) btnExpand.addEventListener('click', function(){ setAll(true); });
    if (btnCollapse) btnCollapse.addEventListener('click', function(){ setAll(false); });

    // Init polished tooltips without conflicting with modal toggles
    try {
      if (window.bootstrap) {
        document.querySelectorAll('[data-bs-toggle-tooltip]').forEach(function(el){
          try { new bootstrap.Tooltip(el, { container: 'body' }); } catch(e) { /* ignore */ }
        });
      }
    } catch (e) { /* ignore */ }
  })();
</script>


