<?php
/** @var string $csrf */
/** @var array $vendors */
/** @var int $vendorId */
/** @var array $packages */
/** @var array $countries */
/** @var array $cities */
/** @var string $selectedCountry */
/** @var string $selectedCity */
if (!isset($title)) { $title = 'Packages'; }
?>
<style>
  .section-card { border: 1px solid #e9ecef; border-radius: .5rem; padding: 1rem; margin-bottom: 1rem; }
  .chip { display:inline-block; padding:.25rem .5rem; border-radius:1rem; background:#f1f3f5; margin:.125rem; font-size:.85rem }
  .pkg-row { border-bottom: 1px solid #f1f3f5; padding:.5rem 0; }
  /* Buttons: utilities */
  .btn-pill { border-radius: 999px !important; }
  .btn-elevated { box-shadow: 0 1px 2px rgba(16,24,40,.05), 0 1px 1px rgba(16,24,40,.05); }
  .btn-icon-left .icon { width: 16px; height: 16px; margin-right: .35rem; vertical-align: -2px; }
  .btn-icon-only .icon { width: 16px; height: 16px; }
  .btn-outline-secondary-strong { color: #344054; border-color: #d0d5dd; }
  .btn-outline-secondary-strong:hover { background:#f8f9fb; border-color:#c8ced6; }
  /* Action pill buttons look */
  .table .btn.btn-pill { padding: .4rem .9rem; font-weight: 500; line-height: 1.1; white-space: nowrap; }
  .table .btn.btn-pill .icon { color: currentColor; }
  .table .btn.btn-outline-secondary-strong.btn-pill { border-width: 2px; }
  .table .btn.btn-outline-primary.btn-pill { border-width: 2px; }
  .table .btn.btn-outline-danger.btn-pill { border-width: 2px; }
  /* Stronger outline colors to match mocks */
  #packagesTable .btn.btn-outline-primary { color: #0b4a99; border-color: #0b4a99; }
  #packagesTable .btn.btn-outline-primary:hover { background: rgba(11,74,153,.06); }
  #packagesTable .btn.btn-outline-danger { color: #cc2936; border-color: #cc2936; }
  #packagesTable .btn.btn-outline-danger:hover { background: rgba(204,41,54,.06); }
  /* Ensure right alignment in action cell */
  #packagesTable td.text-end { white-space: nowrap; }
  /* Improve gap between buttons inside action cell */
  #packagesTable td.text-end > .d-inline-flex.gap-1 { gap: .5rem !important; }
</style>
<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-2">
    <h4 class="mb-0">Packages</h4>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-2"><?= htmlspecialchars($_SESSION['flash']) ?></div>
    <?php unset($_SESSION['flash']); endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2">
      <?php foreach ((array)$_SESSION['errors'] as $e): ?>
        <div>- <?= htmlspecialchars($e) ?></div>
      <?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <div class="section-card bg-white">
    <form method="get" class="row g-2 align-items-end">
      <div class="col-sm-6 col-md-3">
        <label class="form-label">Country</label>
        <select name="country" class="form-select" onchange="this.form.submit()">
          <option value="">-- All Countries --</option>
          <?php foreach (($countries ?? []) as $c): $cval = is_array($c) ? ($c['country'] ?? '') : $c; if ($cval==='') continue; ?>
            <option value="<?= htmlspecialchars($cval) ?>" <?= ($selectedCountry ?? '')===$cval ? 'selected' : '' ?>><?= htmlspecialchars($cval) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-sm-6 col-md-3">
        <label class="form-label">City</label>
        <select name="city" class="form-select" onchange="this.form.submit()">
          <option value="">-- All Cities --</option>
          <?php foreach (($cities ?? []) as $c): $cval = is_array($c) ? ($c['city'] ?? '') : $c; if ($cval==='') continue; ?>
            <option value="<?= htmlspecialchars($cval) ?>" <?= ($selectedCity ?? '')===$cval ? 'selected' : '' ?>><?= htmlspecialchars($cval) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-sm-6 col-md-4">
        <label class="form-label">Select Vendor</label>
        <select name="vendor_id" class="form-select" onchange="this.form.submit()">
          <option value="">-- All Vendors --</option>
          <?php foreach (($vendors ?? []) as $v): ?>
            <option value="<?= (int)$v['id'] ?>" <?= isset($vendorId) && $vendorId==(int)$v['id'] ? 'selected' : '' ?>><?= htmlspecialchars($v['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-auto">
        <button class="btn btn-primary">Filter</button>
      </div>
    </form>
  </div>

  <div class="section-card bg-white">
    <?php if (empty($packages)): ?>
      <div class="text-muted">No packages found.</div>
    <?php else: ?>
      <?php $modalsHtml = ''; ?>
      <div class="row g-2 mb-2">
        <div class="col-auto ms-auto">
          <input id="pkgSearch" type="text" class="form-control form-control-sm" placeholder="Search packages... (name, vendor, city, country, policy)">
        </div>
      </div>
      <div class="table-responsive">
        <table class="table table-sm table-hover align-middle" id="packagesTable">
          <thead class="table-light">
            <tr>
              <th style="width:56px">S/N</th>
              <th>Package</th>
              <th style="width:110px">Unique Code</th>
              <th>Vendor</th>
              <th>Location</th>
              <th>Country</th>
              <th>Policy</th>
              <th>Status</th>
              <th class="text-end" style="width:120px">Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php $sn = 1; foreach ($packages as $p): $pid = (int)$p['id']; ?>
              <?php
                $name = (string)($p['name'] ?? '');
                $vendorName = (string)($p['vendor_name'] ?? '');
                $city = (string)($p['city'] ?? '');
                $country = (string)($p['country'] ?? '');
                $policy = (string)($p['age_policy'] ?? 'adult_only');
                $active = (int)($p['active'] ?? 0) === 1;
                $requiresTime = !empty($p['requires_show_time']);
                $thumb = (string)($p['thumbnail_path'] ?? '');
              ?>
              <tr data-search-text="<?= htmlspecialchars(strtolower(trim($pid.' '.$name.' '.$vendorName.' '.$city.' '.$country.' '.$policy))) ?>">
                <td><?= $sn++ ?></td>
                <td>
                  <div class="d-flex align-items-center">
                    <?php if ($thumb !== ''): ?>
                      <img src="<?= htmlspecialchars($thumb) ?>" alt="thumb" class="me-2" style="width:40px;height:40px;object-fit:cover;border-radius:4px;border:1px solid #eee;">
                    <?php endif; ?>
                    <div>
                      <div>
                        <strong><a href="/admin/vendors/package_manage?id=<?= $pid ?>" class="text-decoration-none link-dark"><?= htmlspecialchars($name) ?></a></strong>
                      </div>
                      <?php if ($requiresTime): ?>
                        <div class="small text-muted">Needs time</div>
                      <?php endif; ?>
                    </div>
                  </div>
                </td>
                <td><?= $pid ?></td>
                <td><?= $vendorName !== '' ? htmlspecialchars($vendorName) : '-' ?></td>
                <td><?= $city !== '' ? htmlspecialchars($city) : '-' ?></td>
                <td><?= $country !== '' ? htmlspecialchars($country) : '-' ?></td>
                <td><?= htmlspecialchars($policy) ?></td>
                <td>
                  <span class="badge <?= $active ? 'bg-success' : 'bg-secondary' ?>"><?= $active ? 'Active' : 'Inactive' ?></span>
                </td>
                <td class="text-end">
                  <div class="d-inline-flex gap-1">
                    <button type="button" class="btn btn-outline-secondary-strong btn-sm btn-pill btn-icon-left" data-bs-toggle="modal" data-bs-target="#editPkgModal_<?= $pid ?>" title="Edit package">
                      <svg class="icon" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"><path d="M12.146.646a.5.5 0 0 1 .708 0l2.5 2.5a.5.5 0 0 1 0 .708l-9.5 9.5a.5.5 0 0 1-.233.131l-4 1a.5.5 0 0 1-.606-.606l1-4a.5.5 0 0 1 .131-.233l9.5-9.5zM11.207 2.5 13.5 4.793 14.793 3.5 12.5 1.207 11.207 2.5zM12.5 5.5 10.5 3.5 3 11v2h2l7.5-7.5z"/></svg>
                      Edit
                    </button>
                    <a class="btn btn-outline-primary btn-sm btn-pill btn-icon-left" href="/admin/vendors/package_manage?id=<?= $pid ?>" title="Open manage view">
                      <svg class="icon" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"><path d="M1.5 2A1.5 1.5 0 0 0 0 3.5v9A1.5 1.5 0 0 0 1.5 14h13A1.5 1.5 0 0 0 16 12.5v-9A1.5 1.5 0 0 0 14.5 2h-13zm0 1h13a.5.5 0 0 1 .5.5V5H1V3.5a.5.5 0 0 1 .5-.5zM1 6h14v6.5a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5V6z"/></svg>
                      Manage
                    </a>
                    <button type="button" class="btn btn-outline-danger btn-sm btn-pill btn-icon-left" data-bs-toggle="modal" data-bs-target="#delPkgModal_<?= $pid ?>" title="Delete package">
                      <svg class="icon" viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"><path d="M5.5 5a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5zm3 0a.5.5 0 0 1 .5.5v7a.5.5 0 0 1-1 0v-7a.5.5 0 0 1 .5-.5z"/><path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1 0-2h3.086a1 1 0 0 1 .707.293l.854.854h2.906l.854-.854A1 1 0 0 1 11.414 1H14.5a1 1 0 0 1 1 1z"/></svg>
                      Delete
                    </button>
                  </div>
                </td>
              </tr>
              <?php ob_start(); ?>
              <!-- Edit Package Modal -->
              <div class="modal fade" id="editPkgModal_<?= $pid ?>" tabindex="-1" aria-labelledby="editPkgModalLabel_<?= $pid ?>" aria-hidden="true">
                <div class="modal-dialog modal-lg">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="editPkgModalLabel_<?= $pid ?>">Edit Package</h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form method="post" action="/admin/vendor-packages/store" enctype="multipart/form-data">
                      <div class="modal-body">
                        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                        <input type="hidden" name="id" value="<?= $pid ?>">
                        <input type="hidden" name="vendor_id" value="<?= (int)$p['vendor_id'] ?>">
                        <div class="row g-2">
                          <div class="col-sm-6">
                            <label class="form-label">Name</label>
                            <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($name) ?>" required>
                          </div>
                          <div class="col-sm-6">
                            <label class="form-label">Module</label>
                            <?php $mod = (string)($p['module'] ?? 'activity'); ?>
                            <select name="module" class="form-select" required>
                              <option value="activity" <?= $mod==='activity'?'selected':'' ?>>Activity</option>
                              <option value="hotel" <?= $mod==='hotel'?'selected':'' ?>>Hotel</option>
                              <option value="taxi" <?= $mod==='taxi'?'selected':'' ?>>Taxi</option>
                              <option value="evisa" <?= $mod==='evisa'?'selected':'' ?>>eVisa</option>
                            </select>
                          </div>
                          <div class="col-sm-6 d-flex align-items-center">
                            <div class="form-check mt-3">
                              <input class="form-check-input" type="checkbox" name="requires_show_time" id="reqTime_<?= $pid ?>" <?= $requiresTime ? 'checked' : '' ?>>
                              <label class="form-check-label" for="reqTime_<?= $pid ?>">Requires show time</label>
                            </div>
                          </div>
                          <div class="col-sm-6">
                            <label class="form-label">Age Policy</label>
                            <select name="age_policy" class="form-select">
                              <option value="adult_only" <?= $policy==='adult_only'?'selected':'' ?>>adult_only</option>
                              <option value="family" <?= $policy==='family'?'selected':'' ?>>family</option>
                            </select>
                          </div>
                          <div class="col-12">
                            <label class="form-label">Address Override</label>
                            <textarea name="address_override" class="form-control" rows="2"><?= htmlspecialchars((string)($p['address_override'] ?? '')) ?></textarea>
                          </div>
                          <div class="col-sm-6">
                            <label class="form-label">Thumbnail</label>
                            <div class="thumb-dropzone" id="thumbZone_<?= $pid ?>" data-input="#thumbInput_<?= $pid ?>" data-preview="#thumbPrev_<?= $pid ?>" style="border:1px dashed #ced4da;border-radius:.375rem;padding:.5rem;display:flex;gap:.5rem;align-items:center;cursor:pointer;background:#fff;">
                              <img id="thumbPrev_<?= $pid ?>" src="<?= !empty($thumb) ? htmlspecialchars($thumb) : '' ?>" alt="preview" style="width:56px;height:56px;object-fit:cover;border-radius:4px;border:1px solid #eee;<?= empty($thumb) ? 'display:none;' : '' ?>">
                              <div class="small text-muted">
                                <div><strong>Drop image</strong> here or click to choose</div>
                                <div>JPG/PNG/WebP up to 2MB</div>
                                <?php if (!empty($thumb)): ?>
                                  <div class="text-truncate" style="max-width:260px;">Current: <?= htmlspecialchars($thumb) ?></div>
                                <?php endif; ?>
                              </div>
                            </div>
                            <input id="thumbInput_<?= $pid ?>" type="file" name="thumbnail" accept="image/*" class="form-control mt-2" style="display:none">
                          </div>
                          <div class="col-sm-6 d-flex align-items-center">
                            <div class="form-check mt-3">
                              <input class="form-check-input" type="checkbox" name="active" id="pkgActive_<?= $pid ?>" <?= $active ? 'checked' : '' ?>>
                              <label class="form-check-label" for="pkgActive_<?= $pid ?>">Active</label>
                            </div>
                          </div>
                          <div class="col-sm-6">
                            <label class="form-label">Master Password</label>
                            <input type="password" name="master_password" class="form-control" required>
                          </div>
                        </div>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary">Save Changes</button>
                      </div>
                    </form>
                  </div>
                </div>
              </div>
              <!-- Delete Package Modal -->
              <div class="modal fade" id="delPkgModal_<?= $pid ?>" tabindex="-1" aria-labelledby="delPkgModalLabel_<?= $pid ?>" aria-hidden="true">
                <div class="modal-dialog">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="delPkgModalLabel_<?= $pid ?>">Delete Package</h5>
                      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form method="post" action="/admin/vendor-packages/delete">
                      <div class="modal-body">
                        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                        <input type="hidden" name="id" value="<?= $pid ?>">
                        <input type="hidden" name="vendor_id" value="<?= (int)$p['vendor_id'] ?>">
                        <div class="alert alert-warning small">
                          <strong>Warning:</strong> This will permanently delete the package <strong><?= htmlspecialchars($name) ?></strong> and <em>all related data</em> (variants, prices, showtimes). This action cannot be undone.
                        </div>
                        <div class="mb-2">
                          <label class="form-label">Master Password</label>
                          <input type="password" name="master_password" class="form-control" placeholder="Enter master password to confirm" required>
                        </div>
                      </div>
                      <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                      </div>
                    </form>
                  </div>
                </div>
              </div>
              <?php $modalsHtml .= ob_get_clean(); ?>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
      <!-- Render all accumulated modals outside the table to avoid invalid DOM inside <tbody> -->
      <?= $modalsHtml ?>
    <?php endif; ?>
  </div>
</div>

<script>
  (function(){
    const input = document.getElementById('pkgSearch');
    const tbody = document.querySelector('#packagesTable tbody');
    if (!input || !tbody) return;
    input.addEventListener('input', function(){
      const q = (this.value || '').toLowerCase().trim();
      const rows = tbody.querySelectorAll('tr');
      rows.forEach(function(tr){
        const hay = (tr.getAttribute('data-search-text') || '').toLowerCase();
        tr.style.display = hay.indexOf(q) !== -1 ? '' : 'none';
      });
    });
  })();

  // Thumbnail dropzones: drag & drop + instant preview for Edit modals
  (function(){
    function bindZone(zone){
      if (!zone) return;
      var inputSel = zone.getAttribute('data-input');
      var prevSel = zone.getAttribute('data-preview');
      var input = inputSel ? document.querySelector(inputSel) : null;
      var preview = prevSel ? document.querySelector(prevSel) : null;
      function showFile(file){
        if (!file || !file.type || !file.type.startsWith('image/')) return;
        if (file.size > 2*1024*1024) { alert('Image too large (max 2MB).'); return; }
        var reader = new FileReader();
        reader.onload = function(e){ if (preview) { preview.src = e.target.result; preview.style.display = ''; } };
        reader.readAsDataURL(file);
      }
      zone.addEventListener('click', function(){ if (input) input.click(); });
      ;['dragenter','dragover'].forEach(function(evt){ zone.addEventListener(evt, function(e){ e.preventDefault(); e.stopPropagation(); zone.classList.add('border-primary'); });});
      ;['dragleave','drop'].forEach(function(evt){ zone.addEventListener(evt, function(e){ e.preventDefault(); e.stopPropagation(); zone.classList.remove('border-primary'); });});
      zone.addEventListener('drop', function(e){ var f = e.dataTransfer && e.dataTransfer.files && e.dataTransfer.files[0]; if (f){ if (input) { input.files = e.dataTransfer.files; } showFile(f);} });
      if (input) input.addEventListener('change', function(){ var f = this.files && this.files[0]; if (f) showFile(f); });
    }
    document.querySelectorAll('.thumb-dropzone').forEach(bindZone);
  })();
  </script>
