<?php
// app/Views/vendor/login.php (Bootstrap)
$title = $title ?? 'Vendor Login';
$csrf = $csrf ?? '';
?>
<div class="container py-5" style="max-width:520px;">
  <div class="card shadow-sm">
    <div class="card-body">
      <h5 class="card-title mb-3">Vendor Login</h5>
      <?php if (!empty($_SESSION['flash'])): ?>
        <div class="alert alert-danger py-1 small"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
      <?php endif; ?>
      <form method="post" action="/vendor/login">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
        <div class="mb-3">
          <label for="email" class="form-label">Email</label>
          <input type="email" id="email" name="email" class="form-control" 
                 value="<?= htmlspecialchars($_POST['email'] ?? '') ?>"
                 autocomplete="username" required autofocus>
        </div>
        <div class="mb-3">
          <div class="d-flex justify-content-between">
            <label for="password" class="form-label">Password</label>
            <a href="/vendor/forgot-password" class="small text-muted text-decoration-none">Forgot password?</a>
          </div>
          <div class="input-group">
            <input type="password" id="password" name="password" class="form-control" 
                   autocomplete="current-password" required>
            <button class="btn btn-outline-secondary toggle-password" type="button" title="Show/hide password">
              <i class="bi bi-eye"></i>
            </button>
          </div>
        </div>
        <button type="submit" class="btn btn-primary w-100">
          <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
          <span class="btn-text">Login</span>
        </button>
      </form>
    </div>
  </div>
</div>

<script>
// Toggle password visibility
document.querySelectorAll('.toggle-password').forEach(btn => {
  btn.addEventListener('click', function() {
    const input = this.closest('.input-group').querySelector('input');
    const icon = this.querySelector('i');
    const type = input.type === 'password' ? 'text' : 'password';
    input.type = type;
    icon.className = type === 'password' ? 'bi bi-eye' : 'bi bi-eye-slash';
  });
});

// Form submission feedback
document.querySelector('form').addEventListener('submit', function(e) {
  const btn = this.querySelector('button[type="submit"]');
  const spinner = btn.querySelector('.spinner-border');
  const btnText = btn.querySelector('.btn-text');
  
  // Show loading state
  spinner.classList.remove('d-none');
  btnText.textContent = 'Logging in...';
  btn.disabled = true;
});
</script>
