<?php
// app/Views/vendor/job_view.php
// Expects: $booking (array), $events (array), $csrf (string)
$booking = $booking ?? [];
$events = $events ?? [];
$csrf = $csrf ?? '';
?>

<div class="container-fluid py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h5 mb-0">Job #<?= (int)($booking['id'] ?? 0) ?> <?= htmlspecialchars($booking['booking_code'] ?? '') ?></h1>
    <a href="/vendor/jobs" class="btn btn-sm btn-outline-secondary">Back to Jobs</a>
  </div>

  <div class="row g-3">
    <div class="col-lg-8">
      <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-0">
          <h6 class="mb-0">Booking Details</h6>
        </div>
        <div class="card-body">
          <div class="row mb-2">
            <div class="col-md-6">
              <div class="text-muted small">Ride</div>
              <div class="fw-semibold"><?= htmlspecialchars($booking['ride_name'] ?? '') ?></div>
            </div>
            <div class="col-md-6">
              <div class="text-muted small">Pax</div>
              <div class="fw-semibold"><?= (int)($booking['pax'] ?? 1) ?></div>
            </div>
          </div>
          <div class="row mb-2">
            <div class="col-md-6">
              <div class="text-muted small">Pickup</div>
              <div class="fw-semibold">
                <?= htmlspecialchars($booking['trip_date'] ?? '') ?>
                <?php if (!empty($booking['pickup_time'])): ?>
                  <span class="text-muted"><?= htmlspecialchars(' '.$booking['pickup_time']) ?></span>
                <?php endif; ?>
              </div>
            </div>
            <div class="col-md-6">
              <div class="text-muted small">Status</div>
              <?php
                $st = strtolower((string)($booking['status'] ?? 'pending'));
                $badge = 'warning';
                if ($st === 'confirmed' || $booking['completed_at'] ?? null) { $badge = 'success'; }
                elseif ($st === 'cancelled') { $badge = 'secondary'; }
                elseif ($st === 'refunded') { $badge = 'warning'; }
                elseif ($st === 'failed') { $badge = 'danger'; }
              ?>
              <div class="fw-semibold"><span class="badge bg-<?= $badge ?> text-dark"><?= ucfirst(htmlspecialchars($st)) ?></span></div>
            </div>
          </div>
          <div class="row mb-2">
            <div class="col-md-6">
              <div class="text-muted small">From</div>
              <div class="fw-semibold"><?= htmlspecialchars($booking['from_text'] ?? '') ?></div>
            </div>
            <div class="col-md-6">
              <div class="text-muted small">To</div>
              <div class="fw-semibold"><?= htmlspecialchars($booking['to_text'] ?? '') ?></div>
            </div>
          </div>
          <div class="row mb-2">
            <div class="col-md-6">
              <div class="text-muted small">Customer</div>
              <div class="fw-semibold"><?= htmlspecialchars($booking['customer_name'] ?? 'N/A') ?></div>
              <div class="text-muted small">Email: <?= htmlspecialchars($booking['customer_email'] ?? '') ?></div>
              <div class="text-muted small">Phone: <?= htmlspecialchars($booking['customer_phone'] ?? '') ?></div>
            </div>
            <div class="col-md-6">
              <div class="text-muted small">Amount</div>
              <div class="fw-semibold mb-1"><?= number_format((float)($booking['amount_total'] ?? 0), 2) . ' ' . htmlspecialchars((string)($booking['currency'] ?? 'THB')) ?></div>
              <div class="text-muted small">Vendor Cost: <span class="fw-semibold text-dark"><?= number_format((float)($booking['vendor_cost'] ?? 0), 2) . ' ' . htmlspecialchars((string)($booking['vendor_currency'] ?? ($booking['currency'] ?? 'THB'))) ?></span></div>
              <div class="text-muted small">Payment: <?= htmlspecialchars(($booking['payment_status'] ?? 'unpaid')) ?></div>
            </div>
          </div>
          <?php if (!empty($booking['itinerary_json'])): ?>
            <div class="mt-3">
              <div class="text-muted small mb-1">Itinerary Stops</div>
              <?php $stops = json_decode((string)$booking['itinerary_json'], true) ?: []; ?>
              <ol class="mb-0">
                <?php foreach ($stops as $s): ?>
                  <li class="mb-1">
                    <div class="fw-semibold"><?= htmlspecialchars($s['label'] ?? '') ?></div>
                    <?php if (!empty($s['address'])): ?><div class="text-muted small"><?= htmlspecialchars($s['address']) ?></div><?php endif; ?>
                  </li>
                <?php endforeach; ?>
              </ol>
            </div>
          <?php endif; ?>
        </div>
      </div>

      <div class="card border-0 shadow-sm mt-3">
        <div class="card-header bg-white border-0"><h6 class="mb-0">Events</h6></div>
        <div class="card-body p-0">
          <div class="table-responsive">
            <table class="table table-sm table-striped mb-0">
              <thead><tr><th>#</th><th>Type</th><th>Note</th><th>When</th></tr></thead>
              <tbody>
                <?php foreach ($events as $ev): ?>
                  <tr>
                    <td><?= (int)($ev['id'] ?? 0) ?></td>
                    <td><?= htmlspecialchars((string)($ev['event_type'] ?? '')) ?></td>
                    <td class="small"><?= htmlspecialchars((string)($ev['note'] ?? '')) ?></td>
                    <td class="text-muted small"><?= htmlspecialchars((string)($ev['created_at'] ?? '')) ?></td>
                  </tr>
                <?php endforeach; ?>
                <?php if (!$events): ?>
                  <tr><td colspan="4" class="text-center text-muted small py-3">No events</td></tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    <div class="col-lg-4">
      <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-0"><h6 class="mb-0">Assign Driver</h6></div>
        <div class="card-body">
          <form method="post" action="/vendor/job/assign-driver" class="row g-2">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            <input type="hidden" name="id" value="<?= (int)($booking['id'] ?? 0) ?>">
            <div class="col-12"><input type="text" name="driver_name" class="form-control form-control-sm" placeholder="Driver name" required value="<?= htmlspecialchars($booking['driver_name'] ?? '') ?>"></div>
            <div class="col-12"><input type="text" name="driver_phone" class="form-control form-control-sm" placeholder="Driver phone" required value="<?= htmlspecialchars($booking['driver_phone'] ?? '') ?>"></div>
            <div class="col-12"><input type="text" name="vehicle_number" class="form-control form-control-sm" placeholder="Vehicle number" required value="<?= htmlspecialchars($booking['vehicle_number'] ?? '') ?>"></div>
            <div class="col-12"><button class="btn btn-sm btn-primary w-100">Save</button></div>
          </form>
        </div>
      </div>

      <div class="card border-0 shadow-sm mt-3">
        <div class="card-header bg-white border-0"><h6 class="mb-0">Update Status</h6></div>
        <div class="card-body">
          <form method="post" action="/vendor/job/status" class="row g-2">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            <input type="hidden" name="id" value="<?= (int)($booking['id'] ?? 0) ?>">
            <div class="col-12">
              <select name="status" class="form-select form-select-sm" required>
                <option value="enroute">Enroute</option>
                <option value="picked_up">Picked up</option>
                <option value="completed">Completed</option>
              </select>
            </div>
            <div class="col-12"><button class="btn btn-sm btn-success w-100">Update</button></div>
          </form>
        </div>
      </div>

      <div class="card border-0 shadow-sm mt-3">
        <div class="card-header bg-white border-0"><h6 class="mb-0">Upload Pickup Photo</h6></div>
        <div class="card-body">
          <form method="post" action="/vendor/job/upload-pickup-photo" enctype="multipart/form-data" class="row g-2">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            <input type="hidden" name="id" value="<?= (int)($booking['id'] ?? 0) ?>">
            <div class="col-12"><input type="file" name="photo" accept="image/*" class="form-control form-control-sm" required></div>
            <div class="col-12"><button class="btn btn-sm btn-outline-primary w-100">Upload</button></div>
          </form>
          <?php if (!empty($booking['pickup_photo_path'])): ?>
            <div class="mt-2">
              <a class="d-inline-block" href="<?= htmlspecialchars($booking['pickup_photo_path']) ?>" target="_blank">View current photo</a>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>
