<?php
/** @var array $items */
/** @var string $reqPath */
use App\Core\Menu\MenuItem;

if (!isset($items)) { $items = []; }
$active = function(string $url) use ($reqPath) {
    return $reqPath === $url || str_starts_with($reqPath, rtrim($url,'/').'/');
};
// Determine if any descendant of a menu item is active
$hasActiveDesc = function(MenuItem $item) use (&$hasActiveDesc, $active): bool {
    if (!empty($item->url) && $active($item->url)) { return true; }
    if (!empty($item->children)) {
        foreach ($item->children as $child) {
            if ($child instanceof MenuItem && $hasActiveDesc($child)) { return true; }
        }
    }
    return false;
};
?>
<ul class="navbar-nav me-auto mb-2 mb-lg-0 align-items-center gap-2 gap-lg-3">
  <?php foreach ($items as $it): ?>
    <?php if ($it instanceof MenuItem && $it->url): ?>
      <li class="nav-item">
        <?php $isActiveDirect = $active($it->url); ?>
        <a class="nav-link <?php echo $isActiveDirect ? 'active fw-semibold' : ''; ?>" href="<?= htmlspecialchars($it->url) ?>" <?php echo $isActiveDirect ? 'aria-current="page"' : ''; ?>>
          <?php if (!empty($it->icon)): ?><i class="<?= htmlspecialchars($it->icon) ?> me-1"></i><?php endif; ?>
          <?= htmlspecialchars($it->label) ?>
        </a>
      </li>
    <?php elseif ($it instanceof MenuItem && !empty($it->children)): ?>
      <li class="nav-item dropdown">
        <?php $parentActive = $hasActiveDesc($it); ?>
        <a class="nav-link dropdown-toggle <?php echo $parentActive ? 'active fw-semibold' : ''; ?>" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false" <?php echo $parentActive ? 'aria-current="page"' : ''; ?>>
          <?php if (!empty($it->icon)): ?><i class="<?= htmlspecialchars($it->icon) ?> me-1"></i><?php endif; ?>
          <?= htmlspecialchars($it->label) ?>
        </a>
        <ul class="dropdown-menu">
          <?php foreach ($it->children as $child): ?>
            <?php if ($child instanceof MenuItem && $child->url): ?>
              <li>
                <a class="dropdown-item <?php echo ($child->url && $active($child->url)) ? 'active' : ''; ?>" href="<?= htmlspecialchars((string)$child->url) ?>">
                  <?php if (!empty($child->icon)): ?><i class="<?= htmlspecialchars($child->icon) ?> me-1"></i><?php endif; ?>
                  <?= htmlspecialchars($child->label) ?>
                </a>
              </li>
            <?php elseif ($child instanceof MenuItem && empty($child->url) && !empty($child->children)): ?>
              <li><h6 class="dropdown-header mb-0">
                <?php if (!empty($child->icon)): ?><i class="<?= htmlspecialchars($child->icon) ?> me-1"></i><?php endif; ?>
                <?= htmlspecialchars($child->label) ?>
              </h6></li>
              <?php foreach ($child->children as $gchild): ?>
                <?php if ($gchild instanceof MenuItem && $gchild->url): ?>
                  <li>
                    <a class="dropdown-item <?php echo ($gchild->url && $active($gchild->url)) ? 'active' : ''; ?>" href="<?= htmlspecialchars((string)$gchild->url) ?>">
                      <?php if (!empty($gchild->icon)): ?><i class="<?= htmlspecialchars($gchild->icon) ?> me-1"></i><?php endif; ?>
                      <?= htmlspecialchars($gchild->label) ?>
                    </a>
                  </li>
                <?php endif; ?>
              <?php endforeach; ?>
              <li><hr class="dropdown-divider"></li>
            <?php endif; ?>
          <?php endforeach; ?>
        </ul>
      </li>
    <?php endif; ?>
  <?php endforeach; ?>
</ul>
