<?php
// app/Views/layouts/admin_sidebar.php
// Admin sidebar navigation menu

use App\Core\Menu\AdminMenu;

// Get admin menu items
$adminMenu = new AdminMenu();
$menuItems = $adminMenu->getMenu();
?>

<nav class="nav flex-column">
    <?php foreach ($menuItems as $item): ?>
        <?php if (isset($item['header'])): ?>
            <div class="nav-header mt-3"><?= htmlspecialchars($item['text']) ?></div>
        <?php elseif (isset($item['divider'])): ?>
            <hr class="my-2">
        <?php else: ?>
            <a class="nav-link <?= ($item['active'] ?? false) ? 'active' : '' ?>" 
               href="<?= htmlspecialchars($item['url'] ?? '#') ?>">
                <?php if (!empty($item['icon'])): ?>
                    <i class="bi bi-<?= htmlspecialchars($item['icon']) ?> me-2"></i>
                <?php endif; ?>
                <?= htmlspecialchars($item['text'] ?? '') ?>
                <?php if (!empty($item['badge'])): ?>
                    <span class="badge bg-<?= $item['badge']['type'] ?? 'primary' ?> ms-auto">
                        <?= htmlspecialchars($item['badge']['text']) ?>
                    </span>
                <?php endif; ?>
            </a>
        <?php endif; ?>
    <?php endforeach; ?>
</nav>
