<h1 class="h5 mb-3">Edit Hotel</h1>
<form method="post" action="/hotels/update" class="row g-3">
  <input type="hidden" name="csrf" value="<?= App\Core\Security::csrfToken(); ?>">
  <input type="hidden" name="id" value="<?= (int)$hotel['id'] ?>">
  <div class="col-md-6">
    <label class="form-label">Name</label>
    <input class="form-control" name="name" value="<?= App\Core\Security::sanitize($hotel['name']) ?>" required>
  </div>
  <div class="col-md-3">
    <label class="form-label">City</label>
    <input class="form-control" name="city" value="<?= App\Core\Security::sanitize($hotel['city']) ?>" required>
  </div>
  <div class="col-md-3">
    <label class="form-label">Country</label>
    <input class="form-control" name="country" value="<?= App\Core\Security::sanitize($hotel['country']) ?>" required>
  </div>
  <div class="col-md-4">
    <label class="form-label">Base Price</label>
    <input type="number" step="0.01" class="form-control" name="base_price" value="<?= (float)$hotel['base_price'] ?>" required>
  </div>
  <div class="col-12">
    <button class="btn btn-primary">Update</button>
    <a class="btn btn-light" href="/hotels">Cancel</a>
  </div>
</form>
