<?php
// Values are typically extracted; support both direct vars and $data
$name = isset($name) ? $name : ($data['name'] ?? 'User');
$loginUrl = $loginUrl ?? ($data['loginUrl'] ?? ('http://' . ($_SERVER['HTTP_HOST'] ?? 'localhost') . '/b2b/agent/login'));
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Password Updated - B2B Thai Hub</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; max-width: 600px; margin: 0 auto; padding: 20px; }
        .button { 
            display: inline-block; 
            padding: 12px 24px; 
            background-color: #10b981; 
            color: white; 
            text-decoration: none; 
            border-radius: 4px; 
            font-weight: bold;
            margin: 20px 0; 
        }
        .footer { 
            margin-top: 30px; 
            padding-top: 20px; 
            border-top: 1px solid #eee; 
            font-size: 12px; 
            color: #666; 
        }
        .container { max-width: 600px; margin: 0 auto; }
    </style>
</head>
<body>
    <div class="container">
        <h2>Password Successfully Updated</h2>
        <p>Hello <?= htmlspecialchars($name) ?>,</p>
        
        <p>Your password has been successfully updated. If you did not make this change, please contact our support team immediately.</p>
        
        <p>
            <a href="<?= htmlspecialchars($loginUrl) ?>" class="button">
                Log In to Your Account
            </a>
        </p>
        
        <p>If you didn't make this change, please secure your account by changing your password immediately and contact our support team.</p>
        
        <div class="footer">
            <p>© <?= date('Y') ?> B2B Thai Hub. All rights reserved.</p>
        </div>
    </div>
</body>
</html>
