<?php
// app/Views/checkout/pay.php
/** @var int $orderId */
/** @var string $sig */
$title = 'View Booking Details & Make Payment';
// Load enabled payment methods from config
$gateways = require BASE_PATH . '/config/payment_gateways.php';
$walletEnabled = !empty($gateways['wallet']['enabled']);
$stripeEnabled = !empty($gateways['stripe']['enabled']);
$paypalEnabled = !empty($gateways['paypal']['enabled']);
$anyGateway = ($stripeEnabled || $paypalEnabled);
// CSRF for AJAX
$csrf = \App\Core\Security::csrfToken();
?>
<style>
  /* Watermark stamp styles (match confirm page for consistency) */
  .stamp-watermark{position:absolute;inset:0;display:flex;align-items:center;justify-content:center;pointer-events:none;opacity:.08}
  .stamp-watermark svg{width:300px;height:300px;max-width:70%;max-height:80%;transform:rotate(-12deg)}
  .seal{display:inline-block;color:#1e7e34;vertical-align:middle;transform:rotate(-10deg);filter:url(#stampNoise);mix-blend-mode:multiply}
  .seal text{font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;letter-spacing:2px}
  .seal .ring{fill:none;stroke:currentColor;stroke-width:6}
  .seal .ring--inner{stroke-width:3;opacity:.9}
  .seal .guilloche{fill:none;stroke:currentColor;stroke-width:.6;opacity:.35}
  .seal .stars{fill:currentColor}
  .seal .banner{fill:currentColor;opacity:.08}
  .seal .banner-stroke{fill:none;stroke:currentColor;stroke-width:6}
  .seal .banner-text{fill:currentColor;font-weight:900;font-size:34px;text-anchor:middle;dominant-baseline:central}
  .seal .arc-text{fill:currentColor;font-weight:700;font-size:16px;text-transform:uppercase}
  .seal .microtext{fill:currentColor;opacity:.7;font-size:7px;letter-spacing:1.5px}
  @media print{ .stamp-watermark{opacity:.12} }
</style>
<!-- Hidden SVG defs for seal effects -->
<svg width="0" height="0" style="position:absolute;left:-9999px;top:-9999px" aria-hidden="true" focusable="false">
  <defs>
    <filter id="stampNoise">
      <feTurbulence id="stampNoiseTurbPay" type="fractalNoise" baseFrequency="0.9" numOctaves="2" stitchTiles="stitch" result="noise"/>
      <feColorMatrix type="saturate" values="0"/>
      <feComposite operator="in" in2="SourceAlpha"/>
      <feBlend in="SourceGraphic" mode="multiply"/>
    </filter>
    <path id="sealTopArc" d="M 30 100 A 70 70 0 1 1 170 100" />
    <path id="sealBottomArc" d="M 170 100 A 70 70 0 1 1 30 100" />
    <path id="sealMicroArc" d="M 40 100 A 60 60 0 1 1 160 100 A 60 60 0 1 1 40 100" />
    <g id="guillocheRosette">
      <path class="guilloche" d="M100,30 C130,30 155,55 155,85 C155,115 130,140 100,140 C70,140 45,115 45,85 C45,55 70,30 100,30 Z" />
      <use href="#gWave"/>
    </g>
    <path id="gWave" d="M50,85 C70,65 130,105 150,85" />
  </defs>
</svg>
<div class="row g-4">
  <div class="col-12 col-lg-8">
    <h1 class="h4 mb-1">View Booking Details &amp; Make Payment</h1>
    <div class="mb-2 small">
      <a href="/b2b/checkout?id=<?= (int)$orderId ?>&sig=<?= htmlspecialchars($sig) ?>" class="text-decoration-none">← Back to details</a>
    </div>

    <!-- Booking summary on top -->
    <div id="orderCard" class="card mb-3">
      <div class="card-body position-relative">
        <!-- Faint background watermark; visible only when paid -->
        <div id="paidWatermark" class="stamp-watermark" style="display:none;">
          <svg class="seal seal--paid" viewBox="0 0 200 200" aria-hidden="true">
            <circle class="ring" cx="100" cy="100" r="86" />
            <circle class="ring ring--inner" cx="100" cy="100" r="70" />
            <g opacity="0.5">
              <use href="#guillocheRosette" class="guilloche"/>
              <use href="#gWave" class="guilloche" transform="rotate(36,100,85)"/>
              <use href="#gWave" class="guilloche" transform="rotate(72,100,85)"/>
              <use href="#gWave" class="guilloche" transform="rotate(108,100,85)"/>
              <use href="#gWave" class="guilloche" transform="rotate(144,100,85)"/>
            </g>
            <g class="stars" transform="translate(100,100)">
              <circle r="4" cx="0" cy="-40"/>
              <circle r="4" cx="0" cy="40"/>
              <circle r="4" cx="-40" cy="0"/>
              <circle r="4" cx="40" cy="0"/>
            </g>
            <g>
              <rect class="banner" x="18" y="84" width="164" height="32" rx="4" ry="4"/>
              <rect class="banner-stroke" x="18" y="84" width="164" height="32" rx="4" ry="4"/>
              <text class="banner-text" x="100" y="100">PAID</text>
            </g>
            <text class="arc-text">
              <textPath href="#sealTopArc" startOffset="50%" text-anchor="middle">WWW.B2BTHAIHUB.COM</textPath>
            </text>
            <text class="arc-text">
              <textPath href="#sealBottomArc" startOffset="50%" text-anchor="middle">WWW.B2BTHAIHUB.COM</textPath>
            </text>
            <text id="sealMicroTextPay" class="microtext">
              <textPath href="#sealMicroArc" startOffset="0%">B2BTHAIHUB • ORDER •</textPath>
            </text>
          </svg>
        </div>
        <div class="d-flex justify-content-between align-items-center mb-2">
          <div class="fw-semibold">Order <span class="text-muted">#<?= (int)$orderId ?></span></div>
          <div class="d-flex align-items-center gap-2">
            <span id="orderStatusBadge" class="badge bg-warning text-dark" style="display:none">pending</span>
          </div>
        </div>
        <div id="orderSummary" class="text-muted">Loading order…</div>
      </div>
    </div>

    <!-- Payment methods below -->
    <div class="card">
      <div class="card-header bg-white fw-semibold d-flex justify-content-between align-items-center">
        <div>Choose payment method</div>
      </div>
      <div class="card-body">
        <div class="list-group">
          <?php if ($walletEnabled): ?>
          <div id="walletMethodItem" class="list-group-item d-flex justify-content-between align-items-center">
            <div>
              <div class="fw-semibold">Wallet</div>
              <div class="small text-muted">Pay instantly from available balance</div>
              <div id="walletBalanceText" class="small mt-1 fw-semibold"></div>
              <div id="walletStatusNote" class="small mt-1 text-danger d-none"></div>
            </div>
            <span id="btnPayWalletWrap" data-bs-toggle="tooltip" data-bs-placement="left" title="">
              <button id="btnPayWallet" class="btn btn-primary">Pay with Wallet</button>
            </span>
          </div>
          <?php endif; ?>

          <?php if ($anyGateway): ?>
          <div class="list-group-item d-flex justify-content-between align-items-center">
            <div>
              <div class="fw-semibold">Online Payment (Gateway)</div>
              <div class="small text-muted">
                Supported:
                <?php if ($stripeEnabled): ?>
                  <span class="badge rounded-pill bg-primary me-1">Stripe</span>
                <?php endif; ?>
                <?php if ($paypalEnabled): ?>
                  <span class="badge rounded-pill bg-warning text-dark">PayPal</span>
                <?php endif; ?>
              </div>
            </div>
            <button id="btnPayGateway" class="btn btn-outline-primary">Proceed</button>
          </div>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-4">
    <div class="position-sticky" style="top: 88px;">
      <div class="card">
        <div class="card-header bg-white fw-semibold">Summary</div>
        <div class="card-body">
          <div class="d-flex justify-content-between mb-1 small text-muted"><div>Order</div><div>#<?= (int)$orderId ?></div></div>
          <div id="summaryCustomer" class="small text-muted mb-2">Customer: <em>not set</em></div>
          <div class="d-flex justify-content-between small mb-1"><div>Subtotal</div><div id="summarySubtotal">–</div></div>
          <div class="d-flex justify-content-between"><div><strong>Total</strong></div><div id="summaryTotal"><strong>–</strong></div></div>
          <hr>
          <div class="small text-muted">
            <div class="mb-1">Secure checkout</div>
            <div>24x7 support • Instant confirmations</div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Payment Message Modal -->
<div class="modal fade" id="paymentMsgModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="paymentMsgTitle">Payment</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div id="paymentMsgBody">Message</div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" data-bs-dismiss="modal">OK</button>
      </div>
    </div>
  </div>
  
</div>

<!-- Transaction PIN Modal -->
<div class="modal fade" id="txPinModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Enter Transaction PIN</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <label for="txPinInput" class="form-label small text-muted">6-digit PIN</label>
        <input id="txPinInput" type="password" inputmode="numeric" pattern="\d*" maxlength="6" class="form-control" placeholder="••••••" autocomplete="one-time-code">
        <div id="txPinError" class="text-danger small mt-2" style="display:none"></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="button" id="btnTxSubmit" class="btn btn-primary">Pay</button>
      </div>
    </div>
  </div>
</div>

<script>
(function(){
  // Popup helper (Bootstrap modal with fallback)
  function showPopup(message, title){
    try{
      let reopenTxAfterMsg = false;
      // If TX PIN modal is open, hide it so the message modal is on top
      const txEl = document.getElementById('txPinModal');
      if (txEl && txEl.classList.contains('show') && window.bootstrap){
        const txModal = bootstrap.Modal.getOrCreateInstance(txEl);
        txModal.hide();
        reopenTxAfterMsg = true;
      }
      const mt = document.getElementById('paymentMsgTitle');
      const mb = document.getElementById('paymentMsgBody');
      if (mt) mt.textContent = title || 'Payment';
      if (mb) mb.textContent = message || '';
      const el = document.getElementById('paymentMsgModal');
      if (window.bootstrap && el){
        const modal = bootstrap.Modal.getOrCreateInstance(el);
        // When payment message closes, optionally bring back the TX PIN modal
        if (reopenTxAfterMsg){
          const handler = () => {
            try{
              const txEl2 = document.getElementById('txPinModal');
              if (txEl2){ bootstrap.Modal.getOrCreateInstance(txEl2).show(); }
            }catch(_){}
            el.removeEventListener('hidden.bs.modal', handler);
          };
          el.addEventListener('hidden.bs.modal', handler);
        }
        modal.show();
        return;
      }

    }catch(_){/* ignore and fall back */}
    alert(message || 'Message');
  }
  window.orderId = <?= (int)$orderId ?>;
  window.checkoutSig = '<?= htmlspecialchars($sig, ENT_QUOTES) ?>';
  window.CSRF_TOKEN = '<?= htmlspecialchars($csrf, ENT_QUOTES) ?>';
  const orderSummary = document.getElementById('orderSummary');
  const badge = document.getElementById('orderStatusBadge');
  const sCust = document.getElementById('summaryCustomer');
  const sSub = document.getElementById('summarySubtotal');
  const sTot = document.getElementById('summaryTotal');
  const btnWallet = document.getElementById('btnPayWallet');
  const btnGateway = document.getElementById('btnPayGateway');
  const txPinModalEl = document.getElementById('txPinModal');
  const txPinInput = document.getElementById('txPinInput');
  const txPinError = document.getElementById('txPinError');
  const btnTxSubmit = document.getElementById('btnTxSubmit');
  const walletStatusNote = document.getElementById('walletStatusNote');
  const walletBalanceText = document.getElementById('walletBalanceText');
  const walletMethodItem = document.getElementById('walletMethodItem');
  const btnPayWalletWrap = document.getElementById('btnPayWalletWrap');
  let walletLocked = false;
  let walletLockedMsg = '';
  let txPinPubKeyPem = '';
  let txPinCryptoKey = null;
  let orderTotalAmount = 0;
  let orderCurrency = 'THB';

  // Load public key for TX PIN encryption (RSA-OAEP SHA-1)
  async function loadTxPinKey(){
    try{
      const res = await fetch('/b2b/api/security/pin-key', { headers:{ 'Accept':'application/json' } });
      if (!res.ok) return;
      const json = await res.json();
      if (!json || !json.public_key_pem) return;
      txPinPubKeyPem = String(json.public_key_pem);
      const pemBody = txPinPubKeyPem.replace('-----BEGIN PUBLIC KEY-----','').replace('-----END PUBLIC KEY-----','').replace(/\s+/g,'');
      const raw = Uint8Array.from(atob(pemBody), c=>c.charCodeAt(0));
      if (window.crypto && window.crypto.subtle){
        txPinCryptoKey = await crypto.subtle.importKey('spki', raw, { name:'RSA-OAEP', hash:'SHA-1' }, false, ['encrypt']);
        console.debug('[txpin] public key loaded');
      }
    }catch(err){ console.warn('[txpin] key load/import failed', err); }
  }

  function escapeHtml(s){ return String(s||'').replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;'); }
  function customerLineInner(name, mobile){
    const n = (name||'').trim();
    const m = (mobile||'').trim();
    if (!n && !m) return 'Customer: <em>not set</em>';
    const namePart = n ? `Customer: <strong>${escapeHtml(n)}</strong>` : 'Customer:';
    const mobilePart = m ? ` • ${escapeHtml(m)}` : '';
    return namePart + mobilePart;
  }

  // Show provisional customer preview from prior page (sessionStorage) until API load completes
  try {
    const key = `checkout_contact_${window.orderId}`;
    const raw = sessionStorage.getItem(key);
    if (raw) {
      const cached = JSON.parse(raw);
      const inner = customerLineInner(cached.name, cached.mobile);
      if (sCust) sCust.innerHTML = `<div class=\"small text-muted\">${inner}</div>`;
      if (orderSummary) orderSummary.innerHTML = `<div class=\"small text-muted mb-2\">${inner}</div>` + orderSummary.innerHTML;
    }
  } catch(_){}

  async function loadOrder(){
    try{
      const url = `/b2b/api/checkout/order?id=${encodeURIComponent(window.orderId)}`;
      const res = await fetch(url, { headers: { 'Accept': 'application/json' } });
      const data = await res.json();
      if(!res.ok || data.error){
        orderSummary.innerHTML = `<div class="text-danger">${data && data.error ? data.error : 'Failed to load order.'}</div>`;
        btnWallet.disabled = true;
        btnGateway.disabled = true;
        return;
      }
      const order = data.order || {};
      const items = data.items || [];
      const currency = order.currency || 'THB';
      const list = items.length ? items.map((it,i)=>{
        const title = [it.name, it.variant_name].filter(Boolean).join(' – ') || ('Item #' + (i+1));
        const unitStr = Number(it.unit_price||0).toFixed(2) + ' ' + (it.currency || currency);
        return `
        <div class="d-flex justify-content-between py-1 border-bottom">
          <div>
            <div>${title}</div>
            <div class="text-muted small">${unitStr} × ${it.qty}${it.pax_type? ' ('+it.pax_type+')':''}</div>
          </div>
          <div class="text-muted small">${Number(it.line_total||0).toFixed(2)} ${it.currency || currency}</div>
        </div>`;
      }).join('') : '<div class="text-muted">No items found.</div>';
      const subtotal = Number(items.reduce((a,b)=>a + (parseFloat(b.line_total)||0),0)).toFixed(2) + ' ' + currency;
      orderTotalAmount = Number(order.total||order.total_amount||0);
      orderCurrency = currency;
      const total = orderTotalAmount.toFixed(2) + ' ' + currency;

      if (badge){
        const paid = (order.status === 'paid');
        const cancelled = ((order.status||'') === 'cancelled');
        let text = 'Payment Pending';
        let cls = 'badge rounded-pill bg-warning-subtle text-warning-emphasis';
        if (paid){ text = 'Payment Success'; cls = 'badge rounded-pill bg-success-subtle text-success-emphasis'; }
        else if (cancelled){ text = 'Payment Cancelled'; cls = 'badge rounded-pill bg-danger-subtle text-danger-emphasis'; }
        badge.textContent = text;
        badge.className = cls;
        badge.style.display = '';
        // Toggle watermark visibility
        const wm = document.getElementById('paidWatermark');
        if (wm) wm.style.display = paid ? 'flex' : 'none';
        
        // Unique noise seed from orderId/sig
        try{
          const seed = (Number(window.orderId||0) + (String(window.checkoutSig||'').charCodeAt(0)||0)) % 9999;
          const turb = document.getElementById('stampNoiseTurbPay');
          if (turb) turb.setAttribute('seed', String(seed));
        }catch(_){ }
        // Microtext with order and signature snippet
        try{
          const microEl = document.getElementById('sealMicroTextPay');
          const shortSig = (String(window.checkoutSig||'').slice(0,12) || 'NOSIG').toUpperCase();
          const microStr = `B2BTHAIHUB • ORDER #${window.orderId} • SIG ${shortSig} • WWW.B2BTHAIHUB.COM • `;
          if (microEl) microEl.querySelector('textPath').textContent = microStr.repeat(3);
        }catch(_){ }
      }

      orderSummary.classList.remove('text-muted');
      const custInner = customerLineInner(order.customer_name, order.customer_mobile);
      orderSummary.innerHTML = `
        <div class="small text-muted mb-2">${custInner}</div>
        <div class="border rounded p-2 mb-2 bg-white">${list}</div>
        <div class="d-flex justify-content-between small"><div>Subtotal</div><div>${subtotal}</div></div>
        <div class="d-flex justify-content-between"><div><strong>Total</strong></div><div><strong>${total}</strong></div></div>
      `;

      if (sCust) sCust.innerHTML = `<div class=\"small text-muted\">${custInner}</div>`;
      if (sSub) sSub.textContent = subtotal;
      if (sTot) sTot.innerHTML = `<strong>${total}</strong>`;

      // Clear provisional cached contact now that authoritative data is shown
      try {
        const key = `checkout_contact_${window.orderId}`;
        sessionStorage.removeItem(key);
      } catch(_) {}

      // enable method buttons only when pending
      const pending = (order.status === 'pending');
      if (btnWallet) btnWallet.disabled = !pending;
      // If wallet info already loaded, re-evaluate insufficiency state and visibility
      try {
        if (!walletLocked && typeof orderTotalAmount === 'number' && orderTotalAmount > 0 && walletBalanceText && walletBalanceText.dataset.balance){
          const bal = parseFloat(walletBalanceText.dataset.balance);
          if (!isNaN(bal)){
            const insufficient = pending && bal < orderTotalAmount;
            if (walletMethodItem) walletMethodItem.classList.toggle('d-none', insufficient);
            if (!insufficient){
              if (walletStatusNote){ walletStatusNote.textContent = ''; walletStatusNote.classList.add('d-none'); }
            }
            if (walletBalanceText){
              walletBalanceText.classList.toggle('text-danger', bal < orderTotalAmount);
              walletBalanceText.classList.toggle('text-success', bal >= orderTotalAmount);
            }
          }
        }
      } catch(_) {}
      if (btnGateway) btnGateway.disabled = !pending;
    }catch(e){
      orderSummary.innerHTML = '<div class="text-danger">Unexpected error loading order.</div>';
      if (btnWallet) btnWallet.disabled = true;
      if (btnGateway) btnGateway.disabled = true;
    }
  }

  async function payWallet(txPin){
    try{
      if (btnWallet) btnWallet.disabled = true;
      // Obfuscate PIN: send Base64 and URL-encoded variants
      const body = { order_id: window.orderId };
      if (txPin){
        try{ body.tx_password_b64 = btoa(txPin); }catch(_){ /* fallback below */ }
        try{ body.tx_password_url = encodeURIComponent(txPin); }catch(_){ }
      }
      const res = await fetch('/b2b/api/checkout/pay-wallet', { method:'POST', headers:{'Content-Type':'application/json','Accept':'application/json','X-CSRF-Token': (window.CSRF_TOKEN||'')}, body: JSON.stringify(body)});
      const json = await res.json();
      if(!res.ok || json.error){
        const msg = (json && json.error) ? String(json.error) : 'Payment failed';
        // Inline-handle common PIN-related validation errors while keeping the PIN modal open
        if (res.status === 422 && txPinError && txPinInput && txPinModalEl){
          const pinMsgs = [
            'Please enter your 6-digit transaction PIN to proceed.',
            'PIN format is invalid. Enter a 4–6 digit PIN.',
            'Invalid PIN.',
            'Attempts remaining:',
            'Wallet is temporarily disabled'
          ];
          if (pinMsgs.some(s => msg.indexOf(s) !== -1)){
            try{
              if (window.bootstrap){
                const m = bootstrap.Modal.getOrCreateInstance(txPinModalEl);
                m.show();
              }
            }catch(_){}
            txPinError.textContent = msg;
            txPinError.style.display = 'block';
            try{ txPinInput.focus(); txPinInput.select && txPinInput.select(); }catch(_){}
            if (btnWallet) btnWallet.disabled = false;
            return;
          }
        }
        // Fallback to popup for non-PIN or other errors
        showPopup(msg, 'Wallet Payment');
        if (btnWallet) btnWallet.disabled = false; 
        return; 
      }
      // Success: close PIN modal (if open) and redirect to confirmation page
      try{
        if (window.bootstrap && txPinModalEl){
          const m = bootstrap.Modal.getOrCreateInstance(txPinModalEl);
          m.hide();
        }
      }catch(_){ }
      const confirmUrl = `/b2b/checkout/confirm?id=${encodeURIComponent(window.orderId)}&sig=${encodeURIComponent(window.checkoutSig||'')}`;
      window.location = confirmUrl;
    } catch(e){
      showPopup('Unexpected error while paying. Please retry.', 'Wallet Payment');
    } finally {
      if (btnWallet) btnWallet.disabled = false;
    }
  }

  async function payGateway(){
    try{
      btnGateway.disabled = true;
      const res = await fetch('/b2b/api/checkout/pay-gateway-init', { method:'POST', headers:{'Content-Type':'application/json','Accept':'application/json','X-CSRF-Token': (window.CSRF_TOKEN||'')}, body: JSON.stringify({ order_id: window.orderId })});
      const json = await res.json();
      if (res.ok && json && json.redirect_url){ window.location = json.redirect_url; return; }
      showPopup(json && json.error ? json.error : 'Gateway not available', 'Payment Gateway');
      if (btnGateway) btnGateway.disabled = false;
    }catch(e){ showPopup('Gateway init failed', 'Payment Gateway'); if (btnGateway) btnGateway.disabled = false; }
  }

  // Load wallet status (lockout state)
  async function loadWalletStatus(){
    if (!btnWallet) return;
    try{
      const res = await fetch('/b2b/api/wallet', { headers: { 'Accept':'application/json' }});
      const json = await res.json();
      walletLocked = !!(json && json.locked);
      walletLockedMsg = (json && json.locked_message) ? String(json.locked_message) : 'Wallet is temporarily disabled. Please try again later.';
      const balance = (json && typeof json.balance !== 'undefined') ? Number(json.balance) : NaN;
      const wCur = (json && json.currency) ? String(json.currency) : orderCurrency;
      // Show balance text with prominent color
      if (walletBalanceText){
        if (!isNaN(balance)){
          walletBalanceText.textContent = `Available: ${balance.toFixed(2)} ${wCur}`;
          walletBalanceText.dataset.balance = String(balance);
          walletBalanceText.classList.toggle('text-danger', orderTotalAmount > 0 && balance < orderTotalAmount);
          walletBalanceText.classList.toggle('text-success', orderTotalAmount > 0 && balance >= orderTotalAmount);
        } else {
          walletBalanceText.textContent = '';
          delete walletBalanceText.dataset.balance;
          walletBalanceText.classList.remove('text-danger');
          walletBalanceText.classList.remove('text-success');
        }
      }
      // Tooltip helper
      const setTooltip = (text) => {
        try{
          if (!btnPayWalletWrap) return;
          btnPayWalletWrap.setAttribute('title', text || '');
          if (window.bootstrap && bootstrap.Tooltip){
            const tip = bootstrap.Tooltip.getInstance(btnPayWalletWrap) || new bootstrap.Tooltip(btnPayWalletWrap);
            tip.setContent({ '.tooltip-inner': text || '' });
          }
        }catch(_){}
      };

      if (walletLocked){
        if (btnWallet) btnWallet.disabled = true;
        setTooltip(walletLockedMsg);
        if (walletStatusNote){ walletStatusNote.textContent = walletLockedMsg; walletStatusNote.classList.remove('d-none'); }
        if (walletMethodItem) walletMethodItem.classList.remove('d-none'); // show row with disabled button for lock state
      } else {
        // If order pending and balance insufficient -> hide Wallet option entirely
        const insufficient = !isNaN(balance) && orderTotalAmount > 0 && balance < orderTotalAmount;
        if (walletMethodItem) walletMethodItem.classList.toggle('d-none', insufficient);
        if (!insufficient){
          if (btnWallet) btnWallet.disabled = false; // allow if pending; loadOrder() also controls pending
          setTooltip('');
          if (walletStatusNote){ walletStatusNote.textContent = ''; walletStatusNote.classList.add('d-none'); }
        } else {
          setTooltip('Insufficient wallet balance for this order');
        }
      }
    }catch(_){ /* ignore status errors */ }
  }

  // Wallet click -> open TX PIN modal and on confirm call payWallet
  if (btnWallet) btnWallet.addEventListener('click', async function(){
    if (walletLocked){ showPopup(walletLockedMsg, 'Wallet Payment'); return; }
    try{
      txPinError.style.display = 'none';
      txPinInput.value = '';
      if (window.bootstrap && txPinModalEl){
        const m = bootstrap.Modal.getOrCreateInstance(txPinModalEl);
        m.show();
        setTimeout(()=>{ try{ txPinInput.focus(); }catch(_){ } }, 150);
      } else {
        const pin = prompt('Enter 6-digit Transaction PIN');
        if (!pin) { return; }
        if (!/^\d{4,6}$/.test(pin)) { showPopup('Invalid PIN format', 'Wallet Payment'); return; }
        payWallet(pin);
      }
    }catch(_){ payWallet(null); }
  });

  if (btnTxSubmit) btnTxSubmit.addEventListener('click', async function(){
    txPinError.style.display='none';
    txPinError.textContent='';
    const pin = (txPinInput.value||'').trim();
    if (!/^\d{4,6}$/.test(pin)) { txPinError.textContent = 'Please enter a valid 4–6 digit PIN'; txPinError.style.display='block'; return; }
    try{
      btnTxSubmit.disabled = true;
      // payWallet will handle popups; also show inline error if it early-aborts due to encryption unavailability
      await payWallet(pin);
    } catch(e){
      txPinError.textContent = 'Payment failed. Please try again.';
      txPinError.style.display='block';
    } finally { btnTxSubmit.disabled = false; }
  });

  if (txPinInput) txPinInput.addEventListener('keypress', function(e){
    if (e.key === 'Enter') { e.preventDefault(); btnTxSubmit && btnTxSubmit.click(); }
  });

  if (btnGateway) btnGateway.addEventListener('click', payGateway);
  loadOrder();
  loadWalletStatus();
})();
</script>
