<?php
// app/Views/agent/yachts.php
$title = $title ?? 'Yachts';
$yachts = $yachts ?? [];
$filters = $filters ?? ['q'=>'','city'=>'','price_min'=>'','price_max'=>'','sort'=>'best','page'=>1,'per_page'=>12];
$pagination = $pagination ?? ['total'=>count($yachts),'page'=>($filters['page']??1),'per_page'=>($filters['per_page']??12),'pages'=>1];
$partner = $partner ?? ['fixed_markup'=>null];
$active = 'yachts';
require __DIR__ . '/partials/header.php';
?>

<div class="max-w-7xl mx-auto px-4 py-6">
  <!-- Top search + sort bar -->
  <div class="flex flex-col gap-3 md:flex-row md:items-center md:justify-between mb-4">
    <form method="get" class="w-full md:w-auto flex-1">
      <div class="join w-full">
        <input class="input input-bordered join-item w-full" name="city" placeholder="Destination" value="<?= htmlspecialchars($filters['city'] ?? '') ?>">
        <input class="input input-bordered join-item max-md:hidden" name="q" placeholder="Yacht name" value="<?= htmlspecialchars($filters['q'] ?? '') ?>">
        <button class="btn btn-primary join-item">Search</button>
      </div>
    </form>
    <form method="get" class="md:ml-4 flex items-center gap-2">
      <?php // preserve other filters when changing sort ?>
      <input type="hidden" name="q" value="<?= htmlspecialchars($filters['q'] ?? '') ?>">
      <input type="hidden" name="city" value="<?= htmlspecialchars($filters['city'] ?? '') ?>">
      <input type="hidden" name="price_min" value="<?= htmlspecialchars($filters['price_min'] ?? '') ?>">
      <input type="hidden" name="price_max" value="<?= htmlspecialchars($filters['price_max'] ?? '') ?>">
      <input type="hidden" name="page" value="<?= (int)($filters['page'] ?? 1) ?>">
      <label class="label mr-2">Sort</label>
      <select name="sort" class="select select-bordered" onchange="this.form.submit()">
        <option value="best" <?= ($filters['sort']??'best')==='best'?'selected':'' ?>>Recommended</option>
        <option value="price_asc" <?= ($filters['sort']??'')==='price_asc'?'selected':'' ?>>Price (low to high)</option>
        <option value="price_desc" <?= ($filters['sort']??'')==='price_desc'?'selected':'' ?>>Price (high to low)</option>
        <option value="name_asc" <?= ($filters['sort']??'')==='name_asc'?'selected':'' ?>>Name (A–Z)</option>
      </select>
    </form>
  </div>

  <div class="grid grid-cols-1 md:grid-cols-12 gap-6">
    <!-- Sidebar Filters -->
    <aside class="md:col-span-3 lg:col-span-3">
      <form method="get" class="space-y-4 p-4 rounded-xl border bg-white/70">
        <div>
          <div class="font-semibold mb-2">Destination</div>
          <input class="input input-bordered w-full" name="city" placeholder="Where are you going?" value="<?= htmlspecialchars($filters['city'] ?? '') ?>">
        </div>
        <div class="grid grid-cols-2 gap-3">
          <div>
            <div class="text-sm mb-1">Min price</div>
            <input class="input input-bordered w-full" name="price_min" placeholder="THB" value="<?= htmlspecialchars($filters['price_min'] ?? '') ?>">
          </div>
          <div>
            <div class="text-sm mb-1">Max price</div>
            <input class="input input-bordered w-full" name="price_max" placeholder="THB" value="<?= htmlspecialchars($filters['price_max'] ?? '') ?>">
          </div>
        </div>
        <div>
          <div class="font-semibold mb-2">Name</div>
          <input class="input input-bordered w-full" name="q" placeholder="Yacht name" value="<?= htmlspecialchars($filters['q'] ?? '') ?>">
        </div>
        <input type="hidden" name="page" value="1">
        <button class="btn btn-primary w-full">Apply filters</button>
      </form>
    </aside>

    <!-- Results List -->
    <section class="md:col-span-9 lg:col-span-9 space-y-4">
      <?php if (!$yachts): ?>
        <div class="alert">
          <div>
            <span>No yachts found. Try adjusting filters.</span>
          </div>
        </div>
      <?php else: foreach ($yachts as $y):
        $base = (float)($y['from_price'] ?? 0);
        $currency = (string)($y['currency'] ?? 'THB');
        $markup = (float)($partner['fixed_markup'] ?? 0);
        $agentPrice = $base + ($markup ?: 0);
        $city = trim((string)($y['city'] ?? ''));
        $cover = trim((string)($y['cover_path'] ?? ''));
      ?>
        <article class="rounded-xl border bg-white/80 overflow-hidden">
          <div class="grid grid-cols-1 sm:grid-cols-12">
            <div class="sm:col-span-3">
              <img src="<?= $cover !== '' ? htmlspecialchars($cover) : ('https://picsum.photos/seed/'.urlencode((string)($y['id'] ?? rand(1,9999))).'/640/480') ?>"
                   alt="Yacht cover" class="w-full h-44 sm:h-full object-cover" loading="lazy">
            </div>
            <div class="sm:col-span-6 p-4 md:p-5">
              <div class="flex items-start gap-2">
                <h3 class="text-lg font-bold flex-1">
                  <?= htmlspecialchars($y['name'] ?? 'Yacht') ?>
                </h3>
              </div>
              <div class="text-sm text-base-content/70 mt-1">
                <?= htmlspecialchars($city ?: 'Location not set') ?> • Capacity: <?= (int)($y['capacity'] ?? 0) ?> • Max guests: <?= (int)($y['max_guests'] ?? 0) ?>
              </div>
              <ul class="mt-3 text-sm space-y-1 text-base-content/80">
                <li>• Professional crew</li>
                <li>• Safe & comfortable</li>
                <li>• Flexible hours</li>
              </ul>
            </div>
            <div class="sm:col-span-3 p-4 md:p-5 border-t sm:border-l sm:border-t-0 flex flex-col items-end justify-between gap-2">
              <div class="text-right">
                <div class="text-xs text-base-content/60">From</div>
                <div class="text-2xl font-extrabold leading-tight">
                  <?= number_format($agentPrice, 0) ?> <span class="text-sm font-semibold"><?= htmlspecialchars($currency) ?></span>
                </div>
                <?php if ($markup): ?>
                  <div class="text-xs text-success">Includes markup <?= number_format($markup, 0) ?> THB</div>
                <?php endif; ?>
              </div>
              <a href="/b2b/agent/yacht?id=<?= (int)($y['id'] ?? 0) ?>" class="btn btn-primary btn-sm w-full">View & Book</a>
            </div>
          </div>
        </article>
      <?php endforeach; endif; ?>

      <!-- Pagination -->
      <?php if (($pagination['pages'] ?? 1) > 1):
        $curr = (int)($pagination['page'] ?? 1);
        $pages = (int)$pagination['pages'];
        $mkUrl = function($p) use ($filters) {
          $qs = $_GET;
          $qs['page'] = $p;
          $qsStr = http_build_query($qs);
          return '?' . $qsStr;
        };
      ?>
        <div class="join grid grid-cols-2 sm:inline-flex">
          <?php if ($curr > 1): ?>
            <a class="btn join-item" href="<?= htmlspecialchars($mkUrl($curr-1)) ?>">« Prev</a>
          <?php else: ?>
            <button class="btn join-item" disabled>« Prev</button>
          <?php endif; ?>
          <button class="btn join-item" disabled>Page <?= $curr ?> / <?= $pages ?></button>
          <?php if ($curr < $pages): ?>
            <a class="btn join-item" href="<?= htmlspecialchars($mkUrl($curr+1)) ?>">Next »</a>
          <?php else: ?>
            <button class="btn join-item" disabled>Next »</button>
          <?php endif; ?>
        </div>
      <?php endif; ?>
    </section>
  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
