<?php
// app/Views/agent/yacht_payment.php
$title = $title ?? 'Yacht Payment';
$booking = $booking ?? null;
$intent = $intent ?? null;
$csrf_pay = $csrf_pay ?? '';
$active = 'yachts';
require __DIR__ . '/partials/header.php';
?>

<div class="max-w-3xl mx-auto px-4 py-8">
  <div class="card bg-base-100 shadow-xl border">
    <div class="card-body p-6">
      <h1 class="text-2xl font-extrabold mb-2">Payment</h1>
      <div class="text-sm text-base-content/70 mb-4">Please review your booking and choose a payment method.</div>

      <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 mb-6">
        <div>
          <div class="text-sm text-base-content/60">Booking Code</div>
          <div class="font-semibold">
            <?php if ($booking): ?>
              <?= htmlspecialchars((string)($booking['booking_code'] ?? ('YCH-' . (int)($booking['id'] ?? 0)))) ?>
            <?php else: ?>
              <?php $intentCode = 'INT-' . date('Ymd') . '-' . (int)($intent['id'] ?? 0); ?>
              <?= htmlspecialchars($intentCode) ?>
              <span class="text-xs text-base-content/60">(final booking code issued after payment)</span>
            <?php endif; ?>
          </div>
        </div>
        <div>
          <div class="text-sm text-base-content/60">Yacht</div>
          <div class="font-semibold">
            <?= htmlspecialchars((string)($booking['yacht_name'] ?? ($intent['yacht_name'] ?? '—'))) ?>
          </div>
        </div>
        <div>
          <div class="text-sm text-base-content/60">Trip Date</div>
          <div class="font-semibold"><?= htmlspecialchars((string)($booking['trip_date'] ?? ($intent['trip_date'] ?? '—'))) ?></div>
        </div>
        <div>
          <div class="text-sm text-base-content/60">Hours • Guests</div>
          <div class="font-semibold">
            <?= (int)($booking['hours'] ?? ($intent['hours'] ?? 0)) ?>h • <?= (int)($booking['guests'] ?? ($intent['guests'] ?? 0)) ?> guests
          </div>
        </div>
        <div>
          <div class="text-sm text-base-content/60">Amount</div>
          <div class="font-semibold text-lg">
            <?php
              $amt = $booking ? (float)($booking['amount_total'] ?? 0) : (float)($intent['amount'] ?? 0);
              $cur = (string)($booking['currency'] ?? ($intent['currency'] ?? 'THB'));
            ?>
            <?= number_format($amt, 2) . ' ' . htmlspecialchars($cur) ?>
          </div>
        </div>
        <div>
          <div class="text-sm text-base-content/60">Status</div>
          <div class="font-semibold capitalize">
            <?= htmlspecialchars((string)($booking ? ($booking['payment_status'] ?? 'unpaid') : ($intent['status'] ?? 'pending'))) ?>
          </div>
        </div>
      </div>

      <form id="yachtPayForm" method="post" action="/b2b/agent/yacht/pay" class="space-y-4">
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf_pay) ?>">
        <?php if ($booking): ?>
          <input type="hidden" name="booking_id" value="<?= (int)($booking['id'] ?? 0) ?>">
        <?php endif; ?>
        <?php if ($intent): ?>
          <input type="hidden" name="intent_id" value="<?= (int)($intent['id'] ?? 0) ?>">
        <?php endif; ?>

        <div>
          <div class="label"><span class="label-text font-semibold">Payment Method</span></div>
          <div class="flex items-center gap-4">
            <label class="cursor-pointer flex items-center gap-2">
              <input type="radio" name="method" value="wallet" class="radio" checked>
              <span>Wallet</span>
            </label>
            <label class="cursor-pointer flex items-center gap-2">
              <input type="radio" name="method" value="gateway" class="radio">
              <span>Card / Gateway</span>
            </label>
          </div>
        </div>

        <div id="walletPinBlock">
          <div class="label"><span class="label-text font-semibold">Wallet PIN</span></div>
          <input type="password" name="pin" pattern="\d{4,6}" placeholder="4-6 digit PIN" class="input input-bordered w-full" required>
          <div class="text-xs text-base-content/60 mt-1">Enter your 4-6 digit wallet PIN to authorize payment.</div>
        </div>

        <div class="flex gap-2">
          <button class="btn btn-primary" onclick="return submitWallet()">Pay <?= number_format($amt, 2) . ' ' . htmlspecialchars($cur) ?></button>
          <button type="button" class="btn btn-secondary" onclick="return payGateway()">Pay by Card</button>
        </div>
        <?php if ($booking): ?>
          <a href="/b2b/agent/yacht/confirm?id=<?= (int)($booking['id'] ?? 0) ?>" class="btn">Back</a>
        <?php else: ?>
          <a href="/b2b/agent/yacht?id=<?= (int)($intent['yacht_id'] ?? 0) ?>" class="btn">Back</a>
        <?php endif; ?>
      </form>
    </div>
  </div>
</div>

<script>
  (function(){
    const radios = document.querySelectorAll('input[name=method]');
    const pinBlock = document.getElementById('walletPinBlock');
    function sync(){
      const val = Array.from(radios).find(r=>r.checked)?.value || 'wallet';
      if (val === 'wallet') { pinBlock.style.display='block'; pinBlock.querySelector('input[name=pin]').required = true; }
      else { pinBlock.style.display='none'; pinBlock.querySelector('input[name=pin]').required = false; }
    }
    radios.forEach(r => r.addEventListener('change', sync));
    sync();

    window.submitWallet = function(){
      // ensure wallet selected
      const wallet = Array.from(radios).find(r=>r.value==='wallet');
      if (wallet) wallet.checked = true;
      document.getElementById('yachtPayForm').submit();
      return false;
    }

    window.payGateway = async function(){
      try{
        // ensure gateway selected to hide PIN
        const gw = Array.from(radios).find(r=>r.value==='gateway');
        if (gw) { gw.checked = true; sync(); }
        const payload = {};
        <?php if ($booking): ?>
          payload.booking_id = <?= (int)($booking['id'] ?? 0) ?>;
        <?php else: ?>
          payload.intent_id = <?= (int)($intent['id'] ?? 0) ?>;
        <?php endif; ?>
        payload.gateway = 'stripe';
        const res = await fetch('/b2b/api/yacht/pay-gateway', {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify(payload)
        });
        const json = await res.json();
        if (json && json.redirect_url){ window.location.href = json.redirect_url; return false; }
        alert(json && json.error ? json.error : 'Gateway init failed');
      }catch(e){ alert('Gateway error: '+ (e && e.message ? e.message : String(e))); }
      return false;
    }
  })();
</script>

<?php require __DIR__ . '/partials/footer.php'; ?>
