<?php require __DIR__ . '/partials/header.php'; ?>

<div class="max-w-3xl mx-auto py-8">
  <h1 class="text-2xl font-bold mb-6">Wallet Deposit Request</h1>

  <?php if (!empty($_SESSION['flash_error'])): ?>
    <div class="bg-red-50 text-red-700 px-4 py-3 rounded mb-4"><?php echo htmlspecialchars($_SESSION['flash_error']); unset($_SESSION['flash_error']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['flash_success'])): ?>
    <div class="bg-green-50 text-green-700 px-4 py-3 rounded mb-4"><?php echo htmlspecialchars($_SESSION['flash_success']); unset($_SESSION['flash_success']); ?></div>
  <?php endif; ?>

  <?php $req = $request ?? null; ?>

  <?php if (!$req): ?>
    <!-- New request form -->
    <form action="/b2b/agent/wallet/deposit" method="post" class="space-y-4 bg-white p-6 rounded shadow">
      <input type="hidden" name="csrf" value="<?php echo \App\Core\Security::csrfToken(); ?>" />
      <div>
        <label class="block text-sm font-medium text-gray-700">Amount (THB)</label>
        <input type="number" name="amount" min="1" step="0.01" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm" />
      </div>
      <div>
        <label class="block text-sm font-medium text-gray-700">Payment Mode</label>
        <select name="payment_mode" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm">
          <option value="">Select...</option>
          <option value="bank_transfer">Bank Transfer</option>
          <option value="cash_deposit">Cash Deposit</option>
        </select>
      </div>
      <p class="text-sm text-gray-600">Note: Company bank account details will be assigned by Admin after you submit the request.</p>
      <div class="pt-2">
        <button class="px-4 py-2 bg-blue-600 text-white rounded shadow">Submit Request</button>
      </div>
    </form>
  <?php else: ?>
    <!-- Request detail -->
    <div class="bg-white rounded shadow p-6 space-y-4">
      <div class="grid grid-cols-2 gap-4 text-sm">
        <div><span class="text-gray-500">Reference</span><div class="font-semibold"><?php echo htmlspecialchars($req['reference_code']); ?></div></div>
        <div><span class="text-gray-500">Status</span><div class="font-semibold capitalize"><?php echo htmlspecialchars($req['status']); ?></div></div>
        <div><span class="text-gray-500">Amount</span><div class="font-semibold">฿<?php echo number_format((float)$req['amount'],2); ?></div></div>
        <div><span class="text-gray-500">Payment Mode</span><div class="font-semibold"><?php echo htmlspecialchars(str_replace('_',' ', $req['payment_mode'])); ?></div></div>
        <div><span class="text-gray-500">Requested At</span><div><?php echo htmlspecialchars($req['requested_at']); ?></div></div>
      </div>

      <?php if ($req && in_array($req['status'], ['bank_assigned','under_verification','approved','rejected'], true)): ?>
        <div class="border-t pt-4">
          <h2 class="font-semibold mb-2">Assigned Bank Account</h2>
          <div class="rounded border border-blue-200 bg-blue-50 p-4 text-sm">
            <?php if (!empty($req['bank_account_id'])): ?>
              <p class="mb-2">Please transfer exactly the requested amount to the following company account and keep the slip.</p>
              <div><span class="text-gray-600">Bank:</span> <span class="font-semibold"><?php echo htmlspecialchars($req['bank_name']); ?></span></div>
              <div><span class="text-gray-600">Account Name:</span> <span class="font-semibold"><?php echo htmlspecialchars($req['account_name']); ?></span></div>
              <div><span class="text-gray-600">Account Number:</span> <span class="font-mono font-semibold tracking-wider"><?php echo htmlspecialchars($req['account_number']); ?></span></div>
              <?php if (!empty($req['branch'])): ?><div><span class="text-gray-600">Branch:</span> <?php echo htmlspecialchars($req['branch']); ?></div><?php endif; ?>
              <?php if (!empty($req['swift_code'])): ?><div><span class="text-gray-600">SWIFT:</span> <?php echo htmlspecialchars($req['swift_code']); ?></div><?php endif; ?>
              <div class="mt-2 text-xs text-gray-600">Reference code: <span class="font-mono"><?php echo htmlspecialchars($req['reference_code'] ?? ''); ?></span></div>
              <div class="mt-4 rounded-lg border border-amber-300 bg-amber-50 p-3">
                <div class="text-amber-800 font-semibold uppercase tracking-wide">No Third-Party Deposit</div>
                <ul class="list-disc pl-5 mt-2 text-amber-900 text-[13px] space-y-1">
                  <li>Transfer only from your registered company or personal account linked to your profile.</li>
                  <li>Do not use a friend’s/relative’s/agent’s account. Third-party deposits are not accepted.</li>
                  <li>Always include the reference code in the transfer note if your bank allows.</li>
                  <li>Keep the original bank slip/receipt. Blurred or edited slips will be rejected.</li>
                  <li>We never ask to transfer to any account other than the one shown here.</li>
                  <li>If anyone asks you to deposit to a different account, report it immediately to Support.</li>
                </ul>
                <div class="mt-2 text-[12px] text-amber-800"><strong>Safe Zone:</strong> Verify bank name, account holder, and number before paying. When in doubt, contact Support.</div>
              </div>
            <?php else: ?>
              <div class="text-sm text-gray-600">Admin has not assigned a bank account yet.</div>
            <?php endif; ?>
          </div>
        </div>
      <?php endif; ?>

      <?php if (in_array($req['status'], ['bank_assigned','under_verification'], true)): ?>
        <div class="border-t pt-4">
          <h2 class="font-semibold mb-2">Upload Deposit Proof</h2>
          <form id="proofForm" action="/b2b/agent/wallet/deposit/proof" method="post" enctype="multipart/form-data" class="space-y-3">
            <input type="hidden" name="csrf" value="<?php echo \App\Core\Security::csrfToken(); ?>" />
            <input type="hidden" name="id" value="<?php echo (int)$req['id']; ?>" />
            <div>
              <label class="block text-sm font-medium text-gray-700">Transaction Reference</label>
              <input type="text" name="transaction_ref" required class="mt-1 block w-full border-gray-300 rounded-md shadow-sm" />
            </div>
            <div>
              <label class="block text-sm font-medium text-gray-700 mb-1">Deposit Slip (image/pdf)</label>
              <div id="dropZone" class="mt-1 flex items-center justify-center rounded border-2 border-dashed border-gray-300 bg-gray-50 hover:bg-white transition p-6 cursor-pointer text-center">
                <div>
                  <div class="text-gray-700 font-medium">Drag & Drop your slip here</div>
                  <div class="text-gray-500 text-sm">or click to browse</div>
                </div>
                <input id="fileInput" type="file" name="proof_file" accept="image/*,application/pdf" class="hidden" />
              </div>
              <div id="preview" class="mt-3 hidden">
                <div class="text-sm text-gray-600 mb-2">Preview</div>
                <div id="previewContainer" class="border rounded p-2 bg-white"></div>
              </div>
            </div>
            <div>
              <button class="px-4 py-2 bg-green-600 text-white rounded">Submit for Verification</button>
            </div>
          </form>
          <?php if (!empty($req['proof_file'])): ?>
            <div class="mt-4">
              <div class="text-sm text-gray-600 mb-2">Last uploaded slip</div>
              <?php 
                $pf = (string)$req['proof_file'];
                $isImg = preg_match('/\.(jpg|jpeg|png|gif|webp)$/i', $pf);
                $isPdf = preg_match('/\.(pdf)$/i', $pf);
              ?>
              <?php 
                $exp = time() + 600; // 10 minutes
                $secret = function_exists('env') ? (string)env('APP_SECRET','dev-secret') : 'dev-secret';
                $baseSig = ((int)$req['id']).'|'.$exp;
                $sig = hash_hmac('sha256', $baseSig, $secret);
                $signed = '/file/wallet-deposit?id='.(int)$req['id'].'&exp='.$exp.'&sig='.$sig;
              ?>
              <?php if ($isImg): ?>
                <img src="<?php echo $signed; ?>" alt="Deposit Slip" class="rounded shadow border object-contain max-h-80 w-auto" style="max-width:100%;" />
                <div class="mt-2 text-xs">
                  <a class="text-blue-600" href="<?php echo $signed; ?>" target="_blank">View full size</a>
                  <span class="mx-1">•</span>
                  <a class="text-blue-600" href="<?php echo $signed.'&download=1'; ?>">Download</a>
                </div>
              <?php elseif ($isPdf): ?>
                <object data="<?php echo $signed; ?>" type="application/pdf" width="100%" height="420" class="rounded border">
                  <a class="text-blue-600" href="<?php echo $signed; ?>" target="_blank">Open PDF</a>
                </object>
              <?php else: ?>
                <a class="text-blue-600" href="<?php echo $signed; ?>" target="_blank">View slip</a>
              <?php endif; ?>
            </div>
          <?php endif; ?>
          <script>
            (function(){
              const dz = document.getElementById('dropZone');
              const fi = document.getElementById('fileInput');
              const pv = document.getElementById('preview');
              const pc = document.getElementById('previewContainer');
              if(!dz || !fi) return;
              const openPicker = ()=> fi.click();
              dz.addEventListener('click', openPicker);
              dz.addEventListener('dragover', e=>{ e.preventDefault(); dz.classList.add('bg-white'); });
              dz.addEventListener('dragleave', e=>{ dz.classList.remove('bg-white'); });
              dz.addEventListener('drop', e=>{
                e.preventDefault(); dz.classList.remove('bg-white');
                if (e.dataTransfer.files && e.dataTransfer.files[0]) { fi.files = e.dataTransfer.files; renderPreview(e.dataTransfer.files[0]); }
              });
              fi.addEventListener('change', e=>{
                if (fi.files && fi.files[0]) renderPreview(fi.files[0]);
              });
              function renderPreview(file){
                pv.classList.remove('hidden');
                pc.innerHTML='';
                const name = document.createElement('div');
                name.className='text-xs text-gray-600 mb-1';
                name.textContent = 'Selected: ' + file.name;
                pc.appendChild(name);
                if (file.type.startsWith('image/')){
                  const img = document.createElement('img');
                  img.className='max-w-full rounded border shadow';
                  img.src = URL.createObjectURL(file);
                  pc.appendChild(img);
                } else if (file.type === 'application/pdf'){
                  const pdf = document.createElement('div');
                  pdf.innerHTML = '<span class="text-sm">PDF selected. It will be uploaded when you submit.</span>';
                  pc.appendChild(pdf);
                } else {
                  pc.innerHTML += '<span class="text-sm">File selected.</span>';
                }
              }
            })();
          </script>
        </div>
      <?php endif; ?>

      <?php if ($req['status'] === 'approved'): ?>
        <div class="border-t pt-4 text-green-700">This deposit has been approved and credited to your wallet.</div>
      <?php elseif ($req['status'] === 'rejected'): ?>
        <div class="border-t pt-4 text-red-700">Rejected: <?php echo htmlspecialchars($req['rejection_reason'] ?? ''); ?></div>
      <?php endif; ?>

      <?php if (!empty($audit)): ?>
        <?php
          $maskIp = function($ip){
            if (!$ip) return '—';
            if (strpos($ip, ':') !== false) return 'IPv6';
            $parts = explode('.', $ip);
            if (count($parts) === 4) return $parts[0].'.'.$parts[1].'.***.***';
            return '—';
          };
          $label = function($action){
            return [
              'created' => 'Request Created',
              'assigned' => 'Bank Assigned',
              'proof_uploaded' => 'Proof Uploaded',
              'approved' => 'Approved',
              'rejected' => 'Rejected',
              'status_change' => 'Status Updated',
            ][$action] ?? ucfirst(str_replace('_',' ', $action));
          };
          $roleBadge = function($role){
            $cls = $role === 'admin' ? 'bg-purple-100 text-purple-700' : 'bg-sky-100 text-sky-700';
            return '<span class="px-2 py-0.5 rounded text-[11px] '.$cls.'">'.htmlspecialchars($role).'</span>';
          };
          $summarize = function($action, $meta, $req){
            if (!is_array($meta)) $meta = [];
            if ($action === 'created') {
              $amt = isset($meta['amount']) ? number_format((float)$meta['amount'],2) : number_format((float)($req['amount']??0),2);
              $pm  = isset($meta['payment_mode']) ? str_replace('_',' ', (string)$meta['payment_mode']) : str_replace('_',' ', (string)($req['payment_mode']??''));
              return 'Amount ฿'.$amt.' via '.htmlspecialchars($pm);
            }
            if ($action === 'assigned') {
              if (!empty($req['bank_name'])) {
                return htmlspecialchars($req['bank_name'].' — '.$req['account_name'].' — '.$req['account_number']);
              }
              return 'Company bank account assigned';
            }
            if ($action === 'proof_uploaded') {
              $ref = $meta['transaction_ref'] ?? null;
              return 'Reference '.htmlspecialchars((string)$ref ?: '—').($meta['proof_file'] ? ' • Slip uploaded' : '');
            }
            if ($action === 'approved') {
              $amt = isset($meta['amount']) ? number_format((float)$meta['amount'],2) : number_format((float)($req['amount']??0),2);
              return 'Approved and credited ฿'.$amt;
            }
            if ($action === 'rejected') {
              $reason = (string)($meta['reason'] ?? '—');
              return 'Rejected • Reason: '.htmlspecialchars($reason);
            }
            return '';
          };
        ?>
        <div class="border-t pt-4">
          <h2 class="font-semibold mb-2">Activity Timeline</h2>
          <ol class="relative border-l border-gray-200 ml-2">
            <?php foreach ($audit as $ev): $meta = json_decode((string)($ev['meta'] ?? 'null'), true); ?>
              <li class="mb-4 ml-6">
                <span class="absolute -left-3 flex h-6 w-6 items-center justify-center rounded-full bg-blue-100 ring-8 ring-white text-blue-600">•</span>
                <div class="flex items-center gap-2 text-sm">
                  <span class="font-semibold"><?php echo htmlspecialchars($label($ev['action'])); ?></span>
                  <?php echo $roleBadge($ev['actor_role']); ?>
                  <?php if (($ev['actor_role'] ?? '') === 'agent'):
                    $agentCompany = $_SESSION['agent']['company'] ?? ($_SESSION['user']['company'] ?? '');
                    if ($agentCompany): ?>
                      <span class="text-slate-500 text-xs">— <?php echo htmlspecialchars($agentCompany); ?></span>
                  <?php endif; endif; ?>
                </div>
                <div class="text-xs text-gray-500"><?php echo htmlspecialchars($ev['created_at']); ?> — IP: <?php echo htmlspecialchars($maskIp($ev['ip'] ?? '')); ?></div>
                <?php $summary = $summarize($ev['action'], $meta, $req ?? []); if ($summary !== ''): ?>
                  <div class="mt-1 text-sm text-gray-700"><?php echo $summary; ?></div>
                <?php endif; ?>
              </li>
            <?php endforeach; ?>
          </ol>
        </div>
      <?php endif; ?>

      <div class="pt-4">
        <a class="text-blue-600 text-sm" href="/b2b/agent/wallet/deposit/history">← Back to history</a>
      </div>
    </div>
  <?php endif; ?>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
