<?php require __DIR__ . '/partials/header.php'; ?>

<div class="max-w-6xl mx-auto py-8">
  <div class="flex items-center justify-between mb-6">
    <h1 class="text-2xl font-bold">Wallet Deposit History</h1>
    <div>
      <a href="/b2b/agent/wallet/deposit" class="px-3 py-2 bg-blue-600 text-white rounded">New Deposit Request</a>
    </div>
  </div>

  <?php if (!empty($_SESSION['flash_error'])): ?>
    <div class="bg-red-50 text-red-700 px-4 py-3 rounded mb-4"><?php echo htmlspecialchars($_SESSION['flash_error']); unset($_SESSION['flash_error']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['flash_success'])): ?>
    <div class="bg-green-50 text-green-700 px-4 py-3 rounded mb-4"><?php echo htmlspecialchars($_SESSION['flash_success']); unset($_SESSION['flash_success']); ?></div>
  <?php endif; ?>

  <div class="bg-white shadow rounded overflow-x-auto">
    <table class="min-w-full divide-y divide-gray-200">
      <thead class="bg-gray-50">
        <tr>
          <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">ID</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Reference</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Mode</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Requested</th>
          <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Updated</th>
          <th class="px-4 py-3"></th>
        </tr>
      </thead>
      <tbody class="bg-white divide-y divide-gray-200">
        <?php foreach (($rows ?? []) as $r): ?>
          <?php
            $status = (string)($r['status'] ?? '');
            $badge = 'bg-gray-100 text-gray-800';
            if ($status === 'pending') $badge = 'bg-yellow-100 text-yellow-800';
            elseif ($status === 'bank_assigned') $badge = 'bg-blue-100 text-blue-800';
            elseif ($status === 'under_verification') $badge = 'bg-indigo-100 text-indigo-800';
            elseif ($status === 'approved') $badge = 'bg-green-100 text-green-800';
            elseif ($status === 'rejected') $badge = 'bg-red-100 text-red-800';
          ?>
          <tr>
            <td class="px-4 py-3 text-sm">#<?php echo (int)$r['id']; ?></td>
            <td class="px-4 py-3 text-sm font-mono"><?php echo htmlspecialchars($r['reference_code'] ?? ''); ?></td>
            <td class="px-4 py-3 text-sm">฿<?php echo number_format((float)$r['amount'],2); ?></td>
            <td class="px-4 py-3 text-sm capitalize"><?php echo htmlspecialchars(str_replace('_',' ', (string)$r['payment_mode'])); ?></td>
            <td class="px-4 py-3 text-sm"><span class="px-2 py-1 rounded <?php echo $badge; ?> capitalize"><?php echo htmlspecialchars($status); ?></span></td>
            <td class="px-4 py-3 text-sm"><?php echo htmlspecialchars($r['requested_at']); ?></td>
            <td class="px-4 py-3 text-sm"><?php echo htmlspecialchars($r['updated_at'] ?? ''); ?></td>
            <td class="px-4 py-3 text-right text-sm"><a class="text-blue-600" href="/b2b/agent/wallet/deposit/show?id=<?php echo (int)$r['id']; ?>">View</a></td>
          </tr>
        <?php endforeach; ?>
        <?php if (empty($rows)): ?>
          <tr><td colspan="8" class="px-4 py-6 text-center text-gray-500">No requests yet</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
