<?php
// app/Views/agent/wallet.php
$title = $title ?? 'Wallet';
$balance = $balance ?? 0.0;
$transactions = $transactions ?? [];
$active = 'wallet';
require __DIR__ . '/partials/header.php';
?>

<div class="grid gap-4 lg:grid-cols-3">
  <div class="card bg-base-100 shadow card-hover lg:col-span-2">
    <div class="card-body">
      <div class="flex items-center justify-between">
        <h2 class="card-title">Transactions</h2>
        <form method="get" class="flex gap-2">
          <input class="input input-bordered" name="q" placeholder="Search ref/notes" value="<?= htmlspecialchars($_GET['q'] ?? '') ?>" />
          <button class="btn">Filter</button>
        </form>
      </div>
      <div class="overflow-x-auto">
        <table class="table">
          <thead>
            <tr><th>Date</th><th>Ref</th><th>Type</th><th>Amount</th><th>Balance</th><th>Notes</th></tr>
          </thead>
          <tbody>
            <?php if (!$transactions): ?>
              <tr><td colspan="6" class="text-base-content/60">No transactions</td></tr>
            <?php else: foreach ($transactions as $t): ?>
              <tr>
                <td><?= htmlspecialchars($t['date'] ?? '-') ?></td>
                <td><?= htmlspecialchars($t['ref'] ?? '-') ?></td>
                <td><?= htmlspecialchars($t['type'] ?? '-') ?></td>
                <td><?= number_format((float)($t['amount'] ?? 0), 2) ?> <?= htmlspecialchars($t['currency'] ?? 'THB') ?></td>
                <td><?= number_format((float)($t['balance'] ?? 0), 2) ?> <?= htmlspecialchars($t['currency'] ?? 'THB') ?></td>
                <td><?= htmlspecialchars($t['notes'] ?? '-') ?></td>
              </tr>
            <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <div class="card bg-base-100 shadow card-hover">
    <div class="card-body">
      <h2 class="card-title">Wallet</h2>
      <div class="text-3xl font-bold"><?= number_format((float)$balance, 2) ?> THB</div>
      <div class="text-sm text-base-content/60">Earnings from markup appear here.</div>
      <div class="divider"></div>
      <button class="btn btn-primary" onclick="topUp.showModal()">Top-up</button>
    </div>
  </div>
</div>

<dialog id="topUp" class="modal">
  <div class="modal-box">
    <h3 class="font-bold text-lg">Top-up Wallet</h3>
    <form method="post" class="mt-4 space-y-3">
      <label class="form-control">
        <div class="label"><span class="label-text">Amount (THB)</span></div>
        <input name="amount" type="number" step="0.01" min="0" class="input input-bordered" required />
      </label>
      <div class="modal-action">
        <button type="submit" class="btn btn-primary">Confirm</button>
        <button type="button" class="btn" onclick="topUp.close()">Cancel</button>
      </div>
    </form>
  </div>
  <form method="dialog" class="modal-backdrop">
    <button>close</button>
  </form>
</dialog>

<?php require __DIR__ . '/partials/footer.php'; ?>
