<?php
// app/Views/agent/taxi_voucher_boarding.php
$title = $title ?? 'Transfer Voucher';
$booking = $booking ?? [];
$active = 'taxi';

// Debug function for base_url
if (!function_exists('base_url')) {
function base_url($path = '') {
    return '/b2b/' . ltrim($path, '/');
}
}

// Get company details from environment or use defaults
$company_name = trim($_ENV['COMPANY_NAME'] ?? 'So Simple Trip Co. Ltd', '"');
$company_website = trim($_ENV['COMPANY_WEBSITE'] ?? 'bookmythai.com', '"');
$powered_by = trim($_ENV['POWERED_BY'] ?? 'BookMyThai.com', '"');

// Get current agent details from session
$agent = $_SESSION['agent'] ?? null;

require __DIR__ . '/partials/header.php';
?>

<!-- Boarding Pass Style Voucher -->
<div class="min-h-screen bg-gray-50 py-8">
    <div class="max-w-2xl mx-auto px-4">
        
        <!-- Action Buttons -->
        <div class="flex justify-between items-center mb-6 no-print">
            <a href="<?= base_url('agent/taxi') ?>" class="inline-flex items-center px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                Back to Transfers
            </a>
            
            <button onclick="window.print()" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"/>
                </svg>
                Print/Save as PDF
            </button>
        </div>

        <!-- Voucher Card -->
        <div class="bg-white rounded-lg shadow-lg overflow-hidden">
            <?php 
            $bk_status = strtolower((string)($booking['status'] ?? 'confirmed'));
            $is_cancelled = ($bk_status === 'cancelled');
            
            // Format booking code
            $booking_code = (string)($booking['booking_code'] ?? 'TAX-' . date('Ymd') . '-001');
            
            // Generate verification token
            $code_for_token = $booking_code;
            $secret = (string)($_ENV['VERIFY_SECRET'] ?? ($_ENV['APP_KEY'] ?? 'dev-secret-change'));
            $payload = rtrim(strtr(base64_encode($code_for_token), '+/', '-_'), '=');
            $sig = hash_hmac('sha256', $code_for_token, $secret, true);
            $sigB64 = rtrim(strtr(base64_encode($sig), '+/', '-_'), '=');
            $verify_token = $payload . '.' . $sigB64;
            $secure_verify_url = base_url('taxi/verify?t=' . urlencode($verify_token));
            
            // Build absolute URL for QR (works when scanning from another device)
            $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
            $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
            $absolute_verify_url = $scheme . '://' . $host . $secure_verify_url;
            $qr_img_url = 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=' . urlencode($absolute_verify_url);
            
            // Extract and format booking details
            $guest_name = htmlspecialchars((string)($booking['guest_name'] ?? $booking['customer_name'] ?? 'Guest Name'));
            $guest_phone = htmlspecialchars((string)($booking['guest_phone'] ?? $booking['customer_phone'] ?? $booking['phone'] ?? 'N/A'));
            $guest_email = htmlspecialchars((string)($booking['guest_email'] ?? $booking['customer_email'] ?? $booking['email'] ?? 'N/A'));
            $flight_number = htmlspecialchars((string)($booking['flight_number'] ?? 'N/A'));
            
            // Location details
            $pickup_location = htmlspecialchars((string)($booking['pickup_location'] ?? $booking['from_location'] ?? 'Pickup Location'));
            $pickup_landmark = htmlspecialchars((string)($booking['pickup_landmark'] ?? $booking['landmark'] ?? 'N/A'));
            $dropoff_location = htmlspecialchars((string)($booking['dropoff_location'] ?? $booking['to_location'] ?? 'Dropoff Location'));
            $dropoff_landmark = htmlspecialchars((string)($booking['dropoff_landmark'] ?? 'N/A'));
            
            // Date and time
            $trip_date = date('Y-m-d', strtotime($booking['trip_date'] ?? $booking['travel_date'] ?? date('Y-m-d')));
            $pickup_time = date('H:i', strtotime($booking['pickup_time'] ?? $booking['trip_time'] ?? '10:00'));
            $trip_type = htmlspecialchars(ucfirst($booking['trip_type'] ?? 'One Way'));
            
            // Vehicle and pricing
            $pax = (int)($booking['pax'] ?? $booking['passengers'] ?? 1);
            $adults = (int)($booking['adults'] ?? $pax);
            $children = (int)($booking['children'] ?? 0);
            $infants = (int)($booking['infants'] ?? 0);
            $vehicle_type = htmlspecialchars(ucwords($booking['vehicle_type'] ?? $booking['car_type'] ?? 'Sedan'));
            $vehicle_name = htmlspecialchars(ucwords($booking['vehicle_name'] ?? $vehicle_type));
            $vehicle_capacity = (int)($booking['vehicle_capacity'] ?? ($pax + 2));
            
            // Booking references
            $seat_code = htmlspecialchars((string)($booking['seat_code'] ?? 'TX-' . strtoupper(substr(uniqid(), -4))));
            $voucher_id = htmlspecialchars((string)($booking['id'] ?? 'N/A'));
            $booking_reference = htmlspecialchars((string)($booking['booking_code'] ?? $booking['reference'] ?? 'N/A'));
            
            // Pricing
            $base_fare = (float)($booking['base_fare'] ?? $booking['amount'] ?? 0);
            $discount = (float)($booking['discount'] ?? 0);
            $tax = (float)($booking['tax'] ?? 0);
            $total_amount = (float)($booking['total_amount'] ?? $booking['amount'] ?? 0);
            $paid_amount = (float)($booking['paid_amount'] ?? $total_amount);
            $balance_due = max(0, $total_amount - $paid_amount);
            $currency = htmlspecialchars(strtoupper($booking['currency'] ?? 'THB'));
            
            // Payment status
            $payment_status = strtolower($booking['payment_status'] ?? 'unpaid');
            $payment_status_text = ucfirst($payment_status);
            $payment_status_class = $payment_status === 'paid' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800';
            
            // Format currency
            $format_currency = function($amount) use ($currency) {
                if ($currency === 'THB') {
                    return '฿' . number_format($amount, 2);
                }
                return $currency . ' ' . number_format($amount, 2);
            };
            ?>
            
            <!-- Header -->
            <div class="flex items-start p-6 border-b border-gray-200">
                <div class="flex-shrink-0 mr-4">
                    <div class="w-16 h-16 bg-teal-600 text-white flex items-center justify-center rounded-md">
                        <span class="text-xl font-bold">TH</span>
                    </div>
                </div>
                <div class="flex-grow">
                    <h1 class="text-lg font-bold text-gray-800 flex items-center">
                        <?= htmlspecialchars($powered_by) ?> 
                        <span class="mx-2">—</span>
                        <span class="flex items-center">
                            <?php if ($is_cancelled): ?>
                                <svg class="w-5 h-5 text-red-600 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            <?php endif; ?>
                            <?= $is_cancelled ? 'Cancelled Voucher' : 'Taxi Confirmation Voucher' ?>
                        </span>
                    </h1>
                    <p class="text-xs text-gray-500 mt-1">Issued by: <?= htmlspecialchars($company_name) ?> (TAT Authorized)</p>
                    <div class="mt-1 text-xs text-gray-400">Issued on <?= date('d M Y H:i') ?></div>
                </div>
                <div class="text-right">
                    <div class="text-sm text-gray-600">Voucher ID</div>
                    <div class="font-mono font-bold text-gray-800">TH-<?= $voucher_id ?></div>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="p-6">
                <div class="grid grid-cols-3 gap-6">
                    <!-- Left Column -->
                    <div class="col-span-2">
                        <div class="grid grid-cols-2 gap-6">
                            <!-- Passenger Info -->
                            <div class="col-span-2 border-b pb-2 mb-2">
                                <h3 class="text-lg font-bold text-gray-800 mb-1">Passenger Details</h3>
                                <div class="grid grid-cols-2 gap-2">
                                    <div>
                                        <div class="text-xs text-gray-500">Name</div>
                                        <div class="font-medium"><?= $guest_name ?></div>
                                    </div>
                                    <div>
                                        <div class="text-xs text-gray-500">Contact</div>
                                        <div class="font-medium"><?= $guest_phone ?></div>
                                        <div class="text-xs"><?= $guest_email ?></div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Trip Details -->
                            <div class="col-span-2 border-b pb-2 mb-2">
                                <h3 class="text-lg font-bold text-gray-800 mb-1">Trip Details</h3>
                                <div class="grid grid-cols-2 gap-4">
                                    <div>
                                        <div class="text-xs text-gray-500">Service Type</div>
                                        <div class="font-medium"><?= $vehicle_name ?> Transfer</div>
                                        <div class="text-xs">Max <?= $vehicle_capacity ?> persons</div>
                                    </div>
                                    <div>
                                        <div class="text-xs text-gray-500">Trip Type</div>
                                        <div class="font-medium"><?= $trip_type ?></div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Pickup Details -->
                            <div class="col-span-2 border-b pb-3 mb-3">
                                <div class="flex items-center mb-2">
                                    <svg class="w-5 h-5 text-gray-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
                                    </svg>
                                    <h3 class="text-lg font-bold text-gray-800">Pickup Location</h3>
                                </div>
                                <div class="bg-green-50 p-3 rounded-lg border border-green-100">
                                    <div class="font-medium text-gray-800"><?= $pickup_location ?></div>
                                    <?php if ($pickup_landmark && $pickup_landmark !== 'N/A'): ?>
                                    <div class="mt-1 text-sm text-gray-600">
                                        <span class="font-medium">Landmark:</span> <?= $pickup_landmark ?>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <div class="grid grid-cols-2 gap-4 mt-3 pt-2 border-t border-green-100">
                                        <div>
                                            <div class="text-xs text-gray-500 font-medium">Pickup Date</div>
                                            <div class="text-sm text-gray-700"><?= date('d M Y', strtotime($trip_date)) ?></div>
                                        </div>
                                        <div>
                                            <div class="text-xs text-gray-500 font-medium">Pickup Time</div>
                                            <div class="text-sm text-gray-700"><?= date('h:i A', strtotime($pickup_time)) ?></div>
                                        </div>
                                    </div>
                                    
                                    <?php if ($flight_number && $flight_number !== 'N/A'): ?>
                                    <div class="mt-2 pt-2 border-t border-green-100">
                                        <div class="text-xs text-gray-500 font-medium">Flight Number</div>
                                        <div class="text-sm text-gray-700"><?= $flight_number ?></div>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if (isset($booking['pickup_instructions']) && !empty($booking['pickup_instructions'])): ?>
                                    <div class="mt-2 pt-2 border-t border-green-100">
                                        <div class="text-xs font-medium text-green-700">Special Instructions:</div>
                                        <div class="text-sm text-gray-700"><?= htmlspecialchars($booking['pickup_instructions']) ?></div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <!-- Dropoff Details -->
                            <div class="col-span-2 border-b pb-3 mb-3">
                                <div class="flex items-center mb-2">
                                    <svg class="w-5 h-5 text-gray-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z" />
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z" />
                                    </svg>
                                    <h3 class="text-lg font-bold text-gray-800">Dropoff Location</h3>
                                </div>
                                <div class="bg-blue-50 p-3 rounded-lg border border-blue-100">
                                    <div class="font-medium text-gray-800"><?= $dropoff_location ?></div>
                                    <?php if ($dropoff_landmark && $dropoff_landmark !== 'N/A'): ?>
                                    <div class="mt-1 text-sm text-gray-600">
                                        <span class="font-medium">Landmark:</span> <?= $dropoff_landmark ?>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if (isset($booking['dropoff_instructions']) && !empty($booking['dropoff_instructions'])): ?>
                                    <div class="mt-2 pt-2 border-t border-blue-100">
                                        <div class="text-xs font-medium text-blue-700">Special Instructions:</div>
                                        <div class="text-sm text-gray-700"><?= htmlspecialchars($booking['dropoff_instructions']) ?></div>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if (isset($booking['return_pickup']) && $booking['return_pickup']): ?>
                                    <div class="mt-2 pt-2 border-t border-blue-100">
                                        <div class="flex items-center text-xs font-medium text-blue-700">
                                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                            </svg>
                                            Return Pickup Included
                                        </div>
                                        <?php if (!empty($booking['return_time'])): ?>
                                        <div class="text-sm text-gray-700 mt-1">
                                            Return Time: <?= date('h:i A', strtotime($booking['return_time'])) ?>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <!-- Passenger Count -->
                            <div class="col-span-2">
                                <h3 class="text-lg font-bold text-gray-800 mb-1">Passengers</h3>
                                <div class="grid grid-cols-3 gap-2">
                                    <div class="text-center">
                                        <div class="text-2xl font-bold"><?= $adults ?></div>
                                        <div class="text-xs text-gray-500">Adults</div>
                                    </div>
                                    <?php if ($children > 0): ?>
                                    <div class="text-center">
                                        <div class="text-2xl font-bold"><?= $children ?></div>
                                        <div class="text-xs text-gray-500">Children</div>
                                    </div>
                                    <?php endif; ?>
                                    <?php if ($infants > 0): ?>
                                    <div class="text-center">
                                        <div class="text-2xl font-bold"><?= $infants ?></div>
                                        <div class="text-xs text-gray-500">Infants</div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Agency & Pricing Summary -->
                        <div class="mt-6 bg-gray-50 p-4 rounded-lg">
                            <!-- Agency Details -->
                            <div class="mb-4 pb-4 border-b border-gray-200">
                                <h3 class="text-md font-semibold text-gray-700 mb-3">Agency Details</h3>
                                <div class="space-y-2">
                                    <!-- Company Name -->
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 w-24 text-sm font-medium text-gray-600">Company:</div>
                                        <div class="text-sm text-gray-900 font-medium"><?= htmlspecialchars($agent['company_name'] ?? 'N/A') ?></div>
                                    </div>
                                    
                                    <!-- Agent Name -->
                                    <?php if (!empty($agent['name'])): ?>
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 w-24 text-sm font-medium text-gray-600">Agent:</div>
                                        <div class="text-sm text-gray-700"><?= htmlspecialchars($agent['name']) ?></div>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <!-- Contact Number -->
                                    <?php if (!empty($agent['phone'])): ?>
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 w-24 text-sm font-medium text-gray-600">Contact:</div>
                                        <div class="text-sm text-blue-600"><?= htmlspecialchars($agent['phone']) ?></div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <!-- Booking Summary -->
                            <h3 class="text-lg font-bold text-gray-800 mb-3">Booking Summary</h3>
                            <?php if ($is_cancelled): ?>
                            <div class="space-y-3">
                                <div class="bg-red-50 p-4 rounded-lg border border-red-200">
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 mt-0.5">
                                            <svg class="h-5 w-5 text-red-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                            </svg>
                                        </div>
                                        <div class="ml-3">
                                            <h4 class="font-medium text-red-800">Booking Cancelled</h4>
                                            <p class="mt-1 text-sm text-gray-700">
                                                This booking has been cancelled by your travel agency.
                                            </p>
                                            <p class="mt-2 text-xs text-gray-600">
                                                For any questions or assistance, please contact our support team.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php else: ?>
                            <div class="space-y-3">
                                <div class="bg-blue-50 p-4 rounded-lg border border-blue-100">
                                    <div class="flex items-start">
                                        <div class="flex-shrink-0 mt-0.5">
                                            <svg class="h-5 w-5 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                        </div>
                                        <div class="ml-3">
                                            <p class="text-sm text-gray-700">
                                                This booking was made through our B2B Travel Partner Portal. 
                                                For detailed pricing information, please refer to your agency's booking confirmation 
                                                or contact our support team.
                                            </p>
                                            <p class="mt-2 text-sm text-gray-600">
                                                <span class="font-medium">Payment Status:</span> 
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                    <?= ucfirst($booking['payment_status'] ?? 'confirmed') ?>
                                                </span>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                        </div>
                        
                        <!-- Important Notes -->
                        <div class="mt-6 bg-yellow-50 p-4 rounded-lg border border-yellow-200">
                            <h4 class="font-bold text-yellow-800 mb-2">Important Information</h4>
                            <ul class="list-disc list-inside text-sm text-yellow-700 space-y-1">
                                <li>Please present this voucher to the driver or scan the QR code</li>
                                <li>Driver contact details will be provided before pickup</li>
                                <li>Free waiting time: 60 minutes for airport pickups, 15 minutes for others</li>
                                <li>Extra charges may apply for additional waiting time or route changes</li>
                                <li>Contact support for any changes or cancellations</li>
                            </ul>
                        </div>
                        
                        <!-- Voucher ID -->
                        <div class="mt-4 text-xs text-gray-500 text-right">
                            <div>Voucher ID: <?= $voucher_id ?></div>
                        </div>
                    </div>
                    
                    <!-- Right Column -->
                    <div class="border-l border-gray-200 pl-6">
                        <!-- Voucher Header -->
                        <div class="text-center mb-6">
                            <div class="text-sm text-gray-500 mb-1">Voucher</div>
                            <div class="text-3xl font-bold text-blue-600">#<?= $voucher_id ?></div>
                            <div class="text-xs text-gray-500 mt-1"><?= date('d M Y') ?></div>
                        </div>
                        
                        <!-- Service Code -->
                        <div class="bg-blue-50 p-3 rounded-lg text-center mb-4">
                            <div class="text-xs text-blue-600 mb-1">Service Code</div>
                            <div class="font-bold text-xl text-blue-800"><?= $seat_code ?></div>
                            <div class="text-xs text-blue-500 mt-1"><?= $vehicle_name ?></div>
                        </div>
                        
                        <!-- Booking Reference -->
                        <div class="bg-gray-50 p-3 rounded-lg mb-4">
                            <div class="text-xs text-gray-500 mb-1">Booking Reference</div>
                            <div class="font-mono font-bold text-gray-800 text-center"><?= $booking_reference ?></div>
                        </div>
                        
                        <!-- Status Badge -->
                        <div class="text-center mb-4">
                            <span class="inline-block px-3 py-1 rounded-full text-sm font-semibold <?= $payment_status_class ?>">
                                <?= $payment_status_text ?>
                            </span>
                        </div>
                        
                        <!-- Barcode -->
                        <div class="bg-white p-2 rounded border border-gray-200 mb-4">
                            <img src="https://barcodeapi.org/api/code128/<?= urlencode($booking_reference) ?>" alt="Barcode" class="w-full h-12 object-contain">
                            <div class="text-center text-xs text-gray-500 mt-1"><?= $booking_reference ?></div>
                        </div>
                        
                        <!-- QR Code -->
                        <div class="bg-white p-3 rounded border border-gray-200 text-center">
                            <div id="qrcode" class="flex justify-center"></div>
                            <div class="text-xs text-gray-500 mt-2">Scan to verify booking</div>
                            <div class="mt-2 text-xs text-blue-600">
                                <a href="<?= $absolute_verify_url ?>" target="_blank" class="underline">View online</a>
                            </div>
                        </div>
                        
                        <!-- Contact Support -->
                        <div class="mt-4 p-3 bg-gray-50 rounded-lg text-center">
                            <div class="text-xs text-gray-500">Need help?</div>
                            <div class="font-medium text-sm">+66 123 4567</div>
                            <div class="text-xs text-blue-600">support@<?= htmlspecialchars($company_website) ?></div>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php if ($is_cancelled): ?>
            <!-- Watermark Overlay -->
            <div class="absolute inset-0 pointer-events-none overflow-hidden">
                <div class="absolute left-1/2 top-1/2 -translate-x-1/2 -translate-y-1/2 transform">
                    <div class="text-red-200 text-8xl font-bold opacity-30 rotate-45 whitespace-nowrap">
                        CANCELLED
                    </div>
                </div>
            </div>
            <?php endif; ?>
            
        </div>
    </div>
</div>

<style>
@media print {
    body {
        background: white;
        margin: 0;
        padding: 0;
    }
    
    .no-print {
        display: none !important;
    }
    
    .shadow-lg {
        box-shadow: none !important;
    }
    
    .rounded-lg {
        border-radius: 0 !important;
    }
    
    .max-w-2xl {
        max-width: none !important;
    }
    
    .py-8 {
        padding: 0 !important;
    }
    
    .px-4 {
        padding-left: 0 !important;
        padding-right: 0 !important;
    }
}
</style>

<!-- QR Code Generation -->
<script>
(function(){
  var el = document.getElementById('qrcode');
  if (!el) return;
  el.innerHTML = '';
  var img = document.createElement('img');
  var qrUrl = <?= json_encode($qr_img_url) ?>;
  img.src = qrUrl;
  img.alt = 'Scan to Verify';
  img.width = 150;
  img.height = 150;
  el.appendChild(img);
})();
</script>

<?php require __DIR__ . '/partials/footer.php'; ?>
