<?php
// app/Views/agent/taxi_voucher.php
$title = $title ?? 'Transfer Voucher';
$booking = $booking ?? [];
$active = 'taxi';

// Debug function for base_url
if (!function_exists('base_url')) {
    function base_url($path = '') {
        return '/b2b/' . ltrim($path, '/');
    }
}

// Get company details from environment or use defaults
$company_name = trim($_ENV['COMPANY_NAME'] ?? 'So Simple Trip Co. Ltd', '"');
$company_website = trim($_ENV['COMPANY_WEBSITE'] ?? 'bookmythai.com', '"');
$powered_by = trim($_ENV['POWERED_BY'] ?? 'BookMyThai.com', '"');

// Get current agent details from session
$agent = $_SESSION['agent'] ?? null;

require __DIR__ . '/partials/header.php';
?>

<!-- Transfer Voucher Page -->
<div class="min-h-screen bg-gray-50 py-8">
    <div class="max-w-4xl mx-auto px-4">
        
        <!-- Action Buttons -->
        <div class="flex justify-between items-center mb-6 no-print">
            <a href="<?= base_url('agent/taxi') ?>" class="inline-flex items-center px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/>
                </svg>
                Back to Transfers
            </a>
            <button onclick="window.print()" class="inline-flex items-center px-6 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition-colors">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"/>
                </svg>
                Print/Save as PDF
            </button>
            <?php if (!isset($is_cancelled)) { $bk_status = strtolower((string)($booking['status'] ?? 'confirmed')); $is_cancelled = ($bk_status === 'cancelled'); } ?>
    <?php if ($is_cancelled): ?>
    <!-- Big CANCELLED Watermark -->
    <!-- Removed -->
    <?php endif; ?>
</div>

        <!-- Voucher Document -->
        <div class="bg-white rounded-lg shadow-lg overflow-hidden voucher-container relative" style="position: relative;">
            <?php if (!isset($is_cancelled)) { $bk_status = strtolower((string)($booking['status'] ?? 'confirmed')); $is_cancelled = ($bk_status === 'cancelled'); } ?>
            <?php if ($is_cancelled): ?>
            <!-- Professional CANCELLED Stamp -->
            <div class="cancel-watermark" aria-hidden="true">
                <span>CANCELLED</span>
            </div>
            <?php endif; ?>
            
            <!-- Header with Logo -->
            <div class="bg-gradient-to-r from-blue-800 to-indigo-900 text-white p-6">
                <div class="flex justify-between items-start">
                    <div>
                        <div class="flex items-center mb-3">
                            <!-- Company Logo Placeholder -->
                            <div class="bg-white rounded-lg p-2 mr-3 shadow-lg">
                                <svg class="w-10 h-10 text-blue-800" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M18.92 6.01C18.72 5.42 18.16 5 17.5 5h-11c-.66 0-1.21.42-1.42 1.01L3 12v8c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-1h12v1c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-8l-2.08-5.99zM6.5 16c-.83 0-1.5-.67-1.5-1.5S5.67 13 6.5 13s1.5.67 1.5 1.5S7.33 16 6.5 16zm11 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM5 11l1.5-4.5h11L19 11H5z"/>
                                </svg>
                            </div>
                            <div>
                                <h1 class="text-2xl font-bold text-white tracking-tight">TRANSFER VOUCHER</h1>
                                <p class="text-blue-100 text-sm font-medium">Issued by: <?= htmlspecialchars($company_name) ?></p>
                            </div>
                        </div>
                        <div class="flex items-center text-xs text-blue-200 mt-2">
                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                            <span>Created: <?= date('d M Y, H:i') ?></span>
                            <span class="mx-2">•</span>
                            <span>Powered by <?= htmlspecialchars($powered_by) ?></span>
                        </div>
                    </div>
                    <div class="text-right">
                        <?php 
                        $bk_status = strtolower((string)($booking['status'] ?? 'confirmed'));
                        $is_cancelled = ($bk_status === 'cancelled');
                        ?>
                        <div class="<?= $is_cancelled ? 'bg-red-600' : 'bg-green-500' ?> text-white px-3 py-1 rounded-full text-xs font-semibold mb-2">
                            <?= $is_cancelled ? '✖ CANCELLED' : '✓ CONFIRMED' ?>
                        </div>
                        <?php 
                        $payment_status = $booking['payment_status'] ?? 'unpaid';
                        $is_paid = in_array(strtolower($payment_status), ['paid', 'completed', 'success']);
                        ?>
                        <div class="<?= $is_paid ? 'bg-green-500' : 'bg-red-500' ?> text-white px-3 py-1 rounded-full text-xs font-semibold mb-2 <?= $is_cancelled ? 'opacity-70' : '' ?>">
                            <?= $is_paid ? '✓ PAID' : '⚠ UNPAID' ?>
                        </div>
                        <?php if ($is_cancelled): ?>
                        <div class="text-xs text-white/80">This booking has been cancelled.</div>
                        <?php endif; ?>
                        <div class="bg-white bg-opacity-20 rounded p-2 text-center">
                            <div class="text-xs text-slate-200 mb-1">Booking Code</div>
                            <?php 
                                $__full_code = (string)($booking['booking_code'] ?? 'TAX-' . date('Ymd') . '-001');
                            ?>
                            <div class="font-bold text-sm"><?= htmlspecialchars($__full_code) ?></div>
                            <!-- QR Code -->
                            <div class="mt-2">
                                <div id="qrcode" class="inline-block bg-white p-1 rounded"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Service Details -->
            <div class="p-6 border-b border-gray-200 bg-gradient-to-r from-gray-50 to-white">
                <div class="flex items-center mb-2">
                    <div class="bg-blue-100 rounded-full p-2 mr-3">
                        <svg class="w-6 h-6 text-blue-700" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                        </svg>
                    </div>
                    <h2 class="text-xl font-bold text-gray-800">
                        <?= htmlspecialchars((string)($booking['from_text'] ?? 'Bangkok Airport')) ?> 
                        <span class="inline-block mx-2 text-blue-500">→</span> 
                        <?= htmlspecialchars((string)($booking['to_text'] ?? 'Hotel Destination')) ?>
                    </h2>
                </div>
                <div class="flex items-center ml-11 mb-2">
                    <div class="flex items-center bg-amber-50 border border-amber-200 rounded-full px-3 py-1">
                        <span class="text-amber-500 mr-1">★★★</span>
                        <span class="text-sm text-amber-700 font-medium">Premium Transfer Service</span>
                    </div>
                </div>
                <?php 
                $bk_status = strtolower((string)($booking['status'] ?? 'confirmed'));
                $is_cancelled = ($bk_status === 'cancelled');
                ?>
                <?php $full_code = (string)($booking['booking_code'] ?? 'TAX-' . date('Ymd') . '-001'); ?>
                <p class="text-sm mt-2 <?= $is_cancelled ? 'text-red-600' : 'text-blue-600' ?>">
                    <span class="<?= $is_cancelled ? 'cancelled-line' : '' ?>">Booking Code: <strong><?= htmlspecialchars($full_code) ?></strong></span>
                    <?php if ($is_cancelled): ?>
                        <span class="ml-2 inline-flex items-center px-2 py-0.5 text-xs font-semibold rounded-full bg-red-100 text-red-700 border border-red-300 align-middle">Cancelled</span>
                    <?php endif; ?>
                </p>
            </div>

            <!-- Reservation Summary -->
            <div class="p-6 border-b border-gray-200 bg-white">
                <h3 class="font-bold text-gray-800 mb-4 flex items-center">
                    <svg class="w-5 h-5 text-blue-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"/>
                    </svg>
                    Reservation Summary
                </h3>
                <div class="grid grid-cols-2 gap-6 bg-gray-50 rounded-lg p-4 border border-gray-100 shadow-sm">
                    <div>
                        <div class="mb-3">
                            <span class="text-sm text-gray-500 block mb-1">Travel Date</span>
                            <div class="flex items-center">
                                <div class="bg-blue-50 rounded-full p-1 mr-2">
                                    <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                    </svg>
                                </div>
                                <div class="font-semibold"><?= htmlspecialchars((string)($booking['trip_date'] ?? date('Y-m-d'))) ?></div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <span class="text-sm text-gray-500 block mb-1">Passengers</span>
                            <div class="flex items-center">
                                <div class="bg-blue-50 rounded-full p-1 mr-2">
                                    <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                                    </svg>
                                </div>
                                <div class="font-semibold"><?= (int)($booking['pax'] ?? 1) ?></div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <span class="text-sm text-gray-500 block mb-1">Vehicle Type</span>
                            <div class="flex items-center">
                                <div class="bg-blue-50 rounded-full p-1 mr-2">
                                    <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path d="M18.92 6.01C18.72 5.42 18.16 5 17.5 5h-11c-.66 0-1.21.42-1.42 1.01L3 12v8c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-1h12v1c0 .55.45 1 1 1h1c.55 0 1-.45 1-1v-8l-2.08-5.99zM6.5 16c-.83 0-1.5-.67-1.5-1.5S5.67 13 6.5 13s1.5.67 1.5 1.5S7.33 16 6.5 16zm11 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM5 11l1.5-4.5h11L19 11H5z"/>
                                    </svg>
                                </div>
                                <div class="font-semibold text-capitalize"><?= htmlspecialchars((string)($booking['vehicle_type'] ?? 'Sedan')) ?></div>
                            </div>
                        </div>
                    </div>
                    <div>
                        <div class="mb-3">
                            <span class="text-sm text-gray-500 block mb-1">Pickup Time</span>
                            <div class="flex items-center">
                                <div class="bg-blue-50 rounded-full p-1 mr-2">
                                    <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                    </svg>
                                </div>
                                <div class="font-semibold"><?= htmlspecialchars((string)($booking['pickup_time'] ?? $booking['trip_time'] ?? '09:00')) ?></div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <span class="text-sm text-gray-500 block mb-1">Rate Plan</span>
                            <div class="flex items-center">
                                <div class="bg-blue-50 rounded-full p-1 mr-2">
                                    <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                                    </svg>
                                </div>
                                <div class="font-semibold">Transfer Only (TO)</div>
                            </div>
                        </div>
                        <div class="mb-3 price-hide">
                            <span class="text-sm text-gray-500 block mb-1">Total</span>
                            <div class="flex items-center">
                                <div class="bg-blue-50 rounded-full p-1 mr-2">
                                    <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                    </svg>
                                </div>
                                <div class="font-bold text-blue-700"><?= number_format((float)($booking['amount_total'] ?? 1000), 2) ?> THB</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Guest Information -->
            <div class="p-6 border-b border-gray-200 bg-gradient-to-r from-gray-50 to-white">
                <h3 class="font-bold text-gray-800 mb-4 flex items-center">
                    <svg class="w-5 h-5 text-blue-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                    </svg>
                    Guest Information
                </h3>
                <div class="bg-white rounded-lg p-4 border border-gray-100 shadow-sm">
                    <div class="grid grid-cols-2 gap-4">
                        <div class="flex items-start">
                            <div class="bg-blue-50 rounded-full p-1 mr-2">
                                <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                                </svg>
                            </div>
                            <div>
                                <span class="text-sm text-gray-500 block">Lead Guest</span>
                                <span class="font-semibold text-gray-800"><?= htmlspecialchars((string)($booking['customer_name'] ?? 'Guest Name')) ?></span>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="bg-blue-50 rounded-full p-1 mr-2">
                                <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"/>
                                </svg>
                            </div>
                            <div>
                                <span class="text-sm text-gray-500 block">Guests</span>
                                <span class="font-semibold text-gray-800"><?= (int)($booking['pax'] ?? 1) ?> Adult, 0 Children</span>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="bg-blue-50 rounded-full p-1 mr-2">
                                <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                </svg>
                            </div>
                            <div>
                                <span class="text-sm text-gray-500 block">Email</span>
                                <span class="font-semibold text-blue-600"><?= htmlspecialchars((string)($booking['customer_email'] ?? '—')) ?></span>
                            </div>
                        </div>
                        <div class="flex items-start">
                            <div class="bg-blue-50 rounded-full p-1 mr-2">
                                <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                                </svg>
                            </div>
                            <div>
                                <span class="text-sm text-gray-500 block">Phone</span>
                                <span class="font-semibold text-gray-800"><?= htmlspecialchars((string)($booking['customer_phone'] ?? '—')) ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Booked by Agency -->
            <!-- Always show agency section for demonstration -->
            <?php 
            // Ensure agency section always shows with sample data if no real data exists
            $show_agency = true;
            ?>
            <div class="p-6 border-b border-gray-200 bg-gradient-to-r from-blue-50 to-indigo-50 border-l-4 border-l-blue-500">
                <h3 class="font-bold text-gray-800 mb-4 flex items-center">
                    <svg class="w-5 h-5 text-blue-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1"/>
                    </svg>
                    Booked by Agency
                </h3>
                <div class="bg-white rounded-lg p-4 shadow-sm border border-blue-200 relative">
                    <!-- Agency Round Stamp -->
                    <div class="absolute top-4 right-4 transform rotate-12">
                        <div class="w-32 h-32 border-4 border-blue-600 rounded-full bg-blue-50 shadow-lg relative overflow-hidden">
                            <!-- Curved Text for Agency Name -->
                            <svg class="absolute inset-0 w-full h-full" viewBox="0 0 120 120">
                                <defs>
                                    <path id="circle-path" d="M 60, 60 m -35, 0 a 35,35 0 1,1 70,0 a 35,35 0 1,1 -70,0" />
                                </defs>
                                <text class="fill-blue-700 text-xs font-black uppercase" style="font-size: 8px;">
                                    <textPath href="#circle-path" startOffset="0%">
                                        <?= strtoupper(htmlspecialchars((string)($booking['agency_name'] ?? $agent['name'] ?? $agent['company_name'] ?? 'KARNI DIGITAL SOLUTION'))) ?>
                                    </textPath>
                                </text>
                            </svg>
                            
                            <!-- Center Content -->
                            <div class="absolute inset-0 flex items-center justify-center">
                                <div class="text-center">
                                    <div class="text-xs font-bold text-blue-600 uppercase tracking-wide mb-1">AUTHORIZED</div>
                                    <div class="text-xs text-blue-600 mb-2"><?= date('d/m/Y') ?></div>
                                    <div class="border-t border-blue-300 pt-1">
                                        <div class="text-xs text-blue-500 mb-1">SIGNATURE</div>
                                        <div class="h-1 border-b border-blue-400"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="space-y-3 pr-28">
                        <div class="flex items-center">
                            <span class="text-sm text-gray-600 w-24">Agency Name:</span>
                            <span class="font-semibold text-gray-800"><?= htmlspecialchars((string)($booking['agency_name'] ?? $agent['name'] ?? $agent['company_name'] ?? 'KARNI Digital Solution')) ?></span>
                        </div>
                        <div class="flex items-center">
                            <span class="text-sm text-gray-600 w-24">Contact:</span>
                            <span class="font-semibold text-gray-800"><?= htmlspecialchars((string)($booking['agent_mobile'] ?? $agent['mobile'] ?? $agent['phone'] ?? '+66 89 123 4567')) ?></span>
                        </div>
                        <div class="flex items-center">
                            <span class="text-sm text-gray-600 w-24">Email ID:</span>
                            <span class="font-semibold text-blue-600"><?= htmlspecialchars((string)($booking['agent_email'] ?? $agent['email'] ?? 'karni@bookmythai.com')) ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Service Policies -->
            <div class="p-6 bg-gradient-to-b from-white to-gray-50">
                <h3 class="font-bold text-gray-800 mb-4 flex items-center">
                    <svg class="w-5 h-5 text-blue-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                    </svg>
                    Terms & Conditions
                </h3>
                <ul class="space-y-2 text-sm text-gray-700 bg-white p-4 rounded-lg border border-gray-100 shadow-sm">
                    <li>• <strong>Pickup Service:</strong> Driver will arrive 5 minutes early at designated pickup location</li>
                    <li>• <strong>Waiting Policy:</strong> 15 minutes complimentary waiting time included</li>
                    <li>• <strong>Extended Waiting:</strong> 2+ hours wait: 50% additional charge | 3+ hours wait: 100% additional charge</li>
                    <li>• <strong>Cancellation Policy:</strong> No cancellations accepted within 48 hours of booking</li>
                    <li>• <strong>No-Show Policy:</strong> Full charges apply for no-show without 48-hour notice</li>
                    <li>• <strong>Payment Terms:</strong> All payments must be settled as per booking confirmation</li>
                    <li>• <strong>Liability:</strong> Company not liable for delays due to traffic, weather, or unforeseen circumstances</li>
                    <li>• <strong>Compliance:</strong> Guests must comply with all service terms, conditions & local regulations</li>
                </ul>
                
                <div class="mt-6 pt-4 border-t border-gray-200 text-center">
                    <p class="text-xs text-gray-500">Please present this voucher to your driver. Contact support for changes.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Big professional CANCELLED watermark overlay */
.cancel-watermark {
    position: absolute;
    inset: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    pointer-events: none;
    z-index: 15;
    overflow: visible;
    padding: 2%;
}
.cancel-watermark span {
    display: inline-block;
    /* Scale by the smaller viewport dimension so it never clips */
    font-size: clamp(36px, 12vmin, 130px);
    font-weight: 900;
    line-height: 1;
    color: rgba(220, 38, 38, 0.20); /* slightly stronger for visibility */
    text-transform: uppercase;
    letter-spacing: 0.08em; /* tighter so full word fits */
    white-space: nowrap; /* keep as one line */
    transform: rotate(-12deg);
    transform-origin: 50% 50%;
    padding: 0.28em 0.6em;
    border: 5px solid rgba(220, 38, 38, 0.30);
    border-radius: 9999px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.05), inset 0 0 0 3px rgba(255,255,255,0.35);
    backdrop-filter: saturate(110%);
    max-width: 98%;
    box-sizing: border-box;
}
/* Make sure on very short viewports it still fits */
@media (max-height: 700px) {
    .cancel-watermark span { font-size: clamp(28px, 9vmin, 100px); }
}
.cancelled-line {
    text-decoration-line: line-through;
    text-decoration-color: rgba(220, 38, 38, 0.7);
    text-decoration-thickness: 3px;
    text-underline-offset: 3px;
}
@media print {
    .cancel-watermark span {
        color: rgba(220, 38, 38, 0.22) !important;
        border-color: rgba(220, 38, 38, 0.35) !important;
        -webkit-print-color-adjust: exact !important;
        print-color-adjust: exact !important;
    }
}
@media print {
    /* A4 Paper Size Settings */
    @page {
        size: A4;
        margin: 15mm 10mm 15mm 10mm;
    }
    
    /* Reset all elements */
    * {
        -webkit-print-color-adjust: exact !important;
        color-adjust: exact !important;
        print-color-adjust: exact !important;
    }
    
    /* Base styles */
    html, body {
        margin: 0 !important;
        padding: 0 !important;
        background: white !important;
        color: #1a202c !important;
        font-size: 11pt;
        line-height: 1.4;
        width: 100% !important;
        height: auto !important;
    }
    
    /* Hide unnecessary elements */
    .no-print,
    header,
    nav,
    footer,
    .navbar,
    .sidebar,
    .print-hide,
    .price-hide,
    .amount-hide,
    .cost-hide,
    .fare-hide {
        display: none !important;
    }
    
    /* Voucher container */
    .voucher-container {
        width: 100% !important;
        max-width: 100% !important;
        margin: 0 !important;
        padding: 0 !important;
        box-shadow: none !important;
        border: none !important;
        page-break-after: avoid;
        page-break-inside: avoid;
        position: relative;
        background: white !important;
    }
    
    /* Voucher sections */
    .voucher-section {
        page-break-inside: avoid;
        break-inside: avoid;
        margin-bottom: 10px !important;
        padding: 10px 15px !important;
    }
    
    /* Header and section styling */
    .voucher-header {
        background: #1e293b !important;
        color: white !important;
        padding: 15px 20px !important;
        margin: -15px -15px 15px -15px !important;
        border-radius: 0 !important;
    }
    
    /* Section headers */
    .voucher-section h3 {
        font-size: 13pt !important;
        margin-bottom: 10px !important;
        padding-bottom: 5px;
        border-bottom: 1px solid #e2e8f0;
    }
    
    /* Grid layout */
    .grid-cols-2 {
        grid-template-columns: 1fr 1fr !important;
        gap: 15px !important;
    }
    
    /* Text sizes */
    .text-2xl { font-size: 16pt !important; }
    .text-xl { font-size: 14pt !important; }
    .text-lg { font-size: 13pt !important; }
    .text-base { font-size: 11pt !important; }
    .text-sm { font-size: 10pt !important; }
    .text-xs { font-size: 9pt !important; }
    
    /* Spacing */
    .p-6 { padding: 12px !important; }
    .p-4 { padding: 8px !important; }
    .p-2 { padding: 4px !important; }
    .mb-6 { margin-bottom: 12px !important; }
    .mb-4 { margin-bottom: 8px !important; }
    .mb-2 { margin-bottom: 4px !important; }
    .mt-4 { margin-top: 8px !important; }
    
    /* Colors and backgrounds */
    .bg-blue-50 { background-color: #eff6ff !important; }
    .bg-gray-50 { background-color: #f9fafb !important; }
    .bg-white { background: white !important; }
    .text-blue-600 { color: #2563eb !important; }
    .text-gray-500 { color: #6b7280 !important; }
    .text-gray-700 { color: #374151 !important; }
    .text-red-600 { color: #dc2626 !important; }
    .border-gray-200 { border-color: #e5e7eb !important; }
    
    /* Agency section */
    .bg-gradient-to-r.from-blue-50.to-indigo-50 {
        background: linear-gradient(to right, #eff6ff, #eef2ff) !important;
        border-left: 4px solid #2563eb !important;
    }
    
    /* Icons */
    svg {
        max-width: 18px;
        max-height: 18px;
    }
    
    /* QR Code */
    #qrcode {
        width: 100px !important;
        height: 100px !important;
    }
    
    /* Status badge */
    .status-badge {
        padding: 2px 8px !important;
        font-size: 9pt !important;
        border-radius: 4px !important;
    }
    
    /* Preserve status badge colors */
    .bg-green-500 { background-color: #10b981 !important; color: white !important; }
    .bg-red-500 { background-color: #ef4444 !important; color: white !important; }
    
    /* Clean container styling */
    .max-w-4xl { max-width: none !important; margin: 0 !important; padding: 0 !important; }
    .min-h-screen { min-height: auto !important; }
    .bg-gray-50 { background: white !important; padding: 0 !important; }
    
    /* Optimize stamp size for A4 */
    .w-32.h-32 { width: 100px !important; height: 100px !important; }
    
    /* Ensure proper page breaks */
    .bg-white.rounded-lg.shadow-lg { page-break-inside: avoid; }
    
    /* Hide any remaining UI elements */
    button, .btn, .no-print { display: none !important; }
}
</style>

<!-- QR Code for public verification (static PNG via api.qrserver.com) -->
<?php
    // Build secure verification token: base64url(code).'.'.base64url(hmac)
    $code_for_token = (string)($booking['booking_code'] ?? '');
    $secret = (string)($_ENV['VERIFY_SECRET'] ?? ($_ENV['APP_KEY'] ?? 'dev-secret-change'));
    $payload = rtrim(strtr(base64_encode($code_for_token), '+/', '-_'), '=');
    $sig = hash_hmac('sha256', $code_for_token, $secret, true);
    $sigB64 = rtrim(strtr(base64_encode($sig), '+/', '-_'), '=');
    $verify_token = $payload . '.' . $sigB64;
    $secure_verify_url = base_url('taxi/verify?t=' . urlencode($verify_token));
    // Build absolute URL for QR (works when scanning from another device)
    $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    $absolute_verify_url = $scheme . '://' . $host . $secure_verify_url;
    $qr_img_url = 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=' . urlencode($absolute_verify_url);
?>
<script>
(function(){
  var el = document.getElementById('qrcode');
  if (!el) return;
  el.innerHTML = '';
  var img = document.createElement('img');
  var qrUrl = <?= json_encode($qr_img_url) ?>; // raw string for JS, no HTML escaping
  img.src = qrUrl;
  img.alt = 'Scan to Verify';
  img.width = 120;
  img.height = 120;
  el.appendChild(img);
  var url = <?= json_encode($absolute_verify_url) ?>;
  var link = document.createElement('a');
  link.href = url;
  link.target = '_blank';
  link.rel = 'noopener';
  link.textContent = 'Scan or open to verify';
  link.style.display = 'block';
  link.style.fontSize = '10px';
  link.style.marginTop = '4px';
  link.style.color = '#2563eb';
  el.appendChild(link);
})();
</script>

<?php require __DIR__ . '/partials/footer.php'; ?>
