<?php
// app/Views/agent/taxi_detail.php
// Booking detail page
$pageTitle = htmlspecialchars((string)($ride['name'] ?? 'Transfer Booking'));
require __DIR__ . '/partials/header.php';
?>

<!-- Hero Header -->
<div class="bg-gradient-to-r from-blue-600 to-indigo-600 text-white">
  <div class="max-w-6xl mx-auto px-4 py-6 pb-10">
    <div class="flex items-center justify-between">
      <div>
        <div class="text-sm text-white/80 mb-1">
          <a href="/b2b/agent" class="hover:text-white">Dashboard</a>
          <span class="mx-1">›</span>
          <a href="/b2b/agent/taxi" class="hover:text-white">Transfers</a>
          <span class="mx-1">›</span>
          <span class="text-white font-medium">Detail</span>
        </div>
        <h1 class="text-2xl font-bold"><?= htmlspecialchars((string)($ride['name'] ?? 'Transfer Booking')) ?></h1>
        <p class="text-sm text-white/80 mt-1">Fill in your trip details and continue to payment</p>
      </div>
      <a href="/b2b/agent/taxi" class="px-4 py-2 bg-white/20 hover:bg-white/30 rounded-lg text-sm font-semibold transition-all">← Back to Transfers</a>
    </div>
  </div>
</div>

<div class="max-w-6xl mx-auto px-4 py-6">

  <div class="grid grid-cols-1 lg:grid-cols-12 gap-6 items-start">
    <!-- Summary sidebar -->
    <aside class="lg:col-span-4 space-y-4">
      <div class="rounded-xl border bg-white shadow-sm p-4 md:p-6 sticky top-6">
        <?php $thumb = (string)($ride['thumbnail_url'] ?? ($ride['cover_path'] ?? '')); ?>
        <div class="rounded-xl overflow-hidden bg-slate-100 mb-4">
          <img src="<?= $thumb !== '' ? htmlspecialchars($thumb) : ('https://picsum.photos/seed/'.urlencode((string)($ride['id'] ?? rand(1,9999))).'/1200/600') ?>" alt="Vehicle" class="w-full h-56 object-cover" loading="lazy">
        </div>
        <div class="flex items-center justify-between mb-3">
          <h2 class="text-lg font-bold text-slate-900"><?= htmlspecialchars((string)($ride['name'] ?? 'Transfer')) ?></h2>
          <span class="px-2 py-1 text-xs rounded-full bg-emerald-100 text-emerald-700">Available</span>
        </div>
        <div class="text-sm text-slate-600 mb-4">
          <?= htmlspecialchars((string)($ride['vehicle_type'] ?? '')) ?> • Capacity: <?= (int)($ride['capacity'] ?? 0) ?> pax
        </div>
        <div class="bg-slate-50 rounded-lg p-4 mb-4">
          <h3 class="text-sm font-semibold text-slate-800 mb-2">Service Includes</h3>
          <ul class="text-sm text-slate-600 space-y-2">
            <li class="flex items-center gap-2"><svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-emerald-600" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg> Professional Driver</li>
            <li class="flex items-center gap-2"><svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-emerald-600" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg> Door-to-Door Service</li>
            <li class="flex items-center gap-2"><svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-emerald-600" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg> Free Cancellation</li>
            <li class="flex items-center gap-2"><svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-emerald-600" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg> Instant Confirmation</li>
          </ul>
        </div>
        <div class="border-t pt-3">
          <div class="flex items-center justify-between">
            <div class="text-sm text-slate-600">Agent Price</div>
            <div class="text-2xl font-bold text-slate-900" id="totalPrice">฿<?= number_format((float) (($pricing['agent_price'] ?? null) !== null ? $pricing['agent_price'] : ($ride['base_price'] ?? 0)), 0) ?></div>
          </div>
          <div class="flex items-center justify-between text-xs text-slate-500 mt-1">
            <span>Customer Price</span>
            <span>฿<?= number_format((float) (($pricing['customer_price'] ?? null) !== null ? $pricing['customer_price'] : ($ride['base_price'] ?? 0)), 0) ?></span>
          </div>
          <div class="text-xs text-center text-slate-500 mt-3">All prices in Thai Baht (THB)</div>
        </div>
      </div>
    </aside>

    <!-- Main form -->
    <div class="lg:col-span-8">
      <div class="rounded-xl border bg-white shadow-sm p-4 md:p-6">
        <div class="flex items-center gap-3 mb-5">
          <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-blue-700" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-9 4h9M7 8h10M5 21h14a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2H7l-2 2v12a2 2 0 0 0 2 2z"/></svg>
          </div>
          <div>
            <h2 class="text-xl font-bold text-slate-900">Booking Information</h2>
            <p class="text-sm text-slate-500">Enter trip and customer details</p>
          </div>
        </div>
        
        <form id="taxiDetailForm" method="post" action="/b2b/agent/taxi/payment" onsubmit="return validateForm()">
        <input type="hidden" name="taxi_id" value="<?= (int)($ride['id'] ?? 0) ?>">
        <!-- Backward-compat hidden fields for controller -->
        <input type="hidden" name="from" id="fromHidden" value="">
        <input type="hidden" name="to" id="toHidden" value="">
        <!-- Client-side editable itinerary snapshot -->
        <input type="hidden" name="stops_json" id="stopsJson" value="">
        <!-- CSRF for taxi_intent -->
        <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
        

          <!-- Trip Details -->
          <div class="border-b border-slate-200 pb-6 mb-6">
            <div class="flex items-center gap-2 mb-4">
              <div class="w-8 h-8 bg-emerald-100 rounded-full flex items-center justify-center">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-emerald-700" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a2 2 0 0 1-2.828 0l-4.243-4.243a8 8 0 1 1 11.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 1 1-6 0 3 3 0 0 1 6 0z"/></svg>
              </div>
              <h3 class="text-lg font-semibold text-slate-900">Trip Details</h3>
            </div>
          
          <div class="grid grid-cols-1 md:grid-cols-2 gap-4 md:gap-6">
            <div class="space-y-4">
              <div class="mb-3">
                <label class="block text-sm font-semibold text-slate-700 mb-2">Pickup Location</label>
              <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <select name="pickup_type" id="pickupType" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                  <option value="airport">Airport</option>
                  <option value="hotel">Hotel</option>
                  <option value="apartment">Apartment</option>
                  <option value="address">Address</option>
                </select>
                <input name="date" id="dateInput" type="date" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" value="<?= htmlspecialchars($_GET['date'] ?? '') ?>">
              </div>
              <div id="pickupAirport" class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <?php if (!empty($airports)): ?>
                  <input type="text" id="pickupAirportSearch" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Search airport...">
                  <select name="pickup_airport_code" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                    <option value="">Select Airport</option>
                    <?php foreach ($airports as $ap): $code=(string)($ap['code']??''); $label=(string)($ap['label']??$code); ?>
                      <option value="<?= htmlspecialchars($code) ?>" <?= (($_GET['pickup_airport_code'] ?? '')===$code?'selected':'') ?>><?= htmlspecialchars($label) ?></option>
                    <?php endforeach; ?>
                  </select>
                <?php else: ?>
                  <input name="pickup_airport_code" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Airport Code (e.g. BKK)">
                <?php endif; ?>
                <input name="time" type="time" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Pickup Time">
                <input name="flight_no" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors md:col-span-2" placeholder="Flight No. (e.g. TG123)">
              </div>
              <div id="pickupHotel" class="grid grid-cols-1 gap-4 hidden">
                <input name="pickup_hotel_name" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Hotel Name">
                <input name="pickup_hotel_address" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Hotel Address">
              </div>
              <div id="pickupApartment" class="grid grid-cols-1 gap-4 hidden">
                <input name="pickup_apartment_name" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Apartment Name">
                <input name="pickup_apartment_address" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Apartment Address">
              </div>
              <div id="pickupAddress" class="hidden">
                <input name="pickup_address" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Pickup Address">
              </div>
            </div>

            <div class="space-y-4">
              <div class="mb-3">
                <label class="block text-sm font-semibold text-slate-700 mb-2">Drop-off Location</label>
              <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <select name="drop_type" id="dropType" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                  <option value="hotel">Hotel</option>
                  <option value="apartment">Apartment</option>
                  <option value="airport">Airport</option>
                  <option value="address">Address</option>
                </select>
                <div class="flex items-center border border-slate-300 rounded-lg overflow-hidden">
                  <button type="button" class="px-4 py-3 bg-slate-100 hover:bg-slate-200 text-slate-700 transition-colors" onclick="chgPax(-1)">-</button>
                  <input name="pax" id="paxInput" type="number" min="1" class="flex-1 px-4 py-3 text-center border-0 focus:ring-0" value="<?= htmlspecialchars($_GET['pax'] ?? '2') ?>">
                  <button type="button" class="px-4 py-3 bg-slate-100 hover:bg-slate-200 text-slate-700 transition-colors" onclick="chgPax(1)">+</button>
                </div>
              </div>
              <div id="dropAirport" class="grid grid-cols-1 gap-4 hidden">
                <?php if (!empty($airports)): ?>
                  <input type="text" id="dropAirportSearch" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Search airport...">
                  <select name="drop_airport_code" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                    <option value="">Select Airport</option>
                    <?php foreach ($airports as $ap): $code=(string)($ap['code']??''); $label=(string)($ap['label']??$code); ?>
                      <option value="<?= htmlspecialchars($code) ?>" <?= (($_GET['drop_airport_code'] ?? '')===$code?'selected':'') ?>><?= htmlspecialchars($label) ?></option>
                    <?php endforeach; ?>
                  </select>
                <?php else: ?>
                  <input name="drop_airport_code" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Airport Code (e.g. BKK)">
                <?php endif; ?>
              </div>
              <div id="dropHotel" class="grid grid-cols-1 gap-4">
                <input name="drop_hotel_name" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Hotel Name">
                <input name="drop_hotel_address" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Hotel Address">
              </div>
              <div id="dropApartment" class="grid grid-cols-1 gap-4 hidden">
                <input name="drop_apartment_name" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Apartment Name">
                <input name="drop_apartment_address" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Apartment Address">
              </div>
              <div id="dropAddress" class="hidden">
                <input name="drop_address" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Drop-off Address">
              </div>
            </div>

            <div class="md:col-span-2">
              <div class="mb-3">
                <label class="block text-sm font-semibold text-slate-700 mb-2">Customer Details</label>
              </div>
              <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <input name="customer_name" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Full Name" required>
                <input name="customer_email" type="email" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Email">
                <input name="customer_phone" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Phone">
              </div>
            </div>

            <div class="md:col-span-2">
              <?php if (!empty($itineraries)): ?>
              <div class="mb-4">
                <label class="block text-sm font-semibold text-slate-700 mb-2">Extra Add-ons (optional)</label>
                <select name="itinerary_id" id="itinerarySelect" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors">
                  <option value="">No itinerary</option>
                  <?php foreach ($itineraries as $it): $iid=(int)($it['id']??0); $nm=(string)($it['name']??''); ?>
                    <option value="<?= $iid ?>" <?= (isset($_GET['itinerary_id']) && (int)$_GET['itinerary_id']===$iid?'selected':'') ?>><?= htmlspecialchars($nm) ?></option>
                  <?php endforeach; ?>
                </select>
                <div id="itinNote" class="mt-3 hidden">
                  <div class="alert alert-info text-sm" id="itinNoteText"></div>
                </div>
                <div id="itinEditor" class="mt-3 hidden">
                  <div class="text-sm font-medium mb-2">Extra add-ons for stops</div>
                  <div class="overflow-x-auto">
                    <table class="table table-zebra w-full text-sm">
                      <thead>
                        <tr>
                          <th style="width:48px">#</th>
                          <th>Activity / Stop Address</th>
                          <th style="width:100px">Distance (km)</th>
                          <th style="width:120px">Wait (min)</th>
                          <th style="width:160px">Extra Price (THB)</th>
                          <th style="width:220px">Notes</th>
                        </tr>
                      </thead>
                      <tbody id="itinEditBody"></tbody>
                    </table>
                  </div>
                </div>
              </div>
              <?php endif; ?>
              <label class="block text-sm font-semibold text-slate-700 mb-2">Round Trip</label>
              <label class="flex items-center gap-3 mb-4">
                <input id="isRound" name="is_round_trip" type="checkbox" class="w-5 h-5 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 focus:ring-2">
                <span class="text-sm text-slate-700">Return to pickup after activities</span>
              </label>
              <div id="roundFields" class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-3 hidden">
                <input name="return_date" type="date" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Return Date">
                <input name="return_time" type="time" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors" placeholder="Return Time">
              </div>
            </div>

            <div class="md:col-span-2">
              <label class="block text-sm font-semibold text-slate-700 mb-2">Notes for driver (optional)</label>
              <textarea name="notes" rows="3" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-colors resize-none" placeholder="Any special instructions?"></textarea>
            </div>
          </div>

          
        <div class="mt-6 flex items-center justify-between gap-6 border-t border-slate-200 pt-4">
          <div class="text-left">
            <div class="text-xs text-slate-500 mb-1">Route Summary</div>
            <div class="text-base font-semibold text-slate-900" id="routeSummary">Select pickup and drop-off locations</div>
            <div class="text-xs text-slate-500 mt-1">Max capacity: <span id="capText"><?= (int)($ride['capacity'] ?? 0) ?></span> passengers</div>
          </div>
          <button type="submit" class="px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg shadow-sm hover:shadow transition-all flex items-center gap-2" id="continueBtn">
            <span class="inline-flex items-center gap-2">
              <span id="continueText">Continue to Payment</span>
            </span>
          </button>
        </div>
      </form>
    </div>

    <!-- Summary aside -->
    <aside class="lg:col-span-4 space-y-4">
      <div class="rounded-xl border bg-white shadow-sm p-4 md:p-6 sticky top-6">
        <?php $thumb = (string)($ride['thumbnail_url'] ?? ($ride['cover_path'] ?? '')); ?>
        <div class="rounded-xl overflow-hidden bg-slate-100 mb-4">
          <img src="<?= $thumb !== '' ? htmlspecialchars($thumb) : ('https://picsum.photos/seed/'.urlencode((string)($ride['id'] ?? rand(1,9999))).'/1200/600') ?>" alt="Vehicle" class="w-full h-56 object-cover" loading="lazy">
        </div>
        <div class="flex items-center justify-between mb-3">
          <h2 class="text-lg font-bold text-slate-900"><?= htmlspecialchars((string)($ride['name'] ?? 'Transfer')) ?></h2>
          <span class="px-2 py-1 text-xs rounded-full bg-emerald-100 text-emerald-700">Available</span>
        </div>
        <div class="text-sm text-slate-600 mb-4">
          <?= htmlspecialchars((string)($ride['vehicle_type'] ?? '')) ?> • Capacity: <?= (int)($ride['capacity'] ?? 0) ?> pax
        </div>
        <div class="bg-slate-50 rounded-lg p-4 mb-4">
          <h3 class="text-sm font-semibold text-slate-800 mb-2">Service Includes</h3>
          <ul class="text-sm text-slate-600 space-y-2">
            <li class="flex items-center gap-2"><svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-emerald-600" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg> Professional Driver</li>
            <li class="flex items-center gap-2"><svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-emerald-600" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg> Door-to-Door Service</li>
            <li class="flex items-center gap-2"><svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-emerald-600" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg> Free Cancellation</li>
            <li class="flex items-center gap-2"><svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 text-emerald-600" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg> Instant Confirmation</li>
          </ul>
        </div>
        <div class="border-t pt-3">
          <div class="flex items-center justify-between">
            <div class="text-sm text-slate-600">Agent Price</div>
            <div class="text-2xl font-bold text-slate-900" id="totalPrice">฿<?= number_format((float) (($pricing['agent_price'] ?? null) !== null ? $pricing['agent_price'] : ($ride['base_price'] ?? 0)), 0) ?></div>
          </div>
          <div class="flex items-center justify-between text-xs text-slate-500 mt-1">
            <span>Customer Price</span>
            <span>฿<?= number_format((float) (($pricing['customer_price'] ?? null) !== null ? $pricing['customer_price'] : ($ride['base_price'] ?? 0)), 0) ?></span>
          </div>
          <div class="text-xs text-center text-slate-500 mt-3">All prices in Thai Baht (THB)</div>
        </div>
      </div>
    </aside>
  </div>
</div>

<script>
  function chgPax(d){
    const el = document.getElementById('paxInput');
    let v = parseInt(el.value || '1', 10);
    v = isNaN(v) ? 1 : v + d;
    if (v < 1) v = 1;
    el.value = v;
  }

  // Auto-select matching drop when a single route exists per pickup
  (function(){
    const from = document.getElementById('fromSelect');
    const to = document.getElementById('toSelect');
    if (from && to) {
      const map = {};
      <?php if (!empty($routes)): foreach ($routes as $r): ?>
        map[<?= json_encode((string)$r['pickup_name']) ?>] = <?= json_encode((string)$r['drop_name']) ?>;
      <?php endforeach; endif; ?>
      from.addEventListener('change', function(){
        const v = from.value || '';
        if (map[v] && (!to.value || to.value === '')) {
          // if exact pair exists, set it
          Array.from(to.options).forEach(opt => { if (opt.value === map[v]) opt.selected = true; });
        }
      });
    }
  })();

  // Capacity enforcement
  (function(){
    const cap = parseInt('<?= (int)($ride['capacity'] ?? 0) ?>', 10) || 0;
    const paxEl = document.getElementById('paxInput');
    if (cap>0 && paxEl){ paxEl.setAttribute('max', String(cap)); }
    window.chgPax = function(d){
      const el = document.getElementById('paxInput');
      let v = parseInt(el.value || '1', 10);
      v = isNaN(v) ? 1 : v + d;
      if (v < 1) v = 1;
      el.value = v;
    }

    // Auto-select matching drop when a single route exists per pickup
    (function(){
      const from = document.getElementById('fromSelect');
      const to = document.getElementById('toSelect');
      if (from && to) {
        const map = {};
        <?php if (!empty($routes)): foreach ($routes as $r): ?>
          map[<?= json_encode((string)$r['pickup_name']) ?>] = <?= json_encode((string)$r['drop_name']) ?>;
        <?php endforeach; endif; ?>
        from.addEventListener('change', function(){
          const v = from.value || '';
          if (map[v] && (!to.value || to.value === '')) {
            // if exact pair exists, set it
            Array.from(to.options).forEach(opt => { if (opt.value === map[v]) opt.selected = true; });
          }
        });
      }
    })();

    // Capacity enforcement
    (function(){
      const cap = parseInt('<?= (int)($ride['capacity'] ?? 0) ?>', 10) || 0;
      const paxEl = document.getElementById('paxInput');
      if (cap>0 && paxEl){ paxEl.setAttribute('max', String(cap)); }
      window.chgPax = function(d){
        const el = document.getElementById('paxInput');
        let v = parseInt(el.value || '1', 10);
        v = isNaN(v) ? 1 : v + d;
        if (v < 1) v = 1;
        if (cap > 0 && v > cap) v = cap;
        el.value = v;
      }
    })();

    // Dynamic UI per pickup/drop type + route summary
    (function(){
      const pickupType = document.getElementById('pickupType');
      const dropType = document.getElementById('dropType');
      const sec = (id)=>document.getElementById(id);
      const showPickup = (t)=>{
        sec('pickupAirport').classList.toggle('hidden', t!=='airport');
        sec('pickupHotel').classList.toggle('hidden', t!=='hotel');
        sec('pickupApartment').classList.toggle('hidden', t!=='apartment');
        sec('pickupAddress').classList.toggle('hidden', t!=='address');
      };
      const showDrop = (t)=>{
        sec('dropAirport').classList.toggle('hidden', t!=='airport');
        sec('dropHotel').classList.toggle('hidden', t!=='hotel');
        sec('dropApartment').classList.toggle('hidden', t!=='apartment');
        sec('dropAddress').classList.toggle('hidden', t!=='address');
      };
      const textVal = (name)=> (document.querySelector('[name="'+name+'"]')?.value || '').trim();
      const setSummary = ()=>{
        // Build pickup text
        let from='';
        const pt = pickupType.value;
        if (pt==='airport') from = (textVal('pickup_airport_code')||'Airport');
        if (pt==='hotel') from = textVal('pickup_hotel_name') || 'Hotel';
        if (pt==='apartment') from = textVal('pickup_apartment_name') || 'Apartment';
        if (pt==='address') from = textVal('pickup_address') || 'Address';
        // Build drop text
        let to='';
        const dt = dropType.value;
        if (dt==='airport') to = (textVal('drop_airport_code')||'Airport');
        if (dt==='hotel') to = textVal('drop_hotel_name') || 'Hotel';
        if (dt==='apartment') to = textVal('drop_apartment_name') || 'Apartment';
        if (dt==='address') to = textVal('drop_address') || 'Address';
        // Write summary and hidden fields
        const sum = (from?from:'Pickup') + ' → ' + (to?to:'Drop-off');
        const el = document.getElementById('routeSummary'); if (el) el.textContent = sum;
        const fh = document.getElementById('fromHidden'); if (fh) fh.value = from;
        const th = document.getElementById('toHidden'); if (th) th.value = to;
      };
      showPickup(pickupType.value);
      showDrop(dropType.value);
      const rebind = ()=>{
        setSummary();
      };
      pickupType.addEventListener('change', ()=>{showPickup(pickupType.value); rebind();});
      dropType.addEventListener('change', ()=>{showDrop(dropType.value); rebind();});
      document.querySelectorAll('input').forEach(i=>{
        i.addEventListener('input', rebind);
        i.addEventListener('change', rebind);
      });
      document.querySelectorAll('select').forEach(i=>{
        i.addEventListener('change', rebind);
      });
      // Round trip toggle
      (function(){
        const chk = document.getElementById('isRound');
        const box = document.getElementById('roundFields');
        const dateInput = document.getElementById('dateInput');
        const retDate = document.querySelector('[name="return_date"]');
        const tripType = '<?= htmlspecialchars((string)($ride['trip_type'] ?? 'both')) ?>' || 'both';
        const syncReturnDate = ()=>{ if (retDate && dateInput) { retDate.value = dateInput.value || retDate.value; } };
        if (chk && box){
          const enforceByType = ()=>{
            if (tripType === 'single') {
              // Hide entire round section
              chk.checked = false; chk.disabled = true; box.classList.add('hidden');
            } else if (tripType === 'round') {
              chk.checked = true; chk.disabled = true; box.classList.remove('hidden'); syncReturnDate();
            } else { // both
              chk.disabled = false;
            }
          };
          const upd = ()=> { box.classList.toggle('hidden', !chk.checked); if (chk.checked) syncReturnDate(); };
          chk.addEventListener('change', upd);
          if (dateInput) { dateInput.addEventListener('change', ()=>{ if (chk.checked) syncReturnDate(); }); }
          enforceByType();
          upd();
        }
      })();

      // Itinerary editor binding with editable address/extra and total calc
      (function(){
        var sel = document.getElementById('itinerarySelect');
        if (!sel) return;
        var editor = document.getElementById('itinEditor');
        var body = document.getElementById('itinEditBody');
        var stopsMap = <?php echo json_encode($itinerary_stops ?? [], JSON_UNESCAPED_UNICODE); ?>;
        var tripType = '<?= htmlspecialchars((string)($ride['trip_type'] ?? 'both')) ?>' || 'both';
        var chkRound = document.getElementById('isRound');
        var dateInput = document.getElementById('dateInput');
        var retDate = document.querySelector('[name="return_date"]');
        var stopsJsonInput = document.getElementById('stopsJson');
        var totalEl = document.getElementById('totalPrice');
        var baseAgent = parseFloat('<?= (float)(($pricing['agent_price'] ?? null) !== null ? $pricing['agent_price'] : ($ride['base_price'] ?? 0)) ?>') || 0;
        var perKm = parseFloat('<?= isset($pricing['per_km']) && $pricing['per_km']!==null ? (float)$pricing['per_km'] : 0 ?>') || 0;
        function num(v){ var n=parseFloat(String(v||'').replace(/,/g,'')); return isNaN(n)?0:n; }
        function compute(){
          var extra = 0;
          var rows = Array.from(body.querySelectorAll('tr[data-seq]'));
          for (var i=0;i<rows.length;i++){
            var addr = rows[i].querySelector('input[data-field="address"]').value.trim();
            var price = num(rows[i].querySelector('input[data-field=extra_price]').value);
            if (addr === '') { break; } // sequential gating: stop at first empty address
            extra += price;
            if (perKm > 0){
              var dkm = num(rows[i].querySelector('input[data-field="distance_km"]').value);
              if (dkm > 7){ extra += (dkm - 7) * perKm; }
            }
          }
          var totalVal = (baseAgent + extra);
          if (totalEl) totalEl.innerHTML = '฿' + totalVal.toFixed(2) + ' <span class="text-sm">THB</span>';
          var mob = document.getElementById('mobileTotal');
          if (mob) mob.textContent = '฿' + totalVal.toFixed(2);
        }
        function syncJson(){
          var out = [];
          body.querySelectorAll('tr[data-seq]').forEach(function(tr){
            out.push({
              seq: parseInt(tr.getAttribute('data-seq')||'0',10)||0,
              label: tr.querySelector('input[data-field="label"]').value,
              address: tr.querySelector('input[data-field="address"]').value,
              wait_minutes: tr.querySelector('input[data-field="wait_minutes"]').value,
              distance_km: tr.querySelector('input[data-field="distance_km"]').value,
              extra_price: tr.querySelector('input[data-field="extra_price"]').value,
              notes: tr.querySelector('input[data-field="notes"]').value
            });
          });
          if (stopsJsonInput) stopsJsonInput.value = JSON.stringify(out);
        }
        function render(){
          var val = parseInt(sel.value||'0',10);
          body.innerHTML = '';
          if (!val || !stopsMap[val] || !stopsMap[val].length){ if(editor) editor.classList.add('hidden'); if(stopsJsonInput) stopsJsonInput.value=''; compute(); return; }
          (stopsMap[val]||[]).forEach(function(s, idx){
            var tr = document.createElement('tr'); tr.setAttribute('data-seq', String(s.seq||idx+1));
            tr.innerHTML = ''+
              '<td class="text-muted">'+(s.seq||idx+1)+'</td>'+
              '<td><input type="hidden" data-field="label" value="'+(s.label||'')+'"><input class="input input-bordered input-sm w-full" data-field="address" value="'+(s.address||'')+'" placeholder="Activity / Stop address"></td>'+
              '<td><input class="input input-bordered input-sm w-full" data-field="distance_km" type="number" min="0" step="0.1" value="'+(s.distance_km||'')+'" placeholder="0.0"></td>'+
              '<td><input class="input input-bordered input-sm w-full" data-field="wait_minutes" type="number" min="0" value="'+(s.wait_minutes||'')+'" readonly disabled></td>'+
              '<td><input class="input input-bordered input-sm w-full" data-field="extra_price" type="number" min="0" step="0.01" value="'+((typeof s.extra_price!=="undefined" && s.extra_price!==null && s.extra_price!==""?s.extra_price:0).toString())+'" placeholder="0.00" readonly disabled></td>'+
              '<td><input class="input input-bordered input-sm w-full" data-field="notes" value="'+(s.notes||'')+'"></td>';
            body.appendChild(tr);
          });
          if(editor) editor.classList.remove('hidden');
          // Bind change events for compute + sync
          body.querySelectorAll('input').forEach(function(ip){ ip.addEventListener('input', function(){ compute(); syncJson(); }); ip.addEventListener('change', function(){ compute(); syncJson();});});
          syncJson();
          compute();
        }
        sel.addEventListener('change', function(){
          // Auto-enable round trip when itinerary selected
          var hasItin = !!parseInt(sel.value||'0',10);
          if (hasItin && chkRound && !chkRound.checked) {
            chkRound.checked = true;
            if (retDate && dateInput) { retDate.value = dateInput.value || retDate.value; }
            var evt = new Event('change'); chkRound.dispatchEvent(evt);
          }
          render();
        });
        // If taxi is single-trip only, disable itinerary selection
        if (tripType === 'single') { sel.disabled = true; }
        render();
      })();

      // Airports search filter
      (function(){
        function bindFilter(inputId, selectName){
          var ip = document.getElementById(inputId);
          var sel = document.querySelector('select[name="'+selectName+'"]');
          if (!ip || !sel) return;
          var all = Array.from(sel.options);
          ip.addEventListener('input', function(){
            var q = ip.value.trim().toLowerCase();
            sel.innerHTML = '';
            var first = document.createElement('option'); first.value=''; first.textContent='Select Airport'; sel.appendChild(first);
            all.forEach(function(opt){
              if (!opt.value) return; // skip placeholder from snapshot
              if (q==='' || opt.text.toLowerCase().includes(q) || opt.value.toLowerCase().includes(q)){
                sel.appendChild(opt.cloneNode(true));
              }
            });
          });
        }
        bindFilter('pickupAirportSearch','pickup_airport_code');
        bindFilter('dropAirportSearch','drop_airport_code');
      })();
      // Initial summary
      setSummary();
    })();

    function validateForm(){
      const req = (name) => (document.querySelector('[name="'+name+'"]')?.value || '').trim();
      if (!req('date')) { alert('Please select date'); return false; }
      // Pickup minimal by type
      const pt = document.getElementById('pickupType').value;
      if (pt==='airport' && !req('pickup_airport_code')) { alert('Enter pickup airport code'); return false; }
      if (pt==='hotel' && !req('pickup_hotel_name')) { alert('Enter pickup hotel name'); return false; }
      if (pt==='apartment' && !req('pickup_apartment_name')) { alert('Enter pickup apartment name'); return false; }
      if (pt==='address' && !req('pickup_address')) { alert('Enter pickup address'); return false; }
      // Drop minimal by type
      const dt = document.getElementById('dropType').value;
      if (dt==='airport' && !req('drop_airport_code')) { alert('Enter drop airport code'); return false; }
      if (dt==='hotel' && !req('drop_hotel_name')) { alert('Enter drop hotel name'); return false; }
      if (dt==='apartment' && !req('drop_apartment_name')) { alert('Enter drop apartment name'); return false; }
      if (dt==='address' && !req('drop_address')) { alert('Enter drop address'); return false; }
      // Capacity
      const cap = parseInt('<?= (int)($ride['capacity'] ?? 0) ?>', 10) || 0;
      const pax = parseInt(document.getElementById('paxInput').value||'1',10);
      if (cap>0 && pax>cap){ alert('Pax exceeds vehicle capacity ('+cap+').'); return false; }
      // Customer name
      if (!req('customer_name')) { alert('Enter customer name'); return false; }
      return true;
    }
  </script>

  <script>
    // Submit loading state
    (function(){
      const form = document.getElementById('taxiDetailForm');
      const btn = document.getElementById('continueBtn');
      const txt = document.getElementById('continueText');
      if (form && btn) {
        form.addEventListener('submit', function(){
          btn.disabled = true;
          if (txt) txt.textContent = 'Processing...';
          btn.classList.add('opacity-90');
        });
      }
    })();
  </script>

  <!-- Footer intentionally omitted on this page -->
  </body>
  </html>
