<?php
$taxi = $taxi ?? [];
$csrf = $csrf ?? '';
$active = 'taxi';
require __DIR__ . '/partials/header.php';
?>

<!-- PREMIUM TAXI BOOKING PAGE -->
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-white to-blue-50/30">
  
  <!-- Compact Header -->
  <div class="bg-gradient-to-r from-blue-600 to-purple-600 text-white py-4">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
      <div class="flex items-center justify-between">
        <div>
          <h1 class="text-xl font-bold">Book Transfer</h1>
          <p class="text-sm text-blue-100"><?= htmlspecialchars($taxi['name'] ?? 'Premium Transfer') ?></p>
        </div>
        <a href="/b2b/agent/taxi" class="px-4 py-2 bg-white/20 hover:bg-white/30 rounded-lg text-sm font-semibold transition-all duration-300">
          ← Back to Transfers
        </a>
      </div>
    </div>
  </div>

  <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
      
      <!-- Transfer Summary -->
      <div class="lg:col-span-1">
        <div class="bg-white rounded-2xl shadow-lg border border-slate-200 p-6 sticky top-4">
          <h3 class="text-lg font-bold text-slate-900 mb-4">Transfer Summary</h3>
          
          <div class="space-y-4">
            <div class="flex items-center space-x-3">
              <div class="w-12 h-12 bg-blue-100 rounded-xl flex items-center justify-center">
                <svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M5 11l1.5-4.5A2 2 0 018.4 5h7.2a2 2 0 011.9 1.5L19 11v6a1 1 0 01-1 1h-1a1 1 0 01-1-1v-1H8v1a1 1 0 01-1 1H6a1 1 0 01-1-1v-6h0Z"/>
                </svg>
              </div>
              <div>
                <h4 class="font-semibold text-slate-900"><?= htmlspecialchars($taxi['name'] ?? 'Premium Transfer') ?></h4>
                <p class="text-sm text-slate-600"><?= htmlspecialchars($taxi['vehicle_type'] ?? 'Private Vehicle') ?></p>
              </div>
            </div>
            
            <div class="border-t pt-4">
              <div class="flex items-center text-sm text-slate-600 mb-2">
                <svg class="w-4 h-4 mr-2 text-emerald-600" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <span>Private Transfer</span>
              </div>
              <div class="flex items-center text-sm text-slate-600 mb-2">
                <svg class="w-4 h-4 mr-2 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                </svg>
                <span>Meet & Greet Service</span>
              </div>
              <div class="flex items-center text-sm text-slate-600">
                <svg class="w-4 h-4 mr-2 text-purple-600" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                </svg>
                <span>Instant Confirmation</span>
              </div>
            </div>
            
            <div class="border-t pt-4">
              <div class="text-center">
                <div class="text-sm text-slate-600 mb-1">Total Price</div>
                <div class="text-2xl font-black text-slate-900">
                  ฿<?= number_format((float)($taxi['base_price'] ?? 0), 0) ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Booking Form -->
      <div class="lg:col-span-2">
        <div class="bg-white rounded-2xl shadow-lg border border-slate-200 p-6">
          <h3 class="text-xl font-bold text-slate-900 mb-6">Booking Details</h3>
          
          <form method="post" action="/b2b/agent/taxi/payment" class="space-y-6">
            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
            <input type="hidden" name="taxi_id" value="<?= (int)($taxi['id'] ?? 0) ?>">
            
            <!-- Trip Details -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
              <div>
                <label class="block text-sm font-semibold text-slate-700 mb-2">Pickup Location</label>
                <input type="text" name="pickup_location" required 
                       class="w-full px-4 py-3 bg-slate-50 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-slate-900 font-medium"
                       placeholder="Airport, Hotel, Address..." value="<?= htmlspecialchars($taxi['from'] ?? '') ?>">
              </div>
              <div>
                <label class="block text-sm font-semibold text-slate-700 mb-2">Drop-off Location</label>
                <input type="text" name="dropoff_location" required 
                       class="w-full px-4 py-3 bg-slate-50 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-slate-900 font-medium"
                       placeholder="Destination..." value="<?= htmlspecialchars($taxi['to'] ?? '') ?>">
              </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
              <div>
                <label class="block text-sm font-semibold text-slate-700 mb-2">Travel Date</label>
                <input type="date" name="travel_date" required 
                       class="w-full px-4 py-3 bg-slate-50 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-slate-900 font-medium">
              </div>
              <div>
                <label class="block text-sm font-semibold text-slate-700 mb-2">Travel Time</label>
                <input type="time" name="travel_time" required 
                       class="w-full px-4 py-3 bg-slate-50 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-slate-900 font-medium">
              </div>
              <div>
                <label class="block text-sm font-semibold text-slate-700 mb-2">Passengers</label>
                <select name="passengers" required 
                        class="w-full px-4 py-3 bg-slate-50 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-slate-900 font-medium">
                  <option value="">Select</option>
                  <option value="1">1 Passenger</option>
                  <option value="2">2 Passengers</option>
                  <option value="3">3 Passengers</option>
                  <option value="4">4+ Passengers</option>
                </select>
              </div>
            </div>

            <!-- Customer Details -->
            <div class="border-t pt-6">
              <h4 class="text-lg font-bold text-slate-900 mb-4">Customer Information</h4>
              
              <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                  <label class="block text-sm font-semibold text-slate-700 mb-2">Customer Name</label>
                  <input type="text" name="customer_name" required 
                         class="w-full px-4 py-3 bg-slate-50 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-slate-900 font-medium"
                         placeholder="Full Name">
                </div>
                <div>
                  <label class="block text-sm font-semibold text-slate-700 mb-2">Email Address</label>
                  <input type="email" name="customer_email" required 
                         class="w-full px-4 py-3 bg-slate-50 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-slate-900 font-medium"
                         placeholder="email@example.com">
                </div>
              </div>
              
              <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-4">
                <div>
                  <label class="block text-sm font-semibold text-slate-700 mb-2">Phone Number</label>
                  <input type="tel" name="customer_phone" required 
                         class="w-full px-4 py-3 bg-slate-50 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-slate-900 font-medium"
                         placeholder="+66 XX XXX XXXX">
                </div>
                <div>
                  <label class="block text-sm font-semibold text-slate-700 mb-2">Flight Number (Optional)</label>
                  <input type="text" name="flight_number" 
                         class="w-full px-4 py-3 bg-slate-50 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-slate-900 font-medium"
                         placeholder="TG123">
                </div>
              </div>
            </div>

            <!-- Special Requests -->
            <div class="border-t pt-6">
              <label class="block text-sm font-semibold text-slate-700 mb-2">Special Requests (Optional)</label>
              <textarea name="special_requests" rows="3" 
                        class="w-full px-4 py-3 bg-slate-50 border border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-slate-900 font-medium"
                        placeholder="Any special requirements or notes..."></textarea>
            </div>

            <!-- Submit Button -->
            <div class="border-t pt-6">
              <button type="submit" 
                      class="w-full px-6 py-4 bg-gradient-to-r from-emerald-500 to-green-500 hover:from-emerald-600 hover:to-green-600 text-white font-bold rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                🚗 Proceed to Payment
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
