<?php
// app/Views/agent/support.php
$title = $title ?? 'Support Center';
$active = 'support';
$tickets = $tickets ?? [];
$csrf = $csrf ?? '';

// Status badge classes
$statusBadge = [
    'open' => 'bg-blue-100 text-blue-800',
    'in_progress' => 'bg-amber-100 text-amber-800',
    'resolved' => 'bg-emerald-100 text-emerald-800',
    'closed' => 'bg-slate-100 text-slate-800'
];

// Priority badge classes
$priorityBadge = [
    'low' => 'bg-slate-100 text-slate-800',
    'normal' => 'bg-blue-100 text-blue-800',
    'high' => 'bg-amber-100 text-amber-800',
    'urgent' => 'bg-red-100 text-red-800'
];

// Format timestamp
$fmt = function($ts) { 
    if(!$ts) return '—'; 
    $tm = strtotime((string)$ts); 
    if(!$tm) return '—';
    $now = time();
    $diff = $now - $tm;
    
    // Relative time for recent items
    if($diff < 3600) {
        $mins = floor($diff / 60);
        return $mins <= 1 ? 'just now' : $mins . ' minutes ago';
    } elseif($diff < 86400) {
        $hours = floor($diff / 3600);
        return $hours . ' hour' . ($hours > 1 ? 's' : '') . ' ago';
    } elseif($diff < 604800) {
        $days = floor($diff / 86400);
        return $days . ' day' . ($days > 1 ? 's' : '') . ' ago';
    }
    
    // Full date for older items
    return date('d M Y, H:i', $tm);
};

require __DIR__ . '/partials/header.php';
?>

<div class="bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 min-h-screen">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <?php
      // Pagination and filters
      $view = 'table';
      $page = isset($page) ? (int)$page : max(1, (int)($_GET['page'] ?? 1));
      $perPage = isset($perPage) ? (int)$perPage : 10;
      $total = isset($total) ? (int)$total : count($tickets);
      $statusFilter = isset($statusFilter) ? (string)$statusFilter : '';
      $keyword = isset($keyword) ? (string)$keyword : (string)($_GET['q'] ?? '');
      $lastPage = max(1, (int)ceil(($total ?: 0) / ($perPage ?: 10)));
      $q = function(array $params = []) use ($statusFilter, $view, $keyword) {
        $base = [ 'view' => $view ];
        if ($statusFilter !== '') $base['status'] = $statusFilter;
        if ($keyword !== '') $base['q'] = $keyword;
        $merged = array_merge($base, $params);
        return '?' . http_build_query($merged);
      };
    ?>
    <?php 
      $ok = isset($_GET['ok']) ? (string)$_GET['ok'] : '';
      $err = isset($_GET['err']) ? (string)$_GET['err'] : '';
    ?>
    
    <?php if ($ok === '1'): ?>
      <div class="mb-6 rounded-xl border border-emerald-200 bg-emerald-50 text-emerald-800 px-4 py-3 flex items-start">
        <svg class="h-5 w-5 mr-2 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
        </svg>
        <div>
          <p class="font-medium">Success!</p>
          <p class="text-sm">Your request has been submitted successfully.</p>
        </div>
      </div>
    <?php elseif ($err === 'csrf'): ?>
      <div class="mb-6 rounded-xl border border-amber-200 bg-amber-50 text-amber-800 px-4 py-3 flex items-start">
        <svg class="h-5 w-5 mr-2 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
        </svg>
        <div>
          <p class="font-medium">Session Expired</p>
          <p class="text-sm">Your session has expired. Please refresh the page and try again.</p>
        </div>
      </div>
    <?php elseif ($err === 'required'): ?>
      <div class="mb-6 rounded-xl border border-rose-200 bg-rose-50 text-rose-800 px-4 py-3 flex items-start">
        <svg class="h-5 w-5 mr-2 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
        </svg>
        <div>
          <p class="font-medium">Validation Error</p>
          <p class="text-sm">Please fill in all required fields.</p>
        </div>
      </div>
    <?php elseif ($err === 'db' || $err === 'schema'): ?>
      <div class="mb-6 rounded-xl border border-rose-200 bg-rose-50 text-rose-800 px-4 py-3 flex items-start">
        <svg class="h-5 w-5 mr-2 mt-0.5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
        </svg>
        <div>
          <p class="font-medium">System Error</p>
          <p class="text-sm">We're experiencing technical difficulties. Please try again later or contact support.</p>
        </div>
      </div>
    <?php endif; ?>

    <!-- Header Card -->
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 md:p-8 mb-8">
      <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-6">
        <div class="flex items-center space-x-4">
          <div class="w-16 h-16 bg-gradient-to-br from-blue-600 to-indigo-700 rounded-2xl flex items-center justify-center shadow-lg">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
            </svg>
          </div>
          <div>
            <h1 class="text-3xl font-bold bg-gradient-to-r from-slate-800 to-slate-600 bg-clip-text text-transparent">Support Center</h1>
            <p class="text-slate-600 text-sm mt-1">Get help with your bookings, payments, and account issues</p>
          </div>
        </div>
        <div class="flex-shrink-0">
          <button id="newTicketBtn" class="px-4 py-2.5 bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white font-medium rounded-xl shadow-md hover:shadow-lg transition-all flex items-center">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
            </svg>
            New Ticket
          </button>
        </div>
      </div>
    </div>

    <!-- New Ticket Form (Hidden by default) -->
    <div id="newTicketForm" class="hidden mb-8">
      <div class="bg-white rounded-2xl shadow-lg border border-slate-200/60 overflow-hidden">
        <div class="px-6 py-4 border-b border-slate-200 bg-slate-50">
          <div class="flex items-center justify-between">
            <h2 class="text-lg font-semibold text-slate-800">Create New Support Ticket</h2>
            <button type="button" id="closeTicketForm" class="text-slate-400 hover:text-slate-600">
              <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
              </svg>
            </button>
          </div>
        </div>
        <div class="p-6">
          <form method="post" action="/b2b/agent/support" class="space-y-5">
            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
            
            <div>
              <label for="subject" class="block text-sm font-medium text-slate-700 mb-1">Subject</label>
              <input id="subject" name="subject" type="text" required 
                     class="w-full px-4 py-2.5 border border-slate-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-slate-700 placeholder-slate-400" 
                     placeholder="Brief summary of your issue">
              <p class="mt-1 text-xs text-slate-500">Be specific to help us assist you better</p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
              <div>
                <label for="category" class="block text-sm font-medium text-slate-700 mb-1">Category</label>
                <select id="category" name="category" required 
                        class="w-full px-4 py-2.5 border border-slate-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-slate-700 bg-white">
                  <option value="">Select a category</option>
                  <option value="general">General Inquiry</option>
                  <option value="billing">Billing & Payments</option>
                  <option value="booking">Bookings & Reservations</option>
                  <option value="technical">Technical Issues</option>
                  <option value="kyc">KYC Verification</option>
                  <option value="refund">Refund Request</option>
                  <option value="other">Other</option>
                </select>
              </div>
              
              <div>
                <label for="priority" class="block text-sm font-medium text-slate-700 mb-1">Priority</label>
                <select id="priority" name="priority" 
                        class="w-full px-4 py-2.5 border border-slate-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-slate-700 bg-white">
                  <option value="normal">Normal</option>
                  <option value="high">High</option>
                  <option value="urgent">Urgent</option>
                </select>
                <p class="mt-1 text-xs text-slate-500">Select 'Urgent' only for time-sensitive issues</p>
              </div>
            </div>
            
            <div>
              <label for="message" class="block text-sm font-medium text-slate-700 mb-1">Message</label>
              <textarea id="message" name="message" rows="5" required 
                        class="w-full px-4 py-3 border border-slate-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-blue-500 text-slate-700 placeholder-slate-400" 
                        placeholder="Please provide as much detail as possible about your issue. Include relevant booking IDs, transaction numbers, or error messages."></textarea>
              <p class="mt-1 text-xs text-slate-500">Our support team will respond within 24 hours</p>
            </div>
            
            <div class="flex items-center justify-end space-x-3 pt-2">
              <button type="button" id="cancelTicketBtn" class="px-4 py-2.5 border border-slate-300 rounded-xl text-slate-700 font-medium hover:bg-slate-50 transition-colors">
                Cancel
              </button>
              <button type="submit" class="px-5 py-2.5 bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white font-medium rounded-xl shadow-md hover:shadow-lg transition-all flex items-center">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 19l9 2-9-18-9 18 9-2zm0 0v-8" />
                </svg>
                Submit Ticket
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <!-- Tickets List -->
    <div class="bg-white rounded-2xl shadow-lg border border-slate-200/60 overflow-hidden">
      <div class="px-6 py-4 border-b border-slate-200 bg-slate-50">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between">
          <h3 class="text-lg font-semibold text-slate-800">Support</h3>
          <form method="get" class="mt-2 sm:mt-0 flex items-center gap-2">
            <input type="hidden" name="view" value="table">
            <?php if ($statusFilter !== ''): ?><input type="hidden" name="status" value="<?= htmlspecialchars($statusFilter) ?>"><?php endif; ?>
            <input type="text" name="q" value="<?= htmlspecialchars($keyword) ?>" placeholder="Search subject or message..." class="text-sm border border-slate-300 rounded-lg px-3 py-1.5 focus:ring-2 focus:ring-blue-500 focus:border-blue-500 w-64">
            <select id="statusFilter" class="text-sm border border-slate-300 rounded-lg px-3 py-1.5 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
              <?php $currentStatus = $statusFilter !== '' ? $statusFilter : 'all'; ?>
              <option value="all" <?= $currentStatus==='all'?'selected':''; ?>>All Tickets</option>
              <option value="open" <?= $currentStatus==='open'?'selected':''; ?>>Open</option>
              <option value="in_progress" <?= $currentStatus==='in_progress'?'selected':''; ?>>In Progress</option>
              <option value="resolved" <?= $currentStatus==='resolved'?'selected':''; ?>>Resolved</option>
              <option value="closed" <?= $currentStatus==='closed'?'selected':''; ?>>Closed</option>
            </select>
            <button class="px-3 py-1.5 rounded-lg bg-blue-600 text-white text-sm hover:bg-blue-700">Search</button>
          </form>
        </div>
      </div>
      
        <div class="px-6 py-4 overflow-x-auto">
          <table class="min-w-full text-sm">
            <thead>
              <tr class="text-left text-slate-600 border-b">
                <th class="py-2 pr-4">ID</th>
                <th class="py-2 pr-4">Subject</th>
                <th class="py-2 pr-4">Category</th>
                <th class="py-2 pr-4">Priority</th>
                <th class="py-2 pr-4">Status</th>
                <th class="py-2 pr-4">Created</th>
                <th class="py-2 pr-4">Updated</th>
                <th class="py-2 pr-4">Last Reply</th>
                <th class="py-2 pr-0 text-right">Actions</th>
              </tr>
            </thead>
            <tbody class="divide-y divide-slate-200">
              <?php if (empty($tickets)): ?>
                <tr><td colspan="9" class="py-6 text-center text-slate-500">No tickets found</td></tr>
              <?php else: foreach ($tickets as $t):
                $tid = (int)($t['id'] ?? 0);
                $status = strtolower((string)($t['status'] ?? 'open'));
                $priority = strtolower((string)($t['priority'] ?? 'normal'));
                $createdAt = $fmt($t['created_at'] ?? '');
                $updatedAt = $fmt($t['updated_at'] ?? $t['created_at'] ?? '');
                $lastReplyAt = $fmt($t['last_replied_at'] ?? '');
              ?>
              <tr class="hover:bg-slate-50">
                <td class="py-2 pr-4 font-medium text-slate-800">#<?= $tid ?></td>
                <td class="py-2 pr-4 text-slate-900">
                  <a href="/b2b/agent/support/view?id=<?= $tid ?>" class="text-blue-700 hover:underline">
                    <?= htmlspecialchars((string)($t['subject'] ?? '')) ?>
                  </a>
                </td>
                <td class="py-2 pr-4 text-slate-600 capitalize"><?= htmlspecialchars((string)($t['category'] ?? '')) ?></td>
                <td class="py-2 pr-4 text-slate-600 capitalize">
                  <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?= $priorityBadge[$priority] ?? 'bg-slate-100 text-slate-800' ?>">
                    <?= htmlspecialchars((string)($t['priority'] ?? '')) ?>
                  </span>
                </td>
                <td class="py-2 pr-4">
                  <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?= $statusBadge[$status] ?? 'bg-slate-100 text-slate-800' ?>">
                    <?= ucwords(str_replace('_',' ', $status)) ?>
                  </span>
                </td>
                <td class="py-2 pr-4 text-slate-600"><?= $createdAt ?></td>
                <td class="py-2 pr-4 text-slate-600"><?= $updatedAt ?></td>
                <td class="py-2 pr-4 text-slate-600"><?= $t['last_replied_at'] ? $lastReplyAt : '—' ?></td>
                <td class="py-2 pr-0 text-right">
                  <a href="/b2b/agent/support/view?id=<?= $tid ?>" class="px-3 py-1.5 rounded-lg bg-blue-600 text-white hover:bg-blue-700 text-xs">View</a>
                </td>
              </tr>
              <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>
        <!-- Pagination for table view -->
        <div class="px-6 py-4 border-t border-slate-200 bg-white rounded-b-2xl">
          <div class="flex items-center justify-between">
            <p class="text-sm text-slate-600">
              <?php $start = ($total>0) ? (($page-1)*$perPage+1) : 0; $end = min($total, $page*$perPage); ?>
              Showing <span class="font-medium"><?= $start ?>–<?= $end ?></span> of <span class="font-medium"><?= $total ?></span>
            </p>
            <div class="flex space-x-2">
              <a href="<?= $page>1 ? $q(['page'=>$page-1]) : 'javascript:void(0)' ?>" class="px-3 py-1.5 border border-slate-300 rounded-lg text-sm font-medium <?= $page>1 ? 'text-slate-700 bg-white hover:bg-slate-50' : 'text-slate-400 bg-white cursor-not-allowed' ?>">Previous</a>
              <a href="<?= $page<$lastPage ? $q(['page'=>$page+1]) : 'javascript:void(0)' ?>" class="px-3 py-1.5 border border-slate-300 rounded-lg text-sm font-medium <?= $page<$lastPage ? 'text-white bg-blue-600 hover:bg-blue-700' : 'text-slate-400 bg-white cursor-not-allowed' ?>"><?= $page<$lastPage ? 'Next' : 'Next' ?></a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
  // Toggle new ticket form
  const newTicketBtn = document.getElementById('newTicketBtn');
  const startNewTicketBtn = document.getElementById('startNewTicketBtn');
  const newTicketForm = document.getElementById('newTicketForm');
  const closeTicketForm = document.getElementById('closeTicketForm');
  const cancelTicketBtn = document.getElementById('cancelTicketBtn');
  const statusFilter = document.getElementById('statusFilter');
  
  // Show/hide new ticket form
  function showTicketForm(show = true) {
    if (show) {
      newTicketForm.classList.remove('hidden');
      newTicketForm.scrollIntoView({ behavior: 'smooth', block: 'start' });
      document.getElementById('subject').focus();
    } else {
      newTicketForm.classList.add('hidden');
    }
  }
  
  // Event listeners
  if (newTicketBtn) newTicketBtn.addEventListener('click', () => showTicketForm(true));
  if (startNewTicketBtn) startNewTicketBtn.addEventListener('click', () => showTicketForm(true));
  if (closeTicketForm) closeTicketForm.addEventListener('click', () => showTicketForm(false));
  if (cancelTicketBtn) cancelTicketBtn.addEventListener('click', () => showTicketForm(false));
  
  // Filter tickets by status
  if (statusFilter) {
    statusFilter.addEventListener('change', function() {
      const status = this.value;
      const form = this.closest('form');
      const params = new URLSearchParams(window.location.search);
      if (status === 'all') {
        params.delete('status');
      } else {
        params.set('status', status);
      }
      params.set('view', 'table');
      params.set('page', '1');
      // keep q if present
      const qInput = document.querySelector('input[name="q"]');
      if (qInput && qInput.value.trim() !== '') params.set('q', qInput.value.trim());
      window.location.search = params.toString();
    });
  }
  
  // Auto-resize textarea
  const messageTextarea = document.getElementById('message');
  if (messageTextarea) {
    messageTextarea.addEventListener('input', function() {
      this.style.height = 'auto';
      this.style.height = (this.scrollHeight) + 'px';
    });
  }
  
  // Initialize tooltips if you have any
  // Example with tippy.js: tippy('[data-tippy-content]');
});
</script>
