<!DOCTYPE html>
<html lang="en" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Search Mode - BookMyThai Agent</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        'brand': {
                            50: '#eff6ff',
                            100: '#dbeafe',
                            200: '#bfdbfe',
                            300: '#93c5fd',
                            400: '#60a5fa',
                            500: '#3b82f6',
                            600: '#2563eb',
                            700: '#1d4ed8',
                            800: '#1e40af',
                            900: '#1e3a8a'
                        }
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-gradient-to-br from-slate-50 via-white to-blue-50/30">

<!-- Fullscreen Search Interface -->
<div class="min-h-screen flex flex-col">
  
  <!-- Minimal Top Bar -->
  <div class="bg-white border-b border-slate-200 px-6 py-3">
    <div class="flex items-center justify-between">
      <div class="flex items-center space-x-4">
        <div class="flex items-center space-x-3">
          <div class="w-10 h-10 bg-gradient-to-br from-brand-600 to-blue-600 rounded-xl flex items-center justify-center">
            <span class="text-white font-bold text-lg">B</span>
          </div>
          <div>
            <div class="font-bold text-slate-900">BookMyThai</div>
            <div class="text-xs text-slate-500">Search Mode</div>
          </div>
        </div>
        <div class="h-6 w-px bg-slate-300"></div>
        <div class="flex items-center space-x-2">
          <div class="w-2 h-2 bg-emerald-500 rounded-full animate-pulse"></div>
          <span class="text-sm font-semibold text-emerald-700">Live System</span>
        </div>
      </div>
      
      <div class="flex items-center space-x-4">
        <div class="text-sm text-slate-600">Agent: <span class="font-semibold">KARNI Digital Solution</span></div>
        <button onclick="toggleFullscreen()" class="px-4 py-2 bg-slate-100 hover:bg-slate-200 text-slate-700 font-semibold rounded-lg transition-colors text-sm">
          Exit Fullscreen
        </button>
      </div>
    </div>
  </div>

  <!-- Main Search Area -->
  <div class="flex-1 flex items-center justify-center p-8">
    <div class="w-full max-w-6xl">
      
      <!-- Search Card -->
      <div class="bg-white rounded-3xl shadow-2xl border border-slate-200 overflow-hidden">
        
        <!-- Search Header -->
        <div class="bg-gradient-to-r from-brand-600 to-blue-600 px-10 py-8 text-center">
          <h1 class="text-4xl font-black text-white mb-3">Quick Search</h1>
          <p class="text-brand-100 text-lg">Find and book instantly with live rates</p>
          <div class="flex items-center justify-center space-x-8 mt-6">
            <div class="flex items-center space-x-2 text-white">
              <div class="w-3 h-3 bg-emerald-400 rounded-full animate-pulse"></div>
              <span class="font-semibold">Live Rates</span>
            </div>
            <div class="flex items-center space-x-2 text-white">
              <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
              </svg>
              <span class="font-semibold">Instant Confirm</span>
            </div>
            <div class="flex items-center space-x-2 text-white">
              <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
              </svg>
              <span class="font-semibold">Best Rates</span>
            </div>
          </div>
        </div>

        <!-- Tab Navigation -->
        <div class="bg-slate-50 px-10 py-6">
          <nav class="flex justify-center space-x-2" role="tablist">
            <button role="tab" data-tab="hotels" aria-selected="true" class="tab-active px-8 py-4 rounded-2xl font-bold text-lg transition-all duration-200 flex items-center space-x-3 bg-white text-slate-800 shadow-lg border border-slate-200">
              <svg class="w-6 h-6 text-purple-600" fill="currentColor" viewBox="0 0 24 24">
                <path d="M4 3h10a2 2 0 012 2v14h3v2H3v-2h1V5a2 2 0 012-2Z"/>
              </svg>
              <span>Hotels</span>
            </button>
            <button role="tab" data-tab="activities" class="px-8 py-4 rounded-2xl font-bold text-lg transition-all duration-200 flex items-center space-x-3 text-slate-600 hover:text-slate-800 hover:bg-white/70">
              <svg class="w-6 h-6 text-emerald-600" fill="currentColor" viewBox="0 0 24 24">
                <path d="M12 3a9 9 0 100 18 9 9 0 000-18Zm0 4.5a1.5 1.5 0 110 3 1.5 1.5 0 010-3Zm-3.75 9.75a4.5 4.5 0 017.5 0H8.25Z"/>
              </svg>
              <span>Activities</span>
            </button>
            <button role="tab" data-tab="transfers" class="px-8 py-4 rounded-2xl font-bold text-lg transition-all duration-200 flex items-center space-x-3 text-slate-600 hover:text-slate-800 hover:bg-white/70">
              <svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                <path d="M5 11l1.5-4.5A2 2 0 018.4 5h7.2a2 2 0 011.9 1.5L19 11v6a1 1 0 01-1 1h-1a1 1 0 01-1-1v-1H8v1a1 1 0 01-1 1H6a1 1 0 01-1-1v-6h0Z"/>
              </svg>
              <span>Transfers</span>
            </button>
            <button role="tab" data-tab="yachts" class="px-8 py-4 rounded-2xl font-bold text-lg transition-all duration-200 flex items-center space-x-3 text-slate-600 hover:text-slate-800 hover:bg-white/70">
              <svg class="w-6 h-6 text-cyan-600" fill="currentColor" viewBox="0 0 24 24">
                <path d="M3 18s2 3 9 3 9-3 9-3l-3-6h-6l-3 6Zm9-15l5 9h-5V3Z"/>
              </svg>
              <span>Yachts</span>
            </button>
            <button role="tab" data-tab="packages" class="px-8 py-4 rounded-2xl font-bold text-lg transition-all duration-200 flex items-center space-x-3 text-slate-600 hover:text-slate-800 hover:bg-white/70">
              <svg class="w-6 h-6 text-orange-600" fill="currentColor" viewBox="0 0 24 24">
                <path d="M3 7l9-4 9 4-9 4L3 7Zm0 3l9 4 9-4v7l-9 4-9-4v-7Z"/>
              </svg>
              <span>Packages</span>
            </button>
          </nav>
        </div>

        <!-- Search Content -->
        <div class="p-12">
          <!-- Hotels Search Panel (Active) -->
          <div id="panel-hotels" role="tabpanel" class="space-y-10">
            <!-- Primary Search Row -->
            <div class="grid grid-cols-1 lg:grid-cols-12 gap-8 items-end">
              <!-- Destination -->
              <div class="lg:col-span-4">
                <label class="block text-sm font-bold text-slate-700 uppercase tracking-wide mb-4">Destination</label>
                <div class="relative">
                  <input type="text" placeholder="Bangkok, Phuket, Pattaya..." 
                         class="w-full px-6 py-5 bg-white border-2 border-slate-300 rounded-2xl focus:border-blue-500 focus:ring-4 focus:ring-blue-100 transition-all duration-200 text-slate-900 font-semibold placeholder-slate-500 shadow-lg text-lg">
                  <svg class="absolute right-6 top-5 w-6 h-6 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                  </svg>
                </div>
              </div>
              
              <!-- Check-in -->
              <div class="lg:col-span-2">
                <label class="block text-sm font-bold text-slate-700 uppercase tracking-wide mb-4">Check-in</label>
                <input type="date" class="w-full px-6 py-5 bg-white border-2 border-slate-300 rounded-2xl focus:border-blue-500 focus:ring-4 focus:ring-blue-100 transition-all duration-200 text-slate-900 font-semibold shadow-lg text-lg">
              </div>
              
              <!-- Check-out -->
              <div class="lg:col-span-2">
                <label class="block text-sm font-bold text-slate-700 uppercase tracking-wide mb-4">Check-out</label>
                <input type="date" class="w-full px-6 py-5 bg-white border-2 border-slate-300 rounded-2xl focus:border-blue-500 focus:ring-4 focus:ring-blue-100 transition-all duration-200 text-slate-900 font-semibold shadow-lg text-lg">
              </div>
              
              <!-- Guests & Rooms -->
              <div class="lg:col-span-2">
                <label class="block text-sm font-bold text-slate-700 uppercase tracking-wide mb-4">Guests & Rooms</label>
                <div class="grid grid-cols-2 gap-3">
                  <select class="px-4 py-5 bg-white border-2 border-slate-300 rounded-2xl focus:border-blue-500 focus:ring-4 focus:ring-blue-100 transition-all duration-200 text-slate-900 font-semibold shadow-lg text-lg">
                    <option>1</option>
                    <option>2</option>
                    <option>3</option>
                    <option>4+</option>
                  </select>
                  <select class="px-4 py-5 bg-white border-2 border-slate-300 rounded-2xl focus:border-blue-500 focus:ring-4 focus:ring-blue-100 transition-all duration-200 text-slate-900 font-semibold shadow-lg text-lg">
                    <option>1</option>
                    <option>2</option>
                    <option>3</option>
                    <option>4+</option>
                  </select>
                </div>
              </div>
              
              <!-- Search Button -->
              <div class="lg:col-span-2">
                <button class="w-full px-8 py-5 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-black rounded-2xl shadow-2xl hover:shadow-3xl transition-all duration-300 transform hover:scale-105 flex items-center justify-center space-x-3 text-lg">
                  <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                  </svg>
                  <span>Search</span>
                </button>
              </div>
            </div>

            <!-- Advanced Filters -->
            <div class="border-t-2 border-slate-200 pt-8">
              <div class="grid grid-cols-2 lg:grid-cols-6 gap-6">
                <div>
                  <label class="block text-sm font-bold text-slate-600 mb-3">Star Rating</label>
                  <select class="w-full px-4 py-3 bg-white border-2 border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-lg font-medium">
                    <option>Any</option>
                    <option>5 Star</option>
                    <option>4 Star</option>
                    <option>3 Star</option>
                  </select>
                </div>
                <div>
                  <label class="block text-sm font-bold text-slate-600 mb-3">Price Range</label>
                  <select class="w-full px-4 py-3 bg-white border-2 border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-lg font-medium">
                    <option>Any Budget</option>
                    <option>Under ฿2,000</option>
                    <option>฿2,000 - ฿5,000</option>
                    <option>฿5,000+</option>
                  </select>
                </div>
                <div>
                  <label class="block text-sm font-bold text-slate-600 mb-3">Property Type</label>
                  <select class="w-full px-4 py-3 bg-white border-2 border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-lg font-medium">
                    <option>All Types</option>
                    <option>Hotel</option>
                    <option>Resort</option>
                    <option>Villa</option>
                  </select>
                </div>
                <div>
                  <label class="block text-sm font-bold text-slate-600 mb-3">Amenities</label>
                  <select class="w-full px-4 py-3 bg-white border-2 border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-lg font-medium">
                    <option>Any</option>
                    <option>Pool</option>
                    <option>Spa</option>
                    <option>Beach Access</option>
                  </select>
                </div>
                <div>
                  <label class="block text-sm font-bold text-slate-600 mb-3">Meal Plan</label>
                  <select class="w-full px-4 py-3 bg-white border-2 border-slate-300 rounded-xl focus:border-blue-500 focus:ring-2 focus:ring-blue-100 text-lg font-medium">
                    <option>Room Only</option>
                    <option>Breakfast</option>
                    <option>Half Board</option>
                    <option>Full Board</option>
                  </select>
                </div>
                <div class="flex items-end">
                  <button class="w-full px-6 py-3 bg-slate-100 hover:bg-slate-200 text-slate-700 font-bold rounded-xl transition-colors text-lg">
                    Reset Filters
                  </button>
                </div>
              </div>
            </div>
          </div>

          <!-- Other tab panels (hidden by default) -->
          <div id="panel-activities" role="tabpanel" class="hidden text-center py-20">
            <div class="text-emerald-600 mb-6">
              <svg class="w-24 h-24 mx-auto" fill="currentColor" viewBox="0 0 24 24">
                <path d="M12 3a9 9 0 100 18 9 9 0 000-18Z"/>
              </svg>
            </div>
            <h3 class="text-3xl font-bold text-slate-800 mb-4">Activities & Tours</h3>
            <p class="text-slate-600 text-xl">Search form coming soon...</p>
          </div>

          <div id="panel-transfers" role="tabpanel" class="hidden text-center py-20">
            <h3 class="text-3xl font-bold text-slate-800 mb-4">Transfers</h3>
            <p class="text-slate-600 text-xl">Search form coming soon...</p>
          </div>

          <div id="panel-yachts" role="tabpanel" class="hidden text-center py-20">
            <h3 class="text-3xl font-bold text-slate-800 mb-4">Yachts</h3>
            <p class="text-slate-600 text-xl">Search form coming soon...</p>
          </div>

          <div id="panel-packages" role="tabpanel" class="hidden text-center py-20">
            <h3 class="text-3xl font-bold text-slate-800 mb-4">Packages</h3>
            <p class="text-slate-600 text-xl">Search form coming soon...</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Tab Switching Script -->
<script>
document.addEventListener('DOMContentLoaded', function() {
  const tabs = document.querySelectorAll('[role="tab"]');
  const panels = document.querySelectorAll('[role="tabpanel"]');
  
  function activateTab(tab) {
    const targetPanel = tab.dataset.tab;
    
    // Update tabs
    tabs.forEach(t => {
      const isActive = t === tab;
      t.classList.toggle('tab-active', isActive);
      t.setAttribute('aria-selected', isActive ? 'true' : 'false');
      
      if (isActive) {
        t.classList.remove('text-slate-600', 'hover:text-slate-800', 'hover:bg-white/70');
        t.classList.add('bg-white', 'text-slate-800', 'shadow-lg', 'border', 'border-slate-200');
      } else {
        t.classList.remove('bg-white', 'text-slate-800', 'shadow-lg', 'border', 'border-slate-200');
        t.classList.add('text-slate-600', 'hover:text-slate-800', 'hover:bg-white/70');
      }
    });
    
    // Update panels
    panels.forEach(panel => {
      const isActive = panel.id === `panel-${targetPanel}`;
      panel.classList.toggle('hidden', !isActive);
    });
  }
  
  tabs.forEach(tab => {
    tab.addEventListener('click', () => activateTab(tab));
  });
});

function toggleFullscreen() {
  // Redirect back to normal home page
  window.location.href = '/b2b/agent/home';
}
</script>

</body>
</html>
