<?php
// app/Views/agent/refunds.php
$title = $title ?? 'Refund History';
$refunds = $refunds ?? [];
$pagination = $pagination ?? [];
$filters = $filters ?? [];
$active = 'bookings';
require __DIR__ . '/partials/header.php';

// Normalize pager
$page = (int)($pagination['page'] ?? 1);
$per = (int)($pagination['per_page'] ?? 25);
$total = (int)($pagination['total'] ?? count($refunds));
$pages = (int)($pagination['pages'] ?? ($total > 0 ? (int)ceil($total / max(1,$per)) : 1));
$queryBase = $_GET; unset($queryBase['page']);
$makeUrl = function($p) use ($queryBase) {
  $q = http_build_query(array_merge($queryBase, ['page'=>$p]));
  return '/b2b/agent/refunds' . ($q ? ('?'.$q) : '');
};
?>

<div class="bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 min-h-screen">
  <div class="max-w-7xl mx-auto px-6 py-8">

    <!-- Premium Header -->
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-8 mb-8">
      <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-6">
        <div class="flex items-center space-x-4">
          <div class="w-16 h-16 bg-gradient-to-br from-rose-600 to-red-700 rounded-2xl flex items-center justify-center shadow-lg">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-white" viewBox="0 0 24 24" fill="none" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0 2.08-.402 2.599-1"/>
            </svg>
          </div>
          <div>
            <h1 class="text-4xl font-bold bg-gradient-to-r from-slate-800 to-slate-600 bg-clip-text text-transparent">Refund History</h1>
            <p class="text-slate-600 text-lg mt-1">Payments and refunds across all booking types</p>
            <div class="flex items-center space-x-4 mt-3 text-sm text-slate-500">
              <div class="flex items-center space-x-2"><div class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div><span>Live Data</span></div>
              <div>Total: <?= number_format($total) ?></div>
            </div>
          </div>
        </div>
        <div class="flex flex-col sm:flex-row gap-3">
          <a href="/b2b/agent/bookings" class="btn bg-gradient-to-r from-blue-600 to-indigo-600 text-white border-0">Back to Bookings</a>
        </div>
      </div>
    </div>

    <!-- Analytics Cards -->
    <?php 
      $analytics = $analytics ?? [];
      $refundsToday = (float)($analytics['refunds_today_amount'] ?? 0);
      $refundsChange = isset($analytics['refunds_change_percent']) ? (float)$analytics['refunds_change_percent'] : null;
      $totalRefunds = (float)($analytics['refunds_total_amount'] ?? 0);
      $byType = $analytics['by_type'] ?? [];
      $counts = [
        'activity' => (int)($byType['activity'] ?? 0),
        'hotel'    => (int)($byType['hotel'] ?? 0),
        'taxi'     => (int)($byType['taxi'] ?? 0),
        'yacht'    => (int)($byType['yacht'] ?? 0),
        'holiday'  => (int)($byType['holiday'] ?? 0),
      ];
    ?>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
      <div class="bg-white rounded-xl shadow-lg border border-slate-200/60 p-6 hover:shadow-xl transition-all duration-300">
        <div class="flex items-center justify-between">
          <div>
            <p class="text-slate-600 text-sm font-medium">Refunds Today</p>
            <p class="text-3xl font-bold text-slate-800 mt-1">฿<?= number_format($refundsToday, 2) ?></p>
            <p class="text-sm mt-1 <?= ($refundsChange !== null && $refundsChange > 0) ? 'text-rose-600' : 'text-emerald-600' ?>">
              <?= $refundsChange !== null ? ( ($refundsChange>0?'+':'') . number_format($refundsChange,1) . '% vs yesterday' ) : 'vs yesterday' ?>
            </p>
          </div>
          <div class="w-12 h-12 bg-gradient-to-br from-rose-500 to-red-600 rounded-xl flex items-center justify-center">
            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0 2.08-.402 2.599-1"/></svg>
          </div>
        </div>
        <p class="text-slate-500 text-xs mt-1">All-time refunds: ฿<?= number_format($totalRefunds, 2) ?></p>
      </div>

      <div class="bg-white rounded-xl shadow-lg border border-slate-200/60 p-6 hover:shadow-xl transition-all duration-300">
        <div class="flex items-center justify-between">
          <div>
            <p class="text-slate-600 text-sm font-medium">Refund Counts by Type</p>
            <div class="mt-2 space-y-1 text-sm text-slate-700">
              <div>Activity: <span class="font-semibold"><?= $counts['activity'] ?></span></div>
              <div>Hotel: <span class="font-semibold"><?= $counts['hotel'] ?></span></div>
              <div>Taxi: <span class="font-semibold"><?= $counts['taxi'] ?></span></div>
              <div>Yacht: <span class="font-semibold"><?= $counts['yacht'] ?></span></div>
              <div>Holiday: <span class="font-semibold"><?= $counts['holiday'] ?></span></div>
            </div>
          </div>
          <div class="w-12 h-12 bg-gradient-to-br from-emerald-500 to-green-600 rounded-xl flex items-center justify-center">
            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 11V3a1 1 0 112 0v8h8a1 1 0 110 2h-8v8a1 1 0 11-2 0v-8H3a1 1 0 110-2h8z"/></svg>
          </div>
        </div>
      </div>

      <div class="bg-white rounded-xl shadow-lg border border-slate-200/60 p-6 hover:shadow-xl transition-all duration-300">
        <div class="flex items-center justify-between">
          <div>
            <p class="text-slate-600 text-sm font-medium">Total Refunds</p>
            <p class="text-3xl font-bold text-slate-800 mt-1">฿<?= number_format($totalRefunds, 2) ?></p>
            <p class="text-slate-500 text-xs mt-1">Cumulative</p>
          </div>
          <div class="w-12 h-12 bg-gradient-to-br from-blue-500 to-indigo-600 rounded-xl flex items-center justify-center">
            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2"/></svg>
          </div>
        </div>
      </div>

      <div class="bg-white rounded-xl shadow-lg border border-slate-200/60 p-6 hover:shadow-xl transition-all duration-300">
        <div class="flex items-center justify-between">
          <div>
            <p class="text-slate-600 text-sm font-medium">Filters</p>
            <p class="text-slate-500 text-xs mt-1">Use the panel below to refine results</p>
          </div>
          <div class="w-12 h-12 bg-gradient-to-br from-slate-400 to-slate-600 rounded-xl flex items-center justify-center">
            <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 4h18M3 10h12M3 16h6"/></svg>
          </div>
        </div>
      </div>
    </div>

    <!-- Advanced Filter Panel -->
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 mb-8">
      <form method="get" class="space-y-6">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-6 gap-4">
          <div class="lg:col-span-2">
            <label class="block text-sm font-medium text-slate-700 mb-2">Search</label>
            <input class="block w-full px-3 py-3 border border-slate-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent" name="q" placeholder="Search by booking code, txn id" value="<?= htmlspecialchars($filters['q'] ?? ($_GET['q'] ?? '')) ?>" />
          </div>
          <div>
            <label class="block text-sm font-medium text-slate-700 mb-2">Type</label>
            <select class="block w-full px-3 py-3 border border-slate-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500" name="type">
              <?php $curType = (string)($filters['type'] ?? ($_GET['type'] ?? '')); $types = [''=>'All','activity'=>'Activity','hotel'=>'Hotel','taxi'=>'Taxi','yacht'=>'Yacht','holiday'=>'Holiday']; foreach ($types as $k=>$v): ?>
                <option value="<?= htmlspecialchars($k) ?>" <?= $curType===$k?'selected':'' ?>><?= htmlspecialchars($v) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div>
            <label class="block text-sm font-medium text-slate-700 mb-2">Status</label>
            <select class="block w-full px-3 py-3 border border-slate-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500" name="status">
              <?php $curSt = (string)($filters['status'] ?? ($_GET['status'] ?? '')); $sts = [''=>'All','refunded'=>'Refunded','partial'=>'Partial','captured'=>'Captured','paid'=>'Paid']; foreach ($sts as $k=>$v): ?>
                <option value="<?= htmlspecialchars($k) ?>" <?= $curSt===$k?'selected':'' ?>><?= htmlspecialchars($v) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div>
            <label class="block text-sm font-medium text-slate-700 mb-2">From</label>
            <input type="date" class="block w-full px-3 py-3 border border-slate-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500" name="from" value="<?= htmlspecialchars($filters['from'] ?? ($_GET['from'] ?? '')) ?>" />
          </div>
          <div>
            <label class="block text-sm font-medium text-slate-700 mb-2">To</label>
            <input type="date" class="block w-full px-3 py-3 border border-slate-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500" name="to" value="<?= htmlspecialchars($filters['to'] ?? ($_GET['to'] ?? '')) ?>" />
          </div>
        </div>
        <div class="flex flex-wrap gap-3 pt-2">
          <button class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white text-sm font-semibold rounded-lg shadow-md hover:shadow-lg transition-all duration-200">Apply Filters</button>
          <a href="/b2b/agent/refunds" class="inline-flex items-center px-6 py-3 bg-white border border-slate-300 text-slate-700 text-sm font-semibold rounded-lg hover:bg-slate-50 transition-all duration-200">Reset</a>
        </div>
      </form>
    </div>

    <!-- Refunds Table -->
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 overflow-hidden">
      <div class="px-6 py-4 bg-gradient-to-r from-slate-50 to-slate-100 border-b border-slate-200 flex items-center justify-between">
        <h3 class="text-lg font-semibold text-slate-800 flex items-center">
          <svg class="w-5 h-5 mr-2 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2"/></svg>
          Refund Records
        </h3>
        <div class="text-sm text-slate-600">Total: <?= $total ?></div>
      </div>

      <div class="overflow-x-auto">
        <table class="w-full">
          <thead class="bg-gradient-to-r from-slate-100 to-slate-50">
            <tr class="border-b border-slate-200">
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Type</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Booking</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Txn</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Amount</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Status</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Date</th>
            </tr>
          </thead>
          <tbody class="divide-y divide-slate-200">
            <?php if (empty($refunds)): ?>
              <tr><td colspan="6" class="px-6 py-12 text-center text-slate-500">No refund records</td></tr>
            <?php else: foreach ($refunds as $r): ?>
              <tr class="hover:bg-slate-50 transition-colors">
                <td class="px-6 py-4 text-sm capitalize"><?= htmlspecialchars(strtolower((string)($r['booking_type'] ?? ''))) ?></td>
                <td class="px-6 py-4 text-sm">
                  <?php $bid = (int)($r['booking_id'] ?? 0); $bt = strtolower((string)($r['booking_type'] ?? '')); ?>
                  <div class="flex flex-col">
                    <div class="font-medium">#<?= $bid ?></div>
                    <?php if ($bid>0 && in_array($bt,['taxi'])): ?>
                      <a class="text-blue-600 hover:text-blue-800 text-xs" href="/b2b/agent/<?= $bt ?>/voucher?id=<?= $bid ?>">View Voucher</a>
                    <?php endif; ?>
                  </div>
                </td>
                <td class="px-6 py-4 text-sm">
                  <div class="font-mono text-xs"><?= htmlspecialchars((string)($r['txn_id'] ?? '')) ?></div>
                  <div class="text-xs text-slate-500">Method: <?= htmlspecialchars((string)($r['method'] ?? '')) ?> • <?= htmlspecialchars((string)($r['gateway'] ?? '')) ?></div>
                </td>
                <td class="px-6 py-4 text-sm">
                  <span class="text-slate-900 font-semibold"><?= number_format((float)($r['amount'] ?? 0), 2) ?></span>
                  <span class="text-slate-500 ml-1"><?= htmlspecialchars((string)($r['currency'] ?? 'THB')) ?></span>
                </td>
                <td class="px-6 py-4 text-sm">
                  <?php $st = strtolower((string)($r['status'] ?? '')); $badge = 'bg-gray-100 text-gray-800';
                        if ($st==='refunded') $badge='bg-emerald-100 text-emerald-800';
                        elseif ($st==='partial') $badge='bg-amber-100 text-amber-800';
                        elseif (in_array($st,['failed','void'])) $badge='bg-red-100 text-red-800'; ?>
                  <span class="px-2 py-1 rounded <?= $badge ?> capitalize"><?= htmlspecialchars($st) ?></span>
                </td>
                <td class="px-6 py-4 text-sm">
                  <?= htmlspecialchars((string)($r['created_at'] ?? '')) ?>
                </td>
              </tr>
            <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>

    <!-- Pagination -->
    <div class="mt-8 bg-white rounded-2xl shadow-lg border border-slate-200/60 px-6 py-4">
      <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
        <div class="flex items-center space-x-4">
          <div class="text-sm text-slate-600">
            Showing <span class="font-semibold text-slate-900"><?= ($total ? ((($page - 1) * $per) + 1) : 0) ?></span> to 
            <span class="font-semibold text-slate-900"><?= min($page * $per, $total) ?></span> of 
            <span class="font-semibold text-slate-900"><?= number_format($total) ?></span> results
          </div>
          <div class="text-xs text-slate-500">(<?= $per ?> entries per page)</div>
        </div>
        <?php if (($pages ?? 1) > 1): ?>
          <?php $start = max(1, $page - 2); $end = min($pages, $page + 2); ?>
          <nav class="flex items-center space-x-1">
            <a href="<?= $page>1 ? htmlspecialchars($makeUrl($page-1)) : '#' ?>" class="inline-flex items-center px-3 py-2 text-sm font-medium <?= $page>1 ? 'text-slate-500 bg-white border border-slate-300 rounded-lg hover:bg-slate-50 hover:text-slate-700' : 'pointer-events-none opacity-50 text-slate-400 border border-slate-200 rounded-lg' ?>">Previous</a>
            <?php if ($start > 1): ?>
              <a href="<?= htmlspecialchars($makeUrl(1)) ?>" class="inline-flex items-center px-3 py-2 text-sm font-medium text-slate-500 bg-white border border-slate-300 rounded-lg hover:bg-slate-50 hover:text-slate-700">1</a>
              <?php if ($start > 2): ?><span class="px-2 text-slate-400">...</span><?php endif; ?>
            <?php endif; ?>
            <?php for ($i = $start; $i <= $end; $i++): ?>
              <a href="<?= htmlspecialchars($makeUrl($i)) ?>" class="inline-flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-colors duration-200 <?= $i === $page ? 'bg-blue-600 text-white border border-blue-600' : 'text-slate-500 bg-white border border-slate-300 hover:bg-slate-50 hover:text-slate-700' ?>"><?= $i ?></a>
            <?php endfor; ?>
            <?php if ($end < $pages): ?>
              <?php if ($end < $pages - 1): ?><span class="px-2 text-slate-400">...</span><?php endif; ?>
              <a href="<?= htmlspecialchars($makeUrl($pages)) ?>" class="inline-flex items-center px-3 py-2 text-sm font-medium text-slate-500 bg-white border border-slate-300 rounded-lg hover:bg-slate-50 hover:text-slate-700"><?= $pages ?></a>
            <?php endif; ?>
            <a href="<?= $page<$pages ? htmlspecialchars($makeUrl($page+1)) : '#' ?>" class="inline-flex items-center px-3 py-2 text-sm font-medium <?= $page<$pages ? 'text-slate-500 bg-white border border-slate-300 rounded-lg hover:bg-slate-50 hover:text-slate-700' : 'pointer-events-none opacity-50 text-slate-400 border border-slate-200 rounded-lg' ?>">Next</a>
          </nav>
        <?php endif; ?>
      </div>
    </div>

  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
