<?php
// app/Views/agent/profile.php
$title = $title ?? 'Profile';
$active = 'profile';
$agent = $_SESSION['agent'] ?? [];
$wallet = $wallet ?? ['balance'=>0.0,'locked'=>false,'locked_until'=>null,'attempts'=>0];
$kyc = $kyc ?? ['status'=>'pending','verified_at'=>null];
$name = trim((string)($agent['name'] ?? ''));
$email = trim((string)($agent['email'] ?? ''));
$company = trim((string)($agent['company'] ?? ''));
$phone = trim((string)($agent['phone'] ?? ''));
$city = trim((string)($agent['city'] ?? ''));
$country = trim((string)($agent['country'] ?? ''));
$avatar = (string)($agent['avatar'] ?? '');
$userMeta = $user_meta ?? ['created_at'=>null,'last_login_at'=>null];
require __DIR__ . '/partials/header.php';
?>

<!-- Premium Profile Page -->
<div class="bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 min-h-screen">
  <div class="max-w-7xl mx-auto px-6 py-8">

    <!-- Premium Header Card -->
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 md:p-8 mb-8">
      <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-6">
        <div class="flex items-center gap-4">
          <div class="w-16 h-16 rounded-2xl bg-gradient-to-br from-brand-500 to-blue-600 shadow-lg overflow-hidden flex items-center justify-center text-white font-bold text-xl">
            <?php if ($avatar): ?>
              <img src="/<?= htmlspecialchars($avatar) ?>" alt="avatar" class="w-16 h-16 object-cover" />
            <?php else: ?>
              <?= htmlspecialchars(strtoupper(substr($name !== '' ? $name : ($email !== '' ? explode('@',$email)[0] : 'AG'), 0, 2))) ?>
            <?php endif; ?>
          </div>
          <div>
            <h1 class="text-2xl md:text-3xl font-extrabold bg-gradient-to-r from-slate-800 to-slate-600 bg-clip-text text-transparent">
              <?= htmlspecialchars($name !== '' ? $name : 'Agent') ?>
            </h1>
            <?php
              // Booking-based partner level (provided by controller)
              $pl = $partner_level ?? null;
              $bookingCount = isset($booking_count) ? (int)$booking_count : null;
              $nextThreshold = $next_threshold ?? null;
              if (is_array($pl)) {
                $badgeColor = preg_replace('/[^a-z0-9-]/i','', (string)($pl['badge_color'] ?? 'slate'));
                $label = (string)($pl['label'] ?? 'Startup');
            ?>
              <div class="mt-1 flex items-center flex-wrap gap-3">
                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-[11px] font-semibold border bg-white text-slate-700 border-slate-200 shadow-sm" title="Partner Tier">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="w-3.5 h-3.5 mr-1 text-<?= htmlspecialchars($badgeColor) ?>-600">
                    <path d="M10 2c.23 0 .46.053.667.158l5.333 2.667A1.5 1.5 0 0117 6.18v4.64a6.5 6.5 0 01-3.295 5.65l-2.667 1.6a2 2 0 01-2.076 0l-2.667-1.6A6.5 6.5 0 013 10.82V6.18c0-.57.324-1.09.833-1.355L9.167 2.158A1.5 1.5 0 0110 2z" />
                  </svg>
                  Tier: <?= htmlspecialchars($label) ?>
                </span>
                <?php if ($bookingCount !== null): ?>
                  <span class="text-[11px] text-slate-500">•</span>
                  <span class="text-[12px] text-slate-600">Bookings <span class="font-semibold text-slate-800"><?= (int)$bookingCount ?></span></span>
                <?php endif; ?>
                <?php if ($bookingCount !== null && $nextThreshold): ?>
                  <?php $toGo = max(0, (int)$nextThreshold - (int)$bookingCount); ?>
                  <?php $pct = max(0, min(100, (int)floor(($bookingCount / max(1,(int)$nextThreshold)) * 100))); ?>
                  <div class="w-36 h-2 bg-slate-100 rounded-full overflow-hidden" title="<?= (int)$bookingCount ?>/<?= (int)$nextThreshold ?>">
                    <div class="h-2 bg-gradient-to-r from-blue-500 to-indigo-500" style="width: <?= $pct ?>%"></div>
                  </div>
                  <span class="text-[12px] text-slate-500"><?= $toGo ?> to next tier</span>
                <?php endif; ?>
              </div>
            <?php } ?>
            <?php $isVerified = strtolower((string)($kyc['status'] ?? '')) === 'approved'; ?>
            <?php if ($isVerified): ?>
              <div class="mt-1">
                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-semibold bg-emerald-100 text-emerald-700" title="KYC Verified">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" class="w-3.5 h-3.5 mr-1">
                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 10-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                  </svg>
                  Verified
                </span>
              </div>
            <?php endif; ?>
            <p class="text-slate-600 text-sm md:text-base mt-1">
              <?= $company !== '' ? htmlspecialchars($company) : '—' ?>
            </p>
            <div class="flex items-center space-x-4 mt-2 text-xs text-slate-500">
              <?php if (!empty($userMeta['created_at'])): ?>
                <span>Member since: <?= htmlspecialchars((string)$userMeta['created_at']) ?></span>
              <?php endif; ?>
              <?php if (!empty($userMeta['last_login_at'])): ?>
                <span>Last login: <?= htmlspecialchars((string)$userMeta['last_login_at']) ?></span>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <!-- Quick Stats -->
        <div class="grid grid-cols-2 md:grid-cols-3 gap-3 w-full lg:w-auto">
          <div class="rounded-xl p-4 border border-slate-200 bg-white">
            <div class="text-xs text-slate-500">Wallet Balance</div>
            <div class="text-2xl font-bold mt-1 text-slate-800">฿<?= number_format((float)($wallet['balance'] ?? 0), 2) ?></div>
          </div>
          <div class="rounded-xl p-4 border border-slate-200 bg-white">
            <div class="text-xs text-slate-500">PIN Status</div>
            <div class="mt-1">
              <?php if (!empty($wallet['locked'])): ?>
                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-rose-100 text-rose-800">Locked</span>
                <?php if (!empty($wallet['locked_until'])): ?>
                  <span class="ml-2 text-xs text-slate-500">until <?= htmlspecialchars((string)$wallet['locked_until']) ?></span>
                <?php endif; ?>
              <?php else: ?>
                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-emerald-100 text-emerald-800">Active</span>
              <?php endif; ?>
              <span class="ml-2 text-xs text-slate-500">(Attempts: <?= (int)($wallet['attempts'] ?? 0) ?>)</span>
            </div>
          </div>
          <div class="rounded-xl p-4 border border-slate-200 bg-white">
            <div class="text-xs text-slate-500">Account</div>
            <div class="mt-1 text-sm text-slate-700">ID: <?= (int)($agent['id'] ?? 0) ?></div>
            <div class="text-xs text-slate-500">Role: B2B Agent</div>
          </div>
        </div>
      </div>
    </div>

    <!-- Tabs header -->
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 md:p-8">
      <style>
        .tab-btn { color: rgb(100 116 139); border-bottom: 2px solid transparent; border-radius: 0; }
        .tab-btn:hover { color: rgb(30 41 59); border-bottom-color: rgb(226 232 240); }
        .tab-btn.tab-active { color: rgb(37 99 235); border-bottom-color: rgb(37 99 235); font-weight: 700; }
      </style>
      <div class="flex items-center gap-2 mb-4 border-b border-slate-200">
        <button class="tab-btn tab-active px-3 py-2 text-sm" data-tab="overview">Overview</button>
        <button class="tab-btn px-3 py-2 text-sm" data-tab="verification">Verification</button>
        <button class="tab-btn px-3 py-2 text-sm" data-tab="settings">Settings</button>
      </div>

    <!-- Panel: Overview -->
    <div id="panel-overview" class="tab-panel">
      <div class="mb-2 text-xs font-semibold uppercase tracking-wide text-slate-500">Contact</div>
      <div class="grid gap-6 sm:grid-cols-2">
        <div>
          <div class="text-xs text-slate-500">Email</div>
          <div><?= $email !== '' ? htmlspecialchars($email) : '—' ?></div>
          <div class="text-xs text-slate-500 mt-3">Phone</div>
          <div><?= $phone !== '' ? htmlspecialchars($phone) : '—' ?></div>
        </div>
        <div>
          <div class="text-xs text-slate-500">Location</div>
          <div>
            <?php $loc = trim($city . ', ' . $country, ' ,'); echo $loc !== '' ? htmlspecialchars($loc) : '—'; ?>
          </div>
          <div class="text-xs text-slate-500 mt-3">Company</div>
          <div><?= $company !== '' ? htmlspecialchars($company) : '—' ?></div>
        </div>
      </div>
      <div class="divider my-6"></div>
      <div class="mb-2 text-xs font-semibold uppercase tracking-wide text-slate-500">Account Overview</div>
      <div class="grid gap-6 sm:grid-cols-3">
        <div class="rounded-xl p-4 border border-slate-200 bg-white hover:shadow-sm transition-shadow">
          <div class="text-xs text-slate-500">Wallet Balance</div>
          <div class="text-2xl md:text-3xl font-bold mt-1"><?= number_format((float)($wallet['balance'] ?? 0), 2) ?> THB</div>
        </div>
        <div class="rounded-xl p-4 border border-slate-200 bg-white hover:shadow-sm transition-shadow">
          <div class="text-xs text-slate-500">PIN Status</div>
          <div class="mt-1">
            <?php if (!empty($wallet['locked'])): ?>
              <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-rose-100 text-rose-800">Locked</span>
              <?php if (!empty($wallet['locked_until'])): ?>
                <span class="ml-2 text-xs text-slate-500">until <?= htmlspecialchars((string)$wallet['locked_until']) ?></span>
              <?php endif; ?>
            <?php else: ?>
              <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-emerald-100 text-emerald-800">Active</span>
            <?php endif; ?>
            <span class="ml-2 text-xs text-slate-500">(Attempts: <?= (int)($wallet['attempts'] ?? 0) ?>)</span>
          </div>
        </div>
        <div class="rounded-xl p-4 border border-slate-200 bg-white hover:shadow-sm transition-shadow">
          <div class="text-xs text-slate-500">Account</div>
          <div class="mt-1 text-sm">ID: <?= (int)($agent['id'] ?? 0) ?></div>
          <div class="text-xs text-slate-500">Role: B2B Agent</div>
        </div>
      </div>
    </div>

    <!-- Panel: Verification -->
    <div id="panel-verification" class="tab-panel hidden">
      <div class="mb-2 text-xs text-slate-500">KYC</div>
      <div class="grid gap-6 sm:grid-cols-3">
        <div class="rounded-xl p-4 border border-slate-200 bg-white hover:shadow-sm transition-shadow">
          <div class="text-xs text-slate-500">KYC</div>
          <div class="mt-1">
            <?php $ks = strtolower((string)($kyc['status'] ?? 'pending')); ?>
            <?php if ($ks === 'approved'): ?>
              <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-emerald-100 text-emerald-800">Approved</span>
              <?php if (!empty($kyc['verified_at'])): ?>
                <span class="ml-2 text-xs text-slate-500">Verified on <?= htmlspecialchars((string)$kyc['verified_at']) ?></span>
              <?php endif; ?>
            <?php elseif ($ks === 'rejected'): ?>
              <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-rose-100 text-rose-800">Rejected</span>
            <?php else: ?>
              <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-amber-100 text-amber-800">Pending</span>
            <?php endif; ?>
            <a class="btn btn-xs btn-outline ml-3" href="#" onclick="alert('KYC center coming soon'); return false;">Manage KYC</a>
          </div>
        </div>
        <div class="hidden sm:block"></div>
        <div class="hidden sm:block"></div>
      </div>
    </div>

    <!-- Panel: Settings -->
    <div id="panel-settings" class="tab-panel hidden">
      <div class="mb-2 text-xs font-semibold uppercase tracking-wide text-slate-500">Agent Settings</div>
      <?php $settings = $agent_settings ?? []; ?>
      <?php if (!empty($settings)): ?>
      <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
        <?php foreach ($settings as $key => $val): ?>
          <?php
            $k = (string)$key;
            $label = ucwords(str_replace(['_','-'], ' ', $k));
            $isBool = is_bool($val) || $val === 0 || $val === 1 || $val === '0' || $val === '1';
            $isEmpty = $val === null || $val === '';
            $lowerK = strtolower($k);
            $isSensitive = str_contains($lowerK, 'api') || str_contains($lowerK, 'secret') || str_contains($lowerK, 'hash') || str_contains($lowerK, 'password') || str_contains($lowerK, 'pin');
            // Skip booleans, empty values, and sensitive keys
            if ($isBool || $isEmpty || $isSensitive) { continue; }

            // Only show meaningful numeric limits and non-empty texts
            if (is_numeric($val)) {
              $display = number_format((float)$val, 2);
            } else {
              $display = htmlspecialchars((string)$val);
            }
          ?>
          <div class="rounded-xl p-4 border border-slate-200 bg-white">
            <div class="text-xs text-slate-500"><?= htmlspecialchars($label) ?></div>
            <div class="mt-1 text-sm"><?= $display ?></div>
          </div>
        <?php endforeach; ?>
      </div>
      <?php else: ?>
        <div class="text-sm text-slate-500">No custom settings found for this account.</div>
      <?php endif; ?>
    </div>

  </div>
</div>

<script>
  (function() {
    const tabs = document.querySelectorAll('.tab-btn');
    const panels = {
      overview: document.getElementById('panel-overview'),
      verification: document.getElementById('panel-verification'),
      settings: document.getElementById('panel-settings')
    };
    function activate(name) {
      tabs.forEach(t => t.classList.toggle('tab-active', t.dataset.tab === name));
      Object.keys(panels).forEach(k => {
        if (!panels[k]) return;
        if (k === name) { panels[k].classList.remove('hidden'); }
        else { panels[k].classList.add('hidden'); }
      });
    }
    tabs.forEach(t => t.addEventListener('click', () => activate(t.dataset.tab)));
    // default
    activate('overview');
  })();
</script>

<?php require __DIR__ . '/partials/footer.php'; ?>
