<?php
// app/Views/agent/partials/social_proof.php
?>
<!-- WORLD-CLASS SOCIAL PROOF SECTION -->
<section class="py-20 bg-gradient-to-br from-slate-50 via-white to-blue-50/30 relative overflow-hidden">
  <!-- Background Elements -->
  <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="100" height="100" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23e0f2fe" fill-opacity="0.1"%3E%3Ccircle cx="50" cy="50" r="1"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-60"></div>
  
  <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Section Header -->
    <div class="text-center mb-16">
      <div class="inline-flex items-center space-x-2 bg-emerald-50 px-4 py-2 rounded-full mb-6">
        <div class="w-2 h-2 bg-emerald-500 rounded-full animate-pulse"></div>
        <span class="text-sm font-bold text-emerald-700">TRUSTED WORLDWIDE</span>
      </div>
      <h2 class="text-4xl lg:text-5xl font-black text-slate-900 mb-4">
        Join 10,000+ Successful
        <span class="bg-gradient-to-r from-brand-600 to-blue-600 bg-clip-text text-transparent block">Travel Agents</span>
      </h2>
      <p class="text-xl text-slate-600 max-w-3xl mx-auto">
        Leading travel agencies worldwide trust BookMyThai for their Thailand bookings
      </p>
    </div>

    <!-- Premium Statistics -->
    <div class="grid grid-cols-2 lg:grid-cols-4 gap-8 mb-16">
      <div class="text-center p-6 bg-white/80 backdrop-blur-sm rounded-2xl shadow-lg border border-slate-200/50">
        <div class="text-4xl font-black text-brand-600 mb-2">10K+</div>
        <div class="text-sm font-semibold text-slate-700">Active Agents</div>
        <div class="text-xs text-slate-500 mt-1">Worldwide</div>
      </div>
      <div class="text-center p-6 bg-white/80 backdrop-blur-sm rounded-2xl shadow-lg border border-slate-200/50">
        <div class="text-4xl font-black text-brand-600 mb-2">50K+</div>
        <div class="text-sm font-semibold text-slate-700">Monthly Bookings</div>
        <div class="text-xs text-slate-500 mt-1">Growing fast</div>
      </div>
      <div class="text-center p-6 bg-white/80 backdrop-blur-sm rounded-2xl shadow-lg border border-slate-200/50">
        <div class="text-4xl font-black text-brand-600 mb-2">99.9%</div>
        <div class="text-sm font-semibold text-slate-700">Success Rate</div>
        <div class="text-xs text-slate-500 mt-1">Guaranteed</div>
      </div>
      <div class="text-center p-6 bg-white/80 backdrop-blur-sm rounded-2xl shadow-lg border border-slate-200/50">
        <div class="text-4xl font-black text-brand-600 mb-2">24/7</div>
        <div class="text-sm font-semibold text-slate-700">Support</div>
        <div class="text-xs text-slate-500 mt-1">Always available</div>
      </div>
    </div>

    <!-- Premium Testimonials -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-16">
      <!-- Testimonial 1 -->
      <div class="bg-white/95 backdrop-blur-xl rounded-2xl p-8 shadow-xl border border-slate-200/50 hover:shadow-2xl transition-all duration-300">
        <div class="flex items-center mb-6">
          <div class="w-12 h-12 bg-gradient-to-br from-brand-500 to-blue-500 rounded-full flex items-center justify-center text-white font-bold text-lg mr-4">
            S
          </div>
          <div>
            <div class="font-bold text-slate-800">Sarah Johnson</div>
            <div class="text-sm text-slate-600">CEO, Global Travel Solutions</div>
          </div>
        </div>
        <div class="flex items-center mb-4">
          <div class="flex space-x-1">
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
          </div>
        </div>
        <p class="text-slate-700 leading-relaxed">
          "BookMyThai has revolutionized our Thailand operations. The instant confirmations and competitive rates have increased our bookings by 300%. Best B2B platform we've ever used."
        </p>
      </div>

      <!-- Testimonial 2 -->
      <div class="bg-white/95 backdrop-blur-xl rounded-2xl p-8 shadow-xl border border-slate-200/50 hover:shadow-2xl transition-all duration-300">
        <div class="flex items-center mb-6">
          <div class="w-12 h-12 bg-gradient-to-br from-emerald-500 to-teal-500 rounded-full flex items-center justify-center text-white font-bold text-lg mr-4">
            M
          </div>
          <div>
            <div class="font-bold text-slate-800">Michael Chen</div>
            <div class="text-sm text-slate-600">Director, Asia Pacific Tours</div>
          </div>
        </div>
        <div class="flex items-center mb-4">
          <div class="flex space-x-1">
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
          </div>
        </div>
        <p class="text-slate-700 leading-relaxed">
          "The API integration was seamless and the support team is incredible. We're now competing directly with Booking.com on Thailand packages. Game changer!"
        </p>
      </div>

      <!-- Testimonial 3 -->
      <div class="bg-white/95 backdrop-blur-xl rounded-2xl p-8 shadow-xl border border-slate-200/50 hover:shadow-2xl transition-all duration-300">
        <div class="flex items-center mb-6">
          <div class="w-12 h-12 bg-gradient-to-br from-purple-500 to-pink-500 rounded-full flex items-center justify-center text-white font-bold text-lg mr-4">
            A
          </div>
          <div>
            <div class="font-bold text-slate-800">Ananya Patel</div>
            <div class="text-sm text-slate-600">Founder, Luxury Escapes India</div>
          </div>
        </div>
        <div class="flex items-center mb-4">
          <div class="flex space-x-1">
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <svg class="w-5 h-5 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
          </div>
        </div>
        <p class="text-slate-700 leading-relaxed">
          "Premium inventory access and unbeatable rates. Our Thailand revenue doubled in 6 months. The yacht charter options are absolutely phenomenal."
        </p>
      </div>
    </div>

    <!-- Enterprise Logos -->
    <div class="text-center">
      <p class="text-sm font-semibold text-slate-600 mb-8">Trusted by leading travel companies worldwide</p>
      <div class="flex flex-wrap justify-center items-center gap-12 opacity-60">
        <div class="flex items-center space-x-2 bg-white/80 px-6 py-3 rounded-xl shadow-sm">
          <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-indigo-500 rounded-lg flex items-center justify-center">
            <span class="text-white font-bold text-sm">GT</span>
          </div>
          <span class="font-bold text-slate-700">Global Tours</span>
        </div>
        <div class="flex items-center space-x-2 bg-white/80 px-6 py-3 rounded-xl shadow-sm">
          <div class="w-8 h-8 bg-gradient-to-br from-emerald-500 to-teal-500 rounded-lg flex items-center justify-center">
            <span class="text-white font-bold text-sm">AP</span>
          </div>
          <span class="font-bold text-slate-700">Asia Pacific</span>
        </div>
        <div class="flex items-center space-x-2 bg-white/80 px-6 py-3 rounded-xl shadow-sm">
          <div class="w-8 h-8 bg-gradient-to-br from-purple-500 to-pink-500 rounded-lg flex items-center justify-center">
            <span class="text-white font-bold text-sm">LE</span>
          </div>
          <span class="font-bold text-slate-700">Luxury Escapes</span>
        </div>
        <div class="flex items-center space-x-2 bg-white/80 px-6 py-3 rounded-xl shadow-sm">
          <div class="w-8 h-8 bg-gradient-to-br from-orange-500 to-red-500 rounded-lg flex items-center justify-center">
            <span class="text-white font-bold text-sm">TW</span>
          </div>
          <span class="font-bold text-slate-700">Travel World</span>
        </div>
      </div>
    </div>
  </div>
</section>
