<script>
// Reusable desktop-only PWA install logic
(function(){
  // Register service worker (if present)
  if ('serviceWorker' in navigator) {
    window.addEventListener('load', function(){
      navigator.serviceWorker.register('/service-worker.js').catch(function(){});
    });
  }

  const ua = navigator.userAgent || '';
  const isIOS = /iPhone|iPad|iPod/i.test(ua);
  const isAndroid = /Android/i.test(ua);
  const isMobile = isIOS || isAndroid;
  const isStandalone = window.matchMedia('(display-mode: standalone)').matches || window.navigator.standalone === true;

  let deferredPrompt = null;
  const banner = document.getElementById('appInstallBanner');
  const headerBtn = document.getElementById('pwaInstallBtn');

  window.addEventListener('beforeinstallprompt', (e) => {
    e.preventDefault();
    deferredPrompt = e;
    // Show only on desktop browsers and when not already installed
    if (!isMobile && !isStandalone) {
      if (banner) banner.classList.add('show');
      if (headerBtn) headerBtn.style.display = 'inline-flex';
    }
  });

  window.addEventListener('appinstalled', () => {
    if (banner) banner.classList.remove('show');
    if (headerBtn) headerBtn.style.display = 'none';
  });

  document.getElementById('btnInstall')?.addEventListener('click', async () => {
    if (!deferredPrompt) return;
    deferredPrompt.prompt();
    await deferredPrompt.userChoice;
    deferredPrompt = null;
    if (banner) banner.classList.remove('show');
  });

  // Ensure banner hidden on iOS/Android or when already installed
  if (isMobile || isStandalone) {
    if (banner) banner.classList.remove('show');
    if (headerBtn) headerBtn.style.display = 'none';
  }

  // Expose installer for any header buttons
  window.installAgentPWA = async function(){
    try{
      if (!deferredPrompt) return;
      deferredPrompt.prompt();
      await deferredPrompt.userChoice;
      deferredPrompt = null;
    }catch(err){}
  }
})();
</script>
