<?php // app/Views/agent/partials/public_header.php ?>
<header class="bg-white/95 backdrop-blur-xl shadow-lg border-b border-slate-200/60 sticky top-0 z-50">
  <!-- Premium Status Bar -->
  <div class="bg-gradient-to-r from-brand-600 via-blue-600 to-indigo-600 text-white text-xs">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-1.5 flex items-center justify-between">
      <div class="flex items-center space-x-4">
        <div class="hidden sm:flex items-center space-x-2">
          <svg class="w-3.5 h-3.5 opacity-90" viewBox="0 0 24 24" fill="currentColor"><path d="M12 2a10 10 0 100 20 10 10 0 000-20zm1 17.93V20h-2v-.07A8.001 8.001 0 014.07 13H4v-2h.07A8.001 8.001 0 0111 4.07V4h2v.07A8.001 8.001 0 0119.93 11H20v2h-.07A8.001 8.001 0 0113 19.93z"/></svg>
          <span class="tracking-wide">Professional B2B Workspace</span>
        </div>
      </div>
      <div class="flex items-center space-x-3">
        <span class="hidden sm:block opacity-90">Support</span>
        <a href="tel:+66968826252" class="opacity-90 hover:opacity-100">+66 96 88 26252</a>
      </div>
    </div>
  </div>

  <!-- Main Bar -->
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex justify-between h-20">
      <!-- Logo -->
      <div class="flex-shrink-0 flex items-center">
        <a href="/b2b/agent" class="group flex items-center space-x-3 hover-lift">
          <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-brand-500 to-brand-600 flex items-center justify-center shadow-lg group-hover:shadow-xl transition-all duration-300">
            <span class="text-white font-extrabold">B</span>
          </div>
          <div>
            <div class="text-lg leading-tight font-extrabold bg-clip-text text-transparent bg-gradient-to-r from-slate-800 to-slate-900">BookMyThai.com</div>
            <div class="text-[11px] text-slate-500 -mt-0.5">Agent Workspace</div>
          </div>
        </a>
      </div>

<!-- Right -->
      <div class="flex items-center space-x-3">
        <a href="/login/agent" class="px-4 py-2.5 text-sm font-medium text-slate-700 hover:text-brand-600 hover:bg-slate-100 rounded-lg transition-colors">
          <i class="fas fa-sign-in-alt mr-1.5 text-brand-500"></i> Sign In
        </a>
        <a href="/agent/register" class="inline-flex items-center px-4 py-2.5 text-sm font-semibold text-white rounded-lg shadow-lg bg-gradient-to-r from-brand-600 to-blue-600 hover:from-brand-700 hover:to-blue-700 transition-all hover:shadow-xl hover:-translate-y-0.5">
          <i class="fas fa-user-plus mr-1.5 text-white/90"></i> Become Agent
        </a>
      </div>
    </div>
  </div>
</header>
