<?php
// app/Views/agent/partials/premium_pricing.php
?>
<!-- PREMIUM PRICING DISPLAY SECTION -->
<section class="py-20 bg-gradient-to-br from-slate-900 via-slate-800 to-brand-900 relative overflow-hidden">
  
  <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <!-- Section Header -->
    <div class="text-center mb-16">
      <div class="inline-flex items-center space-x-2 bg-emerald-500/20 px-4 py-2 rounded-full mb-6 border border-emerald-400/30">
        <div class="w-2 h-2 bg-emerald-400 rounded-full animate-pulse"></div>
        <span class="text-sm font-bold text-emerald-300">COMPETITIVE RATES</span>
      </div>
      <h2 class="text-4xl lg:text-5xl font-black text-white mb-4">
        Unbeatable Prices
        <span class="bg-gradient-to-r from-emerald-400 to-blue-400 bg-clip-text text-transparent block">Guaranteed Best Rates</span>
      </h2>
      <p class="text-xl text-slate-300 max-w-3xl mx-auto">
        Access wholesale rates and exclusive deals that beat the competition
      </p>
    </div>

    <!-- Live Rate Comparison -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-16">
      <!-- Featured Hotel Deal -->
      <div class="lg:col-span-2 bg-white/10 backdrop-blur-xl rounded-2xl p-8 border border-white/20">
        <div class="flex items-center justify-between mb-6">
          <div>
            <h3 class="text-2xl font-bold text-white mb-2">Live Rate Example</h3>
            <p class="text-slate-300">5-Star Resort in Phuket</p>
          </div>
          <div class="text-right">
            <div class="text-xs text-emerald-400 font-semibold mb-1">LIVE RATES</div>
            <div class="w-3 h-3 bg-emerald-400 rounded-full animate-pulse"></div>
          </div>
        </div>
        
        <!-- Rate Comparison Table -->
        <div class="space-y-4">
          <div class="flex items-center justify-between p-4 bg-white/5 rounded-xl border border-white/10">
            <div class="flex items-center space-x-3">
              <div class="w-8 h-8 bg-red-500/20 rounded-lg flex items-center justify-center">
                <span class="text-red-400 font-bold text-sm">B</span>
              </div>
              <span class="text-white font-semibold">Booking.com</span>
            </div>
            <div class="text-right">
              <div class="text-slate-400 line-through text-sm">$450</div>
              <div class="text-white font-bold">$420/night</div>
            </div>
          </div>
          
          <div class="flex items-center justify-between p-4 bg-white/5 rounded-xl border border-white/10">
            <div class="flex items-center space-x-3">
              <div class="w-8 h-8 bg-blue-500/20 rounded-lg flex items-center justify-center">
                <span class="text-blue-400 font-bold text-sm">A</span>
              </div>
              <span class="text-white font-semibold">Agoda</span>
            </div>
            <div class="text-right">
              <div class="text-slate-400 line-through text-sm">$465</div>
              <div class="text-white font-bold">$435/night</div>
            </div>
          </div>
          
          <div class="flex items-center justify-between p-4 bg-gradient-to-r from-emerald-500/20 to-brand-500/20 rounded-xl border border-emerald-400/30">
            <div class="flex items-center space-x-3">
              <div class="w-8 h-8 bg-gradient-to-br from-brand-500 to-emerald-500 rounded-lg flex items-center justify-center">
                <span class="text-white font-bold text-sm">B</span>
              </div>
              <span class="text-white font-bold">BookMyThai</span>
              <span class="bg-emerald-400 text-slate-900 px-2 py-1 rounded-full text-xs font-bold">BEST</span>
            </div>
            <div class="text-right">
              <div class="text-emerald-400 font-bold text-lg">$385/night</div>
              <div class="text-emerald-300 text-sm">Save $35-50</div>
            </div>
          </div>
        </div>
        
        <div class="mt-6 p-4 bg-emerald-500/10 rounded-xl border border-emerald-400/20">
          <div class="flex items-center space-x-2 text-emerald-300">
            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
              <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
            </svg>
            <span class="font-semibold">Best Rate Guarantee: If you find lower, we'll match + 5% off</span>
          </div>
        </div>
      </div>
      
      <!-- Savings Calculator -->
      <div class="bg-white/10 backdrop-blur-xl rounded-2xl p-8 border border-white/20">
        <h4 class="text-xl font-bold text-white mb-6">Monthly Savings Calculator</h4>
        
        <div class="space-y-6">
          <div>
            <label class="block text-sm font-semibold text-slate-300 mb-2">Monthly Bookings</label>
            <input type="range" min="10" max="500" value="100" class="w-full" id="bookingsSlider">
            <div class="text-center text-white font-bold mt-2" id="bookingsValue">100 bookings</div>
          </div>
          
          <div>
            <label class="block text-sm font-semibold text-slate-300 mb-2">Average Booking Value</label>
            <input type="range" min="200" max="2000" value="800" class="w-full" id="valueSlider">
            <div class="text-center text-white font-bold mt-2" id="valueAmount">$800</div>
          </div>
          
          <div class="bg-gradient-to-r from-emerald-500/20 to-brand-500/20 rounded-xl p-6 border border-emerald-400/30">
            <div class="text-center">
              <div class="text-emerald-400 text-sm font-semibold mb-1">Monthly Savings</div>
              <div class="text-3xl font-black text-white" id="savingsAmount">$4,000</div>
              <div class="text-emerald-300 text-sm mt-1">vs. competitors</div>
            </div>
          </div>
          
          <div class="text-center">
            <div class="text-slate-300 text-sm mb-2">Annual Savings Potential</div>
            <div class="text-2xl font-bold text-emerald-400" id="annualSavings">$48,000</div>
          </div>
        </div>
      </div>
    </div>

    <!-- Pricing Features -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
      <div class="text-center p-6 bg-white/5 backdrop-blur-sm rounded-2xl border border-white/10">
        <div class="w-12 h-12 bg-emerald-500/20 rounded-xl flex items-center justify-center mx-auto mb-4">
          <svg class="w-6 h-6 text-emerald-400" fill="currentColor" viewBox="0 0 24 24">
            <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
          </svg>
        </div>
        <h4 class="font-bold text-white mb-2">Wholesale Rates</h4>
        <p class="text-slate-300 text-sm">Direct supplier contracts for best prices</p>
      </div>
      
      <div class="text-center p-6 bg-white/5 backdrop-blur-sm rounded-2xl border border-white/10">
        <div class="w-12 h-12 bg-blue-500/20 rounded-xl flex items-center justify-center mx-auto mb-4">
          <svg class="w-6 h-6 text-blue-400" fill="currentColor" viewBox="0 0 24 24">
            <path d="M13 10V3L4 14h7v7l9-11h-7z"/>
          </svg>
        </div>
        <h4 class="font-bold text-white mb-2">Real-Time Pricing</h4>
        <p class="text-slate-300 text-sm">Live rates updated every 30 seconds</p>
      </div>
      
      <div class="text-center p-6 bg-white/5 backdrop-blur-sm rounded-2xl border border-white/10">
        <div class="w-12 h-12 bg-purple-500/20 rounded-xl flex items-center justify-center mx-auto mb-4">
          <svg class="w-6 h-6 text-purple-400" fill="currentColor" viewBox="0 0 24 24">
            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
          </svg>
        </div>
        <h4 class="font-bold text-white mb-2">Price Match</h4>
        <p class="text-slate-300 text-sm">We'll beat any competitor's price</p>
      </div>
      
      <div class="text-center p-6 bg-white/5 backdrop-blur-sm rounded-2xl border border-white/10">
        <div class="w-12 h-12 bg-orange-500/20 rounded-xl flex items-center justify-center mx-auto mb-4">
          <svg class="w-6 h-6 text-orange-400" fill="currentColor" viewBox="0 0 24 24">
            <path d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
          </svg>
        </div>
        <h4 class="font-bold text-white mb-2">Volume Discounts</h4>
        <p class="text-slate-300 text-sm">Better rates with higher volumes</p>
      </div>
    </div>
  </div>
</section>

<script>
// Interactive Savings Calculator
document.addEventListener('DOMContentLoaded', function() {
  const bookingsSlider = document.getElementById('bookingsSlider');
  const valueSlider = document.getElementById('valueSlider');
  const bookingsValue = document.getElementById('bookingsValue');
  const valueAmount = document.getElementById('valueAmount');
  const savingsAmount = document.getElementById('savingsAmount');
  const annualSavings = document.getElementById('annualSavings');
  
  function updateCalculator() {
    const bookings = parseInt(bookingsSlider?.value || 100);
    const avgValue = parseInt(valueSlider?.value || 800);
    
    // Calculate savings (assuming 5% average savings)
    const monthlySavings = Math.round(bookings * avgValue * 0.05);
    const annualSavingsAmount = monthlySavings * 12;
    
    if (bookingsValue) bookingsValue.textContent = `${bookings} bookings`;
    if (valueAmount) valueAmount.textContent = `$${avgValue}`;
    if (savingsAmount) savingsAmount.textContent = `$${monthlySavings.toLocaleString()}`;
    if (annualSavings) annualSavings.textContent = `$${annualSavingsAmount.toLocaleString()}`;
  }
  
  if (bookingsSlider) bookingsSlider.addEventListener('input', updateCalculator);
  if (valueSlider) valueSlider.addEventListener('input', updateCalculator);
  
  // Initialize
  updateCalculator();
});
</script>
