<?php
// app/Views/agent/partials/header.php
$title = $title ?? 'BookMyThai — Travel Workspace';
$agent = $_SESSION['agent'] ?? null;
// Compute display name: prefer company, then agent name
$companyName = trim((string)($agent['company'] ?? ''));
$displayName = $companyName !== '' ? $companyName : (string)($agent['name'] ?? 'Agent');
// Ensure camera is allowed by Permissions-Policy (if server default denies)
if (!headers_sent()) {
  // Allow camera on same origin (localhost)
  header('Permissions-Policy: camera=(self)');
}
?>
<!DOCTYPE html>
<html lang="en" data-theme="light">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover, user-scalable=no" />
  <meta name="theme-color" content="#4f46e5" />
  <meta name="mobile-web-app-capable" content="yes" />
  <meta name="apple-mobile-web-app-capable" content="yes" />
  <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent" />
  <meta name="apple-mobile-web-app-title" content="BookMyThai" />
  <meta name="format-detection" content="telephone=no, address=no, email=no" />
  <link rel="manifest" href="/manifest.webmanifest" crossorigin="use-credentials" />
  <link rel="apple-touch-icon" href="/assets/agent/design/icons/icon-192.png" />
  <title><?= htmlspecialchars($title) ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daisyui@4.12.10/dist/full.min.css" />
  <script>
    tailwind.config = {
      theme: {
        extend: {
          fontFamily: { sans: ['Inter', 'ui-sans-serif', 'system-ui'] },
          colors: { brand: { 50:'#eef8ff',100:'#d8efff',200:'#b2e0ff',300:'#84ccff',400:'#46b3ff',500:'#1b97f0',600:'#0d79c7',700:'#0c62a1',800:'#0c4f82',900:'#0c426c' } }
        }
      }
    }
  </script>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
  <link rel="preconnect" href="https://fonts.googleapis.com" crossorigin>
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <meta name="description" content="BookMyThai — professional workspace for booking hotels, activities, transfers and yachts with instant confirmations and partner-first margins.">
  <meta property="og:title" content="BookMyThai — Travel Workspace">
  <meta property="og:description" content="Search, sell, and manage Thailand travel products in one professional B2B workspace.">
  <meta property="og:type" content="website">
  <meta name="theme-color" content="#0d79c7">
  <link rel="icon" href="data:image/svg+xml,<svg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 100 100'><rect width='100' height='100' fill='%230d79c7'/><text x='50' y='62' font-size='60' text-anchor='middle' fill='white'>B</text></svg>">
  <script src="/assets/agent/js/page-loading.js" defer></script>
  <style>
    /* Hide elements with x-cloak until Alpine is loaded */
    [x-cloak] { display: none !important; }
    
    /* Page Loading Animation */
    @keyframes spin {
      to { transform: rotate(360deg); }
    }
    .animate-spin {
      animation: spin 1s linear infinite;
    }
    :root { color-scheme: light dark; }
    html, body { height: 100%; }
    body { padding: env(safe-area-inset-top) env(safe-area-inset-right) env(safe-area-inset-bottom) env(safe-area-inset-left); }
    * { -webkit-tap-highlight-color: transparent; }
    input, button { touch-action: manipulation; }
    .platform-ios .navbar { padding-top: max(env(safe-area-inset-top), 0.5rem); }
    
    /* Advanced Visual Effects & Animations */
    @keyframes float {
      0%, 100% { transform: translateY(0px); }
      50% { transform: translateY(-6px); }
    }
    
    @keyframes glow {
      0%, 100% { box-shadow: 0 0 5px rgba(59, 130, 246, 0.5); }
      50% { box-shadow: 0 0 20px rgba(59, 130, 246, 0.8), 0 0 30px rgba(59, 130, 246, 0.6); }
    }
    
    @keyframes shimmer {
      0% { background-position: -200% 0; }
      100% { background-position: 200% 0; }
    }
    
    @keyframes slideInFromTop {
      0% { transform: translateY(-100%); opacity: 0; }
      100% { transform: translateY(0); opacity: 1; }
    }
    
    @keyframes fadeInUp {
      0% { transform: translateY(20px); opacity: 0; }
      100% { transform: translateY(0); opacity: 1; }
    }
    
    .animate-float { animation: float 6s ease-in-out infinite; }
    .animate-glow { animation: glow 2s ease-in-out infinite alternate; }
    .animate-shimmer { 
      background: linear-gradient(90deg, transparent, rgba(255,255,255,0.4), transparent);
      background-size: 200% 100%;
      animation: shimmer 2s infinite;
    }
    .animate-slide-in { animation: slideInFromTop 0.6s ease-out; }
    .animate-fade-in-up { animation: fadeInUp 0.8s ease-out; }
    
    /* Enhanced Hover Effects */
    .hover-lift {
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }
    .hover-lift:hover {
      transform: translateY(-2px);
      box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
    }
    
    .hover-scale {
      transition: transform 0.2s cubic-bezier(0.4, 0, 0.2, 1);
    }
    .hover-scale:hover {
      transform: scale(1.05);
    }
    
    .hover-glow {
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }
    .hover-glow::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
      transition: left 0.5s;
    }
    .hover-glow:hover::before {
      left: 100%;
    }
    
    /* Sophisticated Navigation Effects */
    .nav-item {
      position: relative;
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }
    .nav-item::after {
      content: '';
      position: absolute;
      bottom: -2px;
      left: 50%;
      width: 0;
      height: 2px;
      background: linear-gradient(90deg, #3b82f6, #1d4ed8);
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
      transform: translateX(-50%);
    }
    .nav-item:hover::after {
      width: 100%;
    }
    .nav-item:hover {
      color: #3b82f6;
      transform: translateY(-1px);
    }
    
    /* Glass Morphism Effects */
    .glass-effect {
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(10px);
      -webkit-backdrop-filter: blur(10px);
      border: 1px solid rgba(255, 255, 255, 0.2);
    }
    
    /* Pulse Animation for Status Indicators */
    .pulse-ring {
      animation: pulse-ring 1.25s cubic-bezier(0.215, 0.61, 0.355, 1) infinite;
    }
    @keyframes pulse-ring {
      0% { transform: scale(0.33); }
      80%, 100% { opacity: 0; }
    }
    
    /* Hide scrollbars for tablist overflow */
    .no-scrollbar::-webkit-scrollbar { display: none; }
    .no-scrollbar { -ms-overflow-style: none; scrollbar-width: none; }
    
    /* Sticky mobile CTA + tabbar spacing */
    @media (max-width: 768px) {
      body { padding-bottom: calc(env(safe-area-inset-bottom) + 160px); }
    }
    .mobile-cta {
      position: fixed; left: 0; right: 0; bottom: 0; z-index: 50;
      padding-bottom: calc(env(safe-area-inset-bottom) + 0.5rem);
      background: hsl(var(--b1) / 0.85);
      -webkit-backdrop-filter: saturate(180%) blur(12px);
      backdrop-filter: saturate(180%) blur(12px);
      box-shadow: 0 -6px 20px rgba(0,0,0,0.08);
    }
    .mobile-tabbar {
      position: fixed; left: 0; right: 0; z-index: 50;
      bottom: calc(env(safe-area-inset-bottom) + 88px);
      background: hsl(var(--b1) / 0.9);
      -webkit-backdrop-filter: saturate(180%) blur(12px);
      backdrop-filter: saturate(180%) blur(12px);
      border-top: 1px solid hsl(var(--b3));
    }
    .mobile-tabbar .tab-btn { position: relative; color: hsl(var(--nc)); }
    .mobile-tabbar .tab-btn.active { color: hsl(var(--p)); }
    .mobile-tabbar .tab-btn.active::before {
      content: ""; position: absolute; top: 0; left: 22%; right: 22%; height: 2px; background: hsl(var(--p)); border-radius: 2px;
    }
  </style>
</head>
<body class="font-sans bg-gradient-to-b from-brand-50 to-white min-h-screen">
  <!-- Page Loading Overlay -->
  <div id="pageLoading" class="fixed inset-0 bg-white/90 backdrop-blur-sm z-[100] flex flex-col items-center justify-center transition-opacity duration-300 opacity-0 pointer-events-none">
    <div class="relative w-40 h-40 flex items-center justify-center">
      <!-- Outer circle -->
      <div class="absolute inset-0 border-4 border-brand-100 rounded-full"></div>
      <!-- Spinning border -->
      <div class="absolute inset-0 border-4 border-t-brand-600 border-r-brand-600 border-transparent rounded-full animate-spin"></div>
      <!-- Text in the center -->
      <div class="absolute inset-0 flex flex-col items-center justify-center">
        <div class="text-center">
          <div class="text-sm font-bold text-slate-700">bookmythai.com</div>
          <div class="text-xs text-slate-500 mt-1">Loading...</div>
        </div>
      </div>
    </div>
    <!-- KYC Gate Banner (shown when KYC not approved) -->
    <div id="kycGateBanner" class="hidden bg-yellow-50 border-b border-yellow-200">
      <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-2 flex items-center justify-between">
        <div class="text-sm text-yellow-800 font-medium">
          Your KYC is pending. Please complete KYC to continue using the portal.
        </div>
        <div class="flex items-center gap-2">
          <a href="/b2b/agent/kyc" class="px-3 py-1.5 text-sm font-semibold text-white rounded-lg bg-yellow-600 hover:bg-yellow-700">Complete KYC</a>
          <a href="/b2b/agent/kyc/status" class="px-3 py-1.5 text-sm font-semibold text-yellow-900 rounded-lg bg-yellow-100 hover:bg-yellow-200">View Status</a>
        </div>
      </div>
    </div>

  </div>
  

  <!-- Main Navigation -->
  <?php if (!($hide_nav ?? false)): ?>
  <header class="bg-white/95 backdrop-blur-xl shadow-lg border-b border-slate-200/60 sticky top-0 z-50">
    <!-- Premium Status Bar -->
    <div class="bg-gradient-to-r from-brand-600 via-blue-600 to-indigo-600 text-white text-xs">
      <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-1.5 flex items-center justify-between">
        <div class="flex items-center space-x-4">
          <div class="flex items-center space-x-2">
            <div class="w-1.5 h-1.5 rounded-full bg-emerald-400 animate-pulse"></div>
            <span class="font-medium">Live System</span>
          </div>
          <div class="hidden sm:flex items-center space-x-2">
            <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            <span class="text-white/90">Premium Partner Portal</span>
          </div>
        </div>
        <div class="flex items-center space-x-3 text-white/90">
          <span class="hidden md:inline text-xs">Welcome, <?= htmlspecialchars($agent['name'] ?? 'Agent') ?></span>
          <div class="flex items-center space-x-1">
            <div class="w-1 h-1 rounded-full bg-green-400"></div>
            <span class="text-xs">99.9% Uptime</span>
          </div>
        </div>
      </div>
    </div>
    
    <!-- Main Header -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
      <div class="flex justify-between h-20">
        <!-- Enhanced Logo -->
        <div class="flex-shrink-0 flex items-center">
          <a href="/b2b/agent" class="group flex items-center space-x-3 hover-lift">
            <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-brand-500 to-brand-600 flex items-center justify-center shadow-lg group-hover:shadow-xl transition-all duration-300">
              <span class="text-white font-bold text-lg">B</span>
            </div>
            <div class="flex flex-col">
              <span class="text-2xl font-bold bg-gradient-to-r from-slate-800 to-slate-600 bg-clip-text text-transparent">BOOKMYTHAI</span>
              <span class="text-xs text-brand-600 font-semibold tracking-wide">AGENT PORTAL</span>
            </div>
          </a>
        </div>
        
        <!-- Enhanced Desktop Navigation -->
        <nav class="hidden md:ml-8 md:flex md:items-center md:space-x-2">
          <a href="/b2b/agent/home" class="group relative px-4 py-3 text-sm font-semibold <?= ($active ?? '') === 'home' || ($active ?? '') === 'dashboard' ? 'text-brand-600' : 'text-slate-700 hover:text-brand-600' ?> transition-all duration-300 rounded-lg hover:bg-brand-50/50 flex items-center">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
            </svg>
            <span class="relative z-10">Dashboard</span>
            <?php if (($active ?? '') === 'home' || ($active ?? '') === 'dashboard'): ?>
            <div class="absolute inset-x-0 bottom-0 h-0.5 bg-gradient-to-r from-brand-500 to-blue-500 rounded-full"></div>
            <div class="absolute inset-0 bg-brand-50/30 rounded-lg"></div>
            <?php endif; ?>
          </a>
          <a href="/b2b/agent/activities" class="group relative px-4 py-3 text-sm font-semibold <?= ($active ?? '') === 'activities' ? 'text-brand-600' : 'text-slate-700 hover:text-brand-600' ?> transition-all duration-300 rounded-lg hover:bg-brand-50/50 flex items-center">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8" d="M13 10V3L4 14h7v7l9-11h-7z" />
            </svg>
            <span class="relative z-10">Activities</span>
            <?php if (($active ?? '') === 'activities'): ?>
            <div class="absolute inset-x-0 bottom-0 h-0.5 bg-gradient-to-r from-brand-500 to-blue-500 rounded-full"></div>
            <div class="absolute inset-0 bg-brand-50/30 rounded-lg"></div>
            <?php endif; ?>
          </a>
          <a href="/b2b/agent/hotels" class="group relative px-4 py-3 text-sm font-semibold <?= ($active ?? '') === 'hotels' ? 'text-brand-600' : 'text-slate-700 hover:text-brand-600' ?> transition-all duration-300 rounded-lg hover:bg-brand-50/50 flex items-center">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1" />
            </svg>
            <span class="relative z-10">Hotels</span>
            <?php if (($active ?? '') === 'hotels'): ?>
            <div class="absolute inset-x-0 bottom-0 h-0.5 bg-gradient-to-r from-brand-500 to-blue-500 rounded-full"></div>
            <div class="absolute inset-0 bg-brand-50/30 rounded-lg"></div>
            <?php endif; ?>
          </a>
          <a href="/b2b/agent/taxi" class="group relative px-4 py-3 text-sm font-semibold <?= ($active ?? '') === 'taxi' ? 'text-brand-600' : 'text-slate-700 hover:text-brand-600' ?> transition-all duration-300 rounded-lg hover:bg-brand-50/50 flex items-center">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8" d="M8 7h8m-8 0v8m0 0H5m3 0h8m0 0v8m0 0h3m-3 0h-8m8 0v-8m0 0h3" />
            </svg>
            <span class="relative z-10">Taxi</span>
            <?php if (($active ?? '') === 'taxi'): ?>
            <div class="absolute inset-x-0 bottom-0 h-0.5 bg-gradient-to-r from-brand-500 to-blue-500 rounded-full"></div>
            <div class="absolute inset-0 bg-brand-50/30 rounded-lg"></div>
            <?php endif; ?>
          </a>
          <a href="/b2b/agent/yachts" class="group relative px-4 py-3 text-sm font-semibold <?= ($active ?? '') === 'yachts' ? 'text-brand-600' : 'text-slate-700 hover:text-brand-600' ?> transition-all duration-300 rounded-lg hover:bg-brand-50/50 flex items-center">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8" d="M4 21h16a1 1 0 00.8-1.6L18 15h-1.5a.5.5 0 01-.5-.5v-2a.5.5 0 01.5-.5h3a.5.5 0 01.5.5v3.5l2.2-2.8a1 1 0 00.8-1.6L18 5H6L2 12.4a1 1 0 00.8 1.6H4v4a1 1 0 01-2 0v-1.5a.5.5 0 00-1 0V18a1 1 0 102 0v-4h1.5a.5.5 0 010 1H4v1.5a.5.5 0 01-1 0V15h-.5a1 1 0 01-.8-1.6L4 5h16l-2.2 8.4a1 1 0 00.8 1.6H20v4a1 1 0 11-2 0v-1.5a.5.5 0 00-1 0V18a1 1 0 102 0v-4h1.5a.5.5 0 000-1H18v-1.5a.5.5 0 01.5-.5h3a.5.5 0 01.5.5v2a.5.5 0 01-.5.5H18l2.8 4.4a1 1 0 01-.8 1.6z" />
            </svg>
            <span class="relative z-10">Yacht</span>
            <?php if (($active ?? '') === 'yachts'): ?>
            <div class="absolute inset-x-0 bottom-0 h-0.5 bg-gradient-to-r from-brand-500 to-blue-500 rounded-full"></div>
            <div class="absolute inset-0 bg-brand-50/30 rounded-lg"></div>
            <?php endif; ?>
          </a>
          <a href="/b2b/agent/packages" class="group relative px-4 py-3 text-sm font-semibold <?= ($active ?? '') === 'packages' ? 'text-brand-600' : 'text-slate-700 hover:text-brand-600' ?> transition-all duration-300 rounded-lg hover:bg-brand-50/50 flex items-center">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.8" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
            </svg>
            <span class="relative z-10">Holiday Package</span>
            <?php if (($active ?? '') === 'packages'): ?>
            <div class="absolute inset-x-0 bottom-0 h-0.5 bg-gradient-to-r from-brand-500 to-blue-500 rounded-full"></div>
            <div class="absolute inset-0 bg-brand-50/30 rounded-lg"></div>
            <?php endif; ?>
          </a>
        </nav>
        
        <!-- Right side items moved below to keep single implementation -->
        
        <!-- Enhanced Mobile Menu Button -->
        <div class="flex items-center md:hidden">
          <button type="button" id="mobile-menu-button" class="inline-flex items-center justify-center p-2.5 rounded-xl text-slate-600 hover:text-brand-600 hover:bg-brand-50 focus:outline-none focus:ring-2 focus:ring-brand-500 transition-all duration-300 group" aria-expanded="false">
            <span class="sr-only">Open main menu</span>
            <svg class="block h-5 w-5 group-hover:scale-110 transition-transform" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M4 6h16M4 12h16M4 18h16" />
            </svg>
          </button>
        </div>
        
        <!-- Enhanced Right Side -->
        <div class="flex items-center space-x-4">
          <?php if (!$agent): ?>
            <a href="/b2b/agent/register" class="hidden lg:inline-flex px-4 py-2 text-sm font-semibold text-brand-600 hover:text-brand-700 transition-colors">
              Become Partner
            </a>
            <a href="/b2b/agent/login" class="inline-flex px-6 py-2.5 bg-gradient-to-r from-brand-600 to-blue-600 hover:from-brand-700 hover:to-blue-700 text-white font-semibold rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 hover-lift">
              Sign In
            </a>
          <?php else: ?>
            <!-- Premium Notification Center -->
            <div class="relative">
              <button class="relative p-2 text-slate-600 hover:text-brand-600 hover:bg-brand-50 rounded-xl transition-all duration-300 group">
                <svg class="w-5 h-5 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0 3 3 0 016 0z"/>
                </svg>
                <div class="absolute -top-1 -right-1 w-3 h-3 bg-gradient-to-r from-red-500 to-pink-500 rounded-full animate-pulse shadow-lg"></div>
              </button>
            </div>
            
            <!-- Premium User Menu -->
            <div class="dropdown dropdown-end">
              <div tabindex="0" role="button" class="flex items-center space-x-3 px-3 py-2 hover:bg-slate-50 rounded-xl transition-all duration-300 group cursor-pointer">
                <div class="w-9 h-9 rounded-xl bg-gradient-to-br from-brand-500 via-blue-500 to-indigo-500 flex items-center justify-center text-white font-bold shadow-lg group-hover:shadow-xl transition-all duration-300">
                  <?= strtoupper(substr($agent['name'] ?? 'A', 0, 1)) ?>
                </div>
                <div class="hidden lg:block text-left">
                  <div class="text-sm font-semibold text-slate-800"><?= htmlspecialchars($displayName) ?></div>
                </div>
                <svg class="w-4 h-4 text-slate-400 group-hover:text-slate-600 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                </svg>
              </div>
              <ul tabindex="0" class="dropdown-content menu bg-white rounded-2xl z-[1] w-64 p-3 shadow-2xl border border-slate-200/60 mt-2">
                <li class="mb-2">
                  <div class="flex items-center space-x-3 p-3 bg-gradient-to-r from-brand-50 to-blue-50 rounded-xl">
                    <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-brand-500 to-blue-500 flex items-center justify-center text-white font-bold">
                      <?= strtoupper(substr($agent['name'] ?? 'A', 0, 1)) ?>
                    </div>
                    <div>
                      <div class="font-semibold text-slate-800"><?= htmlspecialchars($displayName) ?></div>
                    </div>
                  </div>
                </li>
                <li><a href="/b2b/agent/profile" class="flex items-center space-x-3 p-3 hover:bg-slate-50 rounded-xl transition-all duration-200">
                  <svg class="w-5 h-5 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                  </svg>
                  <span class="font-medium">My Profile</span>
                </a></li>
                <li><a href="/b2b/agent/settings" class="flex items-center space-x-3 p-3 hover:bg-slate-50 rounded-xl transition-all duration-200">
                  <svg class="w-5 h-5 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                  </svg>
                  <span class="font-medium">Settings</span>
                </a></li>
                <li><a href="/b2b/agent/wallet/deposit" class="flex items-center space-x-3 p-3 hover:bg-slate-50 rounded-xl transition-all duration-200">
                  <svg class="w-5 h-5 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                  </svg>
                  <span class="font-medium">Wallet Deposit</span>
                </a></li>
                <li><a href="/b2b/agent/wallet/deposit/history" class="flex items-center space-x-3 p-3 hover:bg-slate-50 rounded-xl transition-all duration-200">
                  <svg class="w-5 h-5 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                  </svg>
                  <span class="font-medium">Deposit History</span>
                </a></li>
                <li><a href="/b2b/agent/support" class="flex items-center space-x-3 p-3 hover:bg-slate-50 rounded-xl transition-all duration-200">
                  <svg class="w-5 h-5 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                  </svg>
                  <span class="font-medium">Support</span>
                </a></li>
                <div class="divider my-2"></div>
                <li><a href="/b2b/agent/logout" class="flex items-center space-x-3 p-3 hover:bg-red-50 text-red-600 rounded-xl transition-all duration-200">
                  <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
                  </svg>
                  <span class="font-medium">Sign Out</span>
                </a></li>
              </ul>
            </div>
          <?php endif; ?>
        </div>
      </div>
    
    <!-- Enhanced Mobile Menu -->
    <div class="md:hidden hidden bg-white/95 backdrop-blur-xl border-t border-slate-200/60 shadow-xl" id="mobile-menu">
      <div class="px-4 py-4 space-y-2">
        <a href="/b2b/agent/home" class="flex items-center space-x-3 px-4 py-3 rounded-xl text-base font-semibold <?= ($active ?? '') === 'home' || ($active ?? '') === 'dashboard' ? 'bg-gradient-to-r from-brand-50 to-blue-50 text-brand-700 border border-brand-200' : 'text-slate-700 hover:bg-slate-50' ?> transition-all duration-200">
          <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
          </svg>
          Dashboard
        </a>
        <a href="/b2b/agent/hotels" class="flex items-center space-x-3 px-4 py-3 rounded-xl text-base font-semibold <?= ($active ?? '') === 'hotels' ? 'bg-gradient-to-r from-brand-50 to-blue-50 text-brand-700 border border-brand-200' : 'text-slate-700 hover:bg-slate-50' ?> transition-all duration-200">
          <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1"/>
          </svg>
          Hotels
        </a>
        <a href="/b2b/agent/activities" class="flex items-center space-x-3 px-4 py-3 rounded-xl text-base font-semibold <?= ($active ?? '') === 'activities' ? 'bg-gradient-to-r from-brand-50 to-blue-50 text-brand-700 border border-brand-200' : 'text-slate-700 hover:bg-slate-50' ?> transition-all duration-200">
          <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
          </svg>
          Activities
        </a>
        <a href="/b2b/agent/transfers" class="flex items-center space-x-3 px-4 py-3 rounded-xl text-base font-semibold <?= ($active ?? '') === 'transfers' ? 'bg-gradient-to-r from-brand-50 to-blue-50 text-brand-700 border border-brand-200' : 'text-slate-700 hover:bg-slate-50' ?> transition-all duration-200">
          <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h8m-8 0v8m0 0H5m3 0h8m0 0v8m0 0h3m-3 0h-8m8 0v-8m0 0h3"/>
          </svg>
          Transfers
        </a>
        <a href="/b2b/agent/packages" class="flex items-center space-x-3 px-4 py-3 rounded-xl text-base font-semibold <?= ($active ?? '') === 'packages' ? 'bg-gradient-to-r from-brand-50 to-blue-50 text-brand-700 border border-brand-200' : 'text-slate-700 hover:bg-slate-50' ?> transition-all duration-200">
          <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
          </svg>
          Holiday Package
        </a>
        <a href="/b2b/agent/wallet" class="flex items-center space-x-3 px-4 py-3 rounded-xl text-base font-semibold <?= ($active ?? '') === 'wallet' ? 'bg-gradient-to-r from-brand-50 to-blue-50 text-brand-700 border border-brand-200' : 'text-slate-700 hover:bg-slate-50' ?> transition-all duration-200">
          <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
          </svg>
          Wallet
        </a>
        <a href="/b2b/agent/support" class="flex items-center space-x-3 px-4 py-3 rounded-xl text-base font-semibold <?= ($active ?? '') === 'support' ? 'bg-gradient-to-r from-brand-50 to-blue-50 text-brand-700 border border-brand-200' : 'text-slate-700 hover:bg-slate-50' ?> transition-all duration-200">
          <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 13a3 3 0 11-6 0 3 3 0 016 0zm0 0v7m0-7h-7a3 3 0 110-6h7a3 3 0 010 6z" />
          </svg>
          Support
        </a>
        <?php if ($agent): ?>
          <div class="border-t border-slate-200/60 mt-4 pt-4 space-y-2">
            <a href="/b2b/agent/profile" class="flex items-center space-x-3 px-4 py-3 rounded-xl text-base font-medium text-slate-700 hover:bg-slate-50 transition-all duration-200">
              <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
              </svg>
              Your Profile
            </a>
            <a href="/b2b/agent/settings" class="flex items-center space-x-3 px-4 py-3 rounded-xl text-base font-medium text-slate-700 hover:bg-slate-50 transition-all duration-200">
              <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
              </svg>
              Settings
            </a>
            <a href="/b2b/agent/logout" class="flex items-center space-x-3 px-4 py-3 rounded-xl text-base font-medium text-red-600 hover:bg-red-50 transition-all duration-200">
              <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
              </svg>
              Sign out
            </a>
          </div>
        <?php else: ?>
          <div class="border-t border-slate-200/60 mt-4 pt-4">
            <a href="/b2b/agent/login" class="w-full flex items-center justify-center space-x-2 px-6 py-3 bg-gradient-to-r from-brand-600 to-blue-600 hover:from-brand-700 hover:to-blue-700 text-white font-semibold rounded-xl shadow-lg transition-all duration-300">
              <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 16l-4-4m0 0l4-4m-4 4h14m-5 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"/>
              </svg>
              Sign in
            </a>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </header>
  <?php endif; ?>
  
  <script>
    // Mobile menu toggle
    document.addEventListener('DOMContentLoaded', function() {
      const mobileMenuButton = document.getElementById('mobile-menu-button');
      const mobileMenu = document.getElementById('mobile-menu');
      
      if (mobileMenuButton && mobileMenu) {
        // Add X icon for mobile menu
        const xIcon = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
        xIcon.setAttribute('class', 'hidden h-6 w-6');
        xIcon.setAttribute('xmlns', 'http://www.w3.org/2000/svg');
        xIcon.setAttribute('fill', 'none');
        xIcon.setAttribute('viewBox', '0 0 24 24');
        xIcon.setAttribute('stroke', 'currentColor');
        xIcon.innerHTML = '<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />';
        mobileMenuButton.appendChild(xIcon);
        
        mobileMenuButton.addEventListener('click', function() {
          const isExpanded = mobileMenuButton.getAttribute('aria-expanded') === 'true';
          mobileMenuButton.setAttribute('aria-expanded', !isExpanded);
          mobileMenu.classList.toggle('hidden');
          
          // Toggle icon between menu and X
          const menuIcon = mobileMenuButton.querySelector('svg:first-child');
          const xIcon = mobileMenuButton.querySelector('svg:last-child');
          
          if (isExpanded) {
            menuIcon?.classList.remove('hidden');
            xIcon?.classList.add('hidden');
          } else {
            menuIcon?.classList.add('hidden');
            xIcon?.classList.remove('hidden');
          }
        });
      }
      // KYC gate: if KYC not approved, force all clicks to KYC pages
      (function(){
        fetch('/b2b/agent/kyc/check', { credentials: 'same-origin' })
          .then(r => r.ok ? r.json() : Promise.reject())
          .then(data => {
            if (!data || data.ok !== true) return;
            const status = data.status || '';
            if (status === 'approved') return;
            const banner = document.getElementById('kycGateBanner');
            if (banner) banner.classList.remove('hidden');
            const targetPath = (status && status !== 'none') ? '/b2b/agent/kyc/status' : '/b2b/agent/kyc';
            const allowList = [
              '/b2b/agent/kyc', '/agent/kyc',
              '/b2b/agent/kyc/status', '/agent/kyc/status',
              '/b2b/agent/logout', '/agent/logout'
            ];
            document.addEventListener('click', function(ev){
              const a = ev.target.closest('a');
              if (!a) return;
              const href = a.getAttribute('href') || '';
              if (href.startsWith('mailto:') || href.startsWith('tel:') || href.startsWith('#')) return;
              // Allow navigating to logout and KYC pages
              if (allowList.some(p => href.startsWith(p))) return;
              ev.preventDefault();
              window.location.href = targetPath;
            }, true); // capture to intercept early
          })
          .catch(() => {});
      })();
    });
  </script>

