<?php
// app/Views/agent/partials/footer_design.php
?>
<!-- Premium Enterprise Footer -->
<footer class="bg-gradient-to-br from-slate-900 via-slate-800 to-slate-900 text-white mt-auto relative overflow-hidden">
  <!-- Background Pattern -->
  <div class="absolute inset-0 bg-[url('data:image/svg+xml,%3Csvg width="60" height="60" viewBox="0 0 60 60" xmlns="http://www.w3.org/2000/svg"%3E%3Cg fill="none" fill-rule="evenodd"%3E%3Cg fill="%23334155" fill-opacity="0.1"%3E%3Ccircle cx="30" cy="30" r="1"/%3E%3C/g%3E%3C/g%3E%3C/svg%3E')] opacity-50"></div>
  
  <!-- Premium Status Strip -->
  <div class="relative bg-gradient-to-r from-brand-600 via-blue-600 to-indigo-600 py-2">
    <div class="max-w-7xl mx-auto px-6 flex items-center justify-between">
      <div class="flex items-center space-x-6">
        <div class="flex items-center space-x-2">
          <div class="w-2 h-2 bg-emerald-400 rounded-full animate-pulse shadow-lg shadow-emerald-400/50"></div>
          <span class="text-sm font-semibold text-white">System Operational</span>
        </div>
        <div class="hidden md:flex items-center space-x-2 text-white/90">
          <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 24 24">
            <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
          </svg>
          <span class="text-sm">Premium B2B Platform</span>
        </div>
      </div>
      <div class="flex items-center space-x-4 text-white/90">
        <div class="hidden lg:flex items-center space-x-1 text-sm">
          <div class="w-1.5 h-1.5 bg-green-400 rounded-full"></div>
          <span>99.9% Uptime</span>
        </div>
        <div class="flex items-center space-x-1 text-sm">
          <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 24 24">
            <path d="M13 10V3L4 14h7v7l9-11h-7z"/>
          </svg>
          <span>Real-time API</span>
        </div>
      </div>
    </div>
  </div>

  <!-- Main Footer Content -->
  <div class="relative max-w-7xl mx-auto px-6 py-3">
    <div class="hidden">
      <!-- Enhanced Company Info -->
      <div class="lg:col-span-2">
        <div class="flex items-center space-x-4 mb-8">
          <div class="w-14 h-14 bg-gradient-to-br from-brand-500 via-blue-500 to-indigo-500 rounded-2xl flex items-center justify-center shadow-2xl">
            <span class="text-white font-bold text-2xl">B</span>
          </div>
          <div>
            <h3 class="text-3xl font-bold bg-gradient-to-r from-white to-slate-300 bg-clip-text text-transparent">BOOKMYTHAI</h3>
            <p class="text-brand-400 font-semibold tracking-wide text-sm">PREMIUM AGENT PORTAL</p>
          </div>
        </div>
        <p class="text-slate-300 text-base leading-relaxed mb-8 max-w-lg">
          Thailand's leading B2B travel platform. Access premium inventory, competitive rates, and instant confirmations for hotels, activities, transfers, and luxury yacht charters.
        </p>
        
        <!-- Premium Features -->
        <div class="grid grid-cols-2 gap-4 mb-8">
          <div class="flex items-center space-x-3 p-3 bg-slate-800/50 rounded-xl border border-slate-700/50">
            <div class="w-8 h-8 bg-emerald-500/20 rounded-lg flex items-center justify-center">
              <svg class="w-4 h-4 text-emerald-400" fill="currentColor" viewBox="0 0 24 24">
                <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
              </svg>
            </div>
            <div>
              <div class="text-sm font-semibold text-white">Instant Booking</div>
              <div class="text-xs text-slate-400">Real-time confirmation</div>
            </div>
          </div>
          <div class="flex items-center space-x-3 p-3 bg-slate-800/50 rounded-xl border border-slate-700/50">
            <div class="w-8 h-8 bg-blue-500/20 rounded-lg flex items-center justify-center">
              <svg class="w-4 h-4 text-blue-400" fill="currentColor" viewBox="0 0 24 24">
                <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
              </svg>
            </div>
            <div>
              <div class="text-sm font-semibold text-white">Best Rates</div>
              <div class="text-xs text-slate-400">Guaranteed pricing</div>
            </div>
          </div>
        </div>
        
        <!-- Social Proof -->
        <div class="flex items-center space-x-6">
          <div class="text-center">
            <div class="text-2xl font-bold text-white">10K+</div>
            <div class="text-xs text-slate-400">Active Agents</div>
          </div>
          <div class="text-center">
            <div class="text-2xl font-bold text-white">50K+</div>
            <div class="text-xs text-slate-400">Monthly Bookings</div>
          </div>
          <div class="text-center">
            <div class="text-2xl font-bold text-white">99.9%</div>
            <div class="text-xs text-slate-400">Uptime SLA</div>
          </div>
        </div>
      </div>
      
      <!-- Premium Services -->
      <div>
        <h4 class="text-xl font-bold text-white mb-6 flex items-center">
          <div class="w-1 h-6 bg-gradient-to-b from-brand-500 to-blue-500 rounded-full mr-3"></div>
          Services
        </h4>
        <ul class="space-y-4">
          <li><a href="/b2b/agent/hotels" class="group flex items-center space-x-3 p-3 rounded-xl hover:bg-slate-800/50 transition-all duration-300 border border-transparent hover:border-slate-700/50">
            <div class="w-10 h-10 bg-gradient-to-br from-purple-500/20 to-pink-500/20 rounded-lg flex items-center justify-center group-hover:scale-110 transition-transform">
              <svg class="w-5 h-5 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1"/>
              </svg>
            </div>
            <div>
              <div class="text-white font-semibold group-hover:text-purple-300 transition-colors">Hotels & Resorts</div>
              <div class="text-xs text-slate-400">Premium accommodations</div>
            </div>
          </a></li>
          <li><a href="/b2b/agent/activities" class="group flex items-center space-x-3 p-3 rounded-xl hover:bg-slate-800/50 transition-all duration-300 border border-transparent hover:border-slate-700/50">
            <div class="w-10 h-10 bg-gradient-to-br from-emerald-500/20 to-teal-500/20 rounded-lg flex items-center justify-center group-hover:scale-110 transition-transform">
              <svg class="w-5 h-5 text-emerald-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
              </svg>
            </div>
            <div>
              <div class="text-white font-semibold group-hover:text-emerald-300 transition-colors">Tours & Activities</div>
              <div class="text-xs text-slate-400">Curated experiences</div>
            </div>
          </a></li>
          <li><a href="/b2b/agent/transfers" class="group flex items-center space-x-3 p-3 rounded-xl hover:bg-slate-800/50 transition-all duration-300 border border-transparent hover:border-slate-700/50">
            <div class="w-10 h-10 bg-gradient-to-br from-blue-500/20 to-indigo-500/20 rounded-lg flex items-center justify-center group-hover:scale-110 transition-transform">
              <svg class="w-5 h-5 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"/>
              </svg>
            </div>
            <div>
              <div class="text-white font-semibold group-hover:text-blue-300 transition-colors">Premium Transfers</div>
              <div class="text-xs text-slate-400">Professional drivers</div>
            </div>
          </a></li>
          <li><a href="/b2b/agent/yachts" class="group flex items-center space-x-3 p-3 rounded-xl hover:bg-slate-800/50 transition-all duration-300 border border-transparent hover:border-slate-700/50">
            <div class="w-10 h-10 bg-gradient-to-br from-cyan-500/20 to-blue-500/20 rounded-lg flex items-center justify-center group-hover:scale-110 transition-transform">
              <svg class="w-5 h-5 text-cyan-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 18s2 3 9 3 9-3 9-3l-3-6h-6l-3 6Zm9-15l5 9h-5V3Z"/>
              </svg>
            </div>
            <div>
              <div class="text-white font-semibold group-hover:text-cyan-300 transition-colors">Luxury Yachts</div>
              <div class="text-xs text-slate-400">Exclusive charters</div>
            </div>
          </a></li>
        </ul>
      </div>
      
      <!-- Premium Support -->
      <div>
        <h4 class="text-xl font-bold text-white mb-6 flex items-center">
          <div class="w-1 h-6 bg-gradient-to-b from-brand-500 to-blue-500 rounded-full mr-3"></div>
          Support
        </h4>
        <ul class="space-y-4">
          <li><a href="/b2b/agent/support" class="group flex items-center space-x-3 p-3 rounded-xl hover:bg-slate-800/50 transition-all duration-300 border border-transparent hover:border-slate-700/50">
            <div class="w-10 h-10 bg-gradient-to-br from-orange-500/20 to-red-500/20 rounded-lg flex items-center justify-center group-hover:scale-110 transition-transform">
              <svg class="w-5 h-5 text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
              </svg>
            </div>
            <div>
              <div class="text-white font-semibold group-hover:text-orange-300 transition-colors">24/7 Support</div>
              <div class="text-xs text-slate-400">Always available</div>
            </div>
          </a></li>
          <li><a href="/b2b/agent/documentation" class="group flex items-center space-x-3 p-3 rounded-xl hover:bg-slate-800/50 transition-all duration-300 border border-transparent hover:border-slate-700/50">
            <div class="w-10 h-10 bg-gradient-to-br from-violet-500/20 to-purple-500/20 rounded-lg flex items-center justify-center group-hover:scale-110 transition-transform">
              <svg class="w-5 h-5 text-violet-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
              </svg>
            </div>
            <div>
              <div class="text-white font-semibold group-hover:text-violet-300 transition-colors">API Docs</div>
              <div class="text-xs text-slate-400">Developer resources</div>
            </div>
          </a></li>
          <li><a href="/b2b/agent/training" class="group flex items-center space-x-3 p-3 rounded-xl hover:bg-slate-800/50 transition-all duration-300 border border-transparent hover:border-slate-700/50">
            <div class="w-10 h-10 bg-gradient-to-br from-green-500/20 to-emerald-500/20 rounded-lg flex items-center justify-center group-hover:scale-110 transition-transform">
              <svg class="w-5 h-5 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"/>
              </svg>
            </div>
            <div>
              <div class="text-white font-semibold group-hover:text-green-300 transition-colors">Training Center</div>
              <div class="text-xs text-slate-400">Learn & grow</div>
            </div>
          </a></li>
        </ul>
        
        <!-- Premium Contact -->
        <div class="mt-8 p-4 bg-gradient-to-r from-slate-800/50 to-slate-700/50 rounded-2xl border border-slate-600/30">
          <h5 class="text-white font-semibold mb-3 flex items-center">
            <svg class="w-4 h-4 mr-2 text-brand-400" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
            </svg>
            Premium Support
          </h5>
          <div class="space-y-3">
            <div class="flex items-center text-sm text-slate-300">
              <svg class="w-4 h-4 mr-3 text-brand-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
              </svg>
              partners@bookmythai.com
            </div>
            <div class="flex items-center text-sm text-slate-300">
              <svg class="w-4 h-4 mr-3 text-brand-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
              </svg>
              +66 (0) 2-123-4567
            </div>
            <div class="flex items-center text-sm text-slate-300">
              <svg class="w-4 h-4 mr-3 text-emerald-400" fill="currentColor" viewBox="0 0 24 24">
                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
              </svg>
              24/7 Live Chat
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  
  <!-- Premium Footer Bottom -->
  <div class="relative border-t border-slate-700/50 bg-gradient-to-r from-slate-900/50 to-slate-800/50">
    <div class="max-w-7xl mx-auto px-6 py-4">
      <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between space-y-6 lg:space-y-0">
        <!-- Left Side - Legal & Brand -->
        <div class="flex flex-col md:flex-row md:items-center space-y-4 md:space-y-0 md:space-x-8">
          <div class="flex items-center space-x-3">
            <div class="w-8 h-8 bg-gradient-to-br from-brand-500 to-blue-500 rounded-lg flex items-center justify-center shadow-lg">
              <span class="text-white font-bold text-sm">B</span>
            </div>
            <div>
              <div class="text-white font-bold text-lg">BookMyThai</div>
              <div class="text-xs text-slate-400">&copy; <?= date('Y') ?> All rights reserved</div>
            </div>
          </div>
          
          <div class="flex flex-wrap items-center gap-6 text-sm text-slate-400">
            <a href="/privacy" class="hover:text-brand-400 transition-colors duration-200 flex items-center space-x-1">
              <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 24 24">
                <path d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4z"/>
              </svg>
              <span>Privacy Policy</span>
            </a>
            <a href="/terms" class="hover:text-brand-400 transition-colors duration-200 flex items-center space-x-1">
              <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 24 24">
                <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8l-6-6z"/>
              </svg>
              <span>Terms of Service</span>
            </a>
            <a href="/compliance" class="hover:text-brand-400 transition-colors duration-200 flex items-center space-x-1">
              <svg class="w-3 h-3" fill="currentColor" viewBox="0 0 24 24">
                <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
              </svg>
              <span>Compliance</span>
            </a>
          </div>
        </div>
        
        <!-- Right Side - Tech & Status -->
        <div class="flex flex-col md:flex-row md:items-center space-y-4 md:space-y-0 md:space-x-6">
          <!-- API Status -->
          <div class="flex items-center space-x-3 p-3 bg-slate-800/50 rounded-xl border border-slate-700/30">
            <div class="flex items-center space-x-2">
              <div class="w-2 h-2 bg-emerald-400 rounded-full animate-pulse"></div>
              <span class="text-sm text-slate-300 font-medium">API Status</span>
            </div>
            <div class="text-xs text-emerald-400 font-semibold bg-emerald-400/10 px-2 py-1 rounded-full">
              Operational
            </div>
          </div>
          
          <!-- Technology Stack -->
          <div class="flex items-center space-x-4">
            <div class="flex items-center space-x-2 text-sm text-slate-400">
              <span>Powered by</span>
              <div class="flex items-center space-x-2 p-2 bg-slate-800/50 rounded-lg border border-slate-700/30">
                <div class="w-5 h-5 bg-gradient-to-br from-brand-500 to-blue-500 rounded flex items-center justify-center">
                  <span class="text-white font-bold text-xs">B</span>
                </div>
                <span class="font-semibold text-slate-300">BookMyThai API</span>
              </div>
            </div>
            
            <!-- Version Badge -->
            <div class="flex items-center space-x-2">
              <div class="text-xs text-slate-400 bg-slate-800/70 border border-slate-700/50 px-3 py-1.5 rounded-full flex items-center space-x-1">
                <svg class="w-3 h-3 text-brand-400" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                </svg>
                <span class="font-mono">v2.1.0</span>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      <!-- Bottom Credits -->
      <div class="mt-6 pt-6 border-t border-slate-700/30 flex flex-col md:flex-row md:items-center md:justify-between text-xs text-slate-500">
        <div class="flex items-center space-x-4">
          <span>Built with enterprise-grade security and reliability</span>
          <div class="hidden md:flex items-center space-x-1">
            <div class="w-1 h-1 bg-slate-600 rounded-full"></div>
            <span>ISO 27001 Certified</span>
          </div>
        </div>
        <div class="flex items-center space-x-4 mt-2 md:mt-0">
          <span>Thailand Tourism Authority Licensed</span>
          <div class="flex items-center space-x-1">
            <svg class="w-3 h-3 text-slate-600" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.94-.49-7-3.85-7-7.93 0-.62.08-1.21.21-1.79L9 15v1c0 1.1.9 2 2 2v1.93zm6.9-2.54c-.26-.81-1-1.39-1.9-1.39h-1v-3c0-.55-.45-1-1-1H8v-2h2c.55 0 1-.45 1-1V7h2c1.1 0 2-.9 2-2v-.41c2.93 1.19 5 4.06 5 7.41 0 2.08-.8 3.97-2.1 5.39z"/>
            </svg>
            <span>Global Coverage</span>
          </div>
        </div>
      </div>
    </div>
  </div>
</footer>

<!-- Notification System -->
<div id="notification" class="fixed bottom-4 right-4 z-50 max-w-sm w-full transform transition-all duration-300 ease-in-out translate-y-20 opacity-0 pointer-events-none">
  <div class="bg-white rounded-lg shadow-xl border-l-4 border-yellow-500 p-4">
    <div class="flex items-start">
      <div class="flex-shrink-0">
        <svg class="h-6 w-6 text-yellow-500" fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
        </svg>
      </div>
      <div class="ml-3 w-0 flex-1 pt-0.5">
        <h3 class="text-sm font-medium text-slate-800" id="notification-title">Action Required</h3>
        <p class="mt-1 text-sm text-slate-600" id="notification-message"></p>
      </div>
      <div class="ml-4 flex-shrink-0 flex">
        <button type="button" onclick="hideNotification()" class="inline-flex text-slate-400 hover:text-slate-500 focus:outline-none">
          <span class="sr-only">Close</span>
          <svg class="h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd" />
          </svg>
        </button>
      </div>
    </div>
  </div>
</div>

<style>
  .notification-show {
    transform: translateY(0) !important;
    opacity: 1 !important;
    pointer-events: auto !important;
  }
  
  @keyframes shake {
    0%, 100% { transform: translateX(0); }
    10%, 30%, 50%, 70%, 90% { transform: translateX(-2px); }
    20%, 40%, 60%, 80% { transform: translateX(2px); }
  }
  
  .animate-shake {
    animation: shake 0.5s cubic-bezier(.36,.07,.19,.97) both;
    border-color: #f59e0b !important;
  }
</style>

<script>
  // Notification functions
  function showNotification(message, title = 'Action Required') {
    const notification = document.getElementById('notification');
    const titleEl = document.getElementById('notification-title');
    const messageEl = document.getElementById('notification-message');
    
    titleEl.textContent = title;
    messageEl.textContent = message;
    
    // Show notification
    notification.classList.add('notification-show');
    
    // Auto-hide after 5 seconds
    setTimeout(hideNotification, 5000);
  }
  
  function hideNotification() {
    const notification = document.getElementById('notification');
    notification.classList.remove('notification-show');
  }
</script>
