<?php // app/Views/agent/kyc/status.php ?>
<?php require __DIR__ . '/../partials/header.php'; ?>

<div class="min-h-screen bg-base-200">
  <div class="max-w-5xl mx-auto px-4 py-8">
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200">
      <div class="px-6 py-5 border-b border-slate-200 flex items-center justify-between">
        <h2 class="text-xl font-bold text-slate-800">KYC Status</h2>
        <div class="flex items-center gap-2">
          <a href="/b2b/agent" class="btn btn-ghost">Dashboard</a>
          <a href="/b2b/agent/kyc" class="btn btn-ghost">Upload/Update</a>
        </div>
      </div>
      <div class="p-6">

        <?php if (!empty($_SESSION['flash'])): ?>
          <div class="alert alert-info mb-3"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
        <?php endif; ?>

        <?php
          $st = $kyc['status'] ?? 'not_submitted';
          $badge = 'badge-ghost';
          if ($st==='pending') $badge='badge-warning';
          elseif ($st==='approved') $badge='badge-success';
          elseif ($st==='rejected') $badge='badge-error';
        ?>
        <div class="flex items-center gap-3">
          <div class="text-sm">Current status:</div>
          <div class="badge <?= $badge ?> text-base"><?= htmlspecialchars(strtoupper($st)) ?></div>
        </div>
        <?php if (!empty($kyc['remarks']) && $st==='rejected'): ?>
          <div class="mt-2 alert alert-warning">
            <div>
              <div class="font-semibold">Rejection reason</div>
              <div><?= nl2br(htmlspecialchars($kyc['remarks'])) ?></div>
            </div>
          </div>
        <?php endif; ?>

        <div class="divider">Submitted Details</div>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
          <div class="p-3 rounded border">
            <div class="text-xs opacity-70">ID Type</div>
            <div class="font-medium"><?= htmlspecialchars($kyc['id_type'] ?? '-') ?></div>
          </div>
          <div class="p-3 rounded border">
            <div class="text-xs opacity-70">ID Number</div>
            <div class="font-medium"><?= htmlspecialchars($kyc['id_number'] ?? '-') ?></div>
          </div>
        </div>

        <div class="divider">Documents</div>
        <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
          <?php
            $thumbs = [];
            if (!empty($kyc['doc_front_path'])) $thumbs[] = ['label'=>'Government ID (Front)', 'path'=>$kyc['doc_front_path']];
            if (!empty($kyc['doc_back_path'])) $thumbs[] = ['label'=>'Government ID (Back)', 'path'=>$kyc['doc_back_path']];
            if (!empty($docs)) {
              foreach ($docs as $d) { $thumbs[] = ['label'=>ucwords(str_replace('_',' ',$d['doc_type'])), 'path'=>$d['file_path']]; }
            }
            function is_image_ext($p){ $p = strtolower($p); return preg_match('/\.(jpg|jpeg|png|webp)$/', $p); }
          ?>
          <?php foreach ($thumbs as $t): $p = '/'.ltrim($t['path'],'/'); $img = is_image_ext($p); ?>
            <div class="p-2 rounded border bg-slate-50">
              <div class="text-xs mb-2 font-medium text-slate-700 truncate" title="<?= htmlspecialchars($t['label']) ?>"><?= htmlspecialchars($t['label']) ?></div>
              <?php if ($img): ?>
                <img src="<?= htmlspecialchars($p) ?>" alt="<?= htmlspecialchars($t['label']) ?>" class="w-full h-32 object-cover rounded cursor-zoom-in lightbox-thumb" data-src="<?= htmlspecialchars($p) ?>">
              <?php else: ?>
                <a class="btn btn-sm w-full" href="<?= htmlspecialchars($p) ?>" target="_blank">Open Document</a>
              <?php endif; ?>
            </div>
          <?php endforeach; ?>
        </div>

        <div id="lb_overlay" class="fixed inset-0 bg-black/80 z-50 hidden items-center justify-center p-4">
          <div class="relative max-w-5xl w-full">
            <button id="lb_close" class="btn btn-sm absolute -top-2 right-0">Close</button>
            <img id="lb_img" src="" alt="Document" class="w-full max-h-[85vh] object-contain rounded shadow-2xl">
          </div>
        </div>

        <div class="mt-6 flex justify-end">
          <a href="/b2b/agent/kyc" class="btn btn-primary">Update KYC</a>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require __DIR__ . '/../partials/footer.php'; ?>

<script>
  (function(){
    const overlay = document.getElementById('lb_overlay');
    const lbImg = document.getElementById('lb_img');
    const closeBtn = document.getElementById('lb_close');
    function open(src){ if (!overlay || !lbImg) return; lbImg.src = src; overlay.classList.remove('hidden'); overlay.classList.add('flex'); }
    function close(){ if (!overlay) return; overlay.classList.add('hidden'); overlay.classList.remove('flex'); lbImg.src=''; }
    document.addEventListener('click', function(e){
      const t = e.target;
      if (t && t.classList && t.classList.contains('lightbox-thumb')) { e.preventDefault(); open(t.getAttribute('data-src')); }
      if (t && (t.id === 'lb_overlay' || t.id === 'lb_close')) { close(); }
    });
    document.addEventListener('keydown', function(e){ if (e.key === 'Escape') close(); });
  })();
</script>
