<?php
// app/Views/agent/hotels.php
$title = $title ?? 'Hotels';
$filters = $filters ?? ['q'=>'','city'=>'','price_min'=>'','price_max'=>'','sort'=>'best','stars'=>[], 'page'=>1, 'per_page'=>10];
$hotels = $hotels ?? [];
$partner = $partner ?? ['fixed_markup'=>null];
$pagination = $pagination ?? ['total'=>count($hotels),'page'=>($filters['page']??1),'per_page'=>($filters['per_page']??10),'pages'=>1];
$active = 'hotels';
require __DIR__ . '/partials/header.php';
?>

<!-- PREMIUM HOTEL SEARCH PAGE -->
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-white to-blue-50/30">
  
  <!-- Compact Hero Section -->
  <div class="bg-gradient-to-r from-blue-600 to-purple-600 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
      <div class="text-center mb-6">
        <h1 class="text-2xl font-bold mb-2">Premium Hotel Collection</h1>
        <p class="text-sm text-blue-100">Luxury accommodations • Best rates • Instant confirmation</p>
      </div>
      
      <!-- Compact Search Form -->
      <div class="bg-white/10 backdrop-blur-sm rounded-2xl p-4 border border-white/20">
        <form method="get" class="grid grid-cols-1 md:grid-cols-5 gap-3 items-end">
          <div>
            <label class="block text-xs font-semibold text-white mb-2">DESTINATION</label>
            <input class="w-full px-3 py-2.5 bg-white/90 border-0 rounded-lg focus:ring-2 focus:ring-blue-300 text-slate-900 font-medium placeholder-slate-500 text-sm" 
                   name="city" placeholder="City or hotel name..." value="<?= htmlspecialchars($filters['city'] ?? '') ?>">
          </div>
          <div>
            <label class="block text-xs font-semibold text-white mb-2">HOTEL NAME</label>
            <input class="w-full px-3 py-2.5 bg-white/90 border-0 rounded-lg focus:ring-2 focus:ring-blue-300 text-slate-900 font-medium placeholder-slate-500 text-sm" 
                   name="q" placeholder="Search hotels..." value="<?= htmlspecialchars($filters['q'] ?? '') ?>">
          </div>
          <div>
            <label class="block text-xs font-semibold text-white mb-2">CHECK-IN</label>
            <input type="date" class="w-full px-3 py-2.5 bg-white/90 border-0 rounded-lg focus:ring-2 focus:ring-blue-300 text-slate-900 font-medium text-sm" 
                   name="checkin" value="<?= htmlspecialchars($_GET['checkin'] ?? '') ?>">
          </div>
          <div>
            <label class="block text-xs font-semibold text-white mb-2">ROOMS</label>
            <select class="w-full px-3 py-2.5 bg-white/90 border-0 rounded-lg focus:ring-2 focus:ring-blue-300 text-slate-900 font-medium text-sm" name="rooms">
              <option value="">Select</option>
              <option value="1" <?= ($_GET['rooms']??'')==='1'?'selected':'' ?>>1</option>
              <option value="2" <?= ($_GET['rooms']??'')==='2'?'selected':'' ?>>2</option>
              <option value="3" <?= ($_GET['rooms']??'')==='3'?'selected':'' ?>>3</option>
              <option value="4" <?= ($_GET['rooms']??'')==='4'?'selected':'' ?>>4+</option>
            </select>
          </div>
          <div>
            <button class="w-full px-4 py-2.5 bg-gradient-to-r from-emerald-500 to-green-500 hover:from-emerald-600 hover:to-green-600 text-white font-bold rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105 text-sm">
              🏨 Search Hotels
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">

  <div class="grid grid-cols-1 md:grid-cols-12 gap-6">
    <!-- Compact Filters Sidebar -->
    <aside class="md:col-span-3 lg:col-span-3">
      <div class="bg-white rounded-2xl shadow-lg border border-slate-200 p-4 sticky top-4">
        <h3 class="text-lg font-bold text-slate-900 mb-4 flex items-center">
          <svg class="w-4 h-4 mr-2 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
            <path d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586l-6.293 6.293a1 1 0 00-.293.707V17l-4 4v-6.414a1 1 0 00-.293-.707L3 7.586V4z"/>
          </svg>
          Filters
        </h3>
        
        <form method="get" class="space-y-4">
          <!-- Location Filters -->
          <div class="space-y-3">
            <div>
              <label class="block text-xs font-semibold text-slate-700 mb-2">DESTINATION</label>
              <input class="w-full px-3 py-2 bg-slate-50 border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-slate-900 font-medium placeholder-slate-500 text-sm" 
                     name="city" placeholder="City or hotel name..." value="<?= htmlspecialchars($filters['city'] ?? '') ?>">
            </div>
            <div>
              <label class="block text-xs font-semibold text-slate-700 mb-2">HOTEL NAME</label>
              <input class="w-full px-3 py-2 bg-slate-50 border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-slate-900 font-medium placeholder-slate-500 text-sm" 
                     name="q" placeholder="Search hotels..." value="<?= htmlspecialchars($filters['q'] ?? '') ?>">
            </div>
          </div>
          
          <!-- Date & Rooms -->
          <div class="grid grid-cols-2 gap-3">
            <div>
              <label class="block text-xs font-semibold text-slate-700 mb-2">CHECK-IN</label>
              <input type="date" class="w-full px-2 py-2 bg-slate-50 border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-slate-900 font-medium text-sm" 
                     name="checkin" value="<?= htmlspecialchars($_GET['checkin'] ?? '') ?>">
            </div>
            <div>
              <label class="block text-xs font-semibold text-slate-700 mb-2">ROOMS</label>
              <select class="w-full px-2 py-2 bg-slate-50 border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-slate-900 font-medium text-sm" name="rooms">
                <option value="">Any</option>
                <option value="1" <?= ($_GET['rooms']??'')==='1'?'selected':'' ?>>1</option>
                <option value="2" <?= ($_GET['rooms']??'')==='2'?'selected':'' ?>>2</option>
                <option value="3" <?= ($_GET['rooms']??'')==='3'?'selected':'' ?>>3</option>
                <option value="4" <?= ($_GET['rooms']??'')==='4'?'selected':'' ?>>4+</option>
              </select>
            </div>
          </div>
          
          <!-- Price Range -->
          <div>
            <label class="block text-xs font-semibold text-slate-700 mb-2">PRICE RANGE (THB)</label>
            <div class="grid grid-cols-2 gap-2">
              <input class="px-2 py-2 bg-slate-50 border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-slate-900 font-medium placeholder-slate-500 text-sm" 
                     name="price_min" placeholder="Min" value="<?= htmlspecialchars($filters['price_min'] ?? '') ?>">
              <input class="px-2 py-2 bg-slate-50 border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-slate-900 font-medium placeholder-slate-500 text-sm" 
                     name="price_max" placeholder="Max" value="<?= htmlspecialchars($filters['price_max'] ?? '') ?>">
            </div>
          </div>
          
          <!-- Sort -->
          <div>
            <label class="block text-xs font-semibold text-slate-700 mb-2">SORT BY</label>
            <select class="w-full px-2 py-2 bg-slate-50 border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-slate-900 font-medium text-sm" name="sort" onchange="this.form.submit()">
              <option value="best" <?= ($filters['sort']??'best')==='best'?'selected':'' ?>>⭐ Recommended</option>
              <option value="price_asc" <?= ($filters['sort']??'')==='price_asc'?'selected':'' ?>>💰 Price (Low to High)</option>
              <option value="price_desc" <?= ($filters['sort']??'')==='price_desc'?'selected':'' ?>>💎 Price (High to Low)</option>
              <option value="stars_desc" <?= ($filters['sort']??'')==='stars_desc'?'selected':'' ?>>🌟 Rating (High to Low)</option>
            </select>
          </div>
          
          <input type="hidden" name="page" value="1">
          <button class="w-full px-4 py-2.5 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-bold rounded-lg shadow-md hover:shadow-lg transition-all duration-300 text-sm">
            🔍 Apply Filters
          </button>
        </form>
      </div>
    </aside>

    <!-- Premium Results List -->
    <section class="md:col-span-9 lg:col-span-9 space-y-6">

      <?php if (!$hotels): ?>
        <div class="bg-gradient-to-r from-blue-50 to-indigo-50 border-2 border-blue-200 rounded-3xl p-8 text-center">
          <div class="text-6xl mb-4">🏨</div>
          <h3 class="text-xl font-bold text-slate-900 mb-2">No hotels found</h3>
          <p class="text-slate-600">Try adjusting your search criteria or filters</p>
        </div>
      <?php else: foreach ($hotels as $h):
        $base = (float)($h['base_price'] ?? 0);
        $markup = (float)($partner['fixed_markup'] ?? 0);
        $agentPrice = $base + ($markup ?: 0);
        $stars = (int)($h['stars'] ?? 0);
        $city = trim((string)($h['city'] ?? ''));
        $thumb = trim((string)($h['thumbnail_url'] ?? ''));
      ?>
        <article class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-[1.01]">
          <div class="grid grid-cols-1 lg:grid-cols-12">
            <!-- Hotel Image -->
            <div class="lg:col-span-4">
              <div class="relative h-44 lg:h-full">
                <img src="<?= $thumb !== '' ? htmlspecialchars($thumb) : ('https://picsum.photos/seed/'.urlencode((string)($h['id'] ?? rand(1,9999))).'/640/480') ?>"
                     alt="Hotel" class="w-full h-full object-cover" loading="lazy">
                <div class="absolute top-3 left-3">
                  <span class="bg-emerald-500 text-white px-2 py-1 rounded-full text-xs font-bold">✓ INSTANT CONFIRM</span>
                </div>
              </div>
            </div>
            
            <!-- Hotel Details -->
            <div class="lg:col-span-5 p-4 lg:p-5">
              <div class="flex items-start justify-between mb-3">
                <h3 class="text-lg font-bold text-slate-900">
                  <?= htmlspecialchars($h['name'] ?? 'Premium Hotel') ?>
                </h3>
                <?php if ($stars>0): ?>
                  <div class="flex items-center space-x-1">
                    <svg class="w-4 h-4 text-yellow-400" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                    </svg>
                    <span class="text-sm font-bold text-slate-700"><?= $stars ?>.0</span>
                  </div>
                <?php endif; ?>
              </div>
              
              <div class="flex items-center text-slate-600 mb-3">
                <svg class="w-4 h-4 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                  <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                </svg>
                <span class="font-semibold text-sm">
                  <?= htmlspecialchars($city ?: 'Premium Location') ?>
                </span>
              </div>
              
              <!-- Compact Features -->
              <div class="grid grid-cols-2 gap-3">
                <div class="flex items-center text-sm text-slate-700">
                  <svg class="w-3 h-3 mr-2 text-emerald-600" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                  </svg>
                  <span class="font-medium">Free Cancellation</span>
                </div>
                <div class="flex items-center text-sm text-slate-700">
                  <svg class="w-3 h-3 mr-2 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                  </svg>
                  <span class="font-medium">No Prepayment</span>
                </div>
              </div>
            </div>
            
            <!-- Pricing & Booking -->
            <div class="lg:col-span-3 p-4 lg:p-5 bg-gradient-to-br from-slate-50 to-blue-50 border-t lg:border-l lg:border-t-0 flex flex-col justify-between">
              <div class="text-center mb-4">
                <div class="text-xs text-slate-600 font-semibold mb-1">Starting from</div>
                <div class="text-2xl font-black text-slate-900 mb-1">
                  ฿<?= number_format($agentPrice, 0) ?>
                </div>
                <div class="text-xs text-slate-600">per night</div>
                <?php if ($markup): ?>
                  <div class="text-xs text-emerald-600 font-semibold bg-emerald-50 px-2 py-1 rounded-full mt-2">
                    +฿<?= number_format($markup, 0) ?> markup
                  </div>
                <?php endif; ?>
              </div>
              
              <div>
                <a href="/b2b/agent/hotel?id=<?= (int)($h['id'] ?? 0) ?>" class="block w-full px-4 py-3 bg-gradient-to-r from-emerald-500 to-green-500 hover:from-emerald-600 hover:to-green-600 text-white font-bold rounded-lg shadow-md hover:shadow-lg transition-all duration-300 transform hover:scale-105 text-sm text-center">
                  🏨 View Details
                </a>
              </div>
            </div>
          </div>
        </article>
      <?php endforeach; endif; ?>

      <!-- Premium Pagination -->
      <?php if (($pagination['pages'] ?? 1) > 1):
        $curr = (int)($pagination['page'] ?? 1);
        $pages = (int)$pagination['pages'];
        $mkUrl = function($p) use ($filters) {
          $params = array_merge($filters, ['page' => $p]);
          return '/b2b/agent/hotels?' . http_build_query($params);
        };
      ?>
        <div class="flex justify-center mt-12">
          <div class="bg-white rounded-2xl shadow-lg border border-slate-200 p-2 flex items-center space-x-2">
            <?php if ($curr > 1): ?>
              <a href="<?= $mkUrl($curr - 1) ?>" 
                 class="px-4 py-2 text-slate-600 hover:text-blue-600 hover:bg-blue-50 rounded-xl transition-all duration-200 font-semibold">
                ← Previous
              </a>
            <?php endif; ?>
            
            <?php for ($i = max(1, $curr - 2); $i <= min($pages, $curr + 2); $i++): ?>
              <a href="<?= $mkUrl($i) ?>" 
                 class="px-4 py-2 rounded-xl font-bold transition-all duration-200 <?= $i === $curr ? 'bg-gradient-to-r from-blue-600 to-purple-600 text-white shadow-lg' : 'text-slate-600 hover:text-blue-600 hover:bg-blue-50' ?>">
                <?= $i ?>
              </a>
            <?php endfor; ?>
            
            <?php if ($curr < $pages): ?>
              <a href="<?= $mkUrl($curr + 1) ?>" 
                 class="px-4 py-2 text-slate-600 hover:text-blue-600 hover:bg-blue-50 rounded-xl transition-all duration-200 font-semibold">
                Next →
              </a>
            <?php endif; ?>
          </div>
        </div>
      <?php endif; ?>
    </section>
  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
