<?php
// app/Views/agent/hotel_booking_view.php
// Detailed view for a single hotel booking (Agent) – consistent with Taxi/Activity/Yacht views

$title    = $title ?? 'Hotel Booking';
$booking  = $booking ?? [];
$events   = $events ?? [];
$payments = $payments ?? [];
$csrf     = $csrf ?? '';

require __DIR__ . '/partials/header.php';

$status = strtolower((string)($booking['status'] ?? ''));
$paymentStatus = strtolower((string)($booking['payment_status'] ?? ''));

function hb_badgeClass($status) {
  $status = strtolower((string)$status);
  return match ($status) {
    'confirmed' => 'badge-info',
    'completed' => 'badge-success',
    'cancelled' => 'badge-error',
    'refunded'  => 'badge-neutral',
    'pending', 'processing', 'unpaid' => 'badge-warning',
    default => 'badge-ghost',
  };
}
?>

<div class="max-w-7xl mx-auto px-4 py-6">
  <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3 mb-6">
    <div>
      <div class="text-sm breadcrumbs">
        <ul>
          <li><a href="/b2b/agent">Dashboard</a></li>
          <li><a href="/b2b/agent/hotels/bookings">Hotel Bookings</a></li>
          <li>#<?= (int)($booking['id'] ?? 0) ?></li>
        </ul>
      </div>
      <h1 class="text-2xl font-bold flex items-center gap-2 mt-2">
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-primary" viewBox="0 0 24 24" fill="currentColor"><path d="M4 7V5a3 3 0 0 1 3-3h10a3 3 0 0 1 3 3v2a3 3 0 0 1 3 3v9h-2v-2H3v2H1V10a3 3 0 0 1 3-3Zm2 0h12V5a1 1 0 0 0-1-1H7a1 1 0 0 0-1 1v2Z"/></svg>
        Hotel Booking #<?= (int)($booking['id'] ?? 0) ?>
      </h1>
      <div class="mt-1 flex items-center gap-2">
        <span class="badge <?= hb_badgeClass($status) ?>"><?= ucfirst($status ?: 'N/A') ?></span>
        <span class="badge <?= hb_badgeClass($paymentStatus) ?>"><?= ucfirst($paymentStatus ?: 'N/A') ?></span>
      </div>

      <!-- Contact Details -->
      <div class="card bg-base-100 shadow-sm">
        <div class="card-body">
          <h2 class="card-title">Contact Details</h2>
          <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mt-2 text-sm">
            <div>
              <div class="text-xs text-base-content/60">Customer Name</div>
              <div class="font-semibold"><?= htmlspecialchars((string)($booking['customer_name'] ?? '')) ?: '—' ?></div>
            </div>
            <div>
              <div class="text-xs text-base-content/60">Email</div>
              <?php if (!empty($booking['customer_email'])): ?>
                <a class="link" href="mailto:<?= htmlspecialchars((string)$booking['customer_email']) ?>"><?= htmlspecialchars((string)$booking['customer_email']) ?></a>
              <?php else: ?>
                <div>—</div>
              <?php endif; ?>
            </div>
            <div>
              <div class="text-xs text-base-content/60">Phone</div>
              <?php if (!empty($booking['customer_phone'])): ?>
                <a class="link" href="tel:<?= preg_replace('/[^0-9+]/', '', (string)$booking['customer_phone']) ?>"><?= htmlspecialchars((string)$booking['customer_phone']) ?></a>
              <?php else: ?>
                <div>—</div>
              <?php endif; ?>
            </div>
          </div>
          <?php if (!empty($booking['customer_notes'])): ?>
          <div class="mt-3 p-3 rounded bg-base-200 text-sm">
            <div class="opacity-70">Customer Notes</div>
            <div class="font-medium mt-1"><?= nl2br(htmlspecialchars((string)$booking['customer_notes'])) ?></div>
          </div>
          <?php endif; ?>
        </div>
      </div>

    </div>
    <div class="flex gap-2">
      <a href="/b2b/agent/hotels/bookings" class="btn btn-ghost">Back</a>
      <?php
        $voucherUrl = '';
        if (in_array($status, ['confirmed','paid','completed'], true)) {
          $voucherUrl = '/b2b/agent/bookings/voucher?id=' . (int)($booking['id'] ?? 0);
        }
      ?>
      <?php if ($voucherUrl): ?>
        <a class="btn btn-primary" target="_blank" href="<?= htmlspecialchars($voucherUrl) ?>">Download Voucher</a>
      <?php endif; ?>
    </div>
  </div>

  <div class="grid grid-cols-1 lg:grid-cols-3 gap-5">
    <div class="lg:col-span-2 space-y-5">
      <!-- Overview -->
      <div class="card bg-base-100 shadow-sm">
        <div class="card-body">
          <h2 class="card-title">Booking Overview</h2>
          <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mt-2">
            <div class="space-y-3">
              <div>
                <div class="text-xs text-base-content/60">Booking Code</div>
                <div class="font-semibold"><?= htmlspecialchars((string)($booking['booking_code'] ?? '')) ?></div>
              </div>
              <div>
                <div class="text-xs text-base-content/60">Agent</div>
                <div class="font-semibold"><?= htmlspecialchars((string)($agent_display ?? (('#'.(int)($booking['agent_id'] ?? 0))))) ?></div>
              </div>
              <?php if (!empty($booking['vendor_name'])): ?>
              <div>
                <div class="text-xs text-base-content/60">Vendor</div>
                <div class="font-semibold"><?= htmlspecialchars((string)$booking['vendor_name']) ?></div>
              </div>
              <?php endif; ?>
              <div>
                <div class="text-xs text-base-content/60">Hotel</div>
                <div class="font-semibold"><?= htmlspecialchars((string)($booking['hotel_name'] ?? 'Hotel')) ?></div>
                <?php if (!empty($booking['room_name'])): ?>
                  <div class="text-sm text-base-content/70 mt-1">Room: <?= htmlspecialchars((string)$booking['room_name']) ?></div>
                <?php endif; ?>
              </div>
            </div>
            <div class="space-y-3">
              <div>
                <div class="text-xs text-base-content/60">Stay</div>
                <div class="font-semibold">
                  <?php $ci = $booking['checkin'] ?? null; $co = $booking['checkout'] ?? null; ?>
                  <?= $ci ? date('d M Y', strtotime((string)$ci)) : 'N/A' ?> → <?= $co ? date('d M Y', strtotime((string)$co)) : 'N/A' ?>
                  <?php if (!empty($booking['nights'])): ?>
                    <span class="ml-1 text-base-content/70">(<?= (int)$booking['nights'] ?> nights)</span>
                  <?php endif; ?>
                </div>
              </div>
              <div>
                <div class="text-xs text-base-content/60">Rooms</div>
                <div class="font-semibold">
                  <?= (int)($booking['rooms_qty'] ?? 1) ?>
                  <?php if (!empty($booking['room_id'])): ?><span class="text-base-content/60"> • Room ID: <?= (int)$booking['room_id'] ?></span><?php endif; ?>
                  <?php if (!empty($booking['rate_plan_id'])): ?><span class="text-base-content/60"> • Plan: <?= (int)$booking['rate_plan_id'] ?></span><?php endif; ?>
                </div>
              </div>
              <?php if (!empty($booking['notify_token']) || !empty($booking['notify_token_expire'])): ?>
              <div>
                <div class="text-xs text-base-content/60">Notify</div>
                <div class="font-medium break-all">
                  <?php if (!empty($booking['notify_token'])): ?>Token: <span class="opacity-80"><?= htmlspecialchars((string)$booking['notify_token']) ?></span><?php endif; ?>
                  <?php if (!empty($booking['notify_token_expire'])): ?><div>Expires: <?= htmlspecialchars((string)$booking['notify_token_expire']) ?></div><?php endif; ?>
                </div>
              </div>
              <?php endif; ?>
              <div>
                <div class="text-xs text-base-content/60">Status</div>
                <div class="flex items-center gap-2">
                  <span class="badge <?= hb_badgeClass($status) ?>"><?= ucfirst($status ?: 'N/A') ?></span>
                  <span class="badge <?= hb_badgeClass($paymentStatus) ?>"><?= ucfirst($paymentStatus ?: 'N/A') ?></span>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Guests -->
      <?php $guests = []; if (!empty($booking['guest_json'])) { $gj = json_decode((string)$booking['guest_json'], true); if (is_array($gj)) { $guests = $gj; } } ?>
      <div class="card bg-base-100 shadow-sm">
        <div class="card-body">
          <div class="flex items-center justify-between">
            <h2 class="card-title">Guests</h2>
            <span class="badge badge-outline"><?= is_array($guests) ? count($guests) : 0 ?></span>
          </div>
          <?php if (!empty($guests)): ?>
            <div class="mt-3 space-y-3">
              <?php foreach ($guests as $i => $g): ?>
                <div class="rounded-xl border p-4 hover:shadow-sm transition">
                  <div class="flex items-center justify-between">
                    <div class="font-semibold flex items-center gap-2">
                      <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 opacity-70" viewBox="0 0 24 24" fill="currentColor"><path d="M12 12c2.21 0 4-1.79 4-4S14.21 4 12 4 8 5.79 8 8s1.79 4 4 4Zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4Z"/></svg>
                      Guest <?= $i+1 ?>
                    </div>
                    <?php $gt = strtolower((string)($g['type'] ?? 'adult')); ?>
                    <span class="badge <?= $gt==='child'?'badge-info':($gt==='infant'?'badge-warning':'badge-success') ?> capitalize"><?= htmlspecialchars($gt) ?></span>
                  </div>
                  <div class="grid grid-cols-1 md:grid-cols-3 gap-3 text-sm mt-3">
                    <div>
                      <div class="opacity-60 text-xs">Name</div>
                      <div class="font-medium"><?= htmlspecialchars((string)($g['name'] ?? ($g['first_name'] ?? 'Guest'))) ?></div>
                    </div>
                    <?php if (!empty($g['passport'])): ?>
                    <div>
                      <div class="opacity-60 text-xs">Passport</div>
                      <div class="font-medium font-mono text-xs"><?= htmlspecialchars((string)$g['passport']) ?></div>
                    </div>
                    <?php endif; ?>
                    <?php if (!empty($g['nationality'])): ?>
                    <div>
                      <div class="opacity-60 text-xs">Nationality</div>
                      <div class="font-medium"><?= htmlspecialchars((string)$g['nationality']) ?></div>
                    </div>
                    <?php endif; ?>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
          <?php else: ?>
            <div class="text-center py-6">
              <div class="text-4xl mb-2">👥</div>
              <div class="font-medium">No Guests</div>
              <div class="text-sm opacity-70">This booking doesn’t include guest profiles.</div>
            </div>
          <?php endif; ?>
        </div>
      </div>

      <!-- Audit Trail -->
      <div class="card bg-base-100 shadow-sm">
        <div class="card-body">
          <h2 class="card-title">Audit Trail</h2>
          <?php if (!empty($events)): ?>
            <div class="overflow-x-auto">
              <table class="table">
                <thead><tr><th>#</th><th>Event</th><th>Note</th><th>When</th></tr></thead>
                <tbody>
                  <?php foreach ($events as $i => $ev): ?>
                    <?php $et = strtolower((string)($ev['event_type'] ?? '')); ?>
                    <tr>
                      <td><?= $i+1 ?></td>
                      <td class="font-medium flex items-center gap-2">
                        <span class="inline-flex h-2 w-2 rounded-full <?= $et==='status_change'?'bg-blue-500':($et==='payment'?'bg-emerald-500':($et==='refund'?'bg-amber-500':'bg-slate-300')) ?>"></span>
                        <?= htmlspecialchars((string)($ev['event_type'] ?? '')) ?>
                      </td>
                      <td class="text-sm opacity-80"><?= htmlspecialchars((string)($ev['note'] ?? '')) ?></td>
                      <td class="text-sm opacity-80"><?= htmlspecialchars((string)($ev['created_at'] ?? '')) ?></td>
                    </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          <?php else: ?>
            <div class="text-center py-6">
              <div class="text-4xl mb-2">📝</div>
              <div class="font-medium">No Audit Events</div>
              <div class="text-sm opacity-70">Lifecycle updates for this booking will appear here.</div>
            </div>
          <?php endif; ?>
        </div>
      </div>

      <!-- Refunds -->
      <div class="card bg-base-100 shadow-sm">
        <div class="card-body">
          <div class="flex items-center justify-between">
            <h2 class="card-title">Refunds</h2>
            <?php $refundTotal = 0.0; foreach (($refunds ?? []) as $r) { $refundTotal += (float)($r['amount'] ?? 0); } ?>
            <?php if ($refundTotal > 0): ?><span class="badge badge-warning">Total: <?= number_format($refundTotal, 2) ?> <?= htmlspecialchars((string)($booking['currency'] ?? 'THB')) ?></span><?php endif; ?>
          </div>
          <?php if (!empty($refunds ?? [])): ?>
            <div class="overflow-x-auto">
              <table class="table table-sm">
                <thead><tr><th>#</th><th>Gateway</th><th>Amount</th><th>Status</th><th>Txn ID</th><th>At</th></tr></thead>
                <tbody>
                <?php foreach ($refunds as $i => $r): ?>
                  <tr>
                    <td><?= $i+1 ?></td>
                    <td><?= htmlspecialchars((string)($r['gateway'] ?? '')) ?></td>
                    <td><?= number_format((float)($r['amount'] ?? 0), 2) ?> <?= htmlspecialchars((string)($r['currency'] ?? 'THB')) ?></td>
                    <td><span class="badge badge-neutral capitalize"><?= htmlspecialchars((string)($r['status'] ?? '')) ?></span></td>
                    <td class="font-mono text-xs"><?= htmlspecialchars((string)($r['txn_id'] ?? '')) ?></td>
                    <td class="text-xs opacity-70"><?= htmlspecialchars((string)($r['at'] ?? '')) ?></td>
                  </tr>
                <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          <?php else: ?>
            <div class="text-center py-6">
              <div class="text-4xl mb-2">💸</div>
              <div class="font-medium">No Refunds</div>
              <div class="text-sm opacity-70">Any refunds processed for this booking will be shown here.</div>
            </div>
          <?php endif; ?>
        </div>
      </div>
    </div>

    <!-- Right: Payment Summary -->
    <aside class="space-y-5">
      <div class="card bg-base-100 shadow-sm">
        <div class="card-body">
          <h2 class="card-title">Payment Summary</h2>
          <div class="mt-2 space-y-2 text-sm">
            <div class="flex items-center justify-between">
              <span class="opacity-60">Amount</span>
              <span class="font-semibold"><?= number_format((float)($booking['total_price'] ?? $booking['label_price'] ?? $booking['amount_total'] ?? 0), 2) ?> <?= htmlspecialchars((string)($booking['currency'] ?? 'THB')) ?></span>
            </div>
            <?php if (isset($booking['base_price']) || isset($booking['tax_amount']) || isset($booking['fee_amount'])): ?>
            <div class="text-xs opacity-70">
              Breakdown:
              <?php if (isset($booking['base_price'])): ?> Base <?= number_format((float)$booking['base_price'],2) ?> <?= htmlspecialchars((string)($booking['currency'] ?? 'THB')) ?><?php endif; ?>
              <?php if (isset($booking['tax_amount'])): ?> • Tax <?= number_format((float)$booking['tax_amount'],2) ?><?php endif; ?>
              <?php if (isset($booking['fee_amount'])): ?> • Fee <?= number_format((float)$booking['fee_amount'],2) ?><?php endif; ?>
            </div>
            <?php endif; ?>
            <div class="flex items-center justify-between">
              <span class="opacity-60">Status</span>
              <span class="badge <?= hb_badgeClass($paymentStatus) ?>"><?= ucfirst($paymentStatus ?: 'N/A') ?></span>
            </div>
          </div>
          <div class="divider"></div>
          <h3 class="font-semibold">Transactions</h3>
          <?php if (!empty($payments)): ?>
            <div class="overflow-x-auto">
              <table class="table table-sm">
                <thead><tr><th>#</th><th>Gateway</th><th>Amount</th><th>Status</th><th>At</th></tr></thead>
                <tbody>
                <?php foreach ($payments as $i => $p): ?>
                  <tr>
                    <td><?= $i+1 ?></td>
                    <td><?= htmlspecialchars((string)($p['gateway'] ?? '')) ?></td>
                    <td><?= number_format((float)($p['amount'] ?? 0), 2) ?> <?= htmlspecialchars((string)($p['currency'] ?? 'THB')) ?></td>
                    <td><span class="badge <?= hb_badgeClass($p['status'] ?? '') ?>"><?= htmlspecialchars((string)($p['status'] ?? '')) ?></span></td>
                    <td class="text-xs opacity-70"><?= htmlspecialchars((string)($p['created_at'] ?? '')) ?></td>
                  </tr>
                <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          <?php else: ?>
            <div class="text-sm opacity-70">No transactions yet.</div>
          <?php endif; ?>
        </div>
      </div>

      <?php if (strtolower((string)($booking['status'] ?? '')) !== 'cancelled'): ?>
      <div class="card bg-base-100 shadow-sm">
        <div class="card-body">
          <h2 class="card-title">Actions</h2>
          <p class="text-sm opacity-70">To request cancellation or refund, contact support or your partner manager. If self-cancel is enabled, it will appear here.</p>
          <div class="flex gap-2">
            <?php if (in_array($status, ['confirmed','paid'], true)): ?>
              <a class="btn btn-outline btn-error btn-sm" href="/b2b/agent/bookings/voucher?id=<?= (int)($booking['id'] ?? 0) ?>#cancel">Cancel Booking</a>
            <?php endif; ?>
          </div>
        </div>
      </div>
      <?php endif; ?>
    </aside>
  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
