<?php
// app/Views/agent/cart.php
$title = $title ?? 'Cart';
$items = $items ?? [];
$active = 'activities';
require __DIR__ . '/partials/header.php';
?>

<div class="max-w-5xl mx-auto px-4 py-6">
  <div class="flex items-center justify-between mb-4">
    <h1 class="text-xl font-semibold">Your Cart</h1>
    <form method="post" action="/b2b/agent/cart/clear" onsubmit="return confirm('Clear cart?')">
      <button class="btn btn-ghost btn-sm">Clear</button>
    </form>
  </div>

  <?php if (empty($items)): ?>
    <div class="alert">
      <div>
        <span>Your cart is empty.</span>
      </div>
    </div>
  <?php else: ?>
    <div class="space-y-3">
      <?php foreach ($items as $i => $it): ?>
        <article class="rounded-xl border bg-white/80 p-4 flex items-center justify-between gap-4">
          <div class="text-sm">
            <div><span class="font-semibold">Package:</span> #<?= (int)$it['package_id'] ?> • Variant #<?= (int)$it['variant_id'] ?> • Price #<?= (int)$it['price_id'] ?></div>
            <div class="text-base-content/60">Qty: <?= (int)$it['qty'] ?><?= !empty($it['show_time']) ? (' • Time: ' . htmlspecialchars((string)$it['show_time'])) : '' ?></div>
          </div>
          <form method="post" action="/b2b/agent/cart/remove">
            <input type="hidden" name="index" value="<?= (int)$i ?>">
            <button class="btn btn-outline btn-sm">Remove</button>
          </form>
        </article>
      <?php endforeach; ?>
    </div>

    <div class="mt-6 flex items-center justify-end">
      <a href="/b2b/agent/bookings/pay" class="btn btn-primary">Proceed to payment</a>
    </div>
  <?php endif; ?>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
