<?php
// app/Views/agent/bookings.php
$title = $title ?? 'Bookings';
$bookings = $bookings ?? [];
$draft = $draft ?? null;
$created = isset($_GET['created']) ? trim((string)$_GET['created']) : '';
$active = 'bookings';
require __DIR__ . '/partials/header.php';
?>

<div class="bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 min-h-screen">
  <div class="max-w-7xl mx-auto px-6 py-8">

    <?php if ($draft): ?>
      <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 mb-6">
        <div class="flex items-center justify-between">
          <div>
            <div class="text-lg font-semibold text-slate-800">Booking draft ready</div>
            <div class="text-sm text-slate-600 mt-1">
              Hotel #<?= (int)($draft['hotel_id'] ?? 0) ?> • Room #<?= (int)($draft['room_id'] ?? 0) ?> • Plan #<?= (int)($draft['rate_plan_id'] ?? 0) ?> •
              <?= htmlspecialchars($draft['checkin'] ?? '') ?> → <?= htmlspecialchars($draft['checkout'] ?? '') ?> • Rooms: <?= (int)($draft['rooms_qty'] ?? 1) ?>
            </div>
          </div>
          <a class="btn bg-gradient-to-r from-blue-600 to-indigo-600 text-white border-0" href="/b2b/agent/bookings/review">Review</a>
        </div>
      </div>
    <?php endif; ?>

    <?php if ($created !== ''): ?>
      <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 mb-6">
        <div class="flex items-center justify-between">
          <div>
            <div class="text-lg font-semibold text-slate-800">Booking created</div>
            <div class="text-sm text-slate-600 mt-1">Reference: <strong><?= htmlspecialchars($created) ?></strong></div>
          </div>
          <a class="btn bg-gradient-to-r from-emerald-600 to-green-600 text-white border-0" href="/b2b/agent/bookings">Dismiss</a>
        </div>
      </div>
    <?php endif; ?>

    <!-- Premium Header Section -->
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-8 mb-8">
      <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-6">
        <div class="flex items-center space-x-4">
          <div class="w-16 h-16 bg-gradient-to-br from-blue-600 to-indigo-700 rounded-2xl flex items-center justify-center shadow-lg">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-white" fill="none" viewBox="0 0 24 24" stroke="currentColor">
              <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2" />
            </svg>
          </div>
          <div>
            <h1 class="text-4xl font-bold bg-gradient-to-r from-slate-800 to-slate-600 bg-clip-text text-transparent">Booking History</h1>
            <p class="text-slate-600 text-lg mt-1">Unified view across Activity, Hotel, Taxi, Yacht, Holiday</p>
            <div class="flex items-center space-x-4 mt-3 text-sm text-slate-500">
              <div class="flex items-center space-x-2"><div class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></div><span>Live Data</span></div>
            </div>
          </div>
        </div>
        <div class="flex flex-col sm:flex-row gap-3">
          <a href="/b2b/agent/activities" class="btn bg-gradient-to-r from-blue-600 to-indigo-600 text-white border-0">New Activity</a>
          <a href="/b2b/agent/hotels" class="btn bg-gradient-to-r from-emerald-600 to-green-600 text-white border-0">New Hotel</a>
          <a href="/b2b/agent/taxi" class="btn bg-gradient-to-r from-purple-600 to-indigo-600 text-white border-0">New Taxi</a>
        </div>
      </div>
    </div>

    <!-- Advanced Filter Panel -->
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 p-6 mb-8">
      <form method="get" class="space-y-6">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-6 gap-4">
          <div class="lg:col-span-2">
            <label class="block text-sm font-medium text-slate-700 mb-2">Search</label>
            <input class="block w-full px-3 py-3 border border-slate-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent" name="q" placeholder="Search by reference or customer" value="<?= htmlspecialchars($filters['q'] ?? ($_GET['q'] ?? '')) ?>" />
          </div>
          <div>
            <label class="block text-sm font-medium text-slate-700 mb-2">Type</label>
            <select class="block w-full px-3 py-3 border border-slate-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500" name="type">
              <?php $curType = (string)($filters['type'] ?? ($_GET['type'] ?? '')); foreach (($available_types ?? []) as $k=>$v): ?>
                <option value="<?= htmlspecialchars($k) ?>" <?= $curType===$k?'selected':'' ?>><?= htmlspecialchars($v) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div>
            <label class="block text-sm font-medium text-slate-700 mb-2">Status</label>
            <select class="block w-full px-3 py-3 border border-slate-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500" name="status">
              <?php $curSt = (string)($filters['status'] ?? ($_GET['status'] ?? '')); foreach (($available_statuses ?? []) as $k=>$v): ?>
                <option value="<?= htmlspecialchars($k) ?>" <?= $curSt===$k?'selected':'' ?>><?= htmlspecialchars($v) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div>
            <label class="block text-sm font-medium text-slate-700 mb-2">From</label>
            <input type="date" class="block w-full px-3 py-3 border border-slate-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500" name="from" value="<?= htmlspecialchars($filters['from'] ?? ($_GET['from'] ?? '')) ?>" />
          </div>
          <div>
            <label class="block text-sm font-medium text-slate-700 mb-2">To</label>
            <input type="date" class="block w-full px-3 py-3 border border-slate-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-blue-500" name="to" value="<?= htmlspecialchars($filters['to'] ?? ($_GET['to'] ?? '')) ?>" />
          </div>
        </div>
        <div class="flex flex-wrap gap-3 pt-2">
          <button class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-indigo-600 hover:from-blue-700 hover:to-indigo-700 text-white text-sm font-semibold rounded-lg shadow-md hover:shadow-lg transition-all duration-200">Apply Filters</button>
          <a href="/b2b/agent/bookings" class="inline-flex items-center px-6 py-3 bg-white border border-slate-300 text-slate-700 text-sm font-semibold rounded-lg hover:bg-slate-50 transition-all duration-200">Reset</a>
        </div>
      </form>
    </div>

    <!-- Payment Status Filter Buttons -->
    <div class="flex space-x-4 mb-6">
      <a href="?status=paid" class="px-6 py-3 rounded-lg font-medium transition-all duration-200 flex-1 text-center <?= ($_GET['status'] ?? '') === 'paid' ? 'bg-blue-600 text-white shadow-lg' : 'bg-white text-slate-700 border border-slate-200 hover:bg-slate-50' ?>">
        <i class="fas fa-check-circle mr-2"></i> Paid
      </a>
      <a href="?status=unpaid" class="px-6 py-3 rounded-lg font-medium transition-all duration-200 flex-1 text-center <?= ($_GET['status'] ?? '') === 'unpaid' ? 'bg-yellow-500 text-white shadow-lg' : 'bg-white text-slate-700 border border-slate-200 hover:bg-slate-50' ?>">
        <i class="fas fa-clock mr-2"></i> Unpaid
      </a>
      <a href="?status=refunded" class="px-6 py-3 rounded-lg font-medium transition-all duration-200 flex-1 text-center <?= in_array(($_GET['status'] ?? ''), ['refunded', 'cancelled']) ? 'bg-red-500 text-white shadow-lg' : 'bg-white text-slate-700 border border-slate-200 hover:bg-slate-50' ?>">
        <i class="fas fa-undo-alt mr-2"></i> Refunded/Cancelled
      </a>
    </div>

    <!-- Data Table -->
    <div class="bg-white rounded-2xl shadow-xl border border-slate-200/60 overflow-hidden">
      <div class="px-6 py-4 bg-gradient-to-r from-slate-50 to-slate-100 border-b border-slate-200 flex items-center justify-between">
        <h3 class="text-lg font-semibold text-slate-800 flex items-center">
          <svg class="w-5 h-5 mr-2 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v10a2 2 0 002 2h8a2 2 0 002-2V7a2 2 0 00-2-2h-2"/></svg>
          Booking Records
        </h3>
        <div class="text-sm text-slate-600">Total: <?= (int)($total_count ?? count($bookings)) ?></div>
      </div>

      <div class="overflow-x-auto">
        <table class="w-full">
          <thead class="bg-gradient-to-r from-slate-100 to-slate-50">
            <?php $curTypeHdr = (string)($_GET['type'] ?? ($filters['type'] ?? '')); ?>
            <tr class="border-b border-slate-200">
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">#</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Trip Date</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Voucher</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Booking Ref</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Customer</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Product</th>
              <?php if (strtolower($curTypeHdr) === 'activity'): ?>
                <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">PAX</th>
                <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Time</th>
              <?php endif; ?>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Booking Date</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Status</th>
              <th class="px-6 py-4 text-left text-xs font-semibold text-slate-600 uppercase tracking-wider">Actions</th>
            </tr>
          </thead>
          <tbody class="divide-y divide-slate-200">
            <?php if (!$bookings): ?>
              <tr><td colspan="7" class="px-6 py-12 text-center text-slate-500">No bookings</td></tr>
            <?php else: 
              $serialNumber = (($current_page ?? 1) - 1) * ($per_page ?? 10) + 1;
              foreach ($bookings as $b): 
            ?>
            <tr class="hover:bg-slate-50 transition-colors">
              <td class="px-6 py-4 text-sm text-slate-500"><?= $serialNumber++ ?></td>
              <?php 
                  $id = (int)($b['id'] ?? 0);
                  // Robust type detection: module | type | booking_type
                  $type = strtolower((string)($b['module'] ?? ($b['type'] ?? ($b['booking_type'] ?? ''))));
                  $statusRaw = strtolower((string)($b['status_raw'] ?? ($b['status'] ?? '')));
                  // View page URL by module
                  $viewUrl = '#';
                  if ($type === 'taxi') { $viewUrl = '/b2b/agent/taxi/booking/view?id=' . $id; }
                  elseif ($type === 'hotel') { $viewUrl = '/b2b/agent/hotel/booking/view?id=' . $id; }
                  elseif ($type === 'activity') { $viewUrl = '/b2b/agent/activity/booking/view?id=' . $id; }
                  elseif ($type === 'yacht') { $viewUrl = '/b2b/agent/yacht/booking/view?id=' . $id; }
              ?>
              <!-- Trip Date Column -->
              <td class="px-6 py-4 text-sm whitespace-nowrap">
                <?php
                  $module = strtolower((string)($b['module'] ?? ($b['type'] ?? ($b['booking_type'] ?? ''))));
                  switch ($module) {
                    case 'hotel':
                      $checkIn = $b['checkin'] ?? $b['check_in'] ?? $b['travel_date'] ?? null;
                      if (!empty($checkIn)) {
                        $checkInFormatted = date('d M Y', strtotime($checkIn));
                        echo '<div class="flex items-center gap-1">'
                           . '<i class="fas fa-calendar-check text-blue-500"></i>'
                           . '<span>' . htmlspecialchars($checkInFormatted) . '</span>'
                           . '</div>';
                      } else {
                        echo '-';
                      }
                      break;
                    case 'activity':
                      $activityDate = $b['activity_date'] ?? $b['travel_date'] ?? null;
                      if (!empty($activityDate)) {
                        $formattedDate = date('d M Y', strtotime($activityDate));
                        echo '<div class="flex items-center gap-1">'
                           . '<i class="fas fa-calendar-day text-green-500"></i>'
                           . '<span>' . htmlspecialchars($formattedDate) . '</span>'
                           . '</div>';
                      } else {
                        echo '-';
                      }
                      break;
                    case 'taxi':
                      $pickupDate = $b['pickup_date'] ?? $b['travel_date'] ?? null;
                      $pickupTime = (string)($b['pickup_time'] ?? '');
                      if (!empty($pickupDate)) {
                        $formattedDate = date('d M Y', strtotime($pickupDate));
                        echo '<div class="flex flex-col gap-1">'
                           . '<div class="flex items-center gap-1">'
                           . '<i class="fas fa-car text-yellow-500"></i>'
                           . '<span>' . htmlspecialchars($formattedDate) . '</span>'
                           . '</div>';
                        if ($pickupTime !== '') {
                          echo '<div class="text-xs text-slate-500">' . htmlspecialchars($pickupTime) . '</div>';
                        }
                        echo '</div>';
                      } else {
                        echo '-';
                      }
                      break;
                    case 'yacht':
                      $startDate = $b['start_date'] ?? $b['travel_date'] ?? null;
                      $endDate = $b['end_date'] ?? null;
                      if (!empty($startDate)) {
                        $formattedStart = date('d M Y', strtotime($startDate));
                        if (!empty($endDate) && $endDate !== $startDate) {
                          $formattedEnd = date('d M Y', strtotime($endDate));
                          $tripDate = $formattedStart . ' - ' . $formattedEnd;
                        } else {
                          $tripDate = $formattedStart;
                        }
                        echo '<div class="flex items-center gap-1">'
                           . '<i class="fas fa-ship text-indigo-500"></i>'
                           . '<span>' . htmlspecialchars($tripDate) . '</span>'
                           . '</div>';
                      } else {
                        echo '-';
                      }
                      break;
                    default:
                      echo '-';
                  }
                ?>
              </td>
              <?php 
                  // Voucher URL per module when confirmed/paid/completed
                  $voucherUrl = '';
                  if (in_array($statusRaw, ['confirmed','paid','completed'], true)) {
                      if (!empty($b['voucher_url'])) { $voucherUrl = (string)$b['voucher_url']; }
                      else {
                          if ($type === 'taxi') { $voucherUrl = '/b2b/agent/taxi/voucher?id=' . $id; }
                          elseif ($type === 'hotel') { $voucherUrl = '/b2b/agent/bookings/voucher?id=' . $id; }
                          elseif ($type === 'activity') { $voucherUrl = '/b2b/agent/activity/voucher?id=' . $id; }
                          elseif ($type === 'yacht') { $voucherUrl = '/b2b/agent/yacht/voucher?id=' . $id; }
                      }
                  }
              ?>
              <td class="px-6 py-4">
                <?php if ($voucherUrl !== ''): ?>
                  <a class="inline-flex items-center px-3 py-2 text-sm border border-slate-300 rounded-lg text-slate-700 bg-white hover:bg-slate-50" href="<?= htmlspecialchars($voucherUrl) ?>" target="_blank">
                    <i class="fas fa-download mr-1 text-xs"></i> Download
                  </a>
                <?php else: ?>
                  <span class="text-slate-300">-</span>
                <?php endif; ?>
              </td>
              <td class="px-6 py-4 font-mono text-sm">
                  <?php $ref = (string)($b['ref'] ?? ($b['booking_code'] ?? '-')); ?>
                  <?php if ($id > 0 && $viewUrl !== '#'): ?>
                    <a href="<?= htmlspecialchars($viewUrl) ?>" class="link link-primary hover:underline"><?= htmlspecialchars($ref) ?></a>
                  <?php else: ?>
                    <?= htmlspecialchars($ref) ?>
                  <?php endif; ?>
              </td>
              <td class="px-6 py-4 text-sm"><?= htmlspecialchars($b['customer'] ?? ($b['customer_name'] ?? '-')) ?></td>
              <td class="px-6 py-4 text-sm">
                <div class="flex items-center gap-2">
                  <?php 
                    $module = strtolower((string)($b['module'] ?? ($b['type'] ?? ($b['booking_type'] ?? ''))));
                    $iconClass = 'fas fa-question-circle text-gray-400';
                    $bgClass = 'bg-gray-100';
                    switch($module) {
                      case 'hotel': $iconClass = 'fas fa-hotel text-blue-600'; $bgClass = 'bg-blue-50'; break;
                      case 'taxi': $iconClass = 'fas fa-taxi text-yellow-600'; $bgClass = 'bg-yellow-50'; break;
                      case 'yacht': $iconClass = 'fas fa-ship text-indigo-600'; $bgClass = 'bg-indigo-50'; break;
                      case 'activity': $iconClass = 'fas fa-ticket-alt text-green-600'; $bgClass = 'bg-green-50'; break;
                    }
                  ?>
                  <span class="inline-flex items-center justify-center w-8 h-8 rounded-full <?= $bgClass ?>">
                    <i class="<?= $iconClass ?> text-sm"></i>
                  </span>
                  <?php 
                    $product = (string)($b['product'] ?? ($b['activity_name'] ?? ($b['hotel_name'] ?? ($b['ride_name'] ?? '-'))));
                    echo htmlspecialchars($product);
                  ?>
                </div>
              </td>
              <?php if (strtolower((string)($_GET['type'] ?? ($filters['type'] ?? ''))) === 'activity'): ?>
                <td class="px-6 py-4 text-sm"><?= (int)($b['pax'] ?? ($b['guests'] ?? 0)) ?></td>
                <td class="px-6 py-4 text-sm"><?= htmlspecialchars((string)($b['show_time'] ?? '')) ?></td>
              <?php endif; ?>
              <td class="px-6 py-4 text-sm whitespace-nowrap">
                <?php 
                  $dateTime = $b['created_at'] ?? null;
                  echo $dateTime ? htmlspecialchars(date('d M Y, h:i A', strtotime($dateTime))) : '-';
                ?>
              </td>
              <td class="px-6 py-4 text-sm">
                <span class="px-2 py-1 rounded capitalize <?php $badge = (string)($b['status_badge'] ?? 'neutral'); echo $badge==='success'?'bg-green-100 text-green-800':($badge==='warning'?'bg-yellow-100 text-yellow-800':($badge==='error'?'bg-red-100 text-red-800':($badge==='info'?'bg-blue-100 text-blue-800':'bg-gray-100 text-gray-800'))); ?>"><?= htmlspecialchars($b['status'] ?? '-') ?></span>
              </td>
              <td class="px-6 py-4 text-sm whitespace-nowrap">
                <div class="flex flex-wrap gap-2">
                  <?php if ($viewUrl !== '#'): ?>
                    <a href="<?= htmlspecialchars($viewUrl) ?>" class="inline-flex items-center px-3 py-1.5 text-xs border border-slate-300 rounded-lg text-slate-700 bg-white hover:bg-slate-50">
                      <i class="fas fa-eye mr-1"></i> View
                    </a>
                  <?php endif; ?>
                  <?php if ($voucherUrl !== ''): ?>
                    <a href="<?= htmlspecialchars($voucherUrl) ?>" target="_blank" class="inline-flex items-center px-3 py-1.5 text-xs border border-slate-300 rounded-lg text-slate-700 bg-white hover:bg-slate-50">
                      <i class="fas fa-download mr-1"></i> Voucher
                    </a>
                  <?php endif; ?>
                  <?php if ($type === 'hotel' && $id > 0): ?>
                    <a href="<?= htmlspecialchars('/b2b/agent/hotel/booking/view?id='.$id) ?>" class="inline-flex items-center px-3 py-1.5 text-xs border border-slate-300 rounded-lg text-slate-700 bg-white hover:bg-slate-50">
                      <i class="fas fa-paper-plane mr-1"></i> Re-send Email
                    </a>
                  <?php endif; ?>
                </div>
              </td>
              </tr>
            <?php endforeach; endif; ?>
          </tbody>
        </table>
      </div>
    </div>

    <!-- Premium Pagination Footer -->
    <?php 
      $page = (int)($pagination['page'] ?? 1);
      $pages = (int)($pagination['pages'] ?? 1);
      $per = (int)($pagination['per_page'] ?? 25);
      $queryBase = $_GET; unset($queryBase['page']);
      $makeUrl = function($p) use ($queryBase) {
        $query = http_build_query(array_merge($queryBase, ['page'=>$p]));
        return '/b2b/agent/bookings' . ($query ? ('?'.$query) : '');
      };
    ?>
    <div class="mt-8 bg-white rounded-2xl shadow-lg border border-slate-200/60 px-6 py-4">
      <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
        <div class="flex items-center space-x-4">
          <div class="text-sm text-slate-600">
            Showing <span class="font-semibold text-slate-900"><?= ($total_count ? ((($page - 1) * $per) + 1) : 0) ?></span> to 
            <span class="font-semibold text-slate-900"><?= min($page * $per, (int)($total_count ?? 0)) ?></span> of 
            <span class="font-semibold text-slate-900"><?= number_format((int)($total_count ?? 0)) ?></span> results
          </div>
          <div class="text-xs text-slate-500">(<?= $per ?> entries per page)</div>
        </div>
        <?php if (($pages ?? 1) > 1): ?>
          <?php $start = max(1, $page - 2); $end = min($pages, $page + 2); ?>
          <nav class="flex items-center space-x-1">
            <a href="<?= $page>1 ? htmlspecialchars($makeUrl($page-1)) : '#' ?>" class="inline-flex items-center px-3 py-2 text-sm font-medium <?= $page>1 ? 'text-slate-500 bg-white border border-slate-300 rounded-lg hover:bg-slate-50 hover:text-slate-700' : 'pointer-events-none opacity-50 text-slate-400 border border-slate-200 rounded-lg' ?>">Previous</a>
            <?php if ($start > 1): ?>
              <a href="<?= htmlspecialchars($makeUrl(1)) ?>" class="inline-flex items-center px-3 py-2 text-sm font-medium text-slate-500 bg-white border border-slate-300 rounded-lg hover:bg-slate-50 hover:text-slate-700">1</a>
              <?php if ($start > 2): ?><span class="px-2 text-slate-400">...</span><?php endif; ?>
            <?php endif; ?>
            <?php for ($i = $start; $i <= $end; $i++): ?>
              <a href="<?= htmlspecialchars($makeUrl($i)) ?>" class="inline-flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-colors duration-200 <?= $i === $page ? 'bg-blue-600 text-white border border-blue-600' : 'text-slate-500 bg-white border border-slate-300 hover:bg-slate-50 hover:text-slate-700' ?>"><?= $i ?></a>
            <?php endfor; ?>
            <?php if ($end < $pages): ?>
              <?php if ($end < $pages - 1): ?><span class="px-2 text-slate-400">...</span><?php endif; ?>
              <a href="<?= htmlspecialchars($makeUrl($pages)) ?>" class="inline-flex items-center px-3 py-2 text-sm font-medium text-slate-500 bg-white border border-slate-300 rounded-lg hover:bg-slate-50 hover:text-slate-700"><?= $pages ?></a>
            <?php endif; ?>
            <a href="<?= $page<$pages ? htmlspecialchars($makeUrl($page+1)) : '#' ?>" class="inline-flex items-center px-3 py-2 text-sm font-medium <?= $page<$pages ? 'text-slate-500 bg-white border border-slate-300 rounded-lg hover:bg-slate-50 hover:text-slate-700' : 'pointer-events-none opacity-50 text-slate-400 border border-slate-200 rounded-lg' ?>">Next</a>
          </nav>
        <?php endif; ?>
      </div>
    </div>

  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
