<?php
// app/Views/agent/booking_review.php
$title = $title ?? 'Review Booking';
$draft = $draft ?? null;
$hotel = $hotel ?? [];
$rooms_map = $rooms_map ?? [];
$plans_map = $plans_map ?? [];
$active = 'bookings';
require __DIR__ . '/partials/header.php';
?>

<?php if (!$draft): ?>
  <div class="alert alert-error mb-4">No booking draft found.</div>
<?php else: ?>
  <!-- Stepper -->
  <div class="mb-4">
    <ul class="steps w-full">
      <li class="step step-primary">Select rooms</li>
      <li class="step step-primary">Guest details</li>
      <li class="step">Confirm</li>
    </ul>
  </div>

  <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <div class="lg:col-span-2 space-y-4">
      <!-- Booking summary card -->
      <div class="card bg-base-100 shadow-sm border">
        <div class="card-body">
          <div class="flex items-start justify-between gap-3">
            <div>
              <h2 class="card-title mb-1">Booking summary</h2>
              <div class="text-sm text-base-content/70">Review your selection before confirming.</div>
            </div>
          </div>
          <div class="mt-3 text-sm">
            <div class="flex items-center gap-2">
              <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2z"/></svg>
              <span class="font-medium">Hotel:</span> <?= htmlspecialchars($hotel['name'] ?? ('#' . (int)($draft['hotel_id'] ?? 0))) ?>
            </div>
            <div class="mt-1 flex items-center gap-2">
              <svg xmlns="http://www.w3.org/2000/svg" class="w-4 h-4" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 0 0 2-2V7a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2z"/></svg>
              <span class="font-medium">Stay:</span> <?= htmlspecialchars($draft['checkin'] ?? '') ?> → <?= htmlspecialchars($draft['checkout'] ?? '') ?>
            </div>

            <div class="divider my-4"></div>

            <div class="space-y-3">
              <?php
                $pricing = $pricing ?? ['items'=>[],'grand_total'=>0,'currency'=>'THB'];
                $mealMap = [ 'RO'=>'Room Only','BB'=>'Bed & Breakfast','HB'=>'Half Board','FB'=>'Full Board','AI'=>'All Inclusive','CP'=>'Continental Plan' ];
              ?>
              <?php foreach (($pricing['items'] ?? []) as $pitem):
                $r = $pitem['room'] ?? [];
                $pl = $pitem['plan'] ?? [];
                $abbr = strtoupper(trim((string)($pl['meal_plan'] ?? '')));
                $mealLabel = $mealMap[$abbr] ?? $abbr;
              ?>
                <div class="border rounded-lg p-3 bg-white/70">
                  <div class="flex items-start justify-between gap-3">
                    <div>
                      <div class="font-medium">
                        <?= htmlspecialchars($r['name'] ?? ('Room #' . (int)($r['id'] ?? 0))) ?>
                      </div>
                      <div class="text-xs text-base-content/70">
                        <?= htmlspecialchars($pl['name'] ?? ('Plan #' . (int)($pl['id'] ?? 0))) ?><?php if ($mealLabel !== ''): ?> • <?= htmlspecialchars($mealLabel) ?><?php endif; ?>
                        <?php if (isset($pl['refundable'])): ?> • <?= (int)$pl['refundable']===1 ? 'Free cancellation' : 'Non-refundable' ?><?php endif; ?>
                      </div>
                    </div>
                    <div class="text-sm font-semibold">× <?= (int)($pitem['qty'] ?? 1) ?></div>
                  </div>
                  <?php if (!empty($pitem['nights'])): ?>
                    <div class="mt-3 overflow-x-auto">
                      <table class="table table-zebra w-full text-xs">
                        <thead>
                          <tr>
                            <th class="text-left">Date</th>
                            <th class="text-right">Unit</th>
                            <th class="text-center">Qty</th>
                            <th class="text-right">Total</th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php foreach ($pitem['nights'] as $n): ?>
                            <tr>
                              <td><?= htmlspecialchars($n['date']) ?></td>
                              <td class="text-right"><?= number_format((float)($n['unit'] ?? 0), 0) ?> <?= htmlspecialchars($pricing['currency'] ?? 'THB') ?></td>
                              <td class="text-center"><?= (int)($n['qty'] ?? 1) ?></td>
                              <td class="text-right font-medium"><?= number_format((float)($n['line_total'] ?? 0), 0) ?> <?= htmlspecialchars($pricing['currency'] ?? 'THB') ?></td>
                            </tr>
                          <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                          <tr>
                            <th colspan="3" class="text-right">Subtotal</th>
                            <th class="text-right font-semibold"><?= number_format((float)($pitem['subtotal'] ?? 0), 0) ?> <?= htmlspecialchars($pricing['currency'] ?? 'THB') ?></th>
                          </tr>
                        </tfoot>
                      </table>
                    </div>
                  <?php endif; ?>
                </div>
              <?php endforeach; ?>
            </div>

            <div class="mt-4 flex flex-wrap gap-2 text-xs">
              <span class="badge">Instant confirmation</span>
              <span class="badge">Secure checkout</span>
            </div>
          </div>
        </div>
      </div>

      <!-- Guest details card -->
      <div class="card bg-base-100 shadow-sm border">
        <div class="card-body">
          <h2 class="card-title">Guest details</h2>
          <form id="booking-form" method="post" action="/b2b/agent/bookings/prepare" class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <?php $csrf = \App\Middleware\AgentGuard::generateCsrfToken('booking_prepare'); ?>
            <input type="hidden" id="csrf_main" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">

            <div class="form-control md:col-span-2">
              <label class="label"><span class="label-text">Customer name</span></label>
              <input type="text" name="customer_name" class="input input-bordered" placeholder="e.g. John Doe" required />
            </div>

            <div class="form-control md:col-span-2">
              <label class="label"><span class="label-text">Customer email (optional)</span></label>
              <input type="email" name="customer_email" class="input input-bordered" placeholder="e.g. john@example.com" />
            </div>

            <div class="form-control">
              <label class="label"><span class="label-text">Phone (WhatsApp preferred)</span></label>
              <input type="tel" name="customer_phone" class="input input-bordered" placeholder="e.g. +66 89 123 4567" />
            </div>
            <div class="form-control">
              <label class="label"><span class="label-text">Nationality</span></label>
              <input type="text" name="customer_nationality" class="input input-bordered" placeholder="e.g. Thai" />
            </div>

            <div class="form-control md:col-span-2">
              <label class="label"><span class="label-text">Special requests (optional)</span></label>
              <textarea name="special_requests" class="textarea textarea-bordered" rows="2" placeholder="e.g. High floor, late check-in"></textarea>
            </div>

            <div class="md:col-span-2">
              <div class="divider">Rooming list</div>
            </div>

            <?php $pricing = $pricing ?? ['items'=>[],'currency'=>'THB']; $roomIdx=0; ?>
            <?php foreach (($pricing['items'] ?? []) as $pitem): ?>
              <?php $qty = (int)($pitem['qty'] ?? 1); $room = $pitem['room'] ?? []; $plan = $pitem['plan'] ?? []; ?>
              <?php for ($i=1; $i<=$qty; $i++): $roomIdx++; ?>
                <div class="md:col-span-2 border rounded-lg p-4 bg-white/70">
                  <div class="flex items-center justify-between">
                    <div class="font-medium">Room <?= $roomIdx ?> • <?= htmlspecialchars($room['name'] ?? ('Room #' . (int)($room['id'] ?? 0))) ?></div>
                    <div class="text-xs text-base-content/70">Plan: <?= htmlspecialchars($plan['name'] ?? ('#' . (int)($plan['id'] ?? 0))) ?></div>
                  </div>
                  <div class="grid grid-cols-1 md:grid-cols-4 gap-3 mt-3">
                    <?php
                      $maxAdults = (int)($room['occupancy_adults'] ?? 2);
                      $maxChildren = (int)($room['occupancy_children'] ?? 0);
                      $capacity = (int)($room['capacity'] ?? max(1, $maxAdults + $maxChildren));
                      if ($maxAdults < 1) { $maxAdults = 1; }
                      if ($capacity < 1) { $capacity = 1; }
                      $defaultAdults = min(2, max(1, $maxAdults));
                      $defaultChildren = 0;
                    ?>
                    <div class="form-control">
                      <label class="label"><span class="label-text">Sharing basis</span></label>
                      <select name="guests[rooms][<?= $roomIdx ?>][sharing_basis]" class="select select-bordered">
                        <option value="single">Single</option>
                        <option value="double" selected>Double</option>
                        <option value="twin">Twin</option>
                        <option value="triple">Triple</option>
                        <option value="quad">Quad</option>
                      </select>
                    </div>
                    <div class="form-control">
                      <label class="label"><span class="label-text">Adults</span></label>
                      <input type="number" min="1" max="<?= $maxAdults ?>" value="<?= $defaultAdults ?>" class="input input-bordered room-adults" data-room="<?= $roomIdx ?>" data-max-adults="<?= $maxAdults ?>" data-max-children="<?= $maxChildren ?>" data-capacity="<?= $capacity ?>" name="guests[rooms][<?= $roomIdx ?>][adults]" />
                    </div>
                    <div class="form-control">
                      <label class="label"><span class="label-text">Children</span></label>
                      <input type="number" min="0" max="<?= $maxChildren ?>" value="<?= $defaultChildren ?>" class="input input-bordered room-children" data-room="<?= $roomIdx ?>" data-max-adults="<?= $maxAdults ?>" data-max-children="<?= $maxChildren ?>" data-capacity="<?= $capacity ?>" name="guests[rooms][<?= $roomIdx ?>][children]" />
                    </div>
                    <div class="form-control">
                      <label class="label"><span class="label-text">Notes (optional)</span></label>
                      <input type="text" class="input input-bordered" name="guests[rooms][<?= $roomIdx ?>][notes]" placeholder="e.g. Near elevator" />
                    </div>
                  </div>
                  <div class="mt-3">
                    <div class="text-sm font-medium mb-2">Occupant names</div>
                    <div id="occupants-<?= $roomIdx ?>" class="grid grid-cols-1 md:grid-cols-2 gap-3"></div>
                  </div>
                </div>
              <?php endfor; ?>
            <?php endforeach; ?>

            <div class="md:col-span-2 flex items-center justify-between gap-2 pt-2">
              <a href="/b2b/agent/hotel?id=<?= (int)($draft['hotel_id'] ?? 0) ?>&checkin=<?= urlencode((string)($draft['checkin'] ?? '')) ?>&checkout=<?= urlencode((string)($draft['checkout'] ?? '')) ?>" class="btn">Back</a>
              <button class="btn btn-primary" type="submit">Confirm booking</button>
            </div>
          </form>
        </div>
      </div>
    </div>

    <!-- Sidebar -->
    <aside class="lg:col-span-1">
      <div class="sticky top-20 space-y-4">
        <div class="card bg-base-100 shadow-sm border">
          <div class="card-body">
            <div class="font-semibold">Heads up</div>
            <div class="text-sm text-base-content/70">We will re-check availability and price at confirmation.</div>
          </div>
        </div>
        <div class="card bg-base-100 shadow-sm border">
          <div class="card-body">
            <div class="font-semibold mb-1">Why book with us</div>
            <ul class="list-disc list-inside text-sm text-base-content/70 space-y-1">
              <li>Trusted B2B partner</li>
              <li>Competitive agent rates</li>
              <li>Dedicated local support</li>
            </ul>
          </div>
        </div>
        <?php $pricing = $pricing ?? ['grand_total'=>0,'currency'=>'THB']; ?>
        <div class="card bg-base-100 shadow-sm border">
          <div class="card-body">
            <div class="flex items-center justify-between">
              <div class="font-semibold">Subtotal</div>
              <div class="text-lg font-semibold"><?= number_format((float)($pricing['grand_total'] ?? 0), 0) ?> <?= htmlspecialchars($pricing['currency'] ?? 'THB') ?></div>
            </div>
            <div class="divider my-2"></div>
            <div class="flex items-center justify-between">
              <div class="font-semibold">Total <span class="text-xs text-base-content/60 font-normal">(all taxes included)</span></div>
              <div class="text-xl font-bold"><?= number_format((float)($pricing['total_with_tax'] ?? ($pricing['grand_total'] ?? 0)), 0) ?> <?= htmlspecialchars($pricing['currency'] ?? 'THB') ?></div>
            </div>
            <div class="mt-2 flex flex-wrap gap-2 text-xs"></div>

            <div class="mt-3 text-xs">
              <div class="font-semibold mb-1">Cancellation policy</div>
              <ul class="list-disc list-inside space-y-1 text-base-content/70">
                <li>Free cancellation up to 7 days before check-in.</li>
                <li>4 days before: THB 100 per booking applies.</li>
                <li>Within 2 days: No refund (no cancellation).</li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </aside>
  </div>
<?php endif; ?>

<script>
  (function(){
    function getLimits(room){
      var a = document.querySelector('.room-adults[data-room="'+room+'"]');
      var c = document.querySelector('.room-children[data-room="'+room+'"]');
      var maxA = a ? parseInt(a.getAttribute('data-max-adults')||a.max||'4',10) : 4;
      var maxC = c ? parseInt(c.getAttribute('data-max-children')||c.max||'3',10) : 3;
      var cap = a ? parseInt(a.getAttribute('data-capacity')||'4',10) : 4;
      return {maxA: Math.max(1, maxA), maxC: Math.max(0, maxC), cap: Math.max(1, cap)};
    }
    function clampCounts(room, adults, children){
      var lim = getLimits(room);
      adults = Math.max(1, Math.min(lim.maxA, parseInt(adults||'1',10)));
      children = Math.max(0, Math.min(lim.maxC, parseInt(children||'0',10)));
      if (adults + children > lim.cap) {
        // Prioritize keeping adults; reduce children first
        children = Math.max(0, Math.min(children, lim.cap - adults));
        if (adults + children > lim.cap) {
          adults = Math.max(1, Math.min(adults, lim.cap));
          children = Math.max(0, Math.min(children, lim.cap - adults));
        }
      }
      return {adults: adults, children: children};
    }
    function renderOccupants(room, adults, children){
      var wrap = document.getElementById('occupants-'+room);
      if(!wrap) return;
      wrap.innerHTML = '';
      var cl = clampCounts(room, adults, children);
      adults = cl.adults; children = cl.children;
      var aInp = document.querySelector('.room-adults[data-room="'+room+'"]');
      var cInp = document.querySelector('.room-children[data-room="'+room+'"]');
      if (aInp) aInp.value = adults;
      if (cInp) cInp.value = children;
      for(let a=1; a<=adults; a++){
        var div = document.createElement('div');
        div.className = 'form-control';
        div.innerHTML = '<label class="label"><span class="label-text">Adult '+a+' name</span></label>'+
                        '<input type="text" required name="guests[rooms]['+room+'][adults_names][]" class="input input-bordered" placeholder="e.g. John Doe" />';
        wrap.appendChild(div);
      }
      for(let c=1; c<=children; c++){
        var divC = document.createElement('div');
        divC.className = 'form-control';
        divC.innerHTML = '<label class="label"><span class="label-text">Child '+c+' name (age)</span></label>'+
                         '<div class="flex gap-2">'+
                           '<input type="text" name="guests[rooms]['+room+'][children_names][]" class="input input-bordered flex-1" placeholder="e.g. Jane Doe" />'+
                           '<input type="number" min="0" max="17" name="guests[rooms]['+room+'][children_ages][]" class="input input-bordered w-24" placeholder="Age" />'+
                         '</div>';
        wrap.appendChild(divC);
      }
    }
    function init(){
      document.querySelectorAll('.room-adults').forEach(function(inp){
        var room = inp.getAttribute('data-room');
        var childInp = document.querySelector('.room-children[data-room="'+room+'"]');
        renderOccupants(room, inp.value, childInp ? childInp.value : 0);
        inp.addEventListener('input', function(){ renderOccupants(room, inp.value, childInp ? childInp.value : 0); });
        if(childInp){ childInp.addEventListener('input', function(){ renderOccupants(room, inp.value, childInp.value); }); }
      });
    }
    if(document.readyState === 'loading') document.addEventListener('DOMContentLoaded', init); else init();
  })();
</script>

<?php require __DIR__ . '/partials/footer.php'; ?>
