<?php
// app/Views/agent/auth/login.php
$title = $title ?? 'Agent Login';
?>
<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <!-- Mobile App-like meta -->
    <meta name="theme-color" content="#0d79c7">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="B2B Thai Hub">
    <meta name="application-name" content="B2B Thai Hub">
    <meta name="format-detection" content="telephone=no,email=no,address=no">
    <title><?= htmlspecialchars($title) ?> - B2B Agent Portal</title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Manifest for PWA -->
    <link rel="manifest" href="/manifest.webmanifest">
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=JetBrains+Mono:wght@400;500&display=swap" rel="stylesheet">
    
    <!-- Enterprise Styles -->
    <style>
        :root {
            --primary-50: #e6f4ff;
            --primary-100: #cce9ff;
            --primary-200: #99d3ff;
            --primary-300: #66beff;
            --primary-400: #33a8ff;
            --primary-500: #008cff; /* MakeMyTrip-like blue */
            --primary-600: #0077e6;
            --primary-700: #0063c7;
            --primary-800: #004f9e;
            --primary-900: #103b73;
            
            --gray-50: #f8fafc;
            --gray-100: #f1f5f9;
            --gray-200: #e2e8f0;
            --gray-300: #cbd5e1;
            --gray-400: #94a3b8;
            --gray-500: #64748b;
            --gray-600: #475569;
            --gray-700: #334155;
            --gray-800: #1e293b;
            --gray-900: #0f172a;
            
            --success-50: #f0fdf4;
            --success-500: #22c55e;
            --success-600: #16a34a;
            
            --error-50: #fef2f2;
            --error-500: #ef4444;
            --error-600: #dc2626;
            
            --warning-50: #fffbeb;
            --warning-500: #f59e0b;
            --warning-600: #d97706;
        }
        
        * {
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, var(--primary-600) 0%, var(--primary-800) 50%, var(--primary-950) 100%);
            min-height: 100vh;
            margin: 0;
            /* Safe area paddings for iOS notch */
            padding-top: calc(env(safe-area-inset-top, 0px));
            padding-bottom: calc(env(safe-area-inset-bottom, 0px));
            padding-left: calc(env(safe-area-inset-left, 0px));
            padding-right: calc(env(safe-area-inset-right, 0px));
            overflow-x: hidden;
            position: relative;
        }
        
        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: 
                radial-gradient(circle at 20% 80%, rgba(120, 119, 198, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(120, 119, 198, 0.2) 0%, transparent 50%);
            pointer-events: none;
            z-index: 0;
        }
        
        .main-container {
            position: relative;
            z-index: 1;
            min-height: 100svh; /* mobile viewport units */
            background: linear-gradient(180deg, #f8fbff 0%, #eef6ff 100%);
            padding: 2rem 1rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .login-card {
            background: white;
            border-radius: 1.5rem;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            width: 100%;
            max-width: 32rem;
            overflow: hidden;
            border: 1px solid rgba(203, 213, 225, 0.3);
            backdrop-filter: blur(10px);
        }
        
        .login-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 40px 80px rgba(0, 0, 0, 0.15), 0 20px 40px rgba(0, 0, 0, 0.1), inset 0 1px 0 rgba(255, 255, 255, 0.8);
        }
        
        .brand-header {
            background: linear-gradient(135deg, var(--primary-600) 0%, var(--primary-800) 100%);
            padding: 3rem 2rem;
            text-align: center;
            color: white;
            position: relative;
            overflow: hidden;
        }
        
        .brand-header::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            right: -50%;
            bottom: -50%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
            transform: rotate(30deg);
        }
        
        .brand-logo {
            width: 5rem;
            height: 5rem;
            margin: 0 auto 1.25rem;
            background: rgba(255, 255, 255, 0.15);
            border-radius: 1.25rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            position: relative;
            z-index: 1;
            backdrop-filter: blur(5px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .brand-logo i {
            font-size: 28px;
            color: white;
        }
        
        .brand-title {
            color: white;
            font-size: 1.75rem;
            font-weight: 700;
            margin: 0 0 0.5rem;
            letter-spacing: -0.025em;
        }
        
        .brand-subtitle {
            color: rgba(255, 255, 255, 0.9);
            font-size: 0.95rem;
            margin: 0;
            font-weight: 400;
        }
        
        .form-container {
            padding: 3rem 2.5rem 2.5rem;
        }
        
        .alert {
            border-radius: 12px;
            padding: 1rem 1.25rem;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: flex-start;
            gap: 0.75rem;
            font-size: 0.875rem;
            line-height: 1.5;
            border: 1px solid;
        }
        
        .alert-success {
            background: var(--success-50);
            border-color: var(--success-200);
            color: var(--success-800);
        }
        
        .alert-error {
            background: var(--error-50);
            border-color: var(--error-200);
            color: var(--error-800);
        }
        
        .alert-warning {
            background: var(--warning-50);
            border-color: var(--warning-200);
            color: var(--warning-800);
        }
        
        .alert-icon {
            width: 20px;
            height: 20px;
            flex-shrink: 0;
            margin-top: 1px;
        }
        
        .form-group {
            margin-bottom: 1.75rem;
            position: relative;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: var(--gray-700);
            font-size: 0.9375rem;
            transition: all 0.2s ease;
        }
        
        .form-group:focus-within label {
            color: var(--primary-600);
        }
        
        .required-asterisk {
            color: var(--error-500);
            margin-left: 2px;
        }
        
        .form-input {
            width: 100%;
            padding: 0.95rem 1.1rem; /* taller for touch */
            border: 1px solid var(--gray-200);
            border-radius: 0.75rem;
            font-size: 1rem;
            line-height: 1.5;
            color: var(--gray-800);
            background-color: var(--gray-50);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
            -webkit-appearance: none; /* iOS remove inner shadow */
        }
        
        .form-input:focus {
            outline: none;
            border-color: var(--primary-400);
            box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.15);
            background-color: white;
        }
        
        .form-input::placeholder {
            color: var(--gray-400);
            opacity: 1;
        }
        
        .form-input.error {
            border-color: var(--error-500);
            box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.1);
        }
        
        .input-group {
            position: relative;
        }
        
        .input-icon {
            position: absolute;
            right: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: var(--gray-400);
            cursor: pointer;
            transition: color 0.2s ease;
        }
        
        .input-icon:hover {
            color: var(--gray-600);
        }
        
        .btn {
            display: block;
            width: 100%;
            padding: 1.05rem 1.25rem; /* bigger tap target */
            background: linear-gradient(135deg, var(--primary-500) 0%, var(--primary-700) 100%);
            color: white;
            font-weight: 600;
            letter-spacing: 0.025em;
            border: none;
            border-radius: 0.9rem;
            font-size: 1rem;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            text-align: center;
            position: relative;
            overflow: hidden;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            min-height: 52px;
        }
        
        .btn:hover {
            background: linear-gradient(135deg, var(--primary-600) 0%, var(--primary-800) 100%);
            transform: translateY(-2px);
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        
        .btn:active {
            transform: translateY(0);
        }
        
        .btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(255,255,255,0.2) 0%, transparent 100%);
            opacity: 0;
            transition: opacity 0.3s ease;
        }
        
        .btn:hover::before {
            opacity: 1;
        }
        
        .footer-links {
            padding: 1.5rem 2.5rem;
            text-align: center;
            border-top: 1px solid var(--gray-200);
            background-color: var(--gray-50);
        }
        
        .footer-text {
            font-size: 0.875rem;
            color: var(--gray-500);
            margin: 0;
            line-height: 1.5;
        }
        
        .footer-links a {
            color: var(--primary-600);
            font-weight: 500;
            text-decoration: none;
            transition: color 0.2s ease;
        }
        
        .footer-links a:hover {
            color: var(--primary-700);
            text-decoration: underline;
        }
        
        .copyright {
            margin-top: 1rem;
            font-size: 0.75rem;
            color: var(--gray-400);
        }
        
        /* Responsive Design */
        @media (max-width: 640px) {
            .main-container {
                padding: 1rem;
            }
            
            .login-card {
                border-radius: 1rem;
            }
            
            .form-container {
                padding: 1.5rem 1rem 1.25rem;
            }
            
            .brand-header {
                padding: 2rem 1.25rem 1.5rem;
            }
            
            .brand-logo {
                width: 4.25rem;
                height: 4.25rem;
                font-size: 1.8rem;
            }
            .btn { font-size: 1.02rem; }
            .form-input { font-size: 1.02rem; }
            .input-icon { right: 0.85rem; }
        }
        
        /* Dark mode support */
        @media (prefers-color-scheme: dark) {
            .login-card {
                background: rgba(30, 41, 59, 0.95);
                border-color: rgba(255, 255, 255, 0.1);
            }
            
            .form-container {
                color: white;
            }
            
            .form-input {
                background: rgba(51, 65, 85, 0.8);
                border-color: rgba(148, 163, 184, 0.3);
                color: white;
            }
            
            .form-label {
                color: rgba(248, 250, 252, 0.9);
            }
        }
        
        /* Accessibility */
        @media (prefers-reduced-motion: reduce) {
            *, *::before, *::after {
                animation-duration: 0.01ms !important;
                animation-iteration-count: 1 !important;
                transition-duration: 0.01ms !important;
            }
        }
        
        /* Focus styles for keyboard navigation */
        .btn:focus-visible,
        .form-input:focus-visible {
            outline: 2px solid var(--primary-500);
            outline-offset: 2px;
        }

        /* Processing overlay */
        .processing-overlay {
            position: fixed;
            inset: 0;
            background: rgba(15, 23, 42, 0.55);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        .processing-card {
            background: #fff;
            border-radius: 1rem;
            padding: 1.5rem;
            width: 90%;
            max-width: 480px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.2);
            border: 1px solid rgba(203,213,225,0.6);
            text-align: center;
        }
        .processing-spinner {
            width: 120px; height: 120px; /* larger so brand fits fully */
            position: relative;
            margin: 0 auto 12px;
        }
        .processing-svg { width: 120px; height: 120px; display: block; }
        .processing-brand {
            position: absolute;
            inset: 0; z-index: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 10px; /* Option C: smaller uppercase text */
            font-weight: 700;
            color: #ff8c00; /* dark orange brand text */
            text-transform: uppercase;
            letter-spacing: 0.3px;
            pointer-events: none;
            max-width: 96px; /* keep text fully inside circle */
            text-align: center;
            white-space: nowrap;
            overflow: hidden;
        }
        .processing-title { font-weight: 700; color: #0f172a; margin-bottom: 4px; }
        .processing-sub { color: #475569; font-size: 0.95rem; }

        /* Mobile app-like top bar (shown only on small screens) */
        .mobile-app-bar {
            display: none;
            position: sticky;
            top: 0;
            z-index: 5;
            padding: calc(env(safe-area-inset-top, 0px) + 8px) 12px 8px 12px;
            background: linear-gradient(135deg, var(--primary-600), var(--primary-800));
            color: #fff;
            box-shadow: 0 6px 20px rgba(0,0,0,0.12);
        }
        .mobile-app-bar .app-row { display:flex; align-items:center; gap:10px; }
        .mobile-app-bar .app-badge { width:28px;height:28px;border-radius:6px;background:rgba(255,255,255,0.2);display:flex;align-items:center;justify-content:center; }
        .mobile-app-bar .app-title { font-weight:700; letter-spacing:.2px; }
        @media (max-width: 640px) { .mobile-app-bar { display:block; } }

        /* App Install Banner (desktop only) */
        .app-install-banner {
            position: fixed;
            left: 0; right: 0; bottom: 0;
            padding: calc(0.75rem + env(safe-area-inset-bottom)) 1rem 1rem;
            background: rgba(15,23,42,0.95);
            color: #fff;
            display: none;
            z-index: 50;
            backdrop-filter: saturate(180%) blur(10px);
        }
        .app-install-banner.show { display: block; }
        .app-install-banner .btn-install {
            background: #0d79c7; color: white; border: 0;
            padding: 0.6rem 0.9rem; border-radius: 0.6rem; font-weight: 600;
        }
    </style>
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#e6f4ff',
                            100: '#cce9ff',
                            200: '#99d3ff',
                            300: '#66beff',
                            400: '#33a8ff',
                            500: '#008cff',
                            600: '#0077e6',
                            700: '#0063c7',
                            800: '#004f9e',
                            900: '#103b73',
                            950: '#0c2c56'
                        },
                        brand: { 50:'#eef8ff',100:'#d8efff',200:'#b2e0ff',300:'#84ccff',400:'#46b3ff',500:'#1b97f0',600:'#0d79c7',700:'#0c62a1',800:'#0c4f82',900:'#0c426c' }
                    },
                    fontFamily: {
                        sans: ['Inter', 'system-ui', 'sans-serif'],
                        mono: ['JetBrains Mono', 'monospace']
                    }
                }
            }
        }
    </script>
</head>
<body>
    <!-- App Install Banner (reusable partial) -->
    <?php include __DIR__ . '/../partials/pwa_install_banner.php'; ?>
    <!-- App-like top bar for mobile -->
    <div class="mobile-app-bar">
        <div class="app-row">
            <div class="app-badge"><i class="fas fa-compass"></i></div>
            <div class="app-title">B2B Thai Hub</div>
        </div>
    </div>
    <?php include __DIR__ . '/../partials/public_header.php'; ?>
    <!-- Processing Overlay (shown during login POST) -->
    <div id="processingOverlay" class="processing-overlay">
        <div class="processing-card">
            <div class="processing-spinner">
                <svg class="processing-svg" viewBox="0 0 100 100">
                    <!-- Track -->
                    <circle cx="50" cy="50" r="42" fill="none" stroke="#e5e7eb" stroke-width="8"></circle>
                    <!-- Arc -->
                    <circle cx="50" cy="50" r="42" fill="none" stroke="#0fb9b1" stroke-width="8" stroke-linecap="round" stroke-dasharray="210" stroke-dashoffset="170">
                        <animateTransform attributeName="transform" type="rotate" from="0 50 50" to="360 50 50" dur="0.9s" repeatCount="indefinite" />
                    </circle>
                </svg>
                <span class="processing-brand">bookmythai.com</span>
            </div>
            <div class="processing-title">Please wait…</div>
            <div class="processing-sub">Unverified: We are sending OTP on your email.</div>
        </div>
    </div>
    <div class="main-container">
        <div class="login-card">
            <!-- Form Container -->
            <div class="form-container">
                <?php 
                    $csrf = \App\Middleware\AgentGuard::generateCsrfToken('agent_login'); 
                    $lockedUntil = (int)($_SESSION['agent_login_locked_until'] ?? 0);
                    $nowTs = time();
                    $isLocked = $lockedUntil > $nowTs;
                ?>
                
                <!-- Trust & Credibility Banner -->
                <div class="mb-6">
                    <div class="rounded-xl border border-gray-200 bg-white shadow-sm overflow-hidden">
                        <div class="px-4 py-3 bg-gradient-to-r from-primary-500 to-primary-600 text-white flex items-center gap-3">
                            <div class="h-8 w-8 rounded-lg bg-white/20 flex items-center justify-center">
                                <i class="fas fa-shield-alt text-white"></i>
                            </div>
                            <div>
                                <div class="text-sm font-semibold tracking-wide">
                                    B2B Thai Hub — Powering Travel Businesses Since 2015
                                </div>
                                <div class="text-xs opacity-90">Secure, reliable, and built for agency operations</div>
                            </div>
                        </div>
                        <div class="p-4">
                            <div class="grid grid-cols-2 gap-3 text-sm">
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-lock text-primary-600"></i>
                                    <span class="text-gray-700">Enterprise security</span>
                                </div>
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-check-circle text-primary-600"></i>
                                    <span class="text-gray-700">10+ years of uptime</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Error Messages -->
                <?php if (!empty($_SESSION['agent_login_success'])): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle alert-icon"></i>
                        <div>
                            <div class="font-medium">Your email is verified</div>
                            <div><?= htmlspecialchars((string)$_SESSION['agent_login_success']) ?></div>
                        </div>
                    </div>
                    <?php unset($_SESSION['agent_login_success']); ?>
                <?php endif; ?>

                <?php if (!empty($_SESSION['agent_login_error'])): ?>
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-triangle alert-icon"></i>
                        <span><?= htmlspecialchars((string)$_SESSION['agent_login_error']) ?></span>
                    </div>
                    <?php unset($_SESSION['agent_login_error']); ?>
                <?php endif; ?>

                <?php if ($isLocked): ?>
                    <div class="alert alert-warning">
                        <i class="fas fa-lock alert-icon"></i>
                        <div>
                            <div class="font-medium">Account temporarily locked</div>
                            <div>Too many attempts. Try again in <span id="lock-countdown" class="font-semibold">--:--</span></div>
                        </div>
                    </div>
                <?php endif; ?>

                <form method="post" action="/b2b/agent/login">
                    <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf) ?>">
                    
                    <!-- Email Field -->
                    <div class="form-group">
                        <label for="email" class="form-label">
                            Email Address <span class="required-asterisk">*</span>
                        </label>
                        <div class="input-group">
                            <input 
                                id="email"
                                name="email" 
                                type="email" 
                                required 
                                class="form-input"
                                placeholder="Enter your email address"
                            />
                            <i class="fas fa-envelope input-icon"></i>
                        </div>
                    </div>

                    <!-- Password Field -->
                    <div class="form-group">
                        <label for="password" class="form-label">
                            Password <span class="required-asterisk">*</span>
                        </label>
                        <div class="input-group">
                            <input 
                                id="password"
                                name="password" 
                                type="password" 
                                required 
                                class="form-input"
                                placeholder="Enter your password"
                            />
                            <i class="fas fa-eye-slash input-icon" onclick="togglePassword(this)"></i>
                        </div>
                    </div>

                    <!-- Remember Me & Forgot Password -->
                    <div class="flex items-center justify-between mb-6">
                        <label class="flex items-center gap-2 text-sm text-gray-600 cursor-pointer">
                            <input type="checkbox" class="w-4 h-4 text-primary-600 border-gray-300 rounded focus:ring-primary-500" disabled>
                            <span>Remember me</span>
                        </label>
                        <a href="#" class="text-sm text-primary-600 hover:text-primary-700 font-medium cursor-not-allowed" title="Coming soon">
                            Forgot password?
                        </a>
                    </div>

                    <!-- Login Button -->
                    <button 
                        type="submit"
                        id="loginButton"
                        class="btn btn-primary btn-full"
                    >
                        <span id="loginBtnLabel">
                            <i class="fas fa-sign-in-alt"></i>
                            Access Dashboard
                        </span>
                        <span id="loginBtnLoading" class="hidden">
                            <div class="spinner"></div>
                            Signing in...
                        </span>
                    </button>

                    <!-- Forgot Password Link -->
                    <div class="mt-4 text-center">
                        <a href="/b2b/agent/forgot-password" class="text-sm text-blue-600 hover:text-blue-800 hover:underline cursor-pointer">
                            <i class="fas fa-key mr-1"></i> Forgot your password?
                        </a>
                    </div>

                    <!-- Sign Up CTA -->
                    <div class="mt-6 text-center">
                        <p class="text-sm text-gray-600 mb-3">New to the portal?</p>
                        <a href="/agent/register" class="btn btn-secondary btn-full">
                            <i class="fas fa-user-plus"></i>
                            Create Agent Account
                        </a>
                    </div>
                </form>
            </div>
            
        </div>
    </div>
    <?php include __DIR__ . '/../partials/public_footer.php'; ?>

    <?php include __DIR__ . '/../partials/pwa_install_js.php'; ?>
    <script>
        // Password visibility toggle
        function togglePassword(icon) {
            const input = icon.closest('.input-group').querySelector('input');
            const isPassword = input.type === 'password';
            
            input.type = isPassword ? 'text' : 'password';
            icon.className = isPassword 
                ? 'fas fa-eye input-icon'
                : 'fas fa-eye-slash input-icon';
        }

        // Loading state on submit
        document.addEventListener('DOMContentLoaded', function() {
            // Show small install button near header for mobile
            try{
                const header = document.querySelector('.brand-header');
                if (header && !document.getElementById('pwaInstallBtn')){
                    const c = document.createElement('div');
                    c.className = 'text-right mt-2';
                    c.innerHTML = '<button id="pwaInstallBtn" onclick="installAgentPWA()" class="hidden md:inline-flex items-center gap-2 px-3 py-1.5 rounded-lg text-xs font-semibold text-white bg-black/20 hover:bg-black/30" style="display:none"><i class="fas fa-download"></i> Install App</button>';
                    header.appendChild(c);
                }
            }catch(_){ }
            const form = document.querySelector('form[action="/b2b/agent/login"]');
            const btn = document.getElementById('loginButton');
            const label = document.getElementById('loginBtnLabel');
            const loading = document.getElementById('loginBtnLoading');
            
            if (form && btn) {
                form.addEventListener('submit', function(){
                    btn.disabled = true;
                    if (label) label.classList.add('hidden');
                    if (loading) loading.classList.remove('hidden');
                    // Show full-page overlay immediately; server may take 5-10s to send OTP
                    const overlay = document.getElementById('processingOverlay');
                    if (overlay) overlay.style.display = 'flex';
                });
            }
            
            // Lockout countdown
            const lockedUntil = <?= json_encode($lockedUntil) ?>;
            const nowTs = Math.floor(Date.now() / 1000);
            if (lockedUntil && lockedUntil > nowTs) {
                const span = document.getElementById('lock-countdown');
                // We keep form enabled so admin unlock works immediately.
                
                function updateCountdown(){
                    const now = Math.floor(Date.now() / 1000);
                    const diff = Math.max(0, lockedUntil - now);
                    const m = Math.floor(diff / 60).toString().padStart(2,'0');
                    const s = Math.floor(diff % 60).toString().padStart(2,'0');
                    if (span) span.textContent = m + ':' + s;
                    if (diff <= 0) { window.location.reload(); }
                }
                
                updateCountdown();
                setInterval(updateCountdown, 1000);
            }
        });
    </script>
</body>
</html>

