<?php
// app/Views/agent/auth/forgot_password.php
$title = $title ?? 'Forgot Password';
?>
<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <meta name="theme-color" content="#0d79c7">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="B2B Thai Hub">
    <meta name="application-name" content="B2B Thai Hub">
    <meta name="format-detection" content="telephone=no,email=no,address=no">
    <title><?= htmlspecialchars($title) ?> - B2B Agent Portal</title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Manifest for PWA -->
    <link rel="manifest" href="/manifest.webmanifest">
    
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=JetBrains+Mono:wght@400;500&display=swap" rel="stylesheet">
    
    <style>
        /* Reuse styles from login page */
        :root {
            --primary-50: #e6f4ff;
            --primary-100: #cce9ff;
            --primary-200: #99d3ff;
            --primary-300: #66beff;
            --primary-400: #33a8ff;
            --primary-500: #008cff;
            --primary-600: #0077e6;
            --primary-700: #0063c7;
            --primary-800: #004f9e;
            --primary-900: #103b73;
            
            --gray-50: #f8fafc;
            --gray-100: #f1f5f9;
            --gray-200: #e2e8f0;
            --gray-300: #cbd5e1;
            --gray-400: #94a3b8;
            --gray-500: #64748b;
            --gray-600: #475569;
            --gray-700: #334155;
            --gray-800: #1e293b;
            --gray-900: #0f172a;
        }
        
        * { box-sizing: border-box; }
        body { 
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background-color: #f8fafc;
            color: #1e293b;
            line-height: 1.5;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        
        .main-container {
            flex: 1;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 1rem;
            background-color: #f8fafc;
        }
        
        .login-card {
            background: white;
            border-radius: 1rem;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            width: 100%;
            max-width: 28rem;
            overflow: hidden;
            border: 1px solid var(--gray-200);
        }
        
        .form-container {
            padding: 2.5rem;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-label {
            display: block;
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--gray-700);
            margin-bottom: 0.5rem;
        }
        
        .form-input {
            width: 100%;
            padding: 0.75rem 1rem;
            font-size: 0.9375rem;
            border: 1px solid var(--gray-300);
            border-radius: 0.5rem;
            background-color: white;
            transition: border-color 0.15s, box-shadow 0.15s;
        }
        
        .form-input:focus {
            outline: none;
            border-color: var(--primary-500);
            box-shadow: 0 0 0 3px rgba(0, 140, 255, 0.1);
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 0.75rem 1.5rem;
            font-size: 0.9375rem;
            font-weight: 500;
            border-radius: 0.5rem;
            cursor: pointer;
            transition: all 0.2s;
            text-decoration: none;
            border: none;
        }
        
        .btn-primary {
            background-color: var(--primary-600);
            color: white;
        }
        
        .btn-primary:hover {
            background-color: var(--primary-700);
        }
        
        .btn-block {
            display: block;
            width: 100%;
        }
        
        .page-header {
            background: linear-gradient(135deg, var(--primary-500), var(--primary-700));
            color: white;
            padding: 1.5rem 2rem;
            text-align: center;
        }
        
        .page-title {
            font-size: 1.5rem;
            font-weight: 700;
            margin: 0 0 0.5rem;
        }
        
        .page-subtitle {
            font-size: 0.9375rem;
            opacity: 0.9;
            margin: 0;
        }
        
        .alert {
            padding: 1rem;
            border-radius: 0.5rem;
            margin-bottom: 1.5rem;
            font-size: 0.9375rem;
        }
        
        .alert-success {
            background-color: #ecfdf5;
            color: #065f46;
            border-left: 4px solid #10b981;
        }
        
        .alert-error {
            background-color: #fef2f2;
            color: #b91c1c;
            border-left: 4px solid #dc2626;
        }
        
        .text-center {
            text-align: center;
        }
        
        .mt-4 {
            margin-top: 1rem;
        }
        
        .text-primary-600 {
            color: #2563eb;
        }
        
        .hover\:text-primary-800:hover {
            color: #1e40af;
        }
        
        .hover\:underline:hover {
            text-decoration: underline;
        }
        
        .text-sm {
            font-size: 0.875rem;
        }
        
        @media (max-width: 640px) {
            .form-container {
                padding: 1.5rem;
            }
            
            .page-header {
                padding: 1.25rem 1.5rem;
            }
        }
        
        /* Loading spinner */
        .spinner {
            width: 1.25rem;
            height: 1.25rem;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
            display: inline-block;
            vertical-align: middle;
            margin-right: 0.5rem;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        .hidden {
            display: none;
        }
    </style>
</head>
<body>
    <div class="main-container">
        <div class="login-card">
            <!-- Header -->
            <div class="page-header">
                <h1 class="page-title">Reset Your Password</h1>
                <p class="page-subtitle">Enter your email to receive a password reset link</p>
            </div>
            
            <!-- Form Container -->
            <div class="form-container">
                <?php if (!empty($_SESSION['forgot_password_success'])): ?>
                    <div class="alert alert-success">
                        <i class="fas fa-check-circle"></i>
                        <span><?= htmlspecialchars($_SESSION['forgot_password_success']) ?></span>
                    </div>
                    <?php unset($_SESSION['forgot_password_success']); ?>
                <?php endif; ?>
                
                <?php if (!empty($_SESSION['forgot_password_error'])): ?>
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-triangle"></i>
                        <span><?= htmlspecialchars($_SESSION['forgot_password_error']) ?></span>
                    </div>
                    <?php unset($_SESSION['forgot_password_error']); ?>
                <?php endif; ?>
                
                <form method="post" action="/b2b/agent/forgot-password" id="forgotPasswordForm">
                    <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf_token ?? '') ?>">
                    
                    <div class="form-group">
                        <label for="email" class="form-label">Email Address</label>
                        <input 
                            type="email" 
                            id="email" 
                            name="email" 
                            class="form-input" 
                            placeholder="Enter your email address"
                            required
                        >
                    </div>
                    
                    <button type="submit" class="btn btn-primary btn-block" id="submitBtn">
                        <span id="submitBtnText">Send Reset Link</span>
                        <span id="submitBtnLoading" class="hidden">
                            <span class="spinner"></span>
                            Sending...
                        </span>
                    </button>
                </form>
                
                <div class="mt-6 text-center">
                    <a href="/b2b/agent/login" class="text-sm text-primary-600 hover:text-primary-800 hover:underline">
                        <i class="fas fa-arrow-left mr-1"></i> Back to Login
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        document.getElementById('forgotPasswordForm').addEventListener('submit', function(e) {
            const submitBtn = document.getElementById('submitBtn');
            const submitBtnText = document.getElementById('submitBtnText');
            const submitBtnLoading = document.getElementById('submitBtnLoading');
            
            // Show loading state
            submitBtn.disabled = true;
            submitBtnText.classList.add('hidden');
            submitBtnLoading.classList.remove('hidden');
        });
    </script>
</body>
</html>
