<?php
// app/Views/agent/activity_voucher.php
$title = $title ?? 'Activity Voucher';
$guest = $guest ?? [];
$paid = !empty($paid);
$booking = $booking ?? [];

// Company/env details (mirror taxi voucher style)
$company_name = trim($_ENV['COMPANY_NAME'] ?? 'So Simple Trip Co. Ltd', '"');
$powered_by = trim($_ENV['POWERED_BY'] ?? 'BookMyThai.com', '"');

// Agent details
$agent = $_SESSION['agent'] ?? null;

require __DIR__ . '/partials/header.php';
?>

<div class="min-h-screen bg-gray-50 py-8">
  <div class="max-w-4xl mx-auto px-4">

    <!-- Action Buttons -->
    <div class="flex justify-between items-center mb-6 no-print">
      <a href="/b2b/agent/activities" class="inline-flex items-center px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700 transition-colors">
        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/></svg>
        Back to Activities
      </a>
      <button onclick="window.print()" class="inline-flex items-center px-6 py-2 bg-green-600 text-white rounded-lg hover:bg-green-700 transition-colors">
        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"/></svg>
        Print/Save as PDF
      </button>
    </div>

    <!-- Boarding Pass Style Voucher -->
    <div class="bg-white rounded-lg shadow-lg overflow-hidden border-2 border-gray-300 relative">
      <!-- Airline Header -->
      <div class="bg-blue-600 text-white p-4">
        <div class="flex justify-between items-center">
          <div class="text-2xl font-bold">BOARDING PASS</div>
          <div class="text-right">
            <div class="text-sm"><?= htmlspecialchars($company_name) ?></div>
            <div class="text-xs opacity-80"><?= date('d M Y, H:i') ?></div>
          </div>
        </div>
      </div>
      
      <!-- Passenger and Booking Info -->
      <div class="p-4 border-b border-gray-200">
        <div class="grid grid-cols-3 gap-4">
          <div>
            <div class="text-xs text-gray-500 mb-1">PASSENGER</div>
            <div class="font-bold"><?= htmlspecialchars($guest['lead']['name'] ?? 'Guest') ?></div>
          </div>
          <div>
            <div class="text-xs text-gray-500 mb-1">BOOKING REF</div>
            <div class="font-mono font-bold"><?= htmlspecialchars($booking['booking_code'] ?? '') ?></div>
          </div>
          <div class="text-right">
            <div class="text-xs text-gray-500 mb-1">STATUS</div>
            <div class="font-bold text-green-600">CONFIRMED</div>
          </div>
        </div>
      </div>
      
      <!-- Activity Details -->
      <div class="p-4 border-b border-gray-200 bg-gray-50">
        <div class="grid grid-cols-2 gap-4">
          <div>
            <div class="text-xs text-gray-500 mb-1">ACTIVITY</div>
            <div class="font-bold"><?= htmlspecialchars($booking['activity_name'] ?? 'Activity') ?></div>
            <?php if (!empty($booking['variant_name'])): ?>
            <div class="text-sm text-gray-600"><?= htmlspecialchars($booking['variant_name']) ?></div>
            <?php endif; ?>
          </div>
          <div class="text-right">
            <div class="text-xs text-gray-500 mb-1">DATE & TIME</div>
            <div class="font-bold"><?= date('d M Y', strtotime($booking['activity_date'] ?? 'now')) ?></div>
            <div class="text-sm"><?= date('H:i', strtotime($booking['show_time'] ?? '12:00')) ?></div>
          </div>
        </div>
      </div>
      
      <!-- Guest Contact -->
      <div class="p-4 border-b border-gray-200">
        <div class="grid grid-cols-2 gap-4">
          <div>
            <div class="text-xs text-gray-500 mb-1">EMAIL</div>
            <div class="text-sm font-medium"><?= htmlspecialchars($guest['lead']['email'] ?? '—') ?></div>
          </div>
          <div class="text-right">
            <div class="text-xs text-gray-500 mb-1">PHONE</div>
            <div class="text-sm font-medium"><?= htmlspecialchars($guest['lead']['phone'] ?? '—') ?></div>
          </div>
        </div>
      </div>
      
      <!-- Barcode and QR Code -->
      <div class="p-4 border-b border-gray-200 bg-gray-100">
        <div class="flex justify-between items-center">
          <div class="text-center">
            <div class="text-xs text-gray-500 mb-1">SCAN TO VERIFY</div>
            <?php if (!empty($booking['booking_code'])): ?>
            <img src="https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=<?= urlencode($absolute_verify_url) ?>" 
                 alt="Verification QR Code" class="w-20 h-20 mx-auto">
            <?php endif; ?>
          </div>
          <div class="text-center">
            <div class="text-xs text-gray-500 mb-1">BOOKING REFERENCE</div>
            <?php if (!empty($booking['booking_code'])): ?>
            <img src="https://barcode.tec-it.com/barcode.ashx?data=<?= urlencode($booking['booking_code']) ?>&code=Code128&dpi=96&dataseparator=" 
                 alt="Barcode" class="h-12 mx-auto">
            <div class="text-xs font-mono mt-1"><?= htmlspecialchars($booking['booking_code']) ?></div>
            <?php endif; ?>
          </div>
        </div>
      </div>

      <!-- Guest Details -->
      <div class="p-4 border-b border-gray-200">
        <div class="flex items-center text-blue-600 mb-3">
          <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
          </svg>
          <div class="font-bold">GUEST DETAILS</div>
        </div>
        
        <div class="grid grid-cols-2 gap-4">
          <div class="bg-blue-50 p-3 rounded-lg">
            <div class="text-xs text-blue-600 mb-1">ADULTS</div>
            <div class="font-bold text-lg"><?= $adult_count ?></div>
          </div>
          
          <?php if ($child_count > 0): ?>
          <div class="bg-amber-50 p-3 rounded-lg">
            <div class="text-xs text-amber-600 mb-1">CHILDREN</div>
            <div class="font-bold text-lg"><?= $child_count ?></div>
          </div>
          <?php endif; ?>
          
          <?php if ($infant_count > 0): ?>
          <div class="bg-purple-50 p-3 rounded-lg">
            <div class="text-xs text-purple-600 mb-1">INFANTS</div>
            <div class="font-bold text-lg"><?= $infant_count ?></div>
          </div>
          <?php endif; ?>
          
          <div class="bg-gray-50 p-3 rounded-lg">
            <div class="text-xs text-gray-600 mb-1">TOTAL</div>
            <div class="font-bold text-lg"><?= $total_guests ?> Person<?= $total_guests != 1 ? 's' : '' ?></div>
          </div>
        </div>
      </div>

      <?php 
        // Decode items once for itemized section
        $items = json_decode($booking['items_json'] ?? '[]', true) ?: [];
      ?>

      <?php if (!empty($items)): ?>
      <!-- Booking Summary -->
      <div class="p-4 border-b border-gray-200">
        <div class="flex items-center text-blue-600 mb-3">
          <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
          </svg>
          <div class="font-bold">BOOKING SUMMARY</div>
        </div>
        
        <div class="space-y-3">
          <?php 
          $subtotal = 0;
          foreach ($items as $it): 
            $pkg = htmlspecialchars((string)($it['package_name'] ?? ''));
            $var = htmlspecialchars((string)($it['variant_name'] ?? ''));
            $label = htmlspecialchars((string)($it['price_name'] ?? ''));
            $qty = (int)($it['qty'] ?? 0);
            $unit = (float)($it['unit'] ?? ($it['price'] ?? 0));
            $line = $unit * $qty;
            $subtotal += $line;
          ?>
          <div class="flex justify-between items-start border-b border-gray-100 pb-2">
            <div>
              <div class="font-medium"><?= $pkg ?></div>
              <?php if ($var): ?><div class="text-xs text-gray-500"><?= $var ?></div><?php endif; ?>
              <?php if ($label): ?><div class="text-xs text-blue-600"><?= $label ?></div><?php endif; ?>
            </div>
            <div class="text-right">
              <div class="font-medium">฿<?= number_format($line, 2) ?></div>
              <div class="text-xs text-gray-500"><?= $qty ?> × ฿<?= number_format($unit, 2) ?></div>
            </div>
          </div>
          <?php endforeach; ?>
          
          <div class="pt-2 mt-2 border-t border-gray-200">
            <div class="flex justify-between font-bold">
              <span>TOTAL</span>
              <span>฿<?= number_format($subtotal, 2) ?></span>
            </div>
            <div class="text-right text-sm mt-1">
              <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?= $paid ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' ?>">
                <?= $paid ? 'PAID' : 'PENDING PAYMENT' ?>
              </span>
            </div>
          </div>
        </div>
      </div>
      <?php endif; ?>

      <!-- Important Information -->
      <div class="p-4 border-b border-gray-200">
        <div class="flex items-center text-red-600 mb-3">
          <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z" />
          </svg>
          <div class="font-bold">IMPORTANT INFORMATION</div>
        </div>
        
        <ul class="text-sm text-gray-700 space-y-2 list-disc pl-5">
          <li>Please present this voucher (digital or printed) at the activity check-in</li>
          <li>Valid only for the date and time specified above</li>
          <li>Please arrive at least 15 minutes before the scheduled start time</li>
          <li>No refunds for no-shows or late arrivals</li>
          <li>Changes must be made at least 24 hours in advance</li>
          <li>Please bring a valid photo ID matching the booking name</li>
        </ul>
        
        <?php if (!empty($guest['notes'])): ?>
        <div class="mt-4 p-3 bg-yellow-50 border-l-4 border-yellow-400 rounded-r">
          <div class="flex">
            <div class="flex-shrink-0">
              <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
              </svg>
            </div>
            <div class="ml-3">
              <h3 class="text-sm font-medium text-yellow-800">Special Request</h3>
              <div class="mt-1 text-sm text-yellow-700">
                <?= nl2br(htmlspecialchars($guest['notes'])) ?>
              </div>
            </div>
          </div>
        </div>
        <?php endif; ?>
        
        <div class="mt-6 pt-4 border-t border-gray-200 text-center">
          <div class="text-xs text-gray-500 mb-2">Need assistance? Contact our support team</div>
          <div class="flex flex-col sm:flex-row justify-center items-center space-y-2 sm:space-y-0 sm:space-x-6">
            <div class="flex items-center">
              <svg class="h-4 w-4 text-gray-500 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
              </svg>
              <span class="text-sm font-medium"><?= htmlspecialchars($agent['email'] ?? 'support@example.com') ?></span>
            </div>
            <div class="flex items-center">
              <svg class="h-4 w-4 text-gray-500 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
              </svg>
              <span class="text-sm font-medium"><?= !empty($agent['phone']) ? htmlspecialchars($agent['phone']) : '+66 XX XXX XXXX' ?></span>
            </div>
          </div>
          
          <div class="mt-4 pt-3 border-t border-gray-100">
            <div class="text-xs text-gray-500">
              Powered by <span class="font-medium"><?= htmlspecialchars($powered_by) ?></span>
            </div>
          </div>
        </div>
      </div>

      <!-- Booked by Agency -->
      <div class="p-6 border-b border-gray-200 bg-gradient-to-r from-blue-50 to-indigo-50 border-l-4 border-l-blue-500">
        <h3 class="font-bold text-gray-800 mb-4 flex items-center">
          <svg class="w-5 h-5 text-blue-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1" />
          </svg>
          Booked by Agency
        </h3>
        <div class="bg-white rounded-lg p-4 shadow-sm border border-blue-200 relative">
          <div class="space-y-3">
            <div class="flex items-center">
              <span class="text-sm text-gray-600 w-28">Agency Name:</span>
              <span class="font-semibold text-gray-800"><?= htmlspecialchars((string)($booking['agency_name'] ?? $agent['name'] ?? $agent['company_name'] ?? 'Agency')) ?></span>
            </div>
            <div class="flex items-center">
              <span class="text-sm text-gray-600 w-28">Contact:</span>
              <span class="font-semibold text-gray-800"><?= htmlspecialchars((string)($booking['agent_mobile'] ?? $agent['mobile'] ?? $agent['phone'] ?? '')) ?></span>
            </div>
            <div class="flex items-center">
              <span class="text-sm text-gray-600 w-28">Email ID:</span>
              <span class="font-semibold text-blue-600"><?= htmlspecialchars((string)($booking['agent_email'] ?? $agent['email'] ?? '')) ?></span>
            </div>
          </div>
        </div>
      </div>

      <!-- Terms & Conditions -->
      <div class="p-6 bg-gradient-to-b from-white to-gray-50">
        <h3 class="font-bold text-gray-800 mb-4 flex items-center">
          <svg class="w-5 h-5 text-blue-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
          </svg>
          Terms & Conditions
        </h3>
        <ul class="space-y-2 text-sm text-gray-700 bg-white p-4 rounded-lg border border-gray-100 shadow-sm">
          <li>• Present this voucher at the venue entrance for admission.</li>
          <li>• Strictly follow date/time printed on the voucher; changes subject to availability.</li>
          <li>• No show or late arrival may result in denial of entry without refund.</li>
          <li>• Operator terms and local regulations apply.</li>
        </ul>
        <div class="mt-6 pt-4 border-t border-gray-200 text-center">
          <p class="text-xs text-gray-500">Keep this voucher handy. Contact your agency for any changes.</p>
        </div>
      </div>
    </div>
  </div>
</div>

<?php if (!empty($booking['booking_code'])): ?>
<?php
  // Simple QR (using existing /verify?code=...) for now
  $code = (string)$booking['booking_code'];
  $verifyRel = '/verify?code=' . urlencode($code);
  $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
  $verifyAbs = $scheme . '://' . $host . $verifyRel;
  $qr_img_url = 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=' . urlencode($verifyAbs);
?>
<script>
(function(){
  var el = document.getElementById('qrcode');
  if (!el) return;
  el.innerHTML = '';
  var img = document.createElement('img');
  img.src = <?= json_encode($qr_img_url) ?>;
  img.alt = 'Scan to Verify';
  img.width = 120; img.height = 120;
  el.appendChild(img);
})();
</script>
<script src="https://cdn.jsdelivr.net/npm/bwip-js@3.0.9/dist/bwip-js-min.js"></script>
<script>
(function(){
  try {
    var canvas = document.getElementById('barcode');
    if (canvas && window.BWIPJS) {
      BWIPJS.toCanvas(canvas, {
        bcid: 'code128',
        text: <?= json_encode($code) ?>,
        scale: 2,
        height: 10,
        includetext: false,
        textxalign: 'center'
      });
    }
  } catch (e) { /* ignore */ }
})();
</script>
<?php endif; ?>

<style>
@media print {
  @page { size: A4; margin: 15mm 10mm 15mm 10mm; }
  * { -webkit-print-color-adjust: exact !important; print-color-adjust: exact !important; }
  .no-print, header, nav, footer { display:none !important; }
  .voucher-container { width:100% !important; max-width:100% !important; box-shadow:none !important; border:none !important; }
  .price-hide { display:none !important; }
}
</style>

<?php require __DIR__ . '/partials/footer.php'; ?>
