<?php
// app/Views/agent/activity_verify.php
// PUBLIC page (no login). Styled similar to taxi_verify.php
$title = $title ?? 'Activity Booking Verification';
$code = (string)($code ?? '');
$result = $result ?? null; // array|null built in controller
$valid = is_array($result) && !empty($result['booking_code']);
$status = strtolower((string)($result['status'] ?? ''));
$paid = strtolower((string)($result['payment_status'] ?? '')) === 'paid';

// Basic app/company info for footer and issuer
$appName = trim($_ENV['COMPANY_NAME'] ?? 'BookMyThai', '"');
$companyName = trim($_ENV['COMPANY_NAME'] ?? 'So Simple Trip Co. Ltd', '"');
$tatLicense = trim($_ENV['TAT_LICENSE'] ?? ($_ENV['TAT_LICENSE_NO'] ?? '13/03289'), '"');
$supportEmail = trim($_ENV['SUPPORT_EMAIL'] ?? 'support@bookmythai.com', '"');
$supportPhone = trim($_ENV['SUPPORT_PHONE'] ?? '+66 123 4567', '"');

$activityName = (string)($result['package_name'] ?? 'Activity Experience');
$activityDate = (string)($result['activity_date'] ?? '');
$showTime = (string)($result['show_time'] ?? '');
$customerName = (string)($result['customer_name'] ?? '—');
$amount = isset($result['amount_total']) ? (float)$result['amount_total'] : 0.0;
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?= htmlspecialchars($title) ?></title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    :root {
      --primary: #2563EB;
      --primary-dark: #1E40AF;
      --primary-light: #DBEAFE;
      --success: #10B981;
      --error: #EF4444;
      --warning: #F59E0B;
      --text-primary: #111827;
      --text-secondary: #4B5563;
      --text-muted: #6B7280;
      --border: #E5E7EB;
      --bg-light: #F9FAFB;
      --white: #FFFFFF;
    }
    * { margin: 0; padding: 0; box-sizing: border-box; }
    body { font-family: 'Inter', system-ui, -apple-system, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, 'Noto Sans', 'Liberation Sans', sans-serif; background: var(--bg-light); color: var(--text-primary); line-height: 1.5; padding: 20px; }
    .container { max-width: 600px; margin: 0 auto; background: var(--white); border-radius: 12px; overflow: hidden; box-shadow: 0 1px 3px rgba(0,0,0,0.1); }
    .header { background: var(--primary); color: #fff; padding: 24px; text-align: center; }
    .logo { max-width: 180px; margin-bottom: 16px; }
    .title { font-size: 20px; font-weight: 600; margin-bottom: 8px; }
    .subtitle { font-size: 14px; opacity: 0.9; font-weight: 400; }
    .content { padding: 32px; }
    .verification-badge { text-align: center; margin-bottom: 28px; }
    .verification-icon { width: 80px; height: 80px; background: var(--primary-light); border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 14px; }
    .verification-icon svg { width: 40px; height: 40px; color: var(--primary); }
    .verification-text { font-size: 20px; font-weight: 600; color: var(--text-primary); margin-bottom: 6px; }
    .verification-subtext { font-size: 14px; color: var(--text-secondary); margin-bottom: 20px; }
    .details-card { background: var(--bg-light); border-radius: 8px; padding: 20px; margin-bottom: 20px; }
    .detail-row { display: flex; justify-content: space-between; padding: 12px 0; border-bottom: 1px solid var(--border); }
    .detail-row:last-child { border-bottom: none; }
    .detail-label { color: var(--text-secondary); font-size: 14px; }
    .detail-value { font-weight: 500; text-align: right; }
    .qr-code { text-align: center; margin: 24px 0; }
    .qr-code img { max-width: 180px; border: 1px solid var(--border); border-radius: 8px; padding: 12px; }
    .footer { text-align: center; padding: 20px; color: var(--text-muted); font-size: 12px; border-top: 1px solid var(--border); }
    .status-badge { display: inline-block; padding: 4px 12px; border-radius: 12px; font-size: 12px; font-weight: 500; background: var(--primary-light); color: var(--primary); }
    .status-badge.paid { background: #D1FAE5; color: #065F46; }
    .status-badge.cancelled { background: #FEE2E2; color: #991B1B; }
    @media (max-width: 480px) { .content { padding: 24px 16px; } .detail-row { flex-direction: column; gap: 4px; } .detail-value { text-align: left; } }
  </style>
</head>
<body>
  <div class="container">
    <div class="header">
      <img src="https://bookmythai.com/logo.png" alt="So Simple Trip" class="logo" onerror="this.src='data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxODAiIGhlaWdodD0iNDgiIHZpZXdCb3g9IjAgMCAxODAgNDgiIGZpbGw9Im5vbmUiPgogIDxyZWN0IHdpZHRoPSIxODAiIGhlaWdodD0iNDgiIHJ4PSI0IiBmaWxsPSIjMjU2M0VCIi8+CiAgPHRleHQgeD0iMjAiIHk9IjMyIiBmb250LWZhbWlseT0iQXJpYWwiIGZvbnQtc2l6ZT0iMTYiIGZvbnQtd2VpZ2h0PSI2MDAiIGZpbGw9IndoaXRlIj5Cb29rTXlUaGFpPC90ZXh0PgogIDx0ZXh0IHg9IjIwIiB5PSIxNiIgZm9udC1mYW1pbHk9IkFyaWFsIiBmb250LXNpemU9IjI0IiBmb250LXdlaWdodD0iYm9sZCIgZmlsbD0id2hpdGUiPkFjdGl2aXR5PC90ZXh0Pgo8L3N2Zz4='">
      <h1 class="title">Official Booking Verification</h1>
      <p class="subtitle">Verify your booking details below</p>
    </div>

    <div class="content">
      <?php if ($valid): ?>
        <div class="verification-badge">
          <div class="verification-icon" <?= $status === 'cancelled' ? 'style="background:#FEE2E2;"' : '' ?>>
            <?php if ($status === 'cancelled'): ?>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="#DC2626"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
            <?php else: ?>
              <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
            <?php endif; ?>
          </div>
          <h2 class="verification-text"><?= $status === 'cancelled' ? 'Booking Cancelled' : 'Booking Verified' ?></h2>
          <p class="verification-subtext">Your booking has been successfully verified with our system</p>
        </div>

        <div class="details-card">
          <div class="detail-row"><span class="detail-label">Voucher ID</span><span class="detail-value"><?= htmlspecialchars($code) ?></span></div>
          <div class="detail-row"><span class="detail-label">Activity</span><span class="detail-value"><?= htmlspecialchars($activityName) ?></span></div>
          <div class="detail-row"><span class="detail-label">Lead Guest</span><span class="detail-value"><?= htmlspecialchars($customerName) ?></span></div>
          <div class="detail-row"><span class="detail-label">Date</span><span class="detail-value"><?= $activityDate ? htmlspecialchars(date('d M Y', strtotime($activityDate))) : '—' ?></span></div>
          <?php if ($showTime !== ''): ?>
          <div class="detail-row"><span class="detail-label">Show Time</span><span class="detail-value"><?= htmlspecialchars($showTime) ?></span></div>
          <?php endif; ?>
          <div class="detail-row"><span class="detail-label">Status</span><span class="detail-value"><span class="status-badge <?= $paid ? 'paid' : ($status === 'cancelled' ? 'cancelled' : '') ?>"><?= $paid ? 'Paid' : ucfirst(htmlspecialchars($result['payment_status'] ?? 'Unpaid')) ?></span></span></div>
          <?php if ($amount > 0): ?>
          <div class="detail-row"><span class="detail-label">Amount</span><span class="detail-value">THB <?= number_format($amount, 2) ?></span></div>
          <?php endif; ?>
        </div>

        <div class="qr-code">
          <?php
            // Show a QR to this page URL for on-site checks (optional)
            $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
            $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
            $selfUrl = $scheme . '://' . $host . ($_SERVER['REQUEST_URI'] ?? '');
            $qrImgUrl = 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=' . urlencode($selfUrl);
          ?>
          <img src="<?= htmlspecialchars($qrImgUrl) ?>" alt="QR Code">
        </div>

      <?php else: ?>
        <div class="verification-badge">
          <div class="verification-icon" style="background:#FEE2E2;">
            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="#EF4444"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/></svg>
          </div>
          <h2 class="verification-text">Booking Not Found</h2>
          <p class="verification-subtext">The booking code you entered is invalid or has expired</p>
        </div>
        <div class="details-card" style="text-align:center;">
          <p style="margin-bottom: 12px;">Please check the booking code and try again, or contact our support team for assistance.</p>
          <p>Booking Code: <strong><?= htmlspecialchars($code) ?></strong></p>
        </div>
      <?php endif; ?>
    </div>

    <div class="footer">
      <p>Verified by <?= htmlspecialchars($companyName) ?></p>
      <p>TAT License No. <?= htmlspecialchars($tatLicense) ?></p>
      <p>Need Help? <?= htmlspecialchars($supportEmail) ?> • <?= htmlspecialchars($supportPhone) ?></p>
    </div>
  </div>
</body>
</html>
