<?php
// app/Views/agent/activity_success.php
$title = $title ?? 'Payment Successful';
$booking = $booking ?? [];
$bookingId = (int)($booking['id'] ?? ($_GET['id'] ?? 0));
$bookingCode = (string)($booking['booking_code'] ?? ($_GET['code'] ?? ''));
$token = (string)($_GET['token'] ?? '');
require __DIR__ . '/partials/header.php';
?>
<div class="min-h-screen bg-gradient-to-br from-green-50 via-white to-emerald-50">
  <div class="max-w-3xl mx-auto px-4 py-10">
    <div class="bg-white border border-emerald-200 rounded-2xl shadow-md p-8">
      <div class="flex items-start gap-4">
        <div class="w-12 h-12 flex items-center justify-center rounded-full bg-emerald-500 text-white">
          <svg class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
        </div>
        <div>
          <h1 class="text-2xl font-bold text-emerald-900">Payment Successful</h1>
          <p class="text-sm text-emerald-700 mt-1">Your booking has been confirmed. You can view the voucher or open the booking details.</p>
        </div>
      </div>

      <div class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-4">
        <div class="bg-emerald-50 rounded-lg p-4 border border-emerald-100">
          <div class="text-xs text-emerald-700">Booking Code</div>
          <div class="text-lg font-bold text-emerald-900"><?= htmlspecialchars($bookingCode) ?></div>
        </div>
        <div class="bg-emerald-50 rounded-lg p-4 border border-emerald-100">
          <div class="text-xs text-emerald-700">Reference</div>
          <div class="text-lg font-semibold text-emerald-900">#<?= (int)$bookingId ?></div>
        </div>
      </div>

      <div class="mt-8 flex flex-col sm:flex-row gap-3">
        <a href="/b2b/agent/activity/voucher?id=<?= (int)$bookingId ?>&code=<?= urlencode($bookingCode) ?>&token=<?= urlencode($token) ?>" class="px-6 py-3 rounded-lg bg-emerald-600 text-white font-semibold shadow hover:bg-emerald-700 text-center">View Voucher</a>
        <a href="/b2b/agent/activity/booking/view?id=<?= (int)$bookingId ?>" class="px-6 py-3 rounded-lg bg-white border border-slate-300 text-slate-800 font-semibold hover:bg-slate-50 text-center">View Booking Details</a>
        <a href="/b2b/agent/activities" class="px-6 py-3 rounded-lg bg-white border border-slate-300 text-slate-800 font-semibold hover:bg-slate-50 text-center">Back to Activities</a>
      </div>

      <div class="mt-6 text-xs text-slate-500">
        Tip: You can always access the voucher from Bookings later.
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/partials/footer.php'; ?>
