<?php
// app/Views/agent/activity_payment.php
$title = $title ?? 'Activity Payment';
$guest = $guest ?? [];
$amount = $amount ?? 0.0;
$currency = $currency ?? 'THB';
$csrf_pay = $csrf_pay ?? '';
$pax_total = isset($pax_total) ? (int)$pax_total : 0;
$summary_title = isset($summary_title) && $summary_title !== '' ? (string)$summary_title : 'Activity Booking';
$booking_preview = isset($booking_preview) ? (string)$booking_preview : '';
require __DIR__ . '/partials/header.php';
?>

<?php
  // Map error codes to friendly messages
  $err = (string)($_GET['err'] ?? '');
  $errMsg = '';
  $left = isset($_GET['left']) ? (int)$_GET['left'] : null;
  switch ($err) {
    case 'csrf': $errMsg = 'Your session expired. Please refresh and try again.'; break;
    case 'pin': $errMsg = 'Invalid PIN. Please enter a 4–6 digit numeric PIN.'; break;
    case 'pin_not_set': $errMsg = 'Transaction PIN is not set for your account. Set a PIN in Profile > Security to use wallet payments.'; break;
    case 'pin_invalid': $errMsg = 'Incorrect PIN.' . ($left !== null ? (' Attempts left: ' . $left) : ''); break;
    case 'pin_locked': $errMsg = 'Your wallet is locked for 24 hours due to too many incorrect PIN attempts.'; break;
    case 'wallet_locked': $errMsg = 'Your wallet is temporarily locked. Please try again later or use another payment method.'; break;
    case 'gateway_not_configured': $errMsg = 'Card payment is not available. Please contact support or choose wallet.'; break;
    case 'cancelled': $errMsg = 'Payment was cancelled.'; break;
    case 'amount': $errMsg = 'Payment amount validation failed. Please re-check your selections.'; break;
    case 'verify_mismatch': $errMsg = 'Amount verification mismatch. Please go back and re-check your booking details.'; break;
    case 'ledger': $errMsg = 'We could not process your wallet payment. Please try again or choose another method.'; break;
    case 'insufficient_funds': $errMsg = 'Insufficient wallet balance. Please <a href="/b2b/agent/wallet" class="underline">top up your wallet</a> or choose another payment method.'; break;
    case 'exception': $errMsg = 'An unexpected error occurred. Please try again.'; break;
  default: $errMsg = '';
  }
?>

<?php if ($errMsg !== ''): ?>
  <div class="max-w-5xl mx-auto px-4 pt-4">
{{ ... }}
    <div class="bg-red-50 border border-red-200 text-red-700 rounded-lg p-3 text-sm">
      <?= htmlspecialchars($errMsg) ?>
      <?php if ($err === 'insufficient_funds'): ?>
        <div class="mt-2 text-xs text-rose-700">
          <a href="/b2b/agent/wallet" class="underline">Top up wallet</a> or <a href="#" onclick="document.getElementById('card_payment').checked=true;return false;" class="underline">pay by card</a>.
        </div>
      <?php endif; ?>
    </div>
  </div>
<?php endif; ?>

<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50">
  <div class="max-w-5xl mx-auto px-4 py-8">
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
      <div class="lg:col-span-1">
        <div class="bg-gradient-to-br from-white to-slate-50 rounded-2xl shadow-xl border border-slate-200 p-6 sticky top-6">
          <div class="flex items-center gap-3 mb-6">
            <div class="w-10 h-10 bg-gradient-to-r from-emerald-500 to-green-500 rounded-full flex items-center justify-center">
              <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
              </svg>
            </div>
            <div>
              <h2 class="text-lg font-bold text-slate-900">Payment Summary</h2>
              <p class="text-xs text-slate-600">Secure & Instant</p>
            </div>
          </div>
          <!-- Info blocks like taxi -->
          <div class="grid grid-cols-2 gap-2 mb-4 text-xs">
            <div class="col-span-2">
              <div class="bg-white border rounded-lg px-3 py-2 flex items-center justify-between">
                <span class="text-slate-500">BOOKING CODE</span>
                <span class="font-semibold text-slate-800">Will be issued after payment</span>
              </div>
            </div>
            <div class="col-span-2">
              <div class="bg-white border rounded-lg px-3 py-2 flex items-center justify-between">
                <span class="text-slate-500">ACTIVITY</span>
                <span class="font-semibold text-slate-800 text-right truncate max-w-[60%]" title="<?= htmlspecialchars($summary_title) ?>"><?= htmlspecialchars($summary_title) ?></span>
              </div>
            </div>
            <div>
              <div class="bg-white border rounded-lg px-3 py-2 flex items-center justify-between">
                <span class="text-slate-500">PAX</span>
                <span class="font-semibold text-slate-800"><?= (int)$pax_total ?></span>
              </div>
            </div>
            <div>
              <div class="bg-white border rounded-lg px-3 py-2 flex items-center justify-between">
                <span class="text-slate-500">DATE</span>
                <?php $rawDate = (string)($guest['date'] ?? ''); $prettyDate = $rawDate !== '' ? date('D M d Y', strtotime($rawDate)) : '—'; ?>
                <span class="font-semibold text-slate-800"><?= htmlspecialchars($prettyDate) ?></span>
              </div>
            </div>
          </div>
          <div class="bg-gradient-to-r from-red-500 to-rose-500 rounded-xl p-4 text-center text-white">
            <div class="text-sm opacity-90 mb-1">Total Amount</div>
            <div class="text-3xl font-black"><?= htmlspecialchars($currency) ?> <?= number_format((float)$amount, 2) ?></div>
            <div class="text-xs opacity-75 mt-2"><span class="bg-white bg-opacity-20 px-2 py-1 rounded-full">Payment Due</span></div>
          </div>
        </div>
      </div>

      <div class="lg:col-span-2">
        <div class="bg-gradient-to-br from-white to-slate-50 rounded-2xl shadow-xl border border-slate-200 p-8">
          <div class="flex items-center gap-3 mb-6">
            <div class="w-10 h-10 bg-gradient-to-r from-blue-500 to-indigo-500 rounded-full flex items-center justify-center">
              <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z"/>
              </svg>
            </div>
            <div>
              <h2 class="text-xl font-bold text-slate-900">Booking Details</h2>
              <p class="text-xs text-slate-600">Lead Traveler</p>
            </div>
          </div>

          <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
            <div class="space-y-3">
              <div>
                <div class="text-xs text-slate-500">Name</div>
                <div class="text-sm font-medium text-slate-900"><?= htmlspecialchars((string)($guest['lead']['name'] ?? '—')) ?></div>
              </div>
              <div>
                <div class="text-xs text-slate-500">Email</div>
                <div class="text-sm font-medium text-slate-900 break-all"><?= htmlspecialchars((string)($guest['lead']['email'] ?? '—')) ?></div>
              </div>
              <div>
                <div class="text-xs text-slate-500">Phone</div>
                <div class="text-sm font-medium text-slate-900"><?= htmlspecialchars((string)($guest['lead']['phone'] ?? '—')) ?></div>
              </div>
            </div>
            <div class="space-y-3">
              <div>
                <div class="text-xs text-slate-500">Date</div>
                <div class="text-sm font-medium text-slate-900"><?= htmlspecialchars((string)($guest['date'] ?? '—')) ?></div>
              </div>
              <div>
                <div class="text-xs text-slate-500">Show Time</div>
                <div class="text-sm font-medium text-slate-900"><?= htmlspecialchars((string)($guest['show_time'] ?? '—')) ?></div>
              </div>
            </div>
          </div>

          <?php if (!empty($_GET['err'])): ?>
            <div class="alert alert-error mb-4">There was a problem: <?= htmlspecialchars((string)$_GET['err']) ?></div>
          <?php endif; ?>

          <div class="border-t border-slate-200 pt-6">
            <h3 class="text-lg font-bold text-slate-900 mb-4">Choose Payment Method</h3>
            <form id="activityPayForm" method="post" action="/b2b/agent/activity/pay" class="space-y-6" onsubmit="return handlePaySubmit(event)">
              <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrf_pay) ?>">

              <div class="space-y-3">
                <label class="flex items-center p-4 border border-slate-300 rounded-lg cursor-pointer hover:bg-slate-50 transition-colors">
                  <input type="radio" name="method" value="wallet" id="wallet_payment" class="w-4 h-4 text-blue-600">
                  <div class="ml-3 flex-1">
                    <div class="text-sm font-medium text-slate-900">Wallet Payment</div>
                    <div class="text-xs text-slate-500">Pay using your agent wallet balance</div>
                  </div>
                  <svg class="w-5 h-5 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 003 3z"/></svg>
                </label>
                <div id="walletPinBlock" class="hidden"></div>
                <label class="flex items-center p-4 border border-slate-300 rounded-lg cursor-pointer hover:bg-slate-50 transition-colors">
                  <input type="radio" name="method" value="gateway" id="card_payment" class="w-4 h-4 text-blue-600">
                  <div class="ml-3 flex-1">
                    <div class="text-sm font-medium text-slate-900">Credit/Debit Card</div>
                    <div class="text-xs text-slate-500">Pay securely with your card</div>
                  </div>
                  <svg class="w-5 h-5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 003 3z"/></svg>
                </label>
              </div>

              <div class="flex gap-3 pt-4">
                <a href="/b2b/agent/activity/checkout" class="px-6 py-3 border border-slate-300 text-slate-700 rounded-lg hover:bg-slate-50 transition-colors font-medium">Back</a>
                <button type="submit" id="payNowBtn" class="flex-1 px-8 py-3 bg-gradient-to-r from-emerald-500 to-green-500 hover:from-emerald-600 hover:to-green-600 text-white font-bold rounded-lg shadow-md hover:shadow-lg transition-all duration-300">
                  Pay Now - <?= htmlspecialchars($currency) ?> <?= number_format((float)$amount, 2) ?>
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
(function(){
  const walletRadio = document.getElementById('wallet_payment');
  const cardRadio = document.getElementById('card_payment');
  function sync(){ /* keep for potential UI toggles */ }
  [walletRadio, cardRadio].forEach(el => { if (el) el.addEventListener('change', sync); });
  sync();
})();

// Wallet PIN Modal
function qs(sel){ return document.querySelector(sel); }
function handlePaySubmit(ev){
  const method = qs('input[name=method]:checked')?.value || '';
  if (method === 'wallet') {
    const pin = qs('#walletPinInput')?.value || '';
    if (!/^\d{4,6}$/.test(pin)) {
      // Open modal to collect PIN
      openWalletModal();
      ev.preventDefault();
      return false;
    }
  }
  return true;
}
function openWalletModal(){
  const m = qs('#walletPinModal'); if (!m) return;
  m.classList.remove('hidden');
  setTimeout(()=>{ m.classList.remove('opacity-0'); qs('#walletPinInput')?.focus(); }, 0);
}
function closeWalletModal(){
  const m = qs('#walletPinModal'); if (!m) return;
  m.classList.add('opacity-0');
  setTimeout(()=>{ m.classList.add('hidden'); }, 150);
}
function submitWalletPin(){
  const pin = qs('#walletPinInput')?.value || '';
  if (!/^\d{4,6}$/.test(pin)) { qs('#walletPinError').textContent = 'Enter a 4–6 digit PIN'; return; }
  // Place pin into a hidden input within the form
  let hid = qs('#hiddenPinField');
  if (!hid) {
    hid = document.createElement('input'); hid.type = 'hidden'; hid.name = 'pin'; hid.id = 'hiddenPinField';
    qs('#activityPayForm').appendChild(hid);
  }
  hid.value = pin;
  closeWalletModal();
  qs('#activityPayForm').submit();
}
document.addEventListener('keydown', function(e){
  if (e.key === 'Escape') closeWalletModal();
});
</script>

<!-- Wallet PIN Modal -->
<div id="walletPinModal" class="fixed inset-0 bg-black/40 backdrop-blur-sm flex items-center justify-center z-50 hidden opacity-0 transition-opacity">
  <div class="bg-white w-full max-w-sm rounded-2xl shadow-xl p-6">
    <div class="flex items-center gap-3 mb-3">
      <div class="w-10 h-10 rounded-full bg-gradient-to-r from-green-500 to-emerald-600 text-white flex items-center justify-center">
        <svg class="w-5 h-5" viewBox="0 0 24 24" fill="none" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 11c.943 0 1.706-.763 1.706-1.706V7.706C13.706 6.763 12.943 6 12 6s-1.706.763-1.706 1.706v1.588C10.294 10.237 11.057 11 12 11zM6 11h12v7a2 2 0 01-2 2H8a2 2 0 01-2-2v-7z"/></svg>
      </div>
      <div>
        <div class="text-lg font-bold text-slate-900">Secure Payment</div>
        <div class="text-xs text-slate-500">Enter your wallet PIN</div>
      </div>
    </div>
    <div class="bg-slate-50 border border-slate-200 rounded-lg p-3 mb-3">
      <div class="flex items-center justify-between text-sm">
        <div class="text-slate-600">Payment Amount</div>
        <div class="font-semibold text-slate-900"><?= htmlspecialchars($currency) ?> <?= number_format((float)$amount, 2) ?></div>
      </div>
      <div class="mt-1 text-xs text-slate-500 flex items-center justify-between">
        <span><?= htmlspecialchars($summary_title) ?></span>
        <?php $rawDate2 = (string)($guest['date'] ?? ''); $prettyDate2 = $rawDate2 !== '' ? date('D M d Y', strtotime($rawDate2)) : '—'; ?>
        <span><?= htmlspecialchars($prettyDate2) ?> <?= htmlspecialchars((string)($guest['show_time'] ?? '')) ?></span>
      </div>
    </div>
    <div class="mt-2">
      <label class="form-control">
        <span class="label-text">PIN (4–6 digits)</span>
        <input id="walletPinInput" type="password" inputmode="numeric" pattern="[0-9]{4,6}" minlength="4" maxlength="6" class="input input-bordered" placeholder="••••" />
      </label>
      <div id="walletPinError" class="text-xs text-rose-600 mt-1"></div>
    </div>
    <div class="mt-5 flex gap-2">
      <button type="button" class="px-4 py-2 rounded-lg border border-slate-300 text-slate-700 hover:bg-slate-50" onclick="closeWalletModal()">Cancel</button>
      <button type="button" class="flex-1 px-5 py-2 rounded-lg bg-gradient-to-r from-emerald-500 to-green-500 text-white font-semibold shadow hover:from-emerald-600 hover:to-green-600" onclick="submitWalletPin()">Confirm Payment</button>
    </div>
  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
