<?php
// app/Views/agent/activities.php
$title = $title ?? 'Activities';
$filters = $filters ?? ['q'=>'','city'=>'','price_min'=>'','price_max'=>'','sort'=>'best','page'=>1,'per_page'=>12];
$activities = $activities ?? [];
$partner = $partner ?? ['fixed_markup'=>null];
$pagination = $pagination ?? ['total'=>count($activities),'page'=>($filters['page']??1),'per_page'=>($filters['per_page']??12),'pages'=>1];
$active = 'activities';
require __DIR__ . '/partials/header.php';
?>

<!-- PREMIUM ACTIVITIES SEARCH PAGE -->
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-white to-blue-50/30">
  
  <!-- Compact Hero Section -->
  <div class="bg-gradient-to-r from-blue-600 to-purple-600 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
      <div class="text-center mb-6">
        <h1 class="text-2xl font-bold mb-2">Premium Activities Collection</h1>
        <p class="text-sm text-blue-100">Exciting experiences • Best rates • Instant confirmation</p>
      </div>
      
      <!-- Compact Search Form -->
      <div class="bg-white/10 backdrop-blur-sm rounded-2xl p-4 border border-white/20">
        <form method="get" class="grid grid-cols-1 md:grid-cols-5 gap-3 items-end">
          <div>
            <label class="block text-xs font-semibold text-white mb-2">DESTINATION</label>
            <input class="w-full px-3 py-2.5 bg-white/90 border-0 rounded-lg focus:ring-2 focus:ring-blue-300 text-slate-900 font-medium placeholder-slate-500 text-sm" 
                   name="city" placeholder="City or destination..." value="<?= htmlspecialchars($filters['city'] ?? '') ?>">
          </div>
          <div>
            <label class="block text-xs font-semibold text-white mb-2">ACTIVITY NAME</label>
            <input class="w-full px-3 py-2.5 bg-white/90 border-0 rounded-lg focus:ring-2 focus:ring-blue-300 text-slate-900 font-medium placeholder-slate-500 text-sm" 
                   name="q" placeholder="Search activities..." value="<?= htmlspecialchars($filters['q'] ?? '') ?>">
          </div>
          <div>
            <label class="block text-xs font-semibold text-white mb-2">SORT BY</label>
            <select class="w-full px-3 py-2.5 bg-white/90 border-0 rounded-lg focus:ring-2 focus:ring-blue-300 text-slate-900 font-medium text-sm" name="sort">
              <option value="best" <?= ($filters['sort']??'best')==='best'?'selected':'' ?>>Recommended</option>
              <option value="price_asc" <?= ($filters['sort']??'')==='price_asc'?'selected':'' ?>>Price (Low to High)</option>
              <option value="price_desc" <?= ($filters['sort']??'')==='price_desc'?'selected':'' ?>>Price (High to Low)</option>
              <option value="name_asc" <?= ($filters['sort']??'')==='name_asc'?'selected':'' ?>>Name (A-Z)</option>
            </select>
          </div>
          <div>
            <label class="block text-xs font-semibold text-white mb-2">PRICE RANGE</label>
            <input class="w-full px-3 py-2.5 bg-white/90 border-0 rounded-lg focus:ring-2 focus:ring-blue-300 text-slate-900 font-medium placeholder-slate-500 text-sm" 
                   name="price_max" placeholder="Max price (THB)" value="<?= htmlspecialchars($filters['price_max'] ?? '') ?>">
          </div>
          <div>
            <button class="w-full px-4 py-2.5 bg-gradient-to-r from-emerald-500 to-green-500 hover:from-emerald-600 hover:to-green-600 text-white font-bold rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105 text-sm">
              🎯 Search Activities
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">

  <div class="grid grid-cols-1 md:grid-cols-12 gap-6">
    <!-- Compact Filters Sidebar -->
    <aside class="md:col-span-3 lg:col-span-3">
      <div class="bg-white rounded-2xl shadow-lg border border-slate-200 p-4 sticky top-4">
        <h3 class="text-lg font-bold text-slate-900 mb-4 flex items-center">
          <svg class="w-4 h-4 mr-2 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
            <path d="M3 4a1 1 0 011-1h16a1 1 0 011 1v2.586l-6.293 6.293a1 1 0 00-.293.707V17l-4 4v-6.414a1 1 0 00-.293-.707L3 7.586V4z"/>
          </svg>
          Filters
        </h3>
        
        <form method="get" class="space-y-4">
          <!-- Price Range -->
          <div>
            <label class="block text-xs font-semibold text-slate-700 mb-2">PRICE RANGE (THB)</label>
            <div class="grid grid-cols-2 gap-2">
              <input class="px-2 py-2 bg-slate-50 border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-slate-900 font-medium placeholder-slate-500 text-sm" 
                     name="price_min" placeholder="Min" value="<?= htmlspecialchars($filters['price_min'] ?? '') ?>">
              <input class="px-2 py-2 bg-slate-50 border border-slate-300 rounded-lg focus:border-blue-500 focus:ring-1 focus:ring-blue-100 text-slate-900 font-medium placeholder-slate-500 text-sm" 
                     name="price_max" placeholder="Max" value="<?= htmlspecialchars($filters['price_max'] ?? '') ?>">
            </div>
          </div>
          
          <!-- Hidden fields to preserve search -->
          <input type="hidden" name="q" value="<?= htmlspecialchars($filters['q'] ?? '') ?>">
          <input type="hidden" name="city" value="<?= htmlspecialchars($filters['city'] ?? '') ?>">
          <input type="hidden" name="sort" value="<?= htmlspecialchars($filters['sort'] ?? 'best') ?>">
          <input type="hidden" name="page" value="1">
          
          <button class="w-full px-4 py-2.5 bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 text-white font-bold rounded-lg shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105 text-sm">
            Apply Filters
          </button>
        </form>
      </div>
    </aside>

    <!-- Results List -->
    <section class="md:col-span-9 lg:col-span-9 space-y-4">
      <?php if (!$activities): ?>
        <div class="bg-gradient-to-r from-blue-50 to-indigo-50 border-2 border-blue-200 rounded-3xl p-8 text-center">
          <div class="text-6xl mb-4">🎯</div>
          <h3 class="text-xl font-bold text-slate-900 mb-2">No activities found</h3>
          <p class="text-slate-600">Try adjusting your search criteria or explore different destinations</p>
        </div>
      <?php else: foreach ($activities as $a):
        $from = (float)($a['from_price'] ?? 0);
        $city = trim((string)($a['city'] ?? ''));
        $timing = 'Flexible';
        $thumb = trim((string)($a['thumbnail_path'] ?? ''));
      ?>
        <article class="bg-white rounded-2xl shadow-lg border border-slate-200 overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-[1.01]">
          <div class="grid grid-cols-1 lg:grid-cols-12">
            <!-- Activity Image -->
            <div class="lg:col-span-4">
              <img src="<?= $thumb !== '' ? htmlspecialchars($thumb) : ('https://picsum.photos/seed/activity'.urlencode((string)($a['id'] ?? rand(1,9999))).'/640/480') ?>"
                   alt="Activity photo" class="w-full h-64 lg:h-full object-cover" loading="lazy">
            </div>
            
            <!-- Activity Details -->
            <div class="lg:col-span-5 p-6">
              <div class="flex items-start justify-between mb-3">
                <div>
                  <h3 class="text-xl font-bold text-slate-900 mb-1">
                    <?= htmlspecialchars($a['name'] ?? 'Activity') ?>
                  </h3>
                  <div class="flex items-center text-sm text-slate-600">
                    <svg class="w-4 h-4 mr-1 text-slate-400" fill="currentColor" viewBox="0 0 24 24">
                      <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                    </svg>
                    <?= htmlspecialchars($city ?: 'Location not set') ?>
                  </div>
                </div>
                <?php $agePol = strtolower((string)($a['age_policy'] ?? ($a['policy'] ?? ''))); if ($agePol !== ''): ?>
                <div class="flex items-center text-xs">
                  <?php if ($agePol === 'adult_only'): ?>
                    <span class="inline-flex items-center gap-1.5 px-2.5 py-0.5 rounded-full border border-rose-200 bg-rose-50 text-rose-700 font-semibold">
                      <svg class="w-3.5 h-3.5" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M12 12a5 5 0 100-10 5 5 0 000 10zm-7 9a7 7 0 0114 0v1H5v-1z"/></svg>
                      Adult only
                    </span>
                  <?php else: ?>
                    <span class="inline-flex items-center gap-1.5 px-2.5 py-0.5 rounded-full border border-emerald-200 bg-emerald-50 text-emerald-700 font-semibold">
                      <svg class="w-3.5 h-3.5" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true"><path d="M16 11c1.66 0 3-1.57 3-3.5S17.66 4 16 4s-3 1.57-3 3.5S14.34 11 16 11zm-8 0c1.66 0 3-1.57 3-3.5S9.66 4 8 4 5 5.57 5 7.5 6.34 11 8 11zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5C15 14.17 10.33 13 8 13zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.96 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z"/></svg>
                      Family
                    </span>
                  <?php endif; ?>
                </div>
                <?php endif; ?>
              </div>
              
              <div class="space-y-2 mb-4">
                <div class="flex items-center text-sm text-emerald-600">
                  <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                  </svg>
                  Free cancellation available
                </div>
                <div class="flex items-center text-sm text-blue-600">
                  <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M17 2H7c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM7 4h10v16H7V4z"/>
                  </svg>
                  Mobile ticket
                </div>
                <div class="flex items-center text-sm text-purple-600">
                  <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                  </svg>
                  Instant confirmation
                </div>
              </div>
            </div>
            
            <!-- Pricing & Booking -->
            <div class="lg:col-span-3 p-6 bg-gradient-to-br from-slate-50 to-blue-50/50 border-t lg:border-l lg:border-t-0 flex flex-col justify-between">
              <div class="text-right mb-4">
                <div class="text-xs text-slate-500 mb-1">Starting from</div>
                <div class="text-3xl font-bold text-emerald-600">
                  ฿<?= number_format($from, 0) ?>
                </div>
                <div class="text-sm text-slate-600">per person</div>
              </div>
              
              <a href="/b2b/agent/activity?id=<?= (int)($a['id'] ?? 0) ?>" 
                 class="w-full px-6 py-3 bg-gradient-to-r from-emerald-500 to-green-500 hover:from-emerald-600 hover:to-green-600 text-white font-bold rounded-xl shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105 text-center">
                Book Activity
              </a>
            </div>
          </div>
        </article>
      <?php endforeach; endif; ?>

      <!-- Pagination -->
      <?php if (($pagination['pages'] ?? 1) > 1):
        $curr = (int)($pagination['page'] ?? 1);
        $pages = (int)$pagination['pages'];
        $mkUrl = function($p) use ($filters) {
          $params = array_merge($filters, ['page' => $p]);
          return '?' . http_build_query($params);
        };
      ?>
        <div class="flex justify-center mt-8">
          <div class="flex items-center space-x-2">
            <?php if ($curr > 1): ?>
              <a href="<?= htmlspecialchars($mkUrl($curr-1)) ?>" 
                 class="px-4 py-2 bg-white border border-slate-300 rounded-lg hover:bg-slate-50 text-slate-700 font-medium transition-colors">
                ← Previous
              </a>
            <?php endif; ?>
            
            <?php for ($i = max(1, $curr-2); $i <= min($pages, $curr+2); $i++): ?>
              <?php if ($i === $curr): ?>
                <span class="px-4 py-2 bg-blue-600 text-white rounded-lg font-medium">
                  <?= $i ?>
                </span>
              <?php else: ?>
                <a href="<?= htmlspecialchars($mkUrl($i)) ?>" 
                   class="px-4 py-2 bg-white border border-slate-300 rounded-lg hover:bg-slate-50 text-slate-700 font-medium transition-colors">
                  <?= $i ?>
                </a>
              <?php endif; ?>
            <?php endfor; ?>
            
            <?php if ($curr < $pages): ?>
              <a href="<?= htmlspecialchars($mkUrl($curr+1)) ?>" 
                 class="px-4 py-2 bg-white border border-slate-300 rounded-lg hover:bg-slate-50 text-slate-700 font-medium transition-colors">
                Next →
              </a>
            <?php endif; ?>
          </div>
        </div>
      <?php endif; ?>
    </section>
  </div>
  </div>
</div>

<?php require __DIR__ . '/partials/footer.php'; ?>
