<?php /** @var string $csrf */ /** @var array $agents */ /** @var array $partners */ ?>
<div class="container py-3">
  <div class="d-flex align-items-center mb-3">
    <i class="bi bi-shield-lock fs-4 me-2 text-primary"></i>
    <h4 class="mb-0">Secure Wallet Operations</h4>
  </div>

  <!-- Reverse Admin → Agent Modal -->
  <div class="modal fade" id="reverseAdminAgentModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h6 class="modal-title"><i class="bi bi-arrow-counterclockwise text-danger me-2"></i>Reverse Admin → Agent</h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="/admin/wallet/secure/reverse/admin-agent" class="secure-form" data-action-label="Reverse Admin → Agent">
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            <div class="mb-2 small text-muted">Logged in as: <?= htmlspecialchars($_SESSION['user']['email'] ?? 'admin') ?></div>
            <div class="mb-2">
              <label class="form-label">Agent</label>
              <select class="form-select" name="agent_user_id" required>
                <option value="">Select Agent</option>
                <?php foreach ($agents as $a): ?>
                  <option value="<?= (int)$a['id'] ?>"><?= htmlspecialchars($a['name'].' ('.$a['email'].')') ?></option>
                <?php endforeach; ?>
              </select>
              <div class="form-text"><span id="agent-balance-reverseAdminAgent" class="text-muted">Balance: —</span></div>
            </div>
            <div class="mb-2">
              <label class="form-label">Amount</label>
              <div class="input-group">
                <span class="input-group-text">THB</span>
                <input class="form-control" type="number" name="amount" min="1" step="0.01" inputmode="decimal" required>
              </div>
              <div class="form-text text-danger">This will move funds from Agent back to Admin with full audit trail.</div>
            </div>
            <div class="mb-2">
              <label class="form-label">Reason (required)</label>
              <input class="form-control" type="text" name="reason" placeholder="e.g., Cash not received" required>
            </div>
            <div class="mb-2">
              <label class="form-label">Master Password</label>
              <input class="form-control" type="password" name="master_password" required>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
            <button class="btn btn-danger px-3"><i class="bi bi-arrow-counterclockwise me-1"></i> Reverse</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Reverse Admin → Partner Modal -->
  <div class="modal fade" id="reverseAdminPartnerModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h6 class="modal-title"><i class="bi bi-arrow-counterclockwise text-danger me-2"></i>Reverse Admin → Partner</h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="/admin/wallet/secure/reverse/admin-partner" class="secure-form" data-action-label="Reverse Admin → Partner">
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            <div class="mb-2 small text-muted">Logged in as: <?= htmlspecialchars($_SESSION['user']['email'] ?? 'admin') ?></div>
            <div class="mb-2">
              <label class="form-label">Channel Partner</label>
              <select class="form-select" name="partner_id" required>
                <option value="">Select Partner</option>
                <?php foreach ($partners as $p): ?>
                  <option value="<?= (int)$p['id'] ?>"><?= htmlspecialchars($p['name']) ?></option>
                <?php endforeach; ?>
              </select>
              <div class="form-text"><span id="partner-balance-reverseAdminPartner" class="text-muted">Balance: —</span></div>
            </div>
            <div class="mb-2">
              <label class="form-label">Amount</label>
              <div class="input-group">
                <span class="input-group-text">THB</span>
                <input class="form-control" type="number" name="amount" min="1" step="0.01" inputmode="decimal" required>
              </div>
            </div>
            <div class="mb-2">
              <label class="form-label">Reason (required)</label>
              <input class="form-control" type="text" name="reason" placeholder="e.g., Settlement failed" required>
            </div>
            <div class="mb-2">
              <label class="form-label">Transaction Password</label>
              <input class="form-control" type="password" name="transaction_password" required>
              <div class="form-text">Channel Partner's transaction password is required for this transfer.</div>
            </div>
            <div class="mb-2">
              <label class="form-label">Master Password</label>
              <input class="form-control" type="password" name="master_password" required>
              <div class="form-text">Admin confirmation required to execute partner payout.</div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
            <button class="btn btn-danger px-3"><i class="bi bi-arrow-counterclockwise me-1"></i> Reverse</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Reverse Partner → Agent Modal -->
  <div class="modal fade" id="reversePartnerAgentModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h6 class="modal-title"><i class="bi bi-arrow-counterclockwise text-danger me-2"></i>Reverse Partner → Agent</h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="/admin/wallet/secure/reverse/partner-agent" class="secure-form" data-action-label="Reverse Partner → Agent">
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            <div class="mb-2">
              <label class="form-label">Channel Partner</label>
              <select class="form-select" name="partner_id" required>
                <option value="">Select Partner</option>
                <?php foreach ($partners as $p): ?>
                  <option value="<?= (int)$p['id'] ?>"><?= htmlspecialchars($p['name']) ?></option>
                <?php endforeach; ?>
              </select>
              <div class="form-text"><span id="partner-balance-reversePartnerAgent" class="text-muted">Balance: —</span></div>
            </div>
            <div class="mb-2">
              <label class="form-label">Agent</label>
              <select class="form-select" name="agent_user_id" required>
                <option value="">Select Agent</option>
                <?php foreach ($agents as $a): ?>
                  <option value="<?= (int)$a['id'] ?>"><?= htmlspecialchars($a['name'].' ('.$a['email'].')') ?></option>
                <?php endforeach; ?>
              </select>
              <div class="form-text"><span id="agent-balance-reversePartnerAgent" class="text-muted">Balance: —</span></div>
            </div>
            <div class="mb-2">
              <label class="form-label">Amount</label>
              <div class="input-group">
                <span class="input-group-text">THB</span>
                <input class="form-control" type="number" name="amount" min="1" step="0.01" inputmode="decimal" required>
              </div>
            </div>
            <div class="mb-2">
              <label class="form-label">Reason (required)</label>
              <input class="form-control" type="text" name="reason" placeholder="e.g., Cash not received" required>
            </div>
            <div class="mb-2">
              <label class="form-label">Master Password</label>
              <input class="form-control" type="password" name="master_password" required>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
            <button class="btn btn-danger px-3"><i class="bi bi-arrow-counterclockwise me-1"></i> Reverse</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-info shadow-sm border-0"><?php echo htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <div class="alert alert-warning py-2 small border-0 shadow-sm mb-3">
    <i class="bi bi-shield-check me-1"></i>
    All operations require Master Password and are fully logged with IP, device, and time. Please review amounts carefully.
  </div>
  <div class="card border-0 shadow-sm mb-3">
    <div class="card-body d-flex align-items-center py-2">
      <i class="bi bi-wallet2 text-success me-2"></i>
      <div class="fw-semibold">Wallet Balances</div>
      <div class="ms-auto small text-muted">Auto-refreshes every 20s</div>
    </div>
    <div class="card-body pt-0">
      <div id="admin-balance-value" class="badge bg-success-subtle text-success border border-success-subtle fs-6">THB <?php echo number_format((float)($adminBalance ?? 0), 2); ?></div>
    </div>
  </div>
  <div class="card border-0 shadow-sm mb-3">
    <div class="card-header bg-light py-2">
      <strong><i class="bi bi-people me-2"></i>Channel Partner Balances</strong>
    </div>
    <div class="card-body py-2">
      <div id="partner-balances-list" class="row g-2">
        <?php if (!empty($partners)): foreach ($partners as $p): ?>
          <div class="col-12 col-md-6 col-lg-4">
            <div class="d-flex align-items-center justify-content-between border rounded-3 px-3 py-2">
              <div class="text-truncate" title="<?= htmlspecialchars($p['name']) ?>"><?= htmlspecialchars($p['name']) ?></div>
              <div class="ms-2 badge bg-secondary-subtle text-secondary border border-secondary-subtle">
                THB <?= number_format((float)($p['balance'] ?? 0), 2) ?>
              </div>
            </div>
          </div>
        <?php endforeach; else: ?>
          <div class="col-12 text-muted small">No active partners.</div>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <div class="card border-0 shadow-sm mb-3">
    <div class="card-body pb-2 d-flex align-items-center">
      <h6 class="mb-0 text-uppercase text-muted">Transfers</h6>
    </div>
    <div class="card-body pt-0">
      <div class="row g-2 g-md-3">
        <div class="col-12 col-sm-6 col-lg-3">
          <button class="btn w-100 btn-outline-primary py-3" data-bs-toggle="modal" data-bs-target="#seedModal" data-bs-toggle="tooltip" title="Seed Admin treasury for testing/staging">
            <i class="bi bi-bank me-2"></i> Seed Treasury
          </button>
        </div>
        <div class="col-12 col-sm-6 col-lg-3">
          <button class="btn w-100 btn-outline-success py-3" data-bs-toggle="modal" data-bs-target="#adminAgentModal" data-bs-toggle="tooltip" title="Move funds Admin → Agent">
            <i class="bi bi-arrow-right-circle me-2"></i> Admin → Agent
          </button>
        </div>
        <div class="col-12 col-sm-6 col-lg-3">
          <button class="btn w-100 btn-outline-warning py-3" data-bs-toggle="modal" data-bs-target="#adminPartnerModal" data-bs-toggle="tooltip" title="Move funds Admin → Partner">
            <i class="bi bi-box-arrow-in-right me-2"></i> Admin → Partner
          </button>
        </div>
        <div class="col-12 col-sm-6 col-lg-3">
          <button class="btn w-100 btn-outline-info py-3" data-bs-toggle="modal" data-bs-target="#partnerAgentModal" data-bs-toggle="tooltip" title="Move funds Partner → Agent">
            <i class="bi bi-arrow-left-right me-2"></i> Partner → Agent
          </button>
        </div>
      </div>
    </div>
  </div>

  <div class="card border-0 shadow-sm mb-3">
    <div class="card-body pb-2 d-flex align-items-center">
      <h6 class="mb-0 text-uppercase text-muted">Reversals</h6>
    </div>
    <div class="card-body pt-0">
      <div class="row g-2 g-md-3">
        <div class="col-12 col-sm-6 col-lg-4">
          <button class="btn w-100 btn-outline-danger py-3" data-bs-toggle="modal" data-bs-target="#reverseAdminAgentModal" data-bs-toggle="tooltip" title="Create compensating entries Agent → Admin">
            <i class="bi bi-arrow-counterclockwise me-2"></i> Reverse Admin → Agent
          </button>
        </div>
        <div class="col-12 col-sm-6 col-lg-4">
          <button class="btn w-100 btn-outline-danger py-3" data-bs-toggle="modal" data-bs-target="#reverseAdminPartnerModal" data-bs-toggle="tooltip" title="Create compensating entries Partner → Admin">
            <i class="bi bi-arrow-counterclockwise me-2"></i> Reverse Admin → Partner
          </button>
        </div>
        <div class="col-12 col-sm-6 col-lg-4">
          <button class="btn w-100 btn-outline-danger py-3" data-bs-toggle="modal" data-bs-target="#reversePartnerAgentModal" data-bs-toggle="tooltip" title="Create compensating entries Agent → Partner">
            <i class="bi bi-arrow-counterclockwise me-2"></i> Reverse Partner → Agent
          </button>
        </div>
      </div>
    </div>
  </div>

  <!-- Seed Treasury Modal -->
  <div class="modal fade" id="seedModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h6 class="modal-title"><i class="bi bi-bank text-primary me-2"></i>Seed Treasury (Admin Wallet)</h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="/admin/wallet/secure/seed" class="secure-form" data-action-label="Seed Treasury">
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            <div class="mb-2">
              <label class="form-label">Admin Email</label>
              <input class="form-control" type="email" name="email" value="admin3@example.com" required>
            </div>
            <div class="mb-2">
              <label class="form-label">Amount</label>
              <div class="input-group">
                <span class="input-group-text">THB</span>
                <input class="form-control" type="number" name="amount" value="10000" min="1" step="0.01" inputmode="decimal" required>
              </div>
              <div class="form-text">Treasury top-up. This creates an approved credit with full audit trail.</div>
            </div>
            <div class="mb-2">
              <label class="form-label">Master Password</label>
              <input class="form-control" type="password" name="master_password" required>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
            <button class="btn btn-primary px-3"><i class="bi bi-upload me-1"></i> Seed</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Admin → Agent Modal -->
  <div class="modal fade" id="adminAgentModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h6 class="modal-title"><i class="bi bi-arrow-right-circle text-success me-2"></i>Admin → Agent (Direct B2B)</h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="/admin/wallet/secure/admin-to-agent" class="secure-form" data-action-label="Admin → Agent Transfer">
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            <div class="mb-2 small text-muted">Logged in as: <?= htmlspecialchars($_SESSION['user']['email'] ?? 'admin') ?></div>
            <div class="mb-2">
              <label class="form-label">To Agent</label>
              <select class="form-select" name="agent_user_id" required>
                <option value="">Select Agent</option>
                <?php foreach ($agents as $a): ?>
                  <option value="<?= (int)$a['id'] ?>"><?= htmlspecialchars($a['name'].' ('.$a['email'].')') ?></option>
                <?php endforeach; ?>
              </select>
              <div class="form-text"><span id="agent-balance-adminAgent" class="text-muted">Balance: —</span></div>
            </div>
            <div class="mb-2">
              <label class="form-label">Amount</label>
              <div class="input-group">
                <span class="input-group-text">THB</span>
                <input class="form-control" type="number" name="amount" min="1" step="0.01" inputmode="decimal" required>
              </div>
              <div class="form-text">Transfers are instant and irreversible.</div>
            </div>
            <div class="mb-2">
              <label class="form-label">Master Password</label>
              <input class="form-control" type="password" name="master_password" required>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
            <button class="btn btn-success px-3"><i class="bi bi-send-check me-1"></i> Transfer</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Admin → Partner Modal -->
  <div class="modal fade" id="adminPartnerModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h6 class="modal-title"><i class="bi bi-box-arrow-in-right text-warning me-2"></i>Admin → Channel Partner</h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="/admin/wallet/secure/admin-to-partner" class="secure-form" data-action-label="Admin → Partner Transfer">
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            <div class="mb-2 small text-muted">Logged in as: <?= htmlspecialchars($_SESSION['user']['email'] ?? 'admin') ?></div>
            <div class="mb-2">
              <label class="form-label">To Channel Partner</label>
              <select class="form-select" name="partner_id" required>
                <option value="">Select Partner</option>
                <?php foreach ($partners as $p): ?>
                  <option value="<?= (int)$p['id'] ?>"><?= htmlspecialchars($p['name']) ?></option>
                <?php endforeach; ?>
              </select>
              <div class="form-text"><span id="partner-balance-adminPartner" class="text-muted">Balance: —</span></div>
            </div>
            <div class="mb-2">
              <label class="form-label">Amount</label>
              <div class="input-group">
                <span class="input-group-text">THB</span>
                <input class="form-control" type="number" name="amount" min="1" step="0.01" inputmode="decimal" required>
              </div>
            </div>
            <div class="mb-2">
              <label class="form-label">Master Password</label>
              <input class="form-control" type="password" name="master_password" required>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
            <button class="btn btn-warning px-3"><i class="bi bi-arrow-right-circle me-1"></i> Transfer</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Partner → Agent Modal -->
  <div class="modal fade" id="partnerAgentModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h6 class="modal-title"><i class="bi bi-arrow-left-right text-info me-2"></i>Channel Partner → Agent</h6>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <form method="post" action="/admin/wallet/secure/partner-to-agent" class="secure-form" data-action-label="Partner → Agent Transfer">
          <div class="modal-body">
            <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            <div class="mb-2">
              <label class="form-label">From Partner</label>
              <select class="form-select" name="partner_id" required>
                <option value="">Select Partner</option>
                <?php foreach ($partners as $p): ?>
                  <option value="<?= (int)$p['id'] ?>"><?= htmlspecialchars($p['name']) ?></option>
                <?php endforeach; ?>
              </select>
              <div class="form-text"><span id="partner-balance-partnerAgent" class="text-muted">Balance: —</span></div>
            </div>
            <div class="mb-2">
              <label class="form-label">To Agent</label>
              <select class="form-select" name="agent_user_id" required>
                <option value="">Select Agent</option>
                <?php foreach ($agents as $a): ?>
                  <option value="<?= (int)$a['id'] ?>"><?= htmlspecialchars($a['name'].' ('.$a['email'].')') ?></option>
                <?php endforeach; ?>
              </select>
              <div class="form-text"><span id="agent-balance-partnerAgent" class="text-muted">Balance: —</span></div>
            </div>
            <div class="mb-2">
              <label class="form-label">Amount</label>
              <div class="input-group">
                <span class="input-group-text">THB</span>
                <input class="form-control" type="number" name="amount" min="1" step="0.01" inputmode="decimal" required>
              </div>
            </div>
            <div class="mb-2">
              <label class="form-label">Master Password</label>
              <input class="form-control" type="password" name="master_password" required>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancel</button>
            <button class="btn btn-info px-3"><i class="bi bi-send-check me-1"></i> Transfer</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <div class="row mt-4">
    <div id="recent-transfers-container" class="col-12">
  <?php if (!empty($recent)): ?>
    <div class="card shadow-sm border-0">
      <div class="card-header bg-light d-flex align-items-center py-2">
        <div class="d-flex align-items-center">
          <i class="bi bi-clock-history me-2 text-secondary"></i>
          <strong>Recent Transfers</strong>
        </div>
        <div class="ms-auto d-flex align-items-center gap-2" style="max-width: 540px;">
          <div class="input-group input-group-sm" style="max-width:160px;">
            <span class="input-group-text bg-white">Rows</span>
            <select id="recent-page-size" class="form-select">
              <option value="10" selected>10</option>
              <option value="25">25</option>
              <option value="50">50</option>
              <option value="100">100</option>
            </select>
          </div>
          <div class="input-group input-group-sm">
            <span class="input-group-text bg-white"><i class="bi bi-search"></i></span>
            <input id="recent-transfers-search" type="text" class="form-control" placeholder="Search time, flow, from, to, amount, status..." aria-label="Search Recent Transfers">
          </div>
          <span id="recent-transfers-count" class="badge bg-secondary-subtle text-secondary border border-secondary-subtle d-none"></span>
        </div>
      </div>
      <div class="card-body p-0">
        <div class="table-responsive">
          <table class="table table-sm table-hover mb-0 align-middle">
            <thead class="table-light">
              <tr>
                <th class="text-nowrap">Time</th>
                <th>Flow</th>
                <th>From</th>
                <th>To</th>
                <th class="text-end">Amount (THB)</th>
                <th>Status</th>
              </tr>
            </thead>
            <tbody id="recent-transfers-tbody">
              <?php foreach ($recent as $r): ?>
                <tr>
                  <td class="text-nowrap"><span class="text-muted small"><?php echo htmlspecialchars($r['created_at']); ?></span></td>
                  <td>
                    <?php if ($r['flow'] === 'admin_to_agent'): ?>
                      <span class="badge bg-success-subtle text-success border border-success-subtle">Admin → Agent</span>
                    <?php elseif ($r['flow'] === 'partner_to_agent'): ?>
                      <span class="badge bg-info-subtle text-info border border-info-subtle">Partner → Agent</span>
                    <?php elseif ($r['flow'] === 'admin_to_partner'): ?>
                      <span class="badge bg-warning-subtle text-warning border border-warning-subtle">Admin → Partner</span>
                    <?php elseif ($r['flow'] === 'reverse_admin_to_agent'): ?>
                      <span class="badge bg-danger-subtle text-danger border border-danger-subtle">Reverse Admin → Agent</span>
                    <?php elseif ($r['flow'] === 'reverse_admin_to_partner'): ?>
                      <span class="badge bg-danger-subtle text-danger border border-danger-subtle">Reverse Admin → Partner</span>
                    <?php elseif ($r['flow'] === 'reverse_partner_to_agent'): ?>
                      <span class="badge bg-danger-subtle text-danger border border-danger-subtle">Reverse Partner → Agent</span>
                    <?php else: ?>
                      <span class="badge bg-secondary-subtle text-secondary border border-secondary-subtle">Seed</span>
                    <?php endif; ?>
                  </td>
                  <td><?php echo htmlspecialchars((string)$r['source']); ?></td>
                  <td><?php echo htmlspecialchars((string)$r['target']); ?></td>
                  <td class="text-end fw-semibold"><?php echo number_format((float)$r['amount'], 2); ?></td>
                  <td>
                    <?php if (($r['status'] ?? '') === 'approved'): ?>
                      <span class="badge bg-success">Approved</span>
                    <?php elseif (($r['status'] ?? '') === 'pending'): ?>
                      <span class="badge bg-warning text-dark">Pending</span>
                    <?php else: ?>
                      <span class="badge bg-secondary">Other</span>
                    <?php endif; ?>
                  </td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
      <div class="card-footer bg-white py-2">
        <div class="d-flex align-items-center justify-content-between">
          <small id="recent-page-info" class="text-muted"></small>
          <nav aria-label="Recent transfers pagination">
            <ul id="recent-pagination" class="pagination pagination-sm mb-0"></ul>
          </nav>
        </div>
      </div>
    </div>
  <?php else: ?>
    <div class="alert alert-light border py-2 small"><i class="bi bi-clock-history me-1"></i>No recent transfers yet.</div>
  <?php endif; ?>
    </div>
  </div>
 

<script>
// Disable submit button on submit to prevent double submissions
(function(){
  const forms = document.querySelectorAll('.secure-form');
  if (!forms.length) return;
  forms.forEach(form => {
    form.addEventListener('submit', function(){
      const btn = form.querySelector('button[type="submit"], button:not([type])');
      if (btn){ btn.disabled = true; btn.classList.add('disabled'); }
    });
  });
})();

// Auto-refresh balances and recent transfers every 20s
(function(){
  async function refreshStats(){
    try {
      const res = await fetch('/admin/api/wallet-secure-stats', { headers: { 'Accept': 'application/json' } });
      const data = await res.json();
      if (!data.ok) return;
      // Admin balance
      const ab = document.getElementById('admin-balance-value');
      if (ab) { ab.textContent = 'THB ' + Number(data.adminBalance || 0).toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 }); }
      // Partner balances
      const pb = document.getElementById('partner-balances-list');
      if (pb && Array.isArray(data.partners)) {
        if (!data.partners.length) {
          pb.innerHTML = '<div class="col-12 text-muted small">No active partners.</div>';
        } else {
          pb.innerHTML = data.partners.map(p => `
            <div class="col-12 col-md-6 col-lg-4">
              <div class="d-flex align-items-center justify-content-between border rounded-3 px-3 py-2">
                <div class="text-truncate" title="${escapeHtml(p.name)}">${escapeHtml(p.name)}</div>
                <div class="ms-2 badge bg-secondary-subtle text-secondary border border-secondary-subtle">
                  THB ${Number(p.balance || 0).toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 })}
                </div>
              </div>
            </div>`).join('');
        }
      }
      // Recent transfers container
      const rtc = document.getElementById('recent-transfers-container');
      if (rtc && Array.isArray(data.recent)) {
        if (!data.recent.length) {
          rtc.innerHTML = '<div class="alert alert-light border py-2 small"><i class="bi bi-clock-history me-1"></i>No recent transfers yet.</div>';
        } else {
          // Build table if not exists
          let tbody = document.getElementById('recent-transfers-tbody');
          if (!tbody) {
            rtc.innerHTML = `
            <div class="card shadow-sm border-0">
              <div class="card-header bg-light d-flex align-items-center py-2">
                <div class="d-flex align-items-center">
                  <i class="bi bi-clock-history me-2 text-secondary"></i>
                  <strong>Recent Transfers</strong>
                </div>
                <div class="ms-auto d-flex align-items-center gap-2" style="max-width: 540px;">
                  <div class="input-group input-group-sm" style="max-width:160px;">
                    <span class="input-group-text bg-white">Rows</span>
                    <select id="recent-page-size" class="form-select">
                      <option value="10" selected>10</option>
                      <option value="25">25</option>
                      <option value="50">50</option>
                      <option value="100">100</option>
                    </select>
                  </div>
                  <div class="input-group input-group-sm">
                    <span class="input-group-text bg-white"><i class="bi bi-search"></i></span>
                    <input id="recent-transfers-search" type="text" class="form-control" placeholder="Search time, flow, from, to, amount, status..." aria-label="Search Recent Transfers">
                  </div>
                  <span id="recent-transfers-count" class="badge bg-secondary-subtle text-secondary border border-secondary-subtle d-none"></span>
                </div>
              </div>
              <div class="card-body p-0">
                <div class="table-responsive">
                  <table class="table table-sm table-hover mb-0 align-middle">
                    <thead class="table-light">
                      <tr>
                        <th class="text-nowrap">Time</th>
                        <th>Flow</th>
                        <th>From</th>
                        <th>To</th>
                        <th class="text-end">Amount (THB)</th>
                        <th>Status</th>
                      </tr>
                    </thead>
                    <tbody id="recent-transfers-tbody"></tbody>
                  </table>
                </div>
              </div>
              <div class="card-footer bg-white py-2">
                <div class="d-flex align-items-center justify-content-between">
                  <small id="recent-page-info" class="text-muted"></small>
                  <nav aria-label="Recent transfers pagination">
                    <ul id="recent-pagination" class="pagination pagination-sm mb-0"></ul>
                  </nav>
                </div>
              </div>
            </div>`;
            tbody = document.getElementById('recent-transfers-tbody');
          }
          tbody.innerHTML = data.recent.map(r => `
            <tr>
              <td class="text-nowrap"><span class="text-muted small">${escapeHtml(r.created_at)}</span></td>
              <td>${flowBadge(r.flow)}</td>
              <td>${escapeHtml(String(r.source || ''))}</td>
              <td>${escapeHtml(String(r.target || ''))}</td>
              <td class="text-end fw-semibold">${Number(r.amount || 0).toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 })}</td>
              <td>${statusBadge(r.status)}</td>
            </tr>`).join('');
          // Re-apply current filter if any
          applyRecentTransfersFilter();
          // Apply pagination after filtering
          applyRecentTransfersPagination();
        }
      }
    } catch (e) {
      // ignore
    }
  }

  function escapeHtml(str){
    return String(str).replace(/[&<>"']/g, s => ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;','\'':'&#39;'}[s]));
  }
  function flowBadge(flow){
    if (flow === 'admin_to_agent') return '<span class="badge bg-success-subtle text-success border border-success-subtle">Admin → Agent</span>';
    if (flow === 'partner_to_agent') return '<span class="badge bg-info-subtle text-info border border-info-subtle">Partner → Agent</span>';
    if (flow === 'admin_to_partner') return '<span class="badge bg-warning-subtle text-warning border border-warning-subtle">Admin → Partner</span>';
    if (flow === 'reverse_admin_to_agent') return '<span class="badge bg-danger-subtle text-danger border border-danger-subtle">Reverse Admin → Agent</span>';
    if (flow === 'reverse_admin_to_partner') return '<span class="badge bg-danger-subtle text-danger border border-danger-subtle">Reverse Admin → Partner</span>';
    if (flow === 'reverse_partner_to_agent') return '<span class="badge bg-danger-subtle text-danger border border-danger-subtle">Reverse Partner → Agent</span>';
    return '<span class="badge bg-secondary-subtle text-secondary border border-secondary-subtle">Seed</span>';
  }
  function statusBadge(s){
    if (s === 'approved') return '<span class="badge bg-success">Approved</span>';
    if (s === 'pending') return '<span class="badge bg-warning text-dark">Pending</span>';
    return '<span class="badge bg-secondary">Other</span>';
  }

  refreshStats();
  setInterval(refreshStats, 20000);
})();
// Recent Transfers search filter with debounce
(function(){
  const searchId = 'recent-transfers-search';
  const countId = 'recent-transfers-count';
  function getEl(id){ return document.getElementById(id); }

  function normalize(s){ return String(s).toLowerCase(); }

  function visibleRowMatches(tr, q){
    if (!q) return true;
    const text = tr.textContent || '';
    return normalize(text).includes(q);
  }

  function updateCount(){
    const tbody = document.getElementById('recent-transfers-tbody');
    const badge = getEl(countId);
    if (!tbody || !badge) return;
    const total = tbody.querySelectorAll('tr').length;
    const visible = tbody.querySelectorAll('tr:not([hidden])').length;
    if (total === visible || total === 0){
      badge.classList.add('d-none');
    } else {
      badge.textContent = `${visible} / ${total}`;
      badge.classList.remove('d-none');
    }
  }

  let debounceTimer = null;
  window.applyRecentTransfersFilter = function(){
    const input = getEl(searchId);
    const tbody = document.getElementById('recent-transfers-tbody');
    if (!input || !tbody) return;
    const q = normalize(input.value.trim());
    tbody.querySelectorAll('tr').forEach(tr => {
      tr.hidden = !visibleRowMatches(tr, q);
    });
    updateCount();
    // After filtering, reset to page 1 and paginate
    recentPaginationState.current = 1;
    applyRecentTransfersPagination();
  };

  function attach(){
    const input = getEl(searchId);
    if (!input) return;
    input.removeEventListener('input', input.__rtHandler || (()=>{}));
    input.__rtHandler = function(){
      clearTimeout(debounceTimer);
      debounceTimer = setTimeout(window.applyRecentTransfersFilter, 150);
    };
    input.addEventListener('input', input.__rtHandler);
  }

  // Attach on DOM ready
  document.addEventListener('DOMContentLoaded', attach);
  // Also try to attach after dynamic refresh builds the header
  const mo = new MutationObserver(() => attach());
  mo.observe(document.body, { childList: true, subtree: true });
})();
// Pagination for Recent Transfers (10 per page)
(function(){
  window.recentPaginationState = { current: 1, size: 10 };

  function pageInfo(totalVisible){
    const { current, size } = window.recentPaginationState;
    const start = totalVisible ? (current - 1) * size + 1 : 0;
    const end = Math.min(current * size, totalVisible);
    return { start, end };
  }

  function renderPager(totalVisible){
    const ul = document.getElementById('recent-pagination');
    const info = document.getElementById('recent-page-info');
    if (!ul || !info) return;
    const { current, size } = window.recentPaginationState;
    const pages = Math.max(1, Math.ceil(totalVisible / size));
    if (current > pages) window.recentPaginationState.current = pages;

    // Info text
    if (!totalVisible){
      info.textContent = '';
    } else {
      const pi = pageInfo(totalVisible);
      info.textContent = `${pi.start}-${pi.end} of ${totalVisible}`;
    }

    // Build pagination
    let html = '';
    const disabledPrev = current <= 1 ? ' disabled' : '';
    const disabledNext = current >= pages ? ' disabled' : '';
    html += `<li class="page-item${disabledPrev}"><a class="page-link" href="#" data-act="prev" aria-label="Previous">«</a></li>`;
    // Up to 5 numeric buttons around current
    const windowSize = 5;
    let start = Math.max(1, current - Math.floor(windowSize/2));
    let end = Math.min(pages, start + windowSize - 1);
    start = Math.max(1, end - windowSize + 1);
    for (let p = start; p <= end; p++){
      const active = p === current ? ' active' : '';
      html += `<li class="page-item${active}"><a class="page-link" href="#" data-page="${p}">${p}</a></li>`;
    }
    html += `<li class="page-item${disabledNext}"><a class="page-link" href="#" data-act="next" aria-label="Next">»</a></li>`;
    ul.innerHTML = html;

    ul.querySelectorAll('a.page-link').forEach(a => {
      a.addEventListener('click', function(e){
        e.preventDefault();
        const act = this.getAttribute('data-act');
        if (act === 'prev' && window.recentPaginationState.current > 1){
          window.recentPaginationState.current--;
        } else if (act === 'next'){
          const pagesLocal = Math.max(1, Math.ceil(totalVisible / window.recentPaginationState.size));
          if (window.recentPaginationState.current < pagesLocal) window.recentPaginationState.current++;
        } else {
          const p = parseInt(this.getAttribute('data-page') || '1', 10);
          window.recentPaginationState.current = p;
        }
        applyRecentTransfersPagination();
      });
    });
  }

  window.applyRecentTransfersPagination = function(){
    const tbody = document.getElementById('recent-transfers-tbody');
    if (!tbody) return;
    const rows = Array.from(tbody.querySelectorAll('tr'));
    const visibleRows = rows.filter(tr => !tr.hidden);
    const totalVisible = visibleRows.length;
    const { current, size } = window.recentPaginationState;
    const startIdx = (current - 1) * size;
    const endIdx = startIdx + size;
    // Hide all visible rows first
    visibleRows.forEach((tr, idx) => {
      tr.style.display = (idx >= startIdx && idx < endIdx) ? '' : 'none';
    });
    // Rows filtered out remain hidden regardless of pagination
    rows.filter(tr => tr.hidden).forEach(tr => { tr.style.display = 'none'; });
    renderPager(totalVisible);
  };

  // Apply once on DOM ready
  document.addEventListener('DOMContentLoaded', () => {
    applyRecentTransfersPagination();
    attachSizeSelector();
  });

  // Attach change handler to size selector (supports dynamic rebuild)
  function attachSizeSelector(){
    const selId = 'recent-page-size';
    const sel = document.getElementById(selId);
    if (!sel) return;
    sel.removeEventListener('change', sel.__rtSizeHandler || (()=>{}));
    sel.__rtSizeHandler = function(){
      const v = parseInt(sel.value || '10', 10);
      window.recentPaginationState.size = isNaN(v) ? 10 : v;
      window.recentPaginationState.current = 1;
      applyRecentTransfersPagination();
    };
    sel.addEventListener('change', sel.__rtSizeHandler);
  }

  // Re-attach on DOM mutations (for dynamic header rebuild)
  const mo2 = new MutationObserver(() => attachSizeSelector());
  mo2.observe(document.body, { childList: true, subtree: true });
})();
// Dynamic agents list based on selected partner in Partner → Agent modal
(function(){
  // Support both Partner → Agent and Reverse Partner → Agent modals
  const modalIds = ['partnerAgentModal','reversePartnerAgentModal'];
  modalIds.forEach(id => {
    const modal = document.getElementById(id);
    if (!modal) return;
    const form = modal.querySelector('form');
    const partnerSelect = form?.querySelector('select[name="partner_id"]');
    const agentSelect = form?.querySelector('select[name="agent_user_id"]');
    if (!partnerSelect || !agentSelect) return;

    async function loadAgentsForPartner(pid){
      agentSelect.disabled = true;
      agentSelect.innerHTML = '<option value="">Loading...</option>';
      if (!pid){
        agentSelect.innerHTML = '<option value="">Select Agent</option>';
        agentSelect.disabled = false;
        return;
      }
      try{
        const res = await fetch('/admin/api/agents-by-partner?partner_id=' + encodeURIComponent(pid), {
          headers: { 'Accept': 'application/json' }
        });
        const data = await res.json();
        agentSelect.innerHTML = '';
        if (!data.ok){
          agentSelect.innerHTML = '<option value="">No agents found</option>';
        } else {
          const list = Array.isArray(data.data) ? data.data : [];
          const placeholder = document.createElement('option');
          placeholder.value = '';
          placeholder.textContent = list.length ? 'Select Agent' : 'No agents for this partner';
          agentSelect.appendChild(placeholder);
          list.forEach(a => {
            const opt = document.createElement('option');
            opt.value = a.id;
            opt.textContent = `${a.name} (${a.email})`;
            agentSelect.appendChild(opt);
          });
        }
      } catch (e){
        agentSelect.innerHTML = '<option value="">Failed to load agents</option>';
      } finally {
        agentSelect.disabled = false;
      }
    }

    partnerSelect.addEventListener('change', function(){
      loadAgentsForPartner(this.value);
    });

    modal.addEventListener('shown.bs.modal', function(){
      loadAgentsForPartner(partnerSelect.value);
    });
  });
})();
</script>
<script>
// Live balance display for Agent/Partner selects across modals
(function(){
  function fmt(amount){
    try { return new Intl.NumberFormat('en-US', { style:'currency', currency:'THB'}).format(amount); } catch(e){ return 'THB ' + (amount?.toFixed ? amount.toFixed(2) : amount); }
  }
  async function fetchUserBalance(userId){
    if (!userId) return null;
    try{
      const r = await fetch('/admin/api/user-balance?user_id=' + encodeURIComponent(userId), { headers:{'Accept':'application/json'} });
      const j = await r.json();
      return j && j.ok ? (j.balance ?? 0) : null;
    } catch(e){ return null; }
  }
  async function fetchPartnerBalance(pid){
    if (!pid) return null;
    try{
      const r = await fetch('/admin/api/partner-balance?partner_id=' + encodeURIComponent(pid), { headers:{'Accept':'application/json'} });
      const j = await r.json();
      return j && j.ok ? (j.balance ?? 0) : null;
    } catch(e){ return null; }
  }
  function setText(span, amount){
    if (!span) return;
    if (amount === null || amount === undefined || amount === '') { span.textContent = 'Balance: —'; return; }
    span.textContent = 'Balance: ' + fmt(Number(amount));
  }

  const wiring = [
    { modalId:'adminAgentModal', sels:[{name:'agent_user_id', type:'user', spanId:'agent-balance-adminAgent'}] },
    { modalId:'adminPartnerModal', sels:[{name:'partner_id', type:'partner', spanId:'partner-balance-adminPartner'}] },
    { modalId:'partnerAgentModal', sels:[
      {name:'partner_id', type:'partner', spanId:'partner-balance-partnerAgent'},
      {name:'agent_user_id', type:'user', spanId:'agent-balance-partnerAgent'}
    ] },
    { modalId:'reverseAdminAgentModal', sels:[{name:'agent_user_id', type:'user', spanId:'agent-balance-reverseAdminAgent'}] },
    { modalId:'reverseAdminPartnerModal', sels:[{name:'partner_id', type:'partner', spanId:'partner-balance-reverseAdminPartner'}] },
    { modalId:'reversePartnerAgentModal', sels:[
      {name:'partner_id', type:'partner', spanId:'partner-balance-reversePartnerAgent'},
      {name:'agent_user_id', type:'user', spanId:'agent-balance-reversePartnerAgent'}
    ] },
  ];

  wiring.forEach(cfg => {
    const modal = document.getElementById(cfg.modalId);
    if (!modal) return;
    const form = modal.querySelector('form');
    if (!form) return;

    async function updateFor(selCfg){
      const select = form.querySelector(`select[name="${selCfg.name}"]`);
      const span = document.getElementById(selCfg.spanId);
      if (!select || !span) return;
      const val = select.value;
      if (!val) { setText(span, null); return; }
      const bal = selCfg.type === 'user' ? await fetchUserBalance(val) : await fetchPartnerBalance(val);
      setText(span, bal);
    }

    function attachHandlers(){
      cfg.sels.forEach(selCfg => {
        const select = form.querySelector(`select[name="${selCfg.name}"]`);
        const span = document.getElementById(selCfg.spanId);
        if (!select || !span) return;
        // Remove previous
        if (select.__balanceHandler) select.removeEventListener('change', select.__balanceHandler);
        select.__balanceHandler = () => updateFor(selCfg);
        select.addEventListener('change', select.__balanceHandler);
      });
    }

    modal.addEventListener('shown.bs.modal', () => {
      attachHandlers();
      // Initial updates
      cfg.sels.forEach(selCfg => updateFor(selCfg));
    });

    // In case DOM within modal changes (e.g., agent list reload after partner change)
    const mo = new MutationObserver(() => attachHandlers());
    mo.observe(modal, { childList:true, subtree:true });
  });
})();
</script>
<script>
// Professional UX: guard submits, show spinner, and enable tooltips
(function(){
  // Bootstrap tooltips for any element with data-bs-toggle="tooltip"
  document.querySelectorAll('[data-bs-toggle="tooltip"]').forEach(function(el){
    try { new bootstrap.Tooltip(el); } catch(e) {}
  });

  // Prevent double submit on all secure forms; apply browser validation
  const forms = document.querySelectorAll('form.secure-form');
  forms.forEach(function(form){
    form.setAttribute('novalidate', 'novalidate');
    form.addEventListener('submit', function(ev){
      // HTML5 constraint validation first
      if (!form.checkValidity()){
        ev.preventDefault();
        ev.stopPropagation();
        form.classList.add('was-validated');
        return false;
      }
      // Lock UI
      const submitBtn = form.querySelector('button[type="submit"], button.btn-danger, button.btn-primary');
      if (submitBtn && !submitBtn.dataset.locked){
        submitBtn.dataset.locked = '1';
        submitBtn.disabled = true;
        const original = submitBtn.innerHTML;
        submitBtn.dataset.original = original;
        submitBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>Processing...';
      }
    }, false);
  });
})();
</script>
</div>
