<?php
// app/Views/admin/wallet_manual.php
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h4 mb-0">Manual Wallet Entry</h1>
    <div>
      <a href="/admin/wallet/secure" class="btn btn-sm btn-outline-primary">Secure Wallet</a>
      <a href="/admin/wallet/ledger" class="btn btn-sm btn-outline-secondary">Ledger</a>
    </div>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-info py-2"><?php echo htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>

  <div class="card shadow-sm">
    <div class="card-body">
      <form method="post" action="/admin/wallet/manual">
        <input type="hidden" name="csrf" value="<?php echo htmlspecialchars($csrf); ?>" />
        <div class="row g-3">
          <div class="col-md-4">
            <label class="form-label">User</label>
            <select name="user_id" class="form-select" required>
              <option value="">Select user...</option>
              <?php foreach ($users as $u): ?>
                <option value="<?php echo (int)$u['id']; ?>"><?php echo htmlspecialchars($u['name'].' ('.$u['email'].')'); ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Type</label>
            <select name="type" class="form-select">
              <option value="credit">Credit</option>
              <option value="debit">Debit</option>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Amount</label>
            <input type="number" name="amount" class="form-control" step="0.01" min="0.01" required />
          </div>
          <div class="col-12">
            <label class="form-label">Note</label>
            <textarea name="note" class="form-control" rows="2" placeholder="Add an optional note..."></textarea>
          </div>
          <div class="col-12">
            <button type="submit" class="btn btn-primary">Create Request</button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
