<?php
// app/Views/admin/wallet_approvals.php
?>
<div class="container py-4">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="h4 mb-0">Wallet Approvals</h1>
    <a href="/admin" class="btn btn-sm btn-outline-secondary">Back to Dashboard</a>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-info py-2"><?php echo htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>

  <div class="card shadow-sm">
    <div class="table-responsive">
      <table class="table align-middle mb-0">
        <thead>
          <tr>
            <th>ID</th>
            <th>User</th>
            <th>Type</th>
            <th>Amount</th>
            <th>Method</th>
            <th>Status</th>
            <th>Requested At</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          <?php if (!empty($rows)): foreach ($rows as $r): ?>
            <tr>
              <td>#<?php echo (int)$r['id']; ?></td>
              <td><?php echo htmlspecialchars($r['user_name']); ?></td>
              <td class="text-uppercase"><?php echo htmlspecialchars($r['type']); ?></td>
              <td><strong><?php echo number_format((float)$r['amount'], 2); ?></strong></td>
              <td><?php echo htmlspecialchars($r['method']); ?></td>
              <td><span class="badge bg-warning text-dark"><?php echo htmlspecialchars($r['status']); ?></span></td>
              <td><?php echo htmlspecialchars($r['created_at'] ?? ''); ?></td>
              <td>
                <form method="post" action="/admin/wallet/approve" class="d-inline" onsubmit="return confirm('Approve this ledger entry?');">
                  <input type="hidden" name="csrf" value="<?php echo htmlspecialchars($csrf); ?>" />
                  <input type="hidden" name="ledger_id" value="<?php echo (int)$r['id']; ?>" />
                  <button type="submit" class="btn btn-sm btn-success">Approve</button>
                </form>
                <form method="post" action="/admin/wallet/reject" class="d-inline ms-1" onsubmit="return confirm('Reject this ledger entry?');">
                  <input type="hidden" name="csrf" value="<?php echo htmlspecialchars($csrf); ?>" />
                  <input type="hidden" name="ledger_id" value="<?php echo (int)$r['id']; ?>" />
                  <button type="submit" class="btn btn-sm btn-outline-danger">Reject</button>
                </form>
              </td>
            </tr>
          <?php endforeach; else: ?>
            <tr>
              <td colspan="8" class="text-center text-muted py-4">No pending wallet entries.</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

