<?php
// app/Views/admin/vendors_activity_create.php
?>
<div class="container py-2">
  <h2 class="h5 mb-3"><i class="bi bi-lightning me-2"></i>Add Vendor Activity</h2>
  <form method="post" action="#" onsubmit="return false;">
    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf ?? '') ?>">
    <div class="row g-3">
      <div class="col-md-4">
        <label class="form-label">Vendor</label>
        <select class="form-select" required>
          <option value="">Select vendor</option>
          <?php foreach (($vendors ?? []) as $v): ?>
            <option value="<?= (int)$v['id'] ?>"><?= htmlspecialchars($v['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">Activity Name</label>
        <input type="text" class="form-control" required>
      </div>
      <div class="col-md-2">
        <label class="form-label">City</label>
        <input type="text" class="form-control" required>
      </div>
      <div class="col-md-2">
        <label class="form-label">Base Price</label>
        <input type="number" class="form-control" step="0.01" required>
      </div>
    </div>
    <div class="mt-3">
      <button class="btn btn-primary" type="submit">Save (demo)</button>
    </div>
  </form>
</div>
