<?php
// app/Views/admin/vendor_payouts.php
// Expects: $csrf, $vendors, $filters = ['vendor_id','status','from','to'], $summary (per-vendor rows), $rows (detail when vendor selected)
$vendors = $vendors ?? [];
$filters = $filters ?? ['vendor_id'=>0,'status'=>'pending','from'=>'','to'=>''];
$summary = $summary ?? [];
$rows = $rows ?? [];
?>
<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h2 class="h5 mb-0"><i class="bi bi-cash-stack me-2"></i>Vendor Payouts</h2>
    <a href="/admin/booking/taxi" class="btn btn-sm btn-outline-secondary">Back to Taxi Bookings</a>
  </div>

  <!-- Filters -->
  <form class="row g-2 mb-3" method="get" action="/admin/vendor-payouts">
    <div class="col-sm-3">
      <label class="form-label">Vendor</label>
      <select name="vendor_id" class="form-select form-select-sm">
        <option value="0">All Vendors</option>
        <?php foreach ($vendors as $v): ?>
          <option value="<?= (int)$v['id'] ?>" <?= ((int)($filters['vendor_id']??0)===(int)$v['id']?'selected':'') ?>><?= htmlspecialchars((string)$v['name']) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-sm-2">
      <label class="form-label">Status</label>
      <select name="status" class="form-select form-select-sm">
        <?php foreach (['pending'=>'Pending','cleared'=>'Cleared','all'=>'All'] as $k=>$label): ?>
          <option value="<?= $k ?>" <?= (($filters['status']??'pending')===$k?'selected':'') ?>><?= $label ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-sm-2">
      <label class="form-label">From</label>
      <input type="date" class="form-control form-control-sm" name="from" value="<?= htmlspecialchars((string)($filters['from']??'')) ?>">
    </div>
    <div class="col-sm-2">
      <label class="form-label">To</label>
      <input type="date" class="form-control form-control-sm" name="to" value="<?= htmlspecialchars((string)($filters['to']??'')) ?>">
    </div>
    <div class="col-sm-2 d-flex align-items-end">
      <button class="btn btn-sm btn-primary">Filter</button>
    </div>
  </form>

  <!-- Summary by vendor -->
  <div class="card border-0 shadow-sm mb-4">
    <div class="card-header bg-white border-0"><h6 class="mb-0">Summary (Paid bookings)</h6></div>
    <div class="card-body p-0">
      <div class="table-responsive">
        <table class="table table-sm table-striped mb-0 align-middle">
          <thead>
            <tr>
              <th>Vendor</th>
              <th class="text-end">Pending</th>
              <th class="text-end">Cleared</th>
              <th class="text-end">Total</th>
              <th class="text-end">Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($summary as $s): ?>
              <tr>
                <td><?= htmlspecialchars((string)($s['vendor_name'] ?? '')) ?> <span class="text-muted">#<?= (int)($s['vendor_id'] ?? 0) ?></span></td>
                <td class="text-end"><?= number_format((float)($s['pending_amount'] ?? 0), 2) ?> THB</td>
                <td class="text-end"><?= number_format((float)($s['cleared_amount'] ?? 0), 2) ?> THB</td>
                <td class="text-end fw-semibold"><?= number_format((float)($s['total_amount'] ?? 0), 2) ?> THB</td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-primary" href="/admin/vendor-payouts?vendor_id=<?= (int)($s['vendor_id'] ?? 0) ?>&status=<?= urlencode($filters['status']??'pending') ?>&from=<?= urlencode($filters['from']??'') ?>&to=<?= urlencode($filters['to']??'') ?>">View</a>
                  <form method="post" action="/admin/vendor-payouts/mark-paid-vendor" class="d-inline-block ms-1">
                    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                    <input type="hidden" name="vendor_id" value="<?= (int)($s['vendor_id'] ?? 0) ?>">
                    <input type="hidden" name="from" value="<?= htmlspecialchars((string)($filters['from']??'')) ?>">
                    <input type="hidden" name="to" value="<?= htmlspecialchars((string)($filters['to']??'')) ?>">
                    <input type="text" name="invoice_no" class="form-control form-control-sm d-inline-block" style="width:140px" placeholder="Invoice #">
                    <input type="text" name="note" class="form-control form-control-sm d-inline-block ms-1" style="width:180px" placeholder="Note">
                    <button class="btn btn-sm btn-success ms-1" onclick="return confirm('Mark all pending for this vendor as paid?')">Mark All Paid</button>
                  </form>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (empty($summary)): ?>
              <tr><td colspan="5" class="text-center text-muted py-3">No data.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>

  <?php if ((int)($filters['vendor_id'] ?? 0) > 0): ?>
  <!-- Detail for selected vendor -->
  <div class="card border-0 shadow-sm">
    <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
      <h6 class="mb-0">Details for Vendor #<?= (int)$filters['vendor_id'] ?></h6>
      <div>
        <form method="post" action="/admin/vendor-payouts/mark-paid" class="d-inline-block">
          <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
          <input type="text" name="invoice_no" class="form-control form-control-sm d-inline-block" style="width:140px" placeholder="Invoice #">
          <input type="text" name="note" class="form-control form-control-sm d-inline-block ms-1" style="width:180px" placeholder="Note">
          <button class="btn btn-sm btn-success ms-1" onclick="return confirm('Mark selected bookings as paid?')">Mark Selected Paid</button>
        </form>
      </div>
    </div>
    <div class="card-body p-0">
      <form method="post" action="/admin/vendor-payouts/mark-paid" id="bulkPaidForm">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
        <div class="table-responsive">
          <table class="table table-sm table-striped mb-0 align-middle">
            <thead>
              <tr>
                <th style="width:36px"><input type="checkbox" onclick="document.querySelectorAll('.rowchk').forEach(cb=>cb.checked=this.checked)"></th>
                <th>#</th>
                <th>Code</th>
                <th>Pickup</th>
                <th>Pax</th>
                <th>Status</th>
                <th>Pay</th>
                <th class="text-end">Vendor Cost</th>
                <th>Pay Status</th>
                <th>Paid At</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($rows as $r): ?>
                <tr>
                  <td><input class="rowchk" type="checkbox" name="booking_ids[]" value="<?= (int)$r['id'] ?>" <?= ((string)($r['vendor_pay_status'] ?? 'pending')==='cleared'?'disabled':'') ?>></td>
                  <td><?= (int)$r['id'] ?></td>
                  <td><?= htmlspecialchars((string)($r['booking_code'] ?? '')) ?></td>
                  <td><?= htmlspecialchars((string)($r['trip_date'] ?? '')) ?> <?php if (!empty($r['pickup_time'])): ?><span class="text-muted small"><?= htmlspecialchars(' '.$r['pickup_time']) ?></span><?php endif; ?></td>
                  <td><?= (int)($r['pax'] ?? 1) ?></td>
                  <td><span class="badge bg-light text-dark"><?= htmlspecialchars((string)($r['status'] ?? '')) ?></span></td>
                  <td><span class="badge bg-<?= ((string)($r['payment_status'] ?? '')==='paid'?'success':'light') ?> text-dark"><?= htmlspecialchars((string)($r['payment_status'] ?? '')) ?></span></td>
                  <td class="text-end"><?= number_format((float)($r['vendor_cost'] ?? 0), 2) ?> <?= htmlspecialchars((string)($r['vendor_currency'] ?? 'THB')) ?></td>
                  <td><span class="badge bg-<?= ((string)($r['vendor_pay_status'] ?? 'pending')==='cleared'?'success':'warning') ?> text-dark"><?= htmlspecialchars((string)($r['vendor_pay_status'] ?? 'pending')) ?></span></td>
                  <td><span class="text-muted small"><?= htmlspecialchars((string)($r['vendor_paid_at'] ?? '')) ?></span></td>
                </tr>
              <?php endforeach; ?>
              <?php if (empty($rows)): ?>
                <tr><td colspan="10" class="text-center text-muted py-3">No bookings.</td></tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </form>
    </div>
  </div>
  <?php endif; ?>
</div>
