<?php
// app/Views/admin/taxis_view.php
?>
<div class="container py-3">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h2 class="h5 mb-0"><i class="bi bi-taxi-front me-2"></i>Taxi Details</h2>
    <div>
      <a class="btn btn-sm btn-outline-secondary" href="/admin/taxis">Back</a>
      <a class="btn btn-sm btn-primary" href="/admin/taxis/edit?id=<?= (int)$taxi['id'] ?>">Edit</a>
      <form method="post" action="<?= ((int)($taxi['active'] ?? 1) === 1) ? '/admin/taxis/disable' : '/admin/taxis/enable' ?>" class="d-inline-flex align-items-center ms-2" onsubmit="return confirm(this.querySelector('input[type=checkbox]').checked ? 'Enable this taxi?' : 'Disable this taxi?')">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
        <input type="hidden" name="id" value="<?= (int)$taxi['id'] ?>">
        <label class="form-check form-switch m-0">
          <input class="form-check-input" type="checkbox"
                 role="switch"
                 data-enable-url="/admin/taxis/enable"
                 data-disable-url="/admin/taxis/disable"
                 onchange="this.form.action = this.checked ? this.dataset.enableUrl : this.dataset.disableUrl; this.form.submit();"
                 <?= ((int)($taxi['active'] ?? 1) === 1) ? 'checked' : '' ?>
          >
        </label>
      </form>
    </div>
  </div>

  <?php if (!empty($_SESSION['flash'])): ?>
    <div class="alert alert-success py-1 small"><?= htmlspecialchars($_SESSION['flash']); unset($_SESSION['flash']); ?></div>
  <?php endif; ?>
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-1 small">
      <?php foreach ($_SESSION['errors'] as $e): ?>
        <div><?= htmlspecialchars($e) ?></div>
      <?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <div class="row g-3">
    <div class="col-12 col-lg-7">
      <div class="card">
        <div class="card-body">
          <div class="mb-2"><strong>Title:</strong> <?= htmlspecialchars($taxi['title'] ?? $taxi['name']) ?></div>
          <div class="mb-2"><strong>Name:</strong> <?= htmlspecialchars($taxi['name']) ?></div>
          <div class="mb-2"><strong>Vendor:</strong> <?= htmlspecialchars($taxi['vendor_name'] ?? '') ?></div>
          <div class="mb-2"><strong>Vehicle Type:</strong> <?= htmlspecialchars($taxi['vehicle_type'] ?? '') ?></div>
          <div class="mb-2"><strong>Capacity:</strong> <?= htmlspecialchars((string)($taxi['capacity'] ?? '')) ?></div>
          <div class="mb-2"><strong>Luggage:</strong> <?= htmlspecialchars((string)($taxi['luggage_capacity'] ?? '')) ?></div>
          <div class="mb-2"><strong>Route:</strong> <?= htmlspecialchars($taxi['route'] ?? '') ?></div>
          <div class="mb-2"><strong>Status:</strong>
            <?php if ((int)($taxi['active'] ?? 1) === 1): ?>
              <span class="badge text-bg-success">Active</span>
            <?php else: ?>
              <span class="badge text-bg-secondary">Inactive</span>
            <?php endif; ?>
          </div>
          <?php if (!empty($taxi['description'])): ?>
          <div class="mb-2"><strong>Description:</strong><br><?= nl2br(htmlspecialchars($taxi['description'])) ?></div>
          <?php endif; ?>
        </div>
      </div>
    </div>
    <div class="col-12 col-lg-5">
      <div class="card">
        <div class="card-body">
          <h6 class="mb-3">Pricing</h6>
          <?php if (!empty($pricing)): ?>
            <div class="row small g-2">
              <div class="col-6"><strong>Currency:</strong> <?= htmlspecialchars($pricing['currency'] ?? '') ?></div>
              <div class="col-6"><strong>Model:</strong> <?= htmlspecialchars($pricing['model'] ?? '') ?></div>
              <div class="col-6"><strong>Base Fare:</strong> <?= htmlspecialchars(number_format((float)($pricing['base_fare'] ?? 0), 2)) ?></div>
              <?php
                $b2c = null;
                if (isset($pricing['customer_price']) && $pricing['customer_price'] !== '' && $pricing['customer_price'] !== null) {
                  $b2c = (float)$pricing['customer_price'];
                } elseif (isset($pricing['base_fare']) && $pricing['base_fare'] !== '' && $pricing['base_fare'] !== null) {
                  $b2c = (float)$pricing['base_fare'];
                }
              ?>
              <div class="col-6"><strong>B2C Price:</strong>
                <?= $b2c !== null ? htmlspecialchars(number_format($b2c, 2)) : '<span class="text-muted">—</span>' ?>
              </div>
              <?php if (!empty($pricing['vendor_cost'])): ?><div class="col-6"><strong>Vendor Cost:</strong> <?= htmlspecialchars(number_format((float)$pricing['vendor_cost'], 2)) ?></div><?php endif; ?>
              <?php if (!empty($pricing['agent_price'])): ?><div class="col-6"><strong>Agent Price:</strong> <?= htmlspecialchars(number_format((float)$pricing['agent_price'], 2)) ?></div><?php endif; ?>
              <?php if (!empty($pricing['per_km'])): ?><div class="col-6"><strong>Per KM:</strong> <?= htmlspecialchars(number_format((float)$pricing['per_km'], 2)) ?></div><?php endif; ?>
              <?php if (!empty($pricing['per_hour'])): ?><div class="col-6"><strong>Per Hour:</strong> <?= htmlspecialchars(number_format((float)$pricing['per_hour'], 2)) ?></div><?php endif; ?>
              <?php if (!empty($pricing['wait_per_hour'])): ?><div class="col-6"><strong>Wait/Hour:</strong> <?= htmlspecialchars(number_format((float)$pricing['wait_per_hour'], 2)) ?></div><?php endif; ?>
              <?php if (!empty($pricing['tax_pct'])): ?><div class="col-6"><strong>Tax %:</strong> <?= htmlspecialchars(number_format((float)$pricing['tax_pct'], 2)) ?></div><?php endif; ?>
              <?php if (!empty($pricing['fee_pct'])): ?><div class="col-6"><strong>Fee %:</strong> <?= htmlspecialchars(number_format((float)$pricing['fee_pct'], 2)) ?></div><?php endif; ?>
            </div>
          <?php else: ?>
            <div class="text-muted small">No pricing set.</div>
          <?php endif; ?>
        </div>
      </div>
    </div>
    <div class="col-12">
      <div class="card">
        <div class="card-body">
          <h6 class="mb-3">Images</h6>
          <div class="d-flex flex-wrap gap-2">
            <?php if (!empty($images)): ?>
              <?php foreach ($images as $img): ?>
                <?php
                  $path = (string)$img['file_path'];
                  $bn = basename($path);
                  $thumbRel = '/assets/uploads/thumbs/' . 'th_' . $bn;
                  $thumbAbs = BASE_PATH . '/public' . $thumbRel;
                  $thumbUrl = file_exists($thumbAbs) ? $thumbRel : $path;
                ?>
                <div class="position-relative">
                  <?php if ((int)($img['is_cover'] ?? 0) === 1): ?>
                    <span class="badge text-bg-primary position-absolute" style="top:6px;left:6px;">Cover</span>
                  <?php endif; ?>
                  <img src="<?= htmlspecialchars($thumbUrl) ?>" class="img-thumbnail" style="width:120px;height:120px;object-fit:cover;">
                </div>
              <?php endforeach; ?>
            <?php else: ?>
              <div class="text-muted small">No images.</div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
