<?php
// app/Views/admin/taxis_form.php
$editing = !empty($taxi['id']);
$action = $editing ? '/admin/taxis/update' : '/admin/taxis/store';
?>
<div class="container py-3">
  <h2 class="h5 mb-3 d-flex align-items-center">
    <i class="bi bi-taxi-front me-2"></i>
    <?= $editing ? 'Edit Taxi' : 'Create Taxi' ?>
  </h2>

  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2 small">
      <?php foreach ($_SESSION['errors'] as $e): ?>
        <div><?= htmlspecialchars($e) ?></div>
      <?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <form method="post" action="<?= $action ?>" enctype="multipart/form-data" class="needs-validation" novalidate>
    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
    <?php if ($editing): ?>
      <input type="hidden" name="id" value="<?= (int)$taxi['id'] ?>">
    <?php endif; ?>

    <!-- Tabs -->
    <ul class="nav nav-tabs small" id="taxiTabs" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="tab-details" data-bs-toggle="tab" data-bs-target="#pane-details" type="button" role="tab">Details</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="tab-pricing" data-bs-toggle="tab" data-bs-target="#pane-pricing" type="button" role="tab">Pricing</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="tab-routes" data-bs-toggle="tab" data-bs-target="#pane-routes" type="button" role="tab">Routes</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="tab-availability" data-bs-toggle="tab" data-bs-target="#pane-availability" type="button" role="tab">Availability</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="tab-media" data-bs-toggle="tab" data-bs-target="#pane-media" type="button" role="tab">Media</button>
      </li>
    </ul>

    <div class="tab-content border border-top-0 rounded-bottom p-3 bg-white" id="taxiTabsContent">
      <!-- Details -->
      <div class="tab-pane fade show active" id="pane-details" role="tabpanel" aria-labelledby="tab-details" tabindex="0">
        <div class="row g-3">
          <?php
            // Build base URL for country filter change (avoid nested forms)
            $filterBase = $editing
              ? '/admin/taxis/edit?id=' . (int)$taxi['id']
              : '/admin/taxis/create';
          ?>
          <div class="col-md-4">
            <label class="form-label">Country</label>
            <select class="form-select form-select-sm" onchange="(function(sel){ var url='<?= $filterBase ?>'; if(sel.value){ url += (url.indexOf('?')>-1?'&':'?') + 'country=' + encodeURIComponent(sel.value); } else { /* clear country */ } window.location = url; })(this)">
              <option value="">All countries</option>
              <?php if (!empty($countries)):
                foreach ($countries as $c): $cname = is_array($c) ? ($c['country'] ?? '') : $c; if ($cname==='') continue; ?>
                  <option value="<?= htmlspecialchars($cname) ?>" <?= ($selectedCountry ?? '') === $cname ? 'selected' : '' ?>><?= htmlspecialchars($cname) ?></option>
              <?php endforeach; endif; ?>
            </select>
            <div class="form-text">Select a country to filter taxi vendors.</div>
          </div>
          <div class="col-md-4">
            <label class="form-label">Vendor</label>
            <select name="vendor_id" class="form-select form-select-sm" required>
              <option value="">Select vendor</option>
              <?php foreach ($vendors as $v): $sel = (int)$taxi['vendor_id'] === (int)$v['id'] ? 'selected' : ''; ?>
                <option value="<?= (int)$v['id'] ?>" <?= $sel ?>><?= htmlspecialchars($v['name']) ?></option>
              <?php endforeach; ?>
            </select>
            <div class="form-text">Vendor providing this taxi service.</div>
          </div>
          <div class="col-md-4">
            <label class="form-label">Title</label>
            <input type="text" name="title" value="<?= htmlspecialchars((string)($taxi['title'] ?? '')) ?>" class="form-control form-control-sm" placeholder="e.g., SUV - Bangkok City" />
            <div class="form-text">Shown to agents/customers.</div>
          </div>
          <div class="col-md-4">
            <label class="form-label">Internal Name</label>
            <input type="text" name="name" value="<?= htmlspecialchars((string)($taxi['name'] ?? '')) ?>" class="form-control form-control-sm" placeholder="Internal reference" />
          </div>

          <div class="col-md-3">
            <label class="form-label">Vehicle Type</label>
            <?php $vt = (string)($taxi['vehicle_type'] ?? ''); ?>
            <select name="vehicle_type" class="form-select form-select-sm">
              <option value="">Select</option>
              <?php foreach (['sedan','suv','van','bus','luxury','other'] as $opt): ?>
                <option value="<?= $opt ?>" <?= $vt === $opt ? 'selected' : '' ?>><?= ucfirst($opt) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-2">
            <label class="form-label">Capacity</label>
            <input type="number" min="1" name="capacity" value="<?= htmlspecialchars((string)($taxi['capacity'] ?? '')) ?>" class="form-control form-control-sm" required />
          </div>
          <div class="col-md-2">
            <label class="form-label">Luggage</label>
            <input type="number" min="0" name="luggage_capacity" value="<?= htmlspecialchars((string)($taxi['luggage_capacity'] ?? '')) ?>" class="form-control form-control-sm" />
          </div>
          <div class="col-md-3">
            <label class="form-label">Route (label)</label>
            <input type="text" name="route" value="<?= htmlspecialchars((string)($taxi['route'] ?? '')) ?>" class="form-control form-control-sm" placeholder="e.g., BKK → City" required />
            <div class="form-text">Short description e.g., Airport → Hotel</div>
          </div>
          <div class="col-md-2">
            <label class="form-label">Trip Type</label>
            <?php $tt = (string)($taxi['trip_type'] ?? 'both'); if ($tt==='') { $tt='both'; } ?>
            <select name="trip_type" class="form-select form-select-sm">
              <option value="both" <?= $tt==='both' ? 'selected' : '' ?>>Both (Single & Round)</option>
              <option value="single" <?= $tt==='single' ? 'selected' : '' ?>>Single Only</option>
              <option value="round" <?= $tt==='round' ? 'selected' : '' ?>>Round Only</option>
            </select>
            <div class="form-text">Controls what agents can book.</div>
          </div>

          <div class="col-12">
            <label class="form-label">Description</label>
            <textarea name="description" rows="4" class="form-control form-control-sm" placeholder="Vehicle details, inclusions, notes..."><?= htmlspecialchars((string)($taxi['description'] ?? '')) ?></textarea>
          </div>

          <div class="col-md-2 form-check ms-2 mt-2">
            <?php $active = (int)($taxi['active'] ?? 1) === 1; ?>
            <input class="form-check-input" type="checkbox" value="1" id="activeChk" name="active" <?= $active ? 'checked' : '' ?>>
            <label class="form-check-label" for="activeChk">Active</label>
          </div>
        </div>
      </div>

      <!-- Pricing -->
      <div class="tab-pane fade" id="pane-pricing" role="tabpanel" aria-labelledby="tab-pricing" tabindex="0">
        <div class="row g-3">
          <div class="col-md-2">
            <label class="form-label">Currency</label>
            <?php
              $cur = (string)($taxi['currency'] ?? 'THB');
              // Build list from DB if available; else fallback
              $codes = [];
              if (!empty($currencyCodes) && is_array($currencyCodes)) {
                foreach ($currencyCodes as $row) {
                  if (is_array($row)) {
                    $code = (string)($row['code'] ?? '');
                  } else {
                    $code = (string)$row;
                  }
                  if ($code !== '') { $codes[] = $code; }
                }
                $codes = array_values(array_unique($codes));
              }
              if (empty($codes)) { $codes = ['THB','USD','INR','AED','EUR']; }
            ?>
            <select name="currency" class="form-select form-select-sm">
              <?php foreach ($codes as $cc): ?>
                <option value="<?= htmlspecialchars($cc) ?>" <?= $cur===$cc?'selected':'' ?>><?= htmlspecialchars($cc) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Vendor Cost</label>
            <input type="number" step="0.01" min="0" name="vendor_cost" value="<?= htmlspecialchars((string)($taxi['vendor_cost'] ?? '')) ?>" class="form-control form-control-sm" placeholder="0.00" />
            <div class="form-text">Our buy cost from vendor.</div>
          </div>
          <div class="col-md-3">
            <label class="form-label">B2B Agent Price</label>
            <input type="number" step="0.01" min="0" name="agent_price" value="<?= htmlspecialchars((string)($taxi['agent_price'] ?? '')) ?>" class="form-control form-control-sm" placeholder="0.00" />
            <div class="form-text">Net rate shown to agents.</div>
          </div>
          <div class="col-md-3">
            <label class="form-label">B2C Customer Price</label>
            <input type="number" step="0.01" min="0" name="customer_price" value="<?= htmlspecialchars((string)($taxi['customer_price'] ?? '')) ?>" class="form-control form-control-sm" placeholder="0.00" />
            <div class="form-text">Public selling price.</div>
          </div>
          <div class="col-md-3">
            <label class="form-label">Pricing Model</label>
            <?php $pm = (string)($taxi['pricing_model'] ?? 'fixed'); ?>
            <select name="pricing_model" class="form-select form-select-sm">
              <?php foreach (['fixed' => 'Fixed','distance' => 'Distance','hourly' => 'Hourly'] as $k=>$v): ?>
                <option value="<?= $k ?>" <?= $pm===$k?'selected':'' ?>><?= $v ?></option>
              <?php endforeach; ?>
            </select>
            <div class="form-text">Choose how price is calculated.</div>
          </div>
          <div class="col-md-3">
            <label class="form-label">Per Km</label>
            <input type="number" step="0.01" min="0" name="per_km_price" value="<?= htmlspecialchars((string)($taxi['per_km_price'] ?? '')) ?>" class="form-control form-control-sm" placeholder="0.00" />
          </div>
          <div class="col-md-3">
            <label class="form-label">Per Hour</label>
            <input type="number" step="0.01" min="0" name="per_hour_price" value="<?= htmlspecialchars((string)($taxi['per_hour_price'] ?? '')) ?>" class="form-control form-control-sm" placeholder="0.00" />
          </div>
          <div class="col-md-3">
            <label class="form-label">Wait/Hour</label>
            <input type="number" step="0.01" min="0" name="wait_per_hour" value="<?= htmlspecialchars((string)($taxi['wait_per_hour'] ?? '')) ?>" class="form-control form-control-sm" placeholder="0.00" />
          </div>
          <div class="col-md-3">
            <label class="form-label">Tax %</label>
            <input type="number" step="0.01" min="0" name="tax_percent" value="<?= htmlspecialchars((string)($taxi['tax_percent'] ?? '')) ?>" class="form-control form-control-sm" placeholder="0" />
          </div>
          <div class="col-md-3">
            <label class="form-label">Fees</label>
            <input type="number" step="0.01" min="0" name="fees_amount" value="<?= htmlspecialchars((string)($taxi['fees_amount'] ?? '')) ?>" class="form-control form-control-sm" placeholder="0.00" />
          </div>
        </div>
      </div>

      <!-- Routes -->
      <div class="tab-pane fade" id="pane-routes" role="tabpanel" aria-labelledby="tab-routes" tabindex="0">
        <div class="row g-3">
          <div class="col-md-4">
            <label class="form-label">Pickup</label>
            <input type="text" name="pickup_label" value="<?= htmlspecialchars((string)($taxi['pickup_label'] ?? '')) ?>" class="form-control form-control-sm" placeholder="e.g., Suvarnabhumi (BKK)" />
            <div class="row g-2 mt-1">
              <div class="col"><input type="text" name="pickup_lat" value="<?= htmlspecialchars((string)($taxi['pickup_lat'] ?? '')) ?>" class="form-control form-control-sm" placeholder="Lat"></div>
              <div class="col"><input type="text" name="pickup_lng" value="<?= htmlspecialchars((string)($taxi['pickup_lng'] ?? '')) ?>" class="form-control form-control-sm" placeholder="Lng"></div>
            </div>
          </div>
          <div class="col-md-4">
            <label class="form-label">Drop</label>
            <input type="text" name="drop_label" value="<?= htmlspecialchars((string)($taxi['drop_label'] ?? '')) ?>" class="form-control form-control-sm" placeholder="e.g., Bangkok City" />
            <div class="row g-2 mt-1">
              <div class="col"><input type="text" name="drop_lat" value="<?= htmlspecialchars((string)($taxi['drop_lat'] ?? '')) ?>" class="form-control form-control-sm" placeholder="Lat"></div>
              <div class="col"><input type="text" name="drop_lng" value="<?= htmlspecialchars((string)($taxi['drop_lng'] ?? '')) ?>" class="form-control form-control-sm" placeholder="Lng"></div>
            </div>
          </div>
          <div class="col-md-4">
            <label class="form-label">Distance-based pricing</label>
            <?php $dist = (int)($taxi['distance_pricing_enabled'] ?? 0) === 1; ?>
            <div class="form-check form-switch mt-2">
              <input class="form-check-input" type="checkbox" role="switch" name="distance_pricing_enabled" value="1" <?= $dist?'checked':'' ?>>
              <label class="form-check-label">Enable per km calculation</label>
            </div>
          </div>
        </div>
      </div>

      <!-- Availability -->
      <div class="tab-pane fade" id="pane-availability" role="tabpanel" aria-labelledby="tab-availability" tabindex="0">
        <div class="row g-3">
          <div class="col-md-6">
            <label class="form-label">Days of Week</label>
            <?php $days = (array)($taxi['available_days'] ?? []); ?>
            <div class="d-flex flex-wrap gap-3 small">
              <?php foreach (['Mon','Tue','Wed','Thu','Fri','Sat','Sun'] as $d): $ck = in_array($d,$days) ? 'checked' : ''; ?>
                <div class="form-check">
                  <input class="form-check-input" type="checkbox" name="available_days[]" value="<?= $d ?>" id="day-<?= $d ?>" <?= $ck ?>>
                  <label class="form-check-label" for="day-<?= $d ?>"><?= $d ?></label>
                </div>
              <?php endforeach; ?>
            </div>
          </div>
          <div class="col-md-3">
            <label class="form-label">Start Time</label>
            <input type="time" name="start_time" value="<?= htmlspecialchars((string)($taxi['start_time'] ?? '')) ?>" class="form-control form-control-sm" />
          </div>
          <div class="col-md-3">
            <label class="form-label">End Time</label>
            <input type="time" name="end_time" value="<?= htmlspecialchars((string)($taxi['end_time'] ?? '')) ?>" class="form-control form-control-sm" />
          </div>

          <div class="col-12">
            <label class="form-label">Blackout Dates</label>
            <input type="text" name="blackout_dates" value="<?= htmlspecialchars((string)($taxi['blackout_dates'] ?? '')) ?>" class="form-control form-control-sm" placeholder="YYYY-MM-DD, YYYY-MM-DD" />
            <div class="form-text">Comma separated list of dates when not available.</div>
          </div>
        </div>
      </div>

      <!-- Media -->
      <div class="tab-pane fade" id="pane-media" role="tabpanel" aria-labelledby="tab-media" tabindex="0">
        <link rel="stylesheet" href="/assets/css/media-uploader.css">
        <div class="row g-3">
          <div class="col-md-8">
            <label class="form-label">Upload Images</label>
            <div id="taxi-media" class="mu" data-upload-url="/admin/media/upload">
              <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
            </div>
            <input type="hidden" name="media_json" id="media_json" value="<?= htmlspecialchars((string)($taxi['media_json'] ?? '')) ?>">
            <div class="form-text">Drag & drop images or click the box. JPG/PNG/WEBP up to 5MB each. Thumbnails are created automatically.</div>
            <!-- Fallback input (hidden) to preserve legacy flow) -->
            <input type="file" name="images[]" class="form-control form-control-sm d-none" accept="image/*" multiple>
          </div>
          <div class="col-md-4">
            <label class="form-label">Cover Index</label>
            <input type="number" min="0" name="cover_index" value="<?= htmlspecialchars((string)($taxi['cover_index'] ?? '0')) ?>" class="form-control form-control-sm" />
            <div class="form-text">Which image should be the cover (0-based).</div>
          </div>
        </div>
        <script src="/assets/js/media-uploader.js" defer></script>
        <script>
          // Capture uploaded URLs into hidden input as JSON array
          document.addEventListener('DOMContentLoaded', function(){
            var container = document.getElementById('taxi-media');
            var hidden = document.getElementById('media_json');
            if (!container || !hidden) return;
            var gridObserver = new MutationObserver(function(){
              var items = container.querySelectorAll('.mu-item');
              var files = [];
              items.forEach(function(it){
                var orig = it.dataset.originalUrl; var th = it.dataset.thumbUrl;
                if (orig) files.push({originalUrl: orig, thumbUrl: th || ''});
              });
              hidden.value = JSON.stringify(files);
            });
            gridObserver.observe(container, {subtree:true, childList:true, attributes:true, attributeFilter:['data-original-url','data-thumb-url']});
          });
        </script>
      </div>
    </div>

    <!-- Sticky actions like Booking.com -->
    <div class="d-flex justify-content-between align-items-center gap-2 mt-3">
      <a class="btn btn-sm btn-secondary" href="/admin/taxis">Cancel</a>
      <button class="btn btn-sm btn-primary"><?= $editing ? 'Save Changes' : 'Create Taxi' ?></button>
    </div>
  </form>
</div>
