<?php
// app/Views/admin/taxi_itineraries_form.php
$editing = !empty($itin['id']);
$action = $editing ? '/admin/taxi/itineraries/update' : '/admin/taxi/itineraries/store';
?>
<div class="container py-3">
  <h2 class="h5 mb-3 d-flex align-items-center">
    <i class="bi bi-signpost-split me-2"></i>
    <?= $editing ? 'Edit Itinerary' : 'Create Itinerary' ?>
  </h2>

  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="alert alert-danger py-2 small">
      <?php foreach ($_SESSION['errors'] as $e): ?><div><?= htmlspecialchars($e) ?></div><?php endforeach; unset($_SESSION['errors']); ?>
    </div>
  <?php endif; ?>

  <div class="row g-3">
    <div class="col-lg-8">
  <form method="post" action="<?= $action ?>" class="needs-validation" novalidate>
    <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
    <?php if ($editing): ?>
      <input type="hidden" name="id" value="<?= (int)$itin['id'] ?>">
    <?php endif; ?>

    <div class="row g-3">
      <div class="col-md-4">
        <label class="form-label">Taxi (optional)</label>
        <select name="taxi_id" class="form-select form-select-sm">
          <option value="">Any taxi</option>
          <?php foreach (($taxis ?? []) as $t): $sel = (int)($itin['taxi_id'] ?? 0) === (int)$t['id'] ? 'selected' : ''; ?>
            <option value="<?= (int)$t['id'] ?>" <?= $sel ?>><?= htmlspecialchars((string)($t['name'] ?? 'Taxi #'.(int)$t['id'])) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">Name</label>
        <input type="text" name="name" value="<?= htmlspecialchars((string)($itin['name'] ?? '')) ?>" class="form-control form-control-sm" placeholder="Itinerary name" required>
      </div>
      <div class="col-md-2 align-self-end">
        <?php $active = (int)($itin['active'] ?? 1) === 1; ?>
        <div class="form-check form-switch">
          <input class="form-check-input" type="checkbox" role="switch" id="activeChk" name="active" value="1" <?= $active?'checked':'' ?>>
          <label class="form-check-label" for="activeChk">Active</label>
        </div>
      </div>
      <div class="col-12">
        <label class="form-label">Description</label>
        <textarea name="description" rows="3" class="form-control form-control-sm" placeholder="Notes for this itinerary (internal)"><?= htmlspecialchars((string)($itin['description'] ?? '')) ?></textarea>
      </div>
    </div>

    <hr>
    <h6 class="mb-2">Stops</h6>
    <div class="alert alert-info py-2 small">
      <strong>Distance Policy (internal):</strong> Each add-on stop includes up to <strong>7 km</strong> from the chosen pickup/drop area. Any distance over 7 km will be charged<br>
      at the taxi's configured <em>Per Km</em> rate (from pricing). This note is only visible in Admin; agents/customers do not see it.
    </div>
    <div id="stopsWrap" class="mb-3 small">
      <div class="table-responsive">
        <table class="table table-sm align-middle" id="stopsTable">
          <thead>
            <tr>
              <th style="width:60px">#</th>
              <th style="width:220px">Label</th>
              <th>Address</th>
              <th style="width:120px">Wait (min)</th>
              <th style="width:140px">Extra Price (THB)</th>
              <th style="width:200px">Notes</th>
              <th style="width:140px"></th>
            </tr>
          </thead>
          <tbody>
            <?php $seq = 1; foreach (($stops ?? []) as $s): ?>
              <tr>
                <td class="seq text-muted"><?= $seq ?></td>
                <td><input name="stops[<?= $seq ?>][label]" class="form-control form-control-sm" value="<?= htmlspecialchars((string)($s['label'] ?? '')) ?>" required></td>
                <td><input name="stops[<?= $seq ?>][address]" class="form-control form-control-sm" value="<?= htmlspecialchars((string)($s['address'] ?? '')) ?>"></td>
                <td><input name="stops[<?= $seq ?>][wait_minutes]" type="number" min="0" class="form-control form-control-sm" value="<?= htmlspecialchars((string)($s['wait_minutes'] ?? '')) ?>"></td>
                <td><input name="stops[<?= $seq ?>][extra_price]" type="number" min="0" step="0.01" class="form-control form-control-sm" value="<?= htmlspecialchars((string)($s['extra_price'] ?? '')) ?>" placeholder="0.00"></td>
                <td><input name="stops[<?= $seq ?>][notes]" class="form-control form-control-sm" value="<?= htmlspecialchars((string)($s['notes'] ?? '')) ?>"></td>
                <td class="text-end">
                  <button class="btn btn-sm btn-outline-secondary" type="button" onclick="moveRow(this,-1)">Up</button>
                  <button class="btn btn-sm btn-outline-secondary" type="button" onclick="moveRow(this,1)">Down</button>
                  <button class="btn btn-sm btn-outline-danger" type="button" onclick="removeRow(this)">Remove</button>
                </td>
              </tr>
            <?php $seq++; endforeach; ?>
          </tbody>
        </table>
      </div>
      <button type="button" class="btn btn-sm btn-primary" onclick="addStopRow()"><i class="bi bi-plus"></i> Add Stop</button>
    </div>

    <div class="d-flex justify-content-between align-items-center gap-2 mt-3">
      <a class="btn btn-sm btn-secondary" href="/admin/taxi/itineraries">Cancel</a>
      <button class="btn btn-sm btn-primary"><?= $editing ? 'Save Changes' : 'Create Itinerary' ?></button>
    </div>
  </form>
    </div>
    <div class="col-lg-4">
      <?php if (!empty($existing)): ?>
        <div class="card">
          <div class="card-body">
            <div class="d-flex justify-content-between align-items-center mb-2">
              <h6 class="mb-0">Existing Itineraries</h6>
              <span class="badge bg-light text-dark"><?= count($existing) ?></span>
            </div>
            <div class="list-group list-group-flush">
              <?php foreach ($existing as $ex): ?>
                <div class="list-group-item d-flex justify-content-between align-items-center">
                  <div>
                    <div class="fw-semibold small"><?= htmlspecialchars((string)($ex['name'] ?? 'Untitled')) ?></div>
                    <div class="small text-muted">ID #<?= (int)($ex['id'] ?? 0) ?> · <?= ((int)($ex['active'] ?? 0)===1?'Active':'Inactive') ?></div>
                  </div>
                  <div class="ms-2">
                    <a href="/admin/taxi/itineraries/edit?id=<?= (int)($ex['id'] ?? 0) ?>" class="btn btn-sm btn-outline-secondary">Edit</a>
                    <form method="post" action="/admin/taxi/itineraries/delete?csrf=<?= htmlspecialchars($csrf) ?>" class="d-inline" onsubmit="return confirm('Delete itinerary?');">
                      <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrf) ?>">
                      <input type="hidden" name="id" value="<?= (int)($ex['id'] ?? 0) ?>">
                      <button class="btn btn-sm btn-outline-danger">Delete</button>
                    </form>
                  </div>
                </div>
              <?php endforeach; ?>
            </div>
          </div>
        </div>
      <?php else: ?>
        <div class="alert alert-info small">No itineraries for selected taxi.</div>
      <?php endif; ?>
    </div>
  </div>
</div>

<script>
(function(){
  function renumber(){
    var rows = document.querySelectorAll('#stopsTable tbody tr');
    var i = 1;
    rows.forEach(function(tr){
      tr.querySelector('.seq').textContent = i;
      tr.querySelectorAll('input').forEach(function(inp){
        inp.name = inp.name.replace(/stops\[[^\]]+\]/, 'stops['+i+']');
      });
      i++;
    });
  }
  window.addStopRow = function(){
    var tb = document.querySelector('#stopsTable tbody');
    var tr = document.createElement('tr');
    tr.innerHTML = '<td class="seq text-muted"></td>'+
      '<td><input name="stops[][label]" class="form-control form-control-sm" required></td>'+
      '<td><input name="stops[][address]" class="form-control form-control-sm"></td>'+
      '<td><input name="stops[][wait_minutes]" type="number" min="0" class="form-control form-control-sm"></td>'+
      '<td><input name="stops[][extra_price]" type="number" min="0" step="0.01" class="form-control form-control-sm" placeholder="0.00"></td>'+
      '<td><input name="stops[][notes]" class="form-control form-control-sm"></td>'+
      '<td class="text-end">'+
      '<button class="btn btn-sm btn-outline-secondary" type="button" onclick="moveRow(this,-1)">Up</button> '+
      '<button class="btn btn-sm btn-outline-secondary" type="button" onclick="moveRow(this,1)">Down</button> '+
      '<button class="btn btn-sm btn-outline-danger" type="button" onclick="removeRow(this)">Remove</button></td>';
    tb.appendChild(tr);
    renumber();
  }
  window.removeRow = function(btn){
    var tr = btn.closest('tr');
    tr.parentNode.removeChild(tr);
    renumber();
  }
  window.moveRow = function(btn, dir){
    var tr = btn.closest('tr');
    if (dir < 0 && tr.previousElementSibling) tr.parentNode.insertBefore(tr, tr.previousElementSibling);
    if (dir > 0 && tr.nextElementSibling) tr.parentNode.insertBefore(tr.nextElementSibling, tr);
    renumber();
  }
})();
</script>
